/*
 *
 *    Copyright (c) 1996-2005 by Brocade Communications Systems, Inc.
 *    All rights reserved.
 *
 *    Description:
 *      Anzio shared memory block layout.
 *
 */

#ifndef __ANZ_SHRMEM_H
#define __ANZ_SHRMEM_H

/* Ports defined in sas_pmmr.h as SAS_PORT_ANZIO(0-8) 8 is message port */
#define ANZ_NUM_PORTS (9)	/* 8 data + 1 message */


/* Command Registers */
typedef struct anz_pmmr_chip_s {
	/* CSI start 0x0000 */
	uint32_t	csi_pci_ctl;		/* 0x000 */
	uint32_t	csi_pci_sts_reg0;	/* 0x004 CSR[31:0] on Xilinx PCI Core IF */
	uint32_t	csi_pci_sts_reg1;	/* 0x008 CSR[39:32] on Xilinx PCI Core IF */
	uint32_t	csi_s_clk_dcm;		/* 0x00c */

	uint32_t	csi_err_int_status;	/* 0x010 */
	uint32_t	csi_err_int_en;		/* 0x014 */
	uint32_t	csi_first_err;		/* 0x018 */
	uint32_t	csi_err_addr_capt;	/* 0x01c */

	uint32_t	csi_glb_int_status;	/* 0x100 */
	uint32_t	csi_glb_int_en;		/* 0x104 */
	uint32_t	csi_glb_first_err;	/* 0x108 */
	uint32_t	csi_glb_fpga_rev_id;/* 0x20c */

	/* FPG start 0x2000 */
	uint32_t	fpg_int_en;			/* 0x008 */
	uint32_t	fpg_int_status;		/* 0x00c */
	uint32_t	fpg_err_int_en;		/* 0x010 */
	uint32_t	fpg_err_int_status;	/* 0x014 */
	uint32_t	fpg_first_err;		/* 0x018 */

	uint32_t	fps_stop_inc;		/* 0x100 */
	uint32_t	fps_clr_acc;		/* 0x104 */

	uint32_t	fps_int_en;			/* 0x108 */
	uint32_t	fps_int_status;		/* 0x10c */
	uint32_t	fps_par_ctl;		/* 0x110 */
	uint32_t	fps_int_status_set;	/* 0x118 */
	uint32_t	fps_ram_err_addr;	/* 0x11c */

	/* FDS starts 0x4000 */
	uint32_t	fds_status;			/* 0x000 */
	uint32_t	fds_ctrl;			/* 0x004 */
	uint32_t	fds_pci_wr_xdata;	/* 0x008 */
	uint32_t	fds_pci_rd_xdata;	/* 0x00c */

	/* CLS starts at 0x6000 */
	uint32_t	cls_chip_id;		/* 0x000 */
	uint32_t	cls_dpc_id;			/* 0x004 */
	uint32_t	cls_ctrl;			/* 0x008 */
	uint32_t	cls_egid2vc;		/* 0x00c */
	uint32_t	cls_actload0;		/* 0x010 */
	uint32_t	cls_actload1;		/* 0x014 */
	uint32_t	cls_actload2;		/* 0x018 */
	uint32_t	cls_actload3;		/* 0x01c */
	uint32_t	cls_egid2core0;		/* 0x020 */
	uint32_t	cls_egid2core1;		/* 0x024 */
	uint32_t	cls_egid2core2;		/* 0x028 */
	uint32_t	cls_egid2core3;		/* 0x02c */
	uint32_t	cls_int_st;			/* 0x030 */
	uint32_t	cls_int_en;			/* 0x034 */
	uint32_t	cls_par_err_idx;	/* 0x038 */
	uint32_t	cls_crc16_hash_in0;	/* 0x03c */
	uint32_t	cls_crc16_hash_in1;	/* 0x040 */
	uint32_t	cls_crc16_hash_out;	/* 0x044 */
	uint32_t	cls_hdr_buf_perr;	/* 0x048 */
	uint32_t	cls_fid_buf_perr;	/* 0x04c */

	/* TXQ starts at 0x8000 */
	uint32_t	txq_int_st;			/* 0x000 */
	uint32_t	txq_int_en;			/* 0x004 */
	uint32_t	txq_ctrl;			/* 0x008 - debug */
	uint32_t	txq_wr_xdata;		/* 0x00c - debug */
	uint32_t	txq_rd_xdata;		/* 0x010 - debug */

	/* TMO starts at 0xa000 */
	uint32_t	tmo_ifid_ctrl;		/* 0x000 */
	uint32_t	tmo_efid_ctrl;		/* 0x004 */
	uint32_t	tmo_cur_tm;			/* 0x008 */
	uint32_t	tmo_ext_fid;		/* 0x00c */
	uint32_t	tmo_int_fid;		/* 0x010 */
	uint32_t	tmo_threshold_num_to_efid;	/* 0x014 */
	uint32_t	tmo_threshold_num_to_ifid;	/* 0x018 */
	uint32_t	tmo_min_threshold_perr;		/* 0x01c */
	uint32_t	tmo_ext_fid_cnt;	/* 0x020 */
	uint32_t	tmo_int_fid_cnt;	/* 0x024 */
	uint32_t	tmo_parity_err_cnt;	/* 0x028 */
	uint32_t	tmo_err_st;			/* 0x030 */
	uint32_t	tmo_err_en;			/* 0x034 */

	/* EBM starts at 0xc000 */
	uint32_t	ebm_config;			/* 0x000 */
	uint32_t	ebm_int_st;			/* 0x004 */
	uint32_t	ebm_int_en;			/* 0x008 */
	uint32_t	ebm_perr_inj;		/* 0x00c DEBUGGING */
	uint32_t	ebm_1st_err;		/* 0x010 */
	uint32_t	ebm_efid_perr;		/* 0x014 */
	uint32_t	ebm_wd_loc_perr;	/* 0x018 */
	uint32_t	ebm_mem_ctrl;		/* 0x01c */
	uint32_t	ebm_max_efid;		/* 0x020 */
	uint32_t	ebm_min_buf_threshold;	/* 0x024 */
	uint32_t	ebm_efid_drop_cnt;	/* 0x028 */
	uint32_t	ebm_inst_drop_cnt;	/* 0x02c */
	uint32_t	ebm_eba_fifo_ptr;	/* 0x030 DEBUGGING */
	uint32_t	ebm_dQ_ptr_buf_has_frame; /* 0x034 DEBUGGING */
	uint32_t	ebm_upQ_wr_ptr;		/* 0x038 DEBUGGING */
	uint32_t	ebm_upQ_rd_ptr;		/* 0x03c DEBUGGING */
	uint32_t	ebm_rcv_inst_cnt;	/* 0x040 DEBUGGING */
	uint32_t	ebm_bypass_send_inst_cnt;	/* 0x044 DEBUGGING */
	uint32_t	ebm_buf_frame_cnt;	/* 0x048 DEBUGGING */
	uint32_t	ebm_fds_frame_cnt;	/* 0x04c DEBUGGING */
	uint32_t	ebm_bist_cmd;		/* 0x050 DEBUGGING */
	uint32_t	ebm_bist_size;		/* 0x054 DEBUGGING */
	uint32_t	ebm_bist_start;		/* 0x058 DEBUGGING */
	uint32_t	ebm_bist_seed;		/* 0x05c DEBUGGING */
	uint32_t	ebm_dcm_ctrl_s0;	/* 0x060 */
	uint32_t	ebm_dcm_ctrl_s1;	/* 0x064 */
	uint32_t	ebm_dcm_ctrl_cr;	/* 0x068 */
	uint32_t	ebm_dcm_st_s0;		/* 0x070 */
	uint32_t	ebm_dcm_st_s1;		/* 0x074 */
	uint32_t	ebm_dcm_st_cr;		/* 0x078 */

	/* MPG starts at 0xe000 */
	uint32_t	mpg_int_en;			/* 0x000 */
	uint32_t	mpg_int_st;			/* 0x004 */
	uint32_t	mpg_err_int_en;		/* 0x008 */
	uint32_t	mpg_err_int_st;		/* 0x00c */

	uint32_t	mps_ctr;			/* 0x400 */
	uint32_t	mps_stats_ram[9];	/* 0x500 - 0x524 */
} anz_pmmr_chip_t;

/* Port Based Registers */
typedef struct anz_pmmr_port_s {
	/* FPG starts at 0x2000 */
	uint32_t		port_config;				/* 0x000 */
	uint32_t		fpl_lli_os_ctl;				/* 0x00c */
	uint32_t		fpl_lli_ctl;				/* 0x014 */
	uint32_t		fpl_lli_int_en;				/* 0x020 */
	uint32_t		fpl_lli_def;				/* 0x028 */
	uint32_t		fpl_lli_ns_status;			/* 0x034 */
	uint32_t		fpl_lli_status;				/* 0x038 */
	uint32_t		fpl_lli_status_set;			/* 0x03c */
	uint32_t		fpl_serdes_ctl;				/* 0x040 */
	uint32_t		fpl_serdes_pma_reg;			/* 0x044 */
	uint32_t		fpl_err_status;				/* 0x050 */
	uint32_t		fpl_err_int_en;				/* 0x058 */
	uint32_t		fpl_debug;					/* 0x064 */
	uint32_t		fpl_dummy;					/* 0x068 */
	uint32_t		fpl_link_ctl;				/* 0x070 */
	uint32_t		fpl_link_stats;				/* 0x074 */

	/* FPG - BBC */
	uint32_t		bbc_tx_crd1_cnt;			/* 0x400 */
	uint32_t		bbc_tx_crd2_cnt;			/* 0x404 */
	uint32_t		bbc_rx_buf_vec;				/* 0x408 */
	uint32_t		bbc_tx_crd_inc;				/* 0x40c */
	uint32_t		bbc_crd_clr;				/* 0x410 */

	uint32_t		fps_slow_sts_status;		/* 0x600 */
	uint32_t		fps_stats_ram[10];			/* 0x700 to 0x728 */

	/* FDS starts at 0x4000 */
	uint32_t		fds_int_st;					/* 0x000 */
	uint32_t		fds_int_en;					/* 0x004 */
	uint32_t		fds_tx_ctrl;				/* 0x008 */
	uint32_t		fds_tx_frame_cnt;			/* 0x00c */
	uint32_t		fds_tx_msg_frame_cnt;		/* 0x010 */
	uint32_t		fds_rx_frame_cnt;			/* 0x014 */
	uint32_t		fds_rx_msg_frame_cnt;		/* 0x018 */

	/* TXQ starts at 0x8000 */
	uint32_t		txq_ctrl_st;				/* 0x000 */
	uint32_t		txq_fifo[16];				/* 0x100 to 0x13c */

	/* MPG starts at 0xe000 */
	uint32_t		mpg_port_config;				/* 0x000 */
	uint32_t		mpg_lli_os_ctl;				/* 0x00c */
	uint32_t		mpg_lli_ctl;				/* 0x014 */
	uint32_t		mpg_lli_int_en;				/* 0x020 */
	uint32_t		mpg_lli_def;				/* 0x028 */
	uint32_t		mpg_lli_ns_status;			/* 0x034 */
	uint32_t		mpg_lli_status;				/* 0x038 */
	uint32_t		mpg_lli_status_set;			/* 0x03c */
	uint32_t		mpg_serdes_ctl;				/* 0x040 */
	uint32_t		mpg_serdes_pma_reg;			/* 0x044 */
	uint32_t		mpg_err_status;				/* 0x050 */
	uint32_t		mpg_err_int_en;				/* 0x058 */
	uint32_t		mpg_debug;					/* 0x064 */
	uint32_t		mpg_dummy;					/* 0x068 */
	uint32_t		mpg_link_ctl;				/* 0x070 */
	uint32_t		mpg_link_stats;				/* 0x074 */

	/* MPG - BBC */
	uint32_t		mpg_rx_buf_vec;				/* 0x400 */
	uint32_t		mpg_rx_buf_vec_clr;			/* 0x404 */
	uint32_t		mpg_port_to_vc;				/* 0x408 */
} anz_pmmr_port_t;

/*
 * This is the per port structure in shared memory.  Each port has a
 * copy of the chip structure, but only port 0's chip structure will
 * be updated on the 1250.
 */
typedef struct anz_pmmr_s {
	anz_pmmr_chip_t		chip;
	anz_pmmr_port_t		port;
} anz_pmmr_t;

#endif /* __ANZ_SHRMEM_H */
