/*
 *    Copyright (c) 2003-2005 Brocade Communications Systems, Inc.
 *    All rights reserved.
 *
 *    Description:
 * 		This file is used to expose all higher level info needed by port 
 * 		modules (running on 1250) to send events/msgs to CP
 */

#ifndef __SAS_PUBLIC_H__
#define __SAS_PUBLIC_H__

#ifdef __KERNEL__
#include <linux/types.h>
#elif defined __SOS__
#include "sos.h"
#include "types.h"
#else
#include <sys/types.h>
#endif /* __KERNEL__ */

#include <sys/fabos/fabprop.h>

/*
 * Static port configuration properties.
 */
typedef struct port_cfg {
	uint32_t	excess_ptintr_thresh;	/* excessive port interrupt threshold */
	uint32_t	rttov;					/* link response timeout */
	uint32_t	busybuf_tov;			/* busy buffer timeout */
	uint32_t	non_crit_par_thresh;	/* non critical parity threshold */
	uint32_t	excess_chintr_thresh;	/* excessive chip interrupt threshold */
	uint32_t	err_sample_period;		/* error sampling period */
	uint32_t    sw_err_thresh;
	uint32_t    data_par_thresh;
	uint32_t    ctrl_par_thresh;
	uint32_t    pad[32];
} port_cfg_t;

/*
 * Generic command arguments
 */
typedef struct sas_cmd_arg {
	int		arg1;		/* argument 1 */
	int		arg2;		/* argument 2 */
	int		arg3;		/* argument 3 */
} sas_cmd_arg_t;

/*
 * Arguments for sending the port property
 * vc_alloc need to be redefined outside because it is a pointer inside
 * of cr_model_t.  Note that norm_vc_alloc and speed_list fields are
 * also pointers but are only used for FE ports.  Since we are only
 * dealing with backend ports, those fields are not redefined outside.
 * If they are needed later, they have to be added.
 */
#define SAS_MAX_VC		17

typedef struct sas_prop_arg {
	cr_model_t	cr_model;				/* credit model */
	link_cap_t	link_cap;				/* link capabilities */
	port_cfg_t	port_cfg;				/* port configurations */
	uint16_t	vc_alloc[SAS_MAX_VC];	/* min buffers per VC */
} sas_prop_arg_t;

/*
 * SAS payload
 */
typedef struct sas_payld {
	uint32_t		cmd;			/* command/event; must be 1st field */	
	int				port_num;		/* port number */
	union {
		sas_prop_arg_t	prop;		/* arguments for the port property */
		sas_cmd_arg_t	cmd_arg;	/* generic command arguments */
	} args;
} sas_payld_t;

#endif /* __SAS_PUBLIC_H__ */
