/*
 *
 *    Copyright (c) 2006 Brocade Communications Systems, Inc.
 *    All rights reserved.
 *
 *    Description:
 *      sbp interface defines. This has to be included by the
 *	  clients using this library
 *
 */
#ifndef _SBP_IF_H
#define _SBP_IF_H

#include <stdio.h>
#include <stdlib.h>
#include <stdtypes.h>
#include <pthread.h>
#include <syslog.h>
#include <cs/cscn.h>

#ifdef __cplusplus
extern C {
#endif

#define LOCK					pthread_mutex_lock(&mutex)
#define UNLOCK					pthread_mutex_unlock(&mutex)

/*
 * The size of payload sent through CSCN lib will be
 * 1) cn_msg_hdl_t
 * 2) SB Header
 * 3) Payload (data_ptr)
 *
 * SBP_MAX_PAYLOAD_SIZE (size for (3)) should consider (1) & (2)
 * while getting defined
 *
 * IMP: The payload size includes the header size too, so the safe
 * payload size is restricted to 32 KB
 */
#define SBP_MAX_PAYLOAD_SIZE	33*1024

typedef enum {
	SBP_FIRST_MOD_ID = 0,
	SBP_LICNESE_MOD_ID,
	SBP_ZS_MOD_ID,
	SBP_NS_MOD_ID,
	SBP_CAL_MOD_ID,
	SBP_ARR_MOD_ID,
	SBP_EVM_MOD_ID,
	SBP_LAST_MOD_ID
} mod_id_t;

typedef enum {
	SBP_FAILURE	= -1,
	SBP_SUCCESS,
	SBP_CONNECT_FAIL,
	SBP_CONNECT_LOST,
	SBP_CB_NULL,
	SBP_INVAL_PAYLOAD_SIZE,
	SBP_INVAL_MODID
} sbp_status_t;

typedef enum {
	SBP_TMR_NONE = 0,	/* No Timer is active			*/
	SBP_TMR_HELLO_SCPD,	/* Received hello response		*/
	SBP_TMR_HELLO_CALD,	/* Received hello response		*/
	SBP_TMR_HELLO_ARRD,	/* Received hello response		*/
	SBP_TMR_HELLO_EVM,	/* Received hello response		*/
	SBP_TMR_HELLO_NS,	/* Received hello response		*/
	SBP_TMR_LAST
} sbp_tmr_t;


/* Callback to be invoked on reception of data */
typedef void (*sbp_recv_data_cb)(void *private_ctx, void *data_ptr,
								 int op_code, int data_length);

/*  Callback to be invoked when sbp suffers unrec errors */
typedef void (*sbp_error_cb)(void *private_ctx, int evt_msg);

/* The callback to be invoked on reception of hello response from cp */
typedef void(*sbp_init_complete_cb)(void *private_ctx, sbp_status_t sts);

/* Init structure that should be filled by the client */
typedef struct {
	sbp_recv_data_cb recv_data;
	sbp_error_cb error_handler;
	sbp_init_complete_cb init_completed;
	mod_id_t module_id;
	sbp_tmr_t type;
	void *private_ctx;	/* Private Context */
	int sap;
	int connected;
} sbp_init_t;

/* The variable that stores the callbacks registered by clients */
extern sbp_init_t lib_cb[SBP_LAST_MOD_ID + 1];

/*  Init function for the module */
extern sbp_status_t sbp_init(sbp_init_t init);

/*  To be called while unloading */
extern void sbp_uninit(mod_id_t module_id);

/* To be called by the client for sending data */
extern sbp_status_t sbp_send_data(void *data_ptr, int data_length,
								  int op_code, mod_id_t mod_id, char mem_flag);

extern  void *sbp_alloc(int size);

extern void sbp_free(cs_cn_msg_hdl_t *msg);

#ifdef __cplusplus
}
#endif

#endif
