/*
 *
 *    Copyright (c) 1996-2005 Brocade Communication Systems, Inc.
 *    All rights reserved.
 *
 *    Description:
 *      This file has the functions exported by signals.c in the utils.
 *
 */

#ifndef __FOS_SIGNALS_H__
#define __FOS_SIGNALS_H__

/*
 * A prototype for a function that the signal handler can call before it
 * calls exit (if it has to).
 */
typedef void (sig_cleanupfunc_t)(void);

/*
 * void fos_coreenv_set(char *name)
 *
 * Description:
 *   This function sets up the environment so that a process may core
 *   appropriately. The convention in fabos is that each daemon has a
 *   directory under CORE_FILES directory, and the core is dumped there. The
 *   function also performs a chdir to this directory, and sets RLIMIT_CORE
 *   so that cores are enabled.
 *
 * Input(s):
 *   name: The name of the directory that should be created under
 *   CORE_FILES (if it is not already there).
 *
 * Output(s):
 *   N/A
 *
 * Returns:
 *   N/A
 *
 */
void fos_coreenv_set(char *name);


/*
 * void fos_sigcleanupset(sig_cleanupfunc_t *func);
 *
 * Description:
 *   This function sets the pointer to a function to be called when a signal
 *   is received and we want to exit on that signal.
 *   The default behavior is to generate core.
 *   By default, the function handle (and the argument) is set to NULL.
 *
 * Input(s):
 *   func: A pointer to a function that is called before exit() is called.
 *   arg : An argument that is handed to the function.
 *
 * Output(s):
 *   N/A
 *
 * Returns:
 *   N/A
 *
 */

void fos_sigcleanup_set(sig_cleanupfunc_t *func);
/*
 * void fos_sighandler(int signum);
 *
 * Description:
 *   This function is the standard signal handler provided in Fabos. It can
 *   be used as the handler in the 'signal' system call. The
 *   actions for the signals are as follows:
 *
 *   SIGPIPE: No action
 *   SIGPROF:
 *   SIGSTKFLT: All signals are ignored,  to 1, and abort is called
 *   SIGTERM: exit is called.
 *   All others: Cleanup function called if defined, and then exit is called.
 *
 *
 * Input(s):
 *   signum: The id of the signal that happened.
 *
 * Output(s):
 *   N/A
 *
 * Returns:
 *   N/A
 *
 */
void fos_sighandler(int signum);

/*
 * void fos_sigdefaults(char *name);
 *
 * Description:
 *   This function sets the default Fabos signal handlers for the process,
 *   and also sets up an environment to generate core if needed. It creates
 *   the appropriate directory in which the process can dump core, and
 *   changes to that directory before returning control to the caller. It
 *   uses the fos_sighandler function above as the signal handler. for the
 *   following signals:
 *
 *	    SIGINT
 *	    SIGQUIT
 *	    SIGPIPE
 *	    SIGSTKFLT
 *	    SIGPROF
 *
 * Input(s):
 *   name: A char string with the name of the application. This will also be
 *   the name of the directory created under /core_files.
 *
 * Output(s):
 *   N/A
 *
 * Returns:
 *   N/A
 *
 */
void fos_sigdefaults(char *name);

/*
 * void fos_pwddefault();
 *
 * Description:
 *   This function sets the default pwd (to CORE_FILES)
 *
 * Input(s):
 *   N/A
 *
 * Output(s):
 *   N/A
 *
 * Returns:
 *   N/A
 *
 */
void fos_pwddefault(void);
#endif	/* __FOS_SIGNALS_H__ */
