/*
 *  Copyright (c) 2006 Brocade Communication Systems, Inc.
 *  All rights reserved.
 *
 */

#ifndef _SAP_OP_H
#define _SAP_OP_H

/* SAP code definitions */


typedef enum _SAP {
	SAP_SB_MGMT				 = 1,
	SAP_BLADE_MGMT,			/* 2 */
	SAP_PORT_MGMT,			/* 3 */

	SAP_MARATHON_MPC_MGMT	 = 10,
	SAP_MARATHON_FCIP_MGMT, /* 11 */
	SAP_MARATHON_BLADE_MGMT, /* 12 */
	SAP_MARATHON_HIFN_MGMT,	/* 13 */
	SAP_MARATHON_TEST_MGMT, /* 14 */

	SAP_ICPD_MGMT,			/* 15 */
	SAP_IBPD_MGMT,			/* 16 */
	SAP_ISCSI_PORT_TCP,		/* 17 */
	SAP_ISCSI_PORT_ISCSI,   /* 18 */
	SAP_ISCSI_PORT_MGMT,	/* 19 */
	SAP_ISCSI_BP_MGMT,  	/* 20 */
	SAP_IPSD_MGMT,   		/* 21 */
	SAP_PC_MGMT,			/* 22 */ 
	SAP_ASIC_MGMT,			/* 23 */

	SAP_IRONMAN_BLDRV_MGMT, /* 24 */
	SAP_IRONMAN_IP_MGMT,	/* 25 */
	SAP_IRONMAN_BLADE_MGMT, /* 26 */
	SAP_IRONMAN_CHIP_MGMT,	/* 27 */
	SAP_IRONMAN_TEST_MGMT,	/* 28 */
	SAP_IRONMAN_BLPTIO_MGMT,/* 29 */

	SAP_SCP_SBP_MGMT,		/* 30 */
	SAP_LICENSE_MGMT,		/* 31 */
	SAP_CAL_MGMT,			/* 32 */
	SAP_ARR_MGMT,			/* 33 */
	SAP_NS_MGMT,			/* 34 */
	SAP_EVM_MGMT,			/* 35 */
	/*
	 * Add new SAP entry above this line.
	 */
	SAP_OF_LAST
} SAP;


/*
 * SAP opcode for Scimitar.  Just alias that of Marathon
 */
#define	SAP_SCIMITAR_MPC_MGMT	 SAP_MARATHON_MPC_MGMT
#define	SAP_SCIMITAR_CPSAS_MGMT  SAP_MARATHON_FCIP_MGMT

/*
**  DEFINE OPCODES FOR VARIOUS SAPs
**	OPCODE from 1 to 30 are reseved for common group operations
**  Group specific op code starts from 41
*/

/*
 * SAP_SB_MGMT(1) OPCODES
 */
typedef enum _SB_MGMT_OP {
	SB_SUBSCRIBE_REQ		= 41,
	SB_SUBSCRIBE_RSP,				  /* 42 */
	SB_DEL_SUBSCRIBE_REQ,			  /* 43 */
	SB_DEL_SUBSCRIBE_RSP,			  /* 44 */
    SB_GET_SAP_OP_SUBSCRIBERS_REQ,    /* 45 */
    SB_GET_SAP_OP_SUBSCRIBERS_RSP,    /* 46 */
	SB_CP_FAILOVER,					  /* 47 */
	SB_OF_LAST
} SB_MGMT_OP;


/*
 * SAP_BLADE_MGMT(2) OPCODES
 */
typedef enum _BLADE_MGMT_OP {
	BMGMT_HELLO_REQ		= 41,
	BMGMT_HELLO_RESP,		/* 42 */
	BMGMT_VERSION_REQ,		/* 43 */
	BMGMT_VERSION_RESP,		/* 44 */
	BMGMT_FWINSTALL_REQ,	/* 45 */
	BMGMT_FWINSTALL_RESP,	/* 46 */
	BMGMT_FWCOMMIT_REQ,		/* 47 */
	BMGMT_FWCOMMIT_RESP,	/* 48 */
	BMGMT_REBOOT_REQ,		/* 49 */
	BMGMT_FWABORT_REQ,		/* 50 */
	BMGMT_FWABORT_RESP,		/* 51 */
	BMGMT_CP_FAILOVER,		/* 52 */

	/*
	 * Applications on AP must wait for this OP before they can
	 * communicate with their CP counterparts. This op indicates that
	 * the version check with the CP has passed, and the AP version is
	 * compatible with that of CP.
	 */
	BMGMT_APPS_START,		/* 53 */
	BMGMT_SFP_INFO,			/* 54 */
	BMGMT_TIMEUPDATE,		/* 55 */ /* time update from CP to BP */
	BMGMT_BLADE_ON,			/* 56 */ /* Blade is now up and running	*/
	BMGMT_SET_DEBUG_FLAG,	/* 57 */ /* Set debug flag				*/
	BMGMT_VERSION_INFO,		/* 58 */ /* Latest BP version info from BC	*/
	BMGMT_BLADE_FAULTY,		/* 59 */ /* Blade is faulty, msg from BC	*/
	BMGMT_BLADE_HTBT_REQ,	/* 60 */ /* htbt request from BM to BC		*/
	BMGMT_BLADE_HTBT_RESP,	/* 61 */ /* htbt response from BC to BM		*/

	/*
	 * Add new OP entry above this line.
	 */
	BMGMT_OP_LAST
} BLADE_MGMT_OP;


/*
 * SAP_PORT_MGMT(3) OPCODES
 */
typedef enum _PORT_MGMT_OP {
    PMGMT_PORT_START	= 41,
    PMGMT_PORT_STOP,			/* 42  */
	PMGMT_PORT_ENABLE,			/* 43  */
	PMGMT_PORT_DISABLE,			/* 44  */
	PMGMT_PORT_DIAG_ENABLE,		/* 45  */
	PMGMT_PORT_DIAG_DISABLE,	/* 46  */

	/*
	 * Add new OP entry above this line.
	 */
	PMGMT_OP_LAST
} OBJMGR_OP;

/*
 * SAP_MARATHON_MPC_MGMT(10) OPCODES
 */
typedef enum _MPC_MGMT_OP {
	MPC_CHIPSTART_RSP	= 41,
	MPC_CHIPSTART_CB,
	MPC_CHIPSTARTED,
	MPC_CHIPSTOP_RSP,
	MPC_CHIPFAILED,
	MPC_CHIPFNUP,
	MPC_CHIPATTACH_DONE,
	MPC_CHIP_WSTART_RSP,
	MPC_IPSEC_STATUS,
	MPC_FIPS_IPSEC,
	MPC_FIPS_IPSEC_FAILURE,

	/* Internal to MPC, MBD, 1250/4350 drivers */
	MPC_GET_CHFNSTATUS = 80,
	MPC_CHIP_START,
	MPC_CHIP_STOP,
	MPC_PORT_ENABLE,
	MPC_PORT_DISABLE,
	MPC_IPSEC_CONFIG,
	MPC_IPSEC_ENABLE,
	MPC_IPSEC_DISABLE,
	MPC_LINK_DOWN,			/* per rcvd IPPM_LINK_DOWN from 1250 */
	MPC_CHIP_WSTART,
	MPC_CHIP_WSTARTED,
	MPC_UP,	
	/*
	 * Add new OP entry above this line
	 */
	MPC_OP_LAST
} MPC_OP;

/*
 * SAP_MARATHON_FCIP_MGMT(11) OPCODES
 */
typedef enum _MFCIP_MGMT_OP {
	MFCIP_CHIP_START	= 41,
	MFCIP_CHIP_STOP,
	MFCIP_PORT_ENABLE,
	MFCIP_PORT_DISABLE,
	MFCIP_CHIP_WSTART,			/* BP WARM start; don't reload 4350/1250 fw */
	MFCIP_IPSEC_CFG,
	MFCIP_IPSEC_ENABLE,
	MFCIP_IPSEC_DISABLE,
	MFCIP_LINK_DOWN,			/* per rcvd IPPM_LINK_DOWN from 1250 */
	/*
	 * Add new OP entry above this line
	 */
	MFCIP_OP_LAST
} MFCIP_OP;

/*
 * SAP_SCIMITAR_CPSAS_MGMT(11) OPCODES
 * They are just alias of the FCIP ones
 */
#define MCPSAS_CHIP_START		MFCIP_CHIP_START
#define MCPSAS_CHIP_STOP		MFCIP_CHIP_STOP
#define MCPSAS_PORT_ENABLE		MFCIP_PORT_ENABLE
#define MCPSAS_PORT_DISABLE		MFCIP_PORT_DISABLE

/*
 * SAP_MARATHON_BLADE_MGMT(12) OPCODES
 */
typedef enum _MBLADE_MGMT_OP {
	MBD_CPFAILOVER	= 41,
	MBD_RESUME,			/* 42 */
	MBD_CONFIGDONE,		/* 43 */
	MBD_BDON,			/* 44 - Blade driver ON		*/

	/*
	 * MBD internal OPs
	 */
	MBD_ATTACH = 80,
	MBD_GETBPCONFIG,
	/*
	 * Add new OP entry above this line
	 */
	MBD_OP_LAST
} MBD_OP;

/*
 * SAP_MARATHON_HIFN_MGMT(13) OPCODES
 */
typedef enum _HIFN_MGMT_OP {
	HIFN_CHIPSTART_RSP	= 41,
	HIFN_CHIPSTART_CB,
	HIFN_CHIPSTOP_RSP,
	HIFN_CHIPFAILED,
	HIFN_CHIPFNUP,
	HIFN_PORTFAILED,
	HIFN_IPSEC_STATUS,
	HIFN_CHIP_WSTART_RSP,
	HIFN_FIPS_IPSEC,
	HIFN_FIPS_IPSEC_FAILURE,
	/*
	 * Add new OP entry above this line
	 */
} HIFN_OP;

/*
 * SAP_MARATHON_TEST_MGMT(14) OPCODES
 */
typedef enum _TEST_MGMT_OP {
	MTST_PRINT_MSGCNT	= 41,
	MTST_TRACE			= 42,

	/*
	 * Add new OP entry above this line
	 */
	M_OP_LAST
} TEST_OP;

/*
 * SAP_ICPD_MGMT(15) OPCODES
 */
typedef enum _ICPD_MGMT_OP {
	ICPD_BLD_HELLO_REQ			= 41, /* icpd <- ibpd */
	ICPD_BLD_HELLO_RSP,			/* 42 icpd -> ibpd */
	ICPD_BLD_VERSION_REQ,		/* 43 icpd <- ibpd */
	ICPD_BLD_VERSION_RSP,		/* 44 icpd -> ibpd */
	ICPD_BLD_DIST_START_REQ,	/* 45 icpd -> ibpd */
	ICPD_BLD_DIST_START_RSP,	/* 46 icpd <- ibpd */
	ICPD_BLD_DIST_COMP_REQ,		/* 47 icpd <- ibpd */
	ICPD_BLD_DIST_COMP_RSP,		/* 48 icpd -> ibpd */
	ICPD_BLD_SESSION_GET_REQ,	/* 49 icpd -> ibpd */
	ICPD_BLD_SESSION_GET_RSP,	/* 50 icpd <- ibpd */
	ICPD_BLD_SESSION_DEL_REQ,	/* 51 icpd -> ibpd */
	ICPD_BLD_SESSION_DEL_RSP,	/* 52 icpd <- ibpd */
	ICPD_BLD_SESSION_CLR_REQ,	/* 53 icpd -> ibpd */
	ICPD_BLD_SESSION_CLR_RSP,	/* 54 icpd <- ibpd */
	ICPD_BLD_GET_ACK,			/* 55 icpd -> ibpd */
	ICPD_BLD_PORT_GET_REQ,		/* 56 icpd -> ibpd */
	ICPD_BLD_PORT_GET_RSP,		/* 57 icpd <- ibpd */
	ICPD_BLD_PORT_CLR_REQ,		/* 58 icpd -> ibpd */
	ICPD_BLD_PORT_CLR_RSP,		/* 59 icpd <- ibpd */
	ICPD_BLD_IQN_GET_REQ,		/* 60 icpd -> ibpd */
	ICPD_BLD_IQN_GET_RSP,		/* 61 icpd <- ibpd */
	ICPD_BLD_PORT_SET_REQ,		/* 62 icpd -> ibpd */
	ICPD_BLD_PORT_SET_RSP,		/* 63 icpd <- ibpd */
	ICPD_MMI_CREATE_REQ,		/* 64 */
	ICPD_MMI_DELETE_REQ,		/* 65 */
	ICPD_MMI_SET_REQ,			/* 66 */
	ICPD_MMI_GET_REQ,			/* 67 */
	ICPD_MMI_GET_NEXT_REQ,		/* 68 */
	ICPD_MMI_MGET_REQ,			/* 69 */
	ICPD_MMI_MSET_REQ,			/* 70 */
	ICPD_MMI_CREATE_RSP,		/* 71 */
	ICPD_MMI_DELETE_RSP,		/* 72 */
	ICPD_MMI_SET_RSP,			/* 73 */
	ICPD_MMI_GET_RSP,			/* 74 */
	ICPD_MMI_GET_NEXT_RSP,		/* 75 */
	ICPD_MMI_MGET_RSP,			/* 76 */
	ICPD_MMI_MSET_RSP,			/* 77 */
	ICPD_BLD_TGT_UPDATE,		/* 78 */
	ICPD_BLD_ITR_CLR,			/* 79 */
	ICPD_MGMT_OP_LAST
} ICPD_OP;

/*
 * SAP_IBPD_MGMT(16) OPCODES
 */
typedef enum _IBPD_MGMT_OP {
	IBPD_CFG_DIST_COMP			= 41, /* child of ibpd ->ibpd */
	IBPD_DBG_CMD,
	IBPD_LOGIN_EVENT_UPDATE,	/* ibpd -> icpd */
	IBPD_EVENT_GET_REQ,			/* icpd -> ibpd */
	IBPD_EVENT_GET_RSP,			/* icpd <- ibpd */
	IBPD_STATUS_UPDATE,			/* icpd -> ibpd */
	IBPD_ITR_CACHE_FULL_EVENT,	/* ibpd -> icpd */
	IBPD_PORTAL_GET_REQ,		/* icpd -> ibpd */
	IBPD_PORTAL_GET_RSP,		/* icpd <- ibpd */
	IBPD_PORTAL_UPDATE,			/* icpd <- ibpd */
	IBPD_EVENT_LOG_CLEAR,		/* icpd -> ibpd */
	IBPD_ICR_SET_REQ,			/* icpd -> ibpd */
	IBPD_ICR_SET_RSP,			/* ibpd -> icpd */
	IBPD_MGMT_OP_LAST
} IBPD_OP;

/*
 * SAP_ISCSI_PORT_TCP (17) OPCODES
 */

typedef enum{
    TCP_OPEN_REQ = 1,
    TCP_INIT_REQ = TCP_OPEN_REQ,
    TCP_OPEN_RSP,       /* 2 */
    TCP_CLOSE_REQ,      /* 3 */
    TCP_CLOSE_RSP,      /* 4 */
    TCP_EVENT,          /* 5 */
    TCP_QOS_REQ,        /* 6 */
    TCP_QOS_RSP,        /* 7 */
    TCP_QOS_DEL,        /* 8 */ 
    TCP_QOS_DEL_RSP,    /* 9 */ 

    TCP_INIT_RSP,        /* 10 ibpd --> Port ack for cnn open */
    TCP_DATA,            /* 11 ibpd <--> port */
    TCP_OPEN_RSP_ACK,    /* 12 ibpd --> Port ack for cnn open */
    TCP_UPDATE_CFG_REQ,  /* 13 ibpd <-->port after session reaches FFP*/
    TCP_UPDATE_CFG_RSP,  /* 14 Port --> ibpd */
	TCP_IP_UP_EVENT, 	/* 15 BP --> port ip ready event */
}OP_ISCSI_PORT_TCP;

/*
 * SAP_ISCSI_PORT_ISCSI (18) OPCODES
 */
typedef enum{
    ISCSI_NORMAL_LOGIN_REQ = 1,  /* 1 ibpd requests iSCSI Port to open target 
                                (ibpd->Port) */
    ISCSI_NORMAL_LOGIN_REQ_ACK,  /* 2 Port to BP - acks the req.this will trigger
	                                  the MNG_REQ to port from BP */
    ISCSI_NORMAL_LOGIN_RSP,      /* 3 iSCSI Port rsp to open target 
                                    req (Port->ibpd) */
    ISCSI_LOGIN_ABORT_REQ,       /* 4 Abort any outstanding logins to the target */
    ISCSI_LOGIN_ABORT_RSP,       /* 5 Abort rsp (port to bp)*/
    ISCSI_SESSION_CLEANUP_REQ,   /* 6 Cleanup active session */
    ISCSI_SESSION_CLEANUP_RSP,   /* 7 Cleanup rsp (port to bp)*/
    /* New types for MC/S */
    ISCSI_CONN_REQ,              /* 8 ibpd-> all associated Port */
    ISCSI_CONN_RSP,              /* 9 Port-> ibpd(port to bp)*/
    ISCSI_CONN_CLEANUP_REQ,      /* 10 Cleanup active connection */
    ISCSI_CONN_CLEANUP_RSP,      /* 11 Cleanup active connection (port to bp)*/
    ISCSI_EVENT_REQ,             /* 12 event from port iscsi agent (port to bp)*/
    ISCSI_EVENT_RSP,             /* 13 event rsp from bp to port */
    ISCSI_STATIC_CLEAR_REQ,      /* 14 ibpd->port to clear the statistics */
    ISCSI_STATIC_CLEAR_RSP,      /* 15 clear the statistics rsp (port to bp)*/
    ISCSI_ADD_FC_TGT_REQ,        /* obsolete */
    ISCSI_FC_TGT_MNG_REQ,        /* 16 manage FC target at the port (bp to port) */
    ISCSI_FC_TGT_MNG_RSP,        /* 17 manage FC target rsp (port to bp) */
	ISCSI_CONN_STATS_REQ,		/* 18 get stats by session request */
	ISCSI_CONN_STATS_RES,		/* 19 get stats by session response */
	ISCSI_GBL_STATS_REQ,		/* 20 get global stats request */
	ISCSI_GBL_STATS_RES,		/* 21 get global stats response */
	ISCSI_CONN_STATS_CLEAR_REQ,	/* 22 clear stats by session request */
	ISCSI_CONN_STATS_CLEAR_RES,	/* 23 clear stats by session response */
	ISCSI_CLEAR_GBL_STATS_REQ,	/* 24 clear global stats request */
	ISCSI_CLEAR_GBL_STATS_RES	/* 25 clear global stats response */

}OP_ISCSI_PORT_ISCSI;



/*
 * SAP_IRONMAN_BLADE_MGMT OPCODES
 */
typedef enum _IBLADE_MGMT_OP {
    IBD_CPFAILOVER  = 41,
    IBD_RESUME,         /* 42 */
    IBD_CONFIGDONE,     /* 43 */
	IBD_GETBPCONFIG,

    /*
     * Add new OP entry above this line
     */
    IBD_OP_LAST
} IBD_OP;

/*
 * SAP_IRONMAN_CHIP_MGMT OPCODES
 */
typedef enum _IPC_MGMT_OP {
    IPC_CHIPSTART_RSP   = 41,
    IPC_CHIPSTART_CB,
    IPC_CHIPSTARTED,
    IPC_CHIPSTOP_RSP,
    IPC_CHIPFAILED,
    IPC_CHIPFNUP,


    /* Internal to IPC, IBD, 1125 drivers */
    IPC_GET_CHFNSTATUS = 80,
    IPC_CHIP_START,
    IPC_CHIP_STOP,
    /*
     * Add new OP entry above this line
     */
    IPC_OP_LAST
} IPC_OP;

/*
 * SAP_IRONMAN_TEST_MGMT OPCODES
 */
typedef enum _ITEST_MGMT_OP {
    ITST_PRINT_MSGCNT   = 41,
    ITST_TRACE,
	ITST_SEND_IPSDMSG,
	ITST_SEND_BLDMSG,
	ITST_SEND_PCMSG,
	ITST_RSP_PCMSG,
	ITST_CQFULL,
	ITST_HTBTDOWN,

	
    /*
     * Add new OP entry above this line
     */
    ITST_OP_LAST
} ITEST_OP;

/*
 * SAP_ISCSI_PORT_MGMT (19)
 */
typedef enum {
	PT_GE_EVENT = 41,
	PT_BI_EVENT,
	PT_CH_EVENT,
	PT_ISCSI_HTBT,
	PT_ISCSI_CQ,
	PT_ISCSI_CFG_DONE,
	PT_EVENT,
	/*
	 * Add new OP entry above this line
	 */
	PORT_OP_LAST
} PORT_OP;

/*
 * SAP_ISCSI_BP_MGMT (20)
 */
typedef enum {
	PTIO_CMD = 41,
	BP_ISCSI_HTBT,
	/*
	 * Add new OP entry above this line
	 */
	BP_OP_LAST
} BP_OP;

/*
 * SAP_PC_MGMT (22)
 */

/*
 * SAP_ASIC_MGMT (23)
 */
typedef enum{
	ASIC_CHIP_START	= 41,
	ASIC_CHIP_STOP,
	
	/*
	 * Add new OP entry above this line
	 */
	ASIC_OP_LAST
} ASIC_OP;

/*
 * SAP_IRONMAN_BLDRV_MGMT OPCODES
 */
typedef enum {
	IBDRV_MGMT_REQ = 41,
	IBDRV_MGMT_RSP,

	OP_IBDRV_LAST
} OP_IBDRV;

/*
 * SAP_IRONMAN_IP_MGMT OPCODES
 */
typedef enum {
	IIP_MGMT_REQ = 41,
	IIP_MGMT_RSP,
	OP_IIP_LAST
} OP_IIP;

typedef enum {
	PT_GET_TRACE_STAT = 41,
	PT_GET_TRACE_BUF,
	PT_TRACE_FLUSH,
	PT_SET_TRACE_CFG,
	OP_IRONMAN_BLPTIO_LAST
} OP_BLPTIO;


/*
 * SAP_SCP_MGMT(30) OPCODES
 */
typedef enum _SCP_SBP_MGMT_OP {
	SCP_BLD_HELLO_REQ			= 41, /* scpd <- sbpd */
	SCP_BLD_HELLO_RSP,			/* 42 scpd -> sbpd */

	SCP_MGMT_OP_LAST
} SCP_OP;

/*
 * SAP_LICENSE_MGMT(31) OPCODES
 */
typedef enum _SBP_LICENSE_OP {
	SCP_LICENSE_HELLO_REQ		= 41, /* scpd <- sbpd */
	SCP_LICENSE_HELLO_RSP,			/* 42 scpd -> sbpd */
	SCP_LICENSE_ADD_REQ,			/* 45 scpd <- sbplib */
	SCP_LICENCE_ADD_RSP,			/* 46 scpd -> sbplib */
	SCP_LICENCE_DELETE_REQ,		/* 47 scpd <- sbplib */
	SCP_LICENCE_DELETE_RSP,		/* 48 scpd -> sbplib */
	SCP_LICENCE_MODIFY_REQ,		/* 49 scpd <- sbplib */
	SCP_LICENCE_MODIFY_RSP,		/* 50 scpd -> sbplib */

	SBP_LICENSE_OP_LAST
} SBP_LICENSE_OP;

/*
 * SAP_CAL_MGMT (32) OP codes
 */
typedef enum _SBP_CAL_MGMT_OP {
	SCP_CAL_HELLO_REQ			= 41, 	/* cald <-- sbp */
	SCP_CAL_HELLO_RSP,					/* cald --> sbp */
	SCP_CAL_TEST_REQ,					/* cald <-- sbp */
	SCP_CAL_TEST_RSP,					/* cald --> sbp */
	SA_MGMT_REGISTER_MESSAGE,			/* BP --> CP 	*/
	SA_MGMT_REGISTER_RESP,				/* CP --> BP	*/
	SA_MGMT_APP_STATUS_REQ,				/* CP --> BP 	*/
	SA_MGMT_APPSTATUS_RESP,				/* BP --> CP	*/
	SA_MGMT_MOF_REQ,					/* CP --> BP	*/
	SA_MGMT_WBEM_REQUEST,				/* CP --> BP	*/

	SCP_CAL_OP_LAST
} SBP_CAL_MGMT_OP;

/*
 * SAP_ARR_MGMT (33) OP Codes
 */
typedef enum _SBP_ARR_MGMT_OP {
	SCP_ARR_HELLO_REQ			= 41,	/* arrd <-- sbp */
	SCP_ARR_HELLO_RSP,					/* arrd --> sbp */
	SCP_ARR_TEST_REQ,					/* arrd <-- sbp */
	SCP_ARR_TEST_RSP,					/* arrd --> sbp */
	SA_MGMT_WBEM_RESP,					/* BP --> CP 	*/
	SA_MGMT_MOF_RESP,					/* BP --> CP 	*/

	SCP_ARR_OP_LAST
} SBP_ARR_MGMT_OP;

/*
 * SAP_NS_MGMT (34) OP Codes
 */
typedef enum _SBP_NS_MGMT_OP {
	SCP_NS_HELLO_REQ			= 41,	/* ns <-- sbp */
	SCP_NS_HELLO_RSP,					/* ns --> sbp */
	SCP_NS_TEST_REQ,					/* ns <-- sbp */
	SCP_NS_TEST_RSP,					/* ns --> sbp */
	GNN_DAP_REQ,
	GNN_DAP_RSP,
	GSPN_DAP_REQ,
	GSPN_DAP_RSP,
	GDAP_PN_REQ,
	GDAP_PN_RSP,
	GDAP_FT_REQ,
	GDAP_FT_RSP,
	GPN_FT_REQ,
	GPN_FT_RSP,
	GDAPOBJ_DAP_REQ,
	GDAPOBJ_DAP_RSP,
	CMD_REJECT,
	CMD_RSCN,
	ZS_ADD_ZONE_REQ, 
	ZS_REMOVE_ZONE_REQ, 
	ZS_COMMIT_REQ,
	ZS_ADD_ZONE_RSP,
        ZS_REMOVE_ZONE_RSP,
        ZS_COMMIT_RSP,
	ZS_QUERY_ZONE_REQ,
	ZS_QUERY_ZONE_RSP,
	SCP_NS_OP_LAST
} SBP_NS_MGMT_OP;

typedef enum _SaP_SCP_SBP_MGMT {
	SBP_CP_FAILOVER_MSG			= 41,
	SBP_CONNECTION_RESTORED
} SAP_SCP_SBP_MGMT_OP;

/*
 * SAP_EVM_MGMT (35) OP Codes
 */
typedef enum _SBP_EVM_MGMT {
	SCP_EVM_HELLO_REQ			= 41,
	SCP_EVM_HELLO_RSP,
	SCP_EVM_TEST_REQ,
	SCP_EVM_TEST_RSP,
	SA_MGMT_EVENT_MESSAGE,				/* BP --> CP	*/

	SCP_EVM_OP_LAST
} SBP_EVM_MGMT;

#endif	/* _SAP_OP_H */
