#ifndef _CSCN_SYNC_H_
#define _CSCN_SYNC_H_

#include <stdtypes.h>
#include <stdlib.h>
#include <errno.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <sys/uio.h>
#include <syslog.h>
#include "cs.h"
#include "csdbg.h"
#include "cs.h"
#include "csmsg.h"

typedef int cs_cn_sync_hdl_t;

/* synchronous-client connection api's */
extern int               
cs_cn_init_sync(char *ident, int logopt, void (*sigterm_hdl) (int sig));
/* Default connection is using tcp */
extern cs_cn_sync_hdl_t  
cs_cn_connect_sync(int port, char *host, int timeout);
extern cs_cn_sync_hdl_t  
cs_cn_connect_sync_uds(int port, char *host, int timeout);
#ifdef XBAR
extern cs_cn_sync_hdl_t 
cs_cn_connect_xbar_sync(int qnum);
#endif
extern int 
cs_cn_setsockopt_sync(cs_cn_sync_hdl_t fd, int level, int optname, void *optval,
 socklen_t optlen, int *err);
extern int               
cs_cn_msg_send_sync(cs_cn_sync_hdl_t ch, char *msg, int len, int timeout);
extern int
cs_cn_msg_recv_sync(cs_cn_sync_hdl_t ch, char *msg, int len, int timeout);
extern void
cs_cn_close_sync(cs_cn_sync_hdl_t ch);

#endif /* _CSCN_SYNC_H_ */
