/*****************************************************************************
 *
 * Copyright 2000 Rhapsody Networks Inc
 *
 * Module Name:
 *     csdbg.h
 *
 * Abstract:
 *     Defines debugging and assertion macros.
 *
 * Revision History:
 *     $Revision: 1.25 $
 *
 ****************************************************************************/

#ifndef _CSDBG_H
#define _CSDBG_H

#include "stdtypes.h"
#include "cstrc.h"

#if !defined(_KERNEL) && !defined(__ARM)
#include <syslog.h>
#endif

#ifndef CS_DEBUG

#ifdef _KERNEL

#include <sys/types.h>
#include <sys/systm.h>
#include <sys/param.h>
#include <sys/kernel.h>

#define cs_assert(_exp) do { } while (/*CONSTCOND*/0)

#else  /* _KERNEL */

#define cs_assert(_exp) do { } while (/*CONSTCOND*/0)

#endif

#else   /* CS_DEBUG */

#ifdef _KERNEL

#include <sys/types.h>
#include <sys/systm.h>
#include <sys/param.h>
#include <sys/kernel.h>

#define cs_assert(_exp) KDASSERT(_exp)
                                      
/*
#define cs_assert(_expression)                                      \
do {                                                                \
    if (!(_expression))                                             \
        panic("Assertion: \"%s\" failed: file \"%s\", line %d\n",    \
            #_expression, __FILE__, __LINE__);                      \
} while(0);
*/

#elif __ARM
#ifdef RN_EAP
#include <stdio.h>
#define vpm_assert()    while(1)

#ifdef RN_GM
#define cs_assert(_expression)  
#else
#define cs_assert(_expression)                                      \
do {                                                                \
    if (!cstrcbuf.asserted) {                                       \
    if (!(_expression)) {                                           \
sprintf(cstrcbuf.assert_str,"Assertion \"%s\" failed: file \"%s\", line %d\n",\
                #_expression, __FILE__, __LINE__);                  \
        printf(cstrcbuf.assert_str);                                \
        cstrcbuf.asserted   = 1;                                    \
        vpm_assert();												\
    }                                                               \
    }                                                               \
} while(0);
#endif
#elif defined (RN_PRODUCTION)
#include <stdio.h>
#define cs_assert(_expression)                                      \
do {                                                                \
    if (!(_expression)) {                                           \
    printf("Assertion \"%s\" failed: file \"%s\", line %d\n",       \
                #_expression, __FILE__, __LINE__);                  \
    }                                                               \
} while(0);
#endif

#else

#include <assert.h>
#include <syslog.h>
#include <stdio.h>		/* for printf */

#define cs_assert(_expression)                                              \
do {                                                                        \
    if (!(_expression)) {                                                   \
        uint32_t *ptr = 0;                                                  \
        syslog(LOG_ERR, "Assertion: \"%s\" Failed: file \"%s\", line %d\n",  \
                #_expression, __FILE__, __LINE__);                          \
        *ptr = 1;                                                           \
    }                                                                       \
} while(0)

#endif  /* _KERNEL */

#ifdef _KERNEL

#elif __ARM

#ifndef RN_SWAPI2

#else  /* ifndef RN_SWAPI2 */

#endif /* ifndef RN_SWAPI2 */

#else

#endif

#endif  /* CS_DEBUG */

#endif /* _CSDBG_H */

