/*
 * Copyright (c) 1996-2007 Brocade Communications Systems, Inc.
 * All rights reserved.
 *
 * Description:
 *    This file contains the datastructures, definitions
 *    needed by the DMM license support.  It also contain function
 *    prototypes.
 *
 */

#ifndef __DMM_LIC_DEF_H__
#define __DMM_LIC_DEF_H__

#include <sys/types.h>
#include <ctype.h>
#include <cs/cscn.h>
#include <dmm_lic_cmhdr.h>

#define DMM_LIC_UCONTEXT_SIZE	16
#define DMM_LIC_TIME_OUT		10000		/* Time in Sec */

#define DMM_LIC_ERROR(x_str) \
	{printf("%-20s %d: ERROR : %s\n", __FUNCTION__, __LINE__, x_str); }

/* Un-init DMM License service */
void dmm_license_deinit(void *uctx);

/* Callback function definitions to send response from CP to DMM */
typedef void(*dmm_lic_init_cb_t)
	(void *uctx, dmm_lic_status_t status);
typedef void(*dmm_lic_add_cb_t)
	(void *uctx, dmm_lic_status_t status, dmm_lic_info_t *dmm_lic_info);
typedef void(*dmm_lic_delete_cb_t)
	(void *uctx, dmm_lic_status_t status, dmm_lic_info_t *dmm_lic_info);
typedef void(*dmm_lic_type_present_cb_t)
	(void *uctx, dmm_lic_status_t status, dmm_lic_info_t *dmm_lic_info);
typedef void(*dmm_lic_get_all_licenses_cb_t)
	(void *uctx, dmm_lic_status_t status, dmm_lic_info_t *dmm_lic_info, 
	int count);
typedef void(*dmm_lic_reserve_tbs_cb_t)
	(void *uctx, dmm_lic_status_t status, uint64_t tbs);
typedef void(*dmm_lic_release_tbs_cb_t)
	(void *uctx, dmm_lic_status_t status);
typedef void(*dmm_lic_add_wwn_cb_t)
	(void *uctx, dmm_lic_status_t status, uint32_t count);
typedef void(*dmm_lic_get_wwn_list_cb_t)
	(void *uctx, dmm_lic_status_t status, dmm_lic_wwn_t *wwn, uint32_t count);
typedef void(*dmm_lic_wwn_present_cb_t)
	(void *uctx, dmm_lic_status_t status);
typedef void(*dmm_lic_get_info_cb_t)
	(void *uctx, dmm_lic_status_t status, uint8_t dmmlicflag);
typedef void(*dmm_lic_parse_key_cb_t)
	(void *uctx, dmm_lic_status_t status, dmm_lic_info_t *dmm_lic_info);
typedef void(*dmm_lic_commit_cb_t)
	(void *uctx, dmm_lic_status_t status);
typedef void(*dmm_lic_flush_cb_t)
	(void *uctx, dmm_lic_status_t status);

/* Structure with all call back functions */
typedef struct _dmm_lic_cb_t {
	dmm_lic_init_cb_t				dmm_lic_init;
	dmm_lic_add_cb_t				dmm_lic_add;
	dmm_lic_delete_cb_t				dmm_lic_delete;
	dmm_lic_type_present_cb_t		dmm_lic_type_present;
	dmm_lic_get_all_licenses_cb_t	dmm_lic_get_all_lics;
	dmm_lic_reserve_tbs_cb_t		dmm_lic_reserve_tbs;
	dmm_lic_release_tbs_cb_t		dmm_lic_release_tbs;
	dmm_lic_add_wwn_cb_t			dmm_lic_add_wwn;
	dmm_lic_get_wwn_list_cb_t		dmm_lic_get_wwn_list;
	dmm_lic_wwn_present_cb_t		dmm_lic_wwn_present;
	dmm_lic_get_info_cb_t			dmm_lic_get_info;
	dmm_lic_parse_key_cb_t			dmm_lic_parse_key;
	dmm_lic_commit_cb_t				dmm_lic_commit;
	dmm_lic_flush_cb_t				dmm_lic_flush;
}dmm_lic_cb_t;


/* Initialize DMM License service */
dmm_lic_status_t dmm_license_init(void *uctx, dmm_lic_cb_t dmm_lic_cb, char *guid);

/* APIs */
dmm_lic_status_t dmm_lic_add(dmm_lic_key_t key, void *uctx);
dmm_lic_status_t dmm_lic_delete(dmm_lic_key_t key, void *uctx);
dmm_lic_status_t dmm_lic_type_present(dmm_lic_type_t type, void *uctx);
dmm_lic_status_t dmm_lic_get_all_licenses(void *uctx);
dmm_lic_status_t dmm_lic_reserve_tbs(dmm_lic_type_t type, uint64_t tbs, void *uctx);
dmm_lic_status_t dmm_lic_release_tbs(dmm_lic_type_t type, uint64_t tbs, void *uctx);
dmm_lic_status_t dmm_lic_add_wwn(dmm_lic_type_t type, dmm_lic_wwn_t wwn, void *uctx);
dmm_lic_status_t dmm_lic_get_wwn_list(dmm_lic_type_t type, void *uctx);
dmm_lic_status_t dmm_lic_wwn_present(dmm_lic_type_t type, dmm_lic_wwn_t wwn, void *uctx);
dmm_lic_status_t dmm_lic_get_info(void *uctx);
dmm_lic_status_t dmm_lic_parse_key(dmm_lic_key_t key, void *uctx);
dmm_lic_status_t dmm_lic_commit(dmm_lic_type_t type, uint64_t tbs, void *uctx);
dmm_lic_status_t dmm_lic_flush(void *uctx);

#endif /* __DMM_LIC_DEF_H__ */
