/*
 *
 *    Copyright (c) 2005 by Brocade Communications Systems, Inc.
 *    All rights reserved.
 *
 *    Module name: swd_api.h
 *
 *    Description:
 *	  Marathon SWD API functions declarations
 */

#ifndef	__SWD_API_H__
#define	__SWD_API_H__

#ifdef __cplusplus
extern C {
#endif

#define SWD_APP_EMPTY	 0	/* must be zero */
#define SWD_APP_CRITICAL  1
#define SWD_APP_NORMAL    2



/*
 * SWD INTERFACE
 */
extern	int	 swd_disable(void);
extern	int	 swd_disable_app(void);
extern	int	 swd_disable_switch(int);
extern	int	 swd_enable(void);
extern	int	 swd_enable_app(void);
extern	int	 swd_enable_switch(int);
extern	int	 swd_get_timeout(u_long *);
extern	int	 swd_init(char *);
extern	void 	 swd_close(void);
extern	int	 swd_list_all(char *, int);
extern	int	 swd_read_conf(int swbd);
extern	int	 swd_refresh(void);
extern	int	 swd_set_min_timeout(int, int);
extern	int	 swd_unregister(void);
extern	int	 swd_get_fd();
extern	int	 swd_register(char *, int, int *, char *,
						char *, int (*graceful_term_callback)(void));
extern	int	 swd_register_dir(char *applName, int switchIns, int timeoutValue,
		 int retry, int type, char *cmd_path, char *args,
				  int (*graceful_term_callback)(void));
extern	time_t 	 swd_refresh_to(void);

#ifdef __cplusplus
}
#endif

#endif /* __SWD_API_H__ */
