/*
 * cslock.h - threaded cs cn/tmr
 */

#ifndef _CSLOCK_H
#define _CSLOCK_H

#ifdef THREADS

#include <pthread.h>

extern pthread_mutex_t cs_mutex;

#ifdef DEBUG
extern pthread_t            cs_mutex_owner;
#define CSL_DBG_LOCK()      cs_mutex_owner = pthread_self()
#define CSL_DBG_UNLOCK()    cs_mutex_owner = 0
#else
#define CSL_DBG_LOCK()
#define CSL_DBG_UNLOCK()
#endif

#define cs_lock(_spl)       do {    \
    (_spl = 1);                     \
    pthread_mutex_lock(&cs_mutex);  \
    CSL_DBG_LOCK();                 \
} while (0)

#define cs_unlock(_spl)     do {    \
    CSL_DBG_UNLOCK();               \
    pthread_mutex_unlock(&cs_mutex);\
    (_spl = 0);                     \
} while (0)

#define cs_lock_held()  (cs_mutex_owner == pthread_self())

int  cs_selinit(void);
void cs_seldone(void);
void cs_selwait(void);
void cs_selwakeup(void);

#elif defined (_KERNEL)
#include <machine/intr.h>

#define cs_lock(_spl)       (_spl) = splnet()

#define cs_unlock(_spl)     splx(_spl)

#define cs_lock_held()      (1)

int  cs_selinit(void);
void cs_seldone(void);
void cs_selwait(void);
void cs_selwakeup(void);

#else

#define cs_lock(_spl)   (_spl = 1)
#define cs_unlock(_spl) (_spl = 0)
#define cs_lock_held()  (1)
#define cs_selinit()    (0)
#define cs_seldone()
#define cs_selwait()
#define cs_selwakeup()

#endif /* THREADS */

#endif /* _CSLOCK_H */
