/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _REMAPI_H_RPCGEN
#define _REMAPI_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif

/*
 * Copyright (c) 1996-2000 by Brocade Communications Systems, Inc.
 * All rights reserved.
 *
 * RPCGEN generated file for Remote APIs
 */
/*
 *  Remote Zone API
 */
#define RAPI_GROUP_MAXNAMELEN 64
#define RAPI_GROUP_MAXARGLEN 256
#define RAPI_MAXHOSTLEN 257
#define RAPI_SCSISTRING_MAXLENGTH 256
#define RPC_LICENSE_LEN_MAX 64
#define MAX_PRODUCTNAME_LEN 255
#define SG_MAX_MEMBERS 128
#define SG_NAME_SIZE 32
#define RAPI_DATA_MAX_PACKET 32768
#define MAX_SERIAL_NUMBER_LEN 64
#define FA_STRING_MAX_SIZE 100
#define FA_STRING_MEDIUM_SIZE 50
#define FA_DESCRIPTION_STRING_SIZE 256

struct auth_res {
	long accesslevel;
	char swid[8];
	u_long conx_sig;
};
typedef struct auth_res auth_res;

struct auth_res2 {
	long accesslevel;
	char swid[8];
	u_long conx_sig;
	long retcode;
};
typedef struct auth_res2 auth_res2;

struct auth_res3 {
	long accesslevel;
	char swid[8];
	u_long conx_sig;
	long retcode;
	int home_ad;
	char home_ad_name[256];
	char role[64];
	char firmwareversion[64];
	char switch_wwn[8];
	struct {
		u_int active_ad_list_len;
		long *active_ad_list_val;
	} active_ad_list;
};
typedef struct auth_res3 auth_res3;

typedef u_char pwwn_t[8];

typedef u_char dotIP[16];

struct sfversion_res {
	long retcode;
	char sfversion[32];
};
typedef struct sfversion_res sfversion_res;

enum zo_type {
	ZN_WILD_CARD = -1,
	ZN_NAME_TYPE = 0,
	ZN_CFG_TYPE = 1,
	ZN_ZONE_TYPE = 2,
	ZN_ALIAS_TYPE = 3,
	ZN_QLP_TYPE = 4,
	ZN_FA_TYPE = 6,
	ZN_CFG_END_TYPE = 7,
};
typedef enum zo_type zo_type;

struct rgroup_info {
	zo_type group_type;
	char *group_name;
	char *group_mem_list;
};
typedef struct rgroup_info rgroup_info;

struct rgroup_info_nolimit {
	zo_type group_type;
	char *group_name;
	char *group_mem_list;
};
typedef struct rgroup_info_nolimit rgroup_info_nolimit;

enum rgroup_copy_op_t {
	RGRP_COPY_OP_COPY = 0,
	RGRP_COPY_OP_RENAME = 1,
};
typedef enum rgroup_copy_op_t rgroup_copy_op_t;

struct rgroup_copy_t {
	rgroup_copy_op_t op;
	zo_type group_type;
	char *group_name1;
	char *group_name2;
};
typedef struct rgroup_copy_t rgroup_copy_t;

struct rcfg_load_t {
	char *buffer;
	int enable;
};
typedef struct rcfg_load_t rcfg_load_t;

enum rzone_asynch_op_t {
	RZN_ASYNCH_SAVE = 0,
	RZN_ASYNCH_ENABLE = 1,
	RZN_ASYNCH_DISABLE = 2,
};
typedef enum rzone_asynch_op_t rzone_asynch_op_t;

struct rzone_asynch_union {
	rzone_asynch_op_t type;
	union {
		char *group_name;
	} rzone_asynch_union_u;
};
typedef struct rzone_asynch_union rzone_asynch_union;

struct rzone_asynch_t {
	int tx_id;
	rzone_asynch_union asynch;
};
typedef struct rzone_asynch_t rzone_asynch_t;

struct license_key {
	char key[RPC_LICENSE_LEN_MAX];
};
typedef struct license_key license_key;

typedef struct {
	u_int license_key_set_len;
	license_key *license_key_set_val;
} license_key_set;

enum fabric_discover_depth {
	DISCOVER_NONE = 0x00,
	DISCOVER_SWITCH = 0x01,
	DISCOVER_PORTMODULE = 0x02,
	DISCOVER_PORT = 0x03,
	DISCOVER_ATTACHEDPORT = 0x04,
	DISCOVER_NODE = 0x05,
	DISCOVER_DEVICE = 0x06,
	DISCOVER_ALL = 0x100,
};
typedef enum fabric_discover_depth fabric_discover_depth;

struct pmodule_msg {
	int minPort;
	int maxPort;
};
typedef struct pmodule_msg pmodule_msg;

struct ms_gsw_msg {
	char switch_wwn[8];
	long ver;
	u_int start_slot;
	int reserve1;
	struct {
		u_int pmoduleList_len;
		pmodule_msg *pmoduleList_val;
	} pmoduleList;
	struct {
		u_int portList_len;
		pwwn_t *portList_val;
	} portList;
};
typedef struct ms_gsw_msg ms_gsw_msg;

struct ms_gfabric_msg {
	fabric_discover_depth discover_cmd;
	int reserve1;
	int reserve2;
	int reserve3;
	int reserve4;
	struct {
		u_int switchList_len;
		ms_gsw_msg *switchList_val;
	} switchList;
};
typedef struct ms_gfabric_msg ms_gfabric_msg;

struct ms_port_msg {
	int portnumber;
	int porttype;
	pwwn_t portwwn;
};
typedef struct ms_port_msg ms_port_msg;

struct ms_pm_topo_msg {
	int slotnumber;
	int slottype;
	int reserved1;
	int reserved2;
	struct {
		u_int portList_len;
		ms_port_msg *portList_val;
	} portList;
};
typedef struct ms_pm_topo_msg ms_pm_topo_msg;

struct ms_gsw_topo_msg {
	char switch_wwn[8];
	long ver;
	u_int start_slot;
	int reserve1;
	struct {
		u_int pmoduleList_len;
		ms_pm_topo_msg *pmoduleList_val;
	} pmoduleList;
};
typedef struct ms_gsw_topo_msg ms_gsw_topo_msg;

struct ms_gfab_topo_msg {
	fabric_discover_depth discover_cmd;
	int reserve1;
	int reserve2;
	int reserve3;
	int reserve4;
	struct {
		u_int switchList_len;
		ms_gsw_topo_msg *switchList_val;
	} switchList;
};
typedef struct ms_gfab_topo_msg ms_gfab_topo_msg;

typedef struct {
	u_int product_id_set_len;
	int *product_id_set_val;
} product_id_set;

struct rapi_res {
	long retcode;
	char *status_msg;
};
typedef struct rapi_res rapi_res;

typedef char *listentry;

struct rapi_listret {
	long retcode;
	char *status_msg;
	struct {
		u_int strlist_len;
		listentry *strlist_val;
	} strlist;
};
typedef struct rapi_listret rapi_listret;

enum TypeDfltZone {
	DFLT_DISABLE_ALL = 0x00,
	DFLT_ENABLE_ALL = 0x01,
};
typedef enum TypeDfltZone TypeDfltZone;

enum TypeZoningCap {
	ZONECAP_FCP_LUN = 0x01,
	ZONECAP_PROTOCOL = 0x02,
	ZONECAP_FCP_RO = 0x04,
	ZONECAP_SWITCHPORT = 0x08,
	ZONECAP_WWN = 0x10,
};
typedef enum TypeZoningCap TypeZoningCap;

enum TypeZoningEnf {
	_ZONE_ENFORCE_SW = 0x01,
	_ZONE_ENFORCE_HW = 0x02,
};
typedef enum TypeZoningEnf TypeZoningEnf;

enum opZone {
	ZN_GET_DEF_BEH = 1,
	ZN_SET_DEF_BEH = 2,
	ZN_GET_ENF_MODE = 4,
};
typedef enum opZone opZone;

struct zone_info_req {
	int op_type;
	int def_zoning_behavior;
	char *zone_name;
};
typedef struct zone_info_req zone_info_req;

struct zone_info_rep {
	int op_type;
	long retcode;
	char *status_msg;
	int def_zoning_behavior;
	int cur_zoning_enforce_mode;
};
typedef struct zone_info_rep zone_info_rep;

struct ms_gswitchdzb_req {
	pwwn_t targetWwn;
	int behavior;
};
typedef struct ms_gswitchdzb_req ms_gswitchdzb_req;

struct zobj_type_ret {
	int type;
	long retcode;
	char *status_msg;
};
typedef struct zobj_type_ret zobj_type_ret;

struct zobj_validate_ret {
	char *zonesetobj;
	char *zoneobj;
	char *zonememobj;
	int type;
	long retcode;
	char *status_msg;
};
typedef struct zobj_validate_ret zobj_validate_ret;

struct EnCfg_Name_ret {
	char *name;
	long retcode;
	char *status_msg;
};
typedef struct EnCfg_Name_ret EnCfg_Name_ret;

struct zonedb_dump_ret {
	struct {
		u_int name_len;
		char *name_val;
	} name;
	long retcode;
	char *status_msg;
};
typedef struct zonedb_dump_ret zonedb_dump_ret;

struct zonedb_checksum_ret {
	u_long db_checksum;
	long retcode;
	char *status_msg;
};
typedef struct zonedb_checksum_ret zonedb_checksum_ret;

struct zone_trans_owner {
	int owner;
	int is_abortable;
	long retcode;
	char *status_msg;
};
typedef struct zone_trans_owner zone_trans_owner;
#define API_FC 0x1000

enum ms_cmd_code {
	GIEL = 0x101,
	GIET = 0x111,
	GDID = 0x112,
	GMID = 0x113,
	GFN = 0x114,
	GLIEN = 0x115,
	GMAL = 0x116,
	GIEIL = 0x117,
	GPL = 0x118,
	GPT = 0x121,
	GPPN = 0x122,
	GAPNL = 0x124,
	GPS = 0x126,
	GPLA = 0x194,
	GPNL = 0x1A2,
	RIELN = 0x215,
	RPL = 0x280,
	RPLN = 0x291,
	RPLT = 0x292,
	RPLM = 0x293,
	DPL = 0x380,
	DPLN = 0x391,
	DPLM = 0x392,
	DPLML = 0x393,
	GPST = 0x400,
	GPERR = 0x401,
	PCLST = 0x402,
	PENAB = 0x403,
	PDISA = 0x404,
	GROUT = 0x405,
	GPATH = 0x407,
	GSROUT = 0x408,
	GFABRIC = 0x501,
	GSW = 0x502,
	GSWITCH = 0x0505,
	SSWITCH = 0x0506,
	GSWITCH2 = 0x0507,
	SSWITCH2 = 0x0508,
	GAPIVERSION = 0x509,
	GSWITCH_NG = 0x050a,
	SSWITCH_NG = 0x050b,
	GFABRIC2 = 0x50c,
	GSW2 = 0x50d,
	GPORT = 0x0605,
	SPORT = 0x0606,
	GPSTATS = 0x0607,
	SPSTATS = 0x0608,
	GDEVICE = 0x0609,
	GDEVICE2 = 0x060a,
	GPERRS = 0x060b,
	SPERRS = 0x060c,
	GENVATTR = 0x60d,
	GFLPORT = 0x60e,
	GMODULE = 0x60f,
	SMODULE = 0x610,
	GPORT2 = 0x611,
	SPORT2 = 0x612,
	GPLATINFO = 0x613,
	GPLATALL = 0x614,
	GCP = 0x615,
	SFRU = 0x616,
	GENVATTR2 = 0x617,
	GPORT_NG = 0x618,
	SPORT_NG = 0x619,
	GPA = 0x628,
	GNPERRS = 0x626,
	FW_LICENSE = 0x0705,
	FW_GET_CA = 0x0706,
	FW_GET_TH = 0x0707,
	FW_APPLY_ALARM = 0x0708,
	FW_APPLY_BOUNDARY = 0x0709,
	FW_CANCEL_ALARM = 0x070a,
	FW_CANCEL_BOUNDARY = 0x070b,
	FW_SET_ALARM_LEVEL = 0x070c,
	FW_SET_ALARM = 0x070d,
	FW_SET_BN_LEVEL = 0x070e,
	FW_SET_BN_BS = 0x070f,
	FW_SET_BN_HIGH = 0x0710,
	FW_SET_BN_LOW = 0x0711,
	FW_SET_BN_TB = 0x0712,
	FW_SET_BN_UNIT = 0x0713,
	FW_SET_TH_STATUS = 0x0714,
	FW_SET_TH_BI = 0x0715,
	FW_SET_TH_BT = 0x0716,
	FW_INIT_CONFIG = 0x0717,
	FW_INSERT_CONFIG = 0x0718,
	FW_UPDATE_CONFIG = 0x0719,
	FW_LOAD_CONFIG = 0x071a,
	FW_GET_TH2 = 0x0735,
	SGROUP_GET = 0x071b,
	SGROUP_CREATE = 0x071c,
	SGROUP_DELETE = 0x071d,
	EVENT_ENABLE_FW = 0x71e,
	EVENT_DISABLE_FW = 0x71f,
	EVENT_ENABLE_FW2 = 0x736,
	EVENT_DISABLE_FW2 = 0x737,
	LICENSE_ADD = 0x0720,
	LICENSE_RM = 0x0721,
	LICENSE_GET = 0x0722,
	LICENSE_GETALL = 0x0723,
	PRODUCT_GET = 0x0726,
	PRODUCT_GETALL = 0x0727,
	DOWNLOAD_START = 0x728,
	DOWNLOAD_PACKET = 0x729,
	DOWNLOAD_ABORT = 0x72a,
	DOWNLOAD_END = 0x72b,
	UPLOAD_START = 0x72c,
	UPLOAD_PACKET = 0x72d,
	UPLOAD_ABORT = 0x72e,
	UPLOAD_END = 0x72f,
	DOWNLOAD_SELF_START = 0x732,
	DOWNLOAD_SELF_ABORT = 0x733,
	VERIFY_FIRMWARE = 0x734,
	EVENT_ENABLE_TC = 0x730,
	EVENT_DISABLE_TC = 0x731,
	DELROUT = 0x750,
	SG_GET = 0x0801,
	SG_SET = 0x0802,
	SG_DEL = 0x0803,
	SG_RNM = 0x0804,
	GSWITCHDZB = 0x0805,
	SSWITCHDZB = 0x0806,
	SEC_GET_CSR = 0x0810,
	SEC_SET_CERT = 0x0811,
	SEC_SET_KEY_CERT = 0x0812,
	SEC_COUNTER = 0x0813,
	SEC_GEN_CSR = 0x0814,
	SEC_COUNTER2 = 0x0815,
	SEC_GET_BANNER = 0x0816,
	SEC_SET_BANNER = 0x0817,
};
typedef enum ms_cmd_code ms_cmd_code;

enum fc_ng2_cmd_code {
	GTCT = 0x630,
	GSNMP = 0x631,
	SSNMP = 0x632,
	GFWEMAIL = 0x633,
	SFWEMAIL = 0x634,
	GFWFRUCFG = 0x635,
	SFWFRUCFG = 0x636,
	GLOGLEVEL = 0x637,
	SLOGLEVEL = 0x638,
	GCHASSIS = 0x639,
	SCHASSIS = 0x63A,
	UPDATE_PASSWORD = 0x63B,
	GSGIF = 0x63C,
	GFWREPORT = 0x63D,
	GXCEIVERINFO = 0x63E,
	CAL_XML = 0x63F,
	CAL_CUP = 0x640,
	GPORT4 = 0x641,
	GMODULE2 = 0x282,
	GPL2 = 0x283,
	GSWITCH4 = 0x284,
	GAPIVERSION2 = 0x285,
	GAPNL2 = 0x646,
	GSCSI_STRING = 0x647,
	SSWITCH4 = 0x648,
	GATTPSFP = 0x6FF,
	GPSFPL = 0x700,
	FCR_GPHSWITCHGRP = 0x701,
	FCR_GLAPN = 0x702,
	FCR_GLVND = 0x703,
	GFID = 0x704,
	SFID = 0x705,
	GSWITCH_ADDITION001 = 0x706,
	SSWITCH_ADDITION001 = 0x707,
	GPSL = 0x708,
	GLSAN = 0x709,
	GFCRROUTE = 0x70A,
	GFCRPHYD = 0x70B,
	GFCRPHYDL = 0x70C,
	GFCRPHYDBN = 0x70D,
	GEXPARG = 0x70E,
	SEXPARG = 0x70F,
	SEC_GCSR = 0x710,
	SEC_CCSR = 0x711,
	SEC_SCERT = 0x712,
	GVIVT = 0x713,
	GAVIVT = 0x714,
	GALSAN = 0x715,
	GAFCRPHYD = 0x716,
	GAFCRPHYDL = 0x717,
	GAFCRPHYDBN = 0x718,
	GMODULE3 = 0x719,
	GPL3 = 0x720,
	GFABRICTOPO = 0x721,
	GSWTOPO = 0x722,
	GET_ALL_FA_SYS = 0x800,
	GET_FA_SYS = 0x801,
	GET_ALL_FA_AGENT_SW_FEAT = 0x802,
	GET_FA_AGENT_SW_FEAT = 0x803,
	GET_ALL_FA_AGENT_SUPPORTED_MODEL_PROFILE = 0x804,
	GET_FA_AGENT_SUPPORTED_MODEL_PROFILE = 0x805,
	GET_FA_AGENT_MOF = 0x806,
	FA_WBEM_OPERATION = 0x807,
	FA_WBEM_OPERATION_WITH_ASYNC_RESP = 0x808,
	GET_FA_AGENT_MOF_ASYNC = 0x809,
};
typedef enum fc_ng2_cmd_code fc_ng2_cmd_code;

enum fa_wbem_op_code {
	FA_WBEM_OP_INITIALIZE = 1,
	FA_WBEM_OP_CLEANUP = 2,
	FA_WBEM_OP_CREATE_INSTANCE = 3,
	FA_WBEM_OP_DELETE_INSTANCE = 4,
	FA_WBEM_OP_GET_INSTANCE = 5,
	FA_WBEM_OP_SET_INSTANCE = 6,
	FA_WBEM_OP_ENUMERATE_INSTANCE_NAMES = 7,
	FA_WBEM_OP_ENUMERATE_INSTANCES = 8,
	FA_WBEM_OP_INVOKE_METHOD = 9,
	FA_WBEM_OP_ASSOCIATOR_NAMES = 10,
	FA_WBEM_OP_ASSOCIATORS = 11,
	FA_WBEM_OP_REFERENCE_NAMES = 12,
	FA_WBEM_OP_REFERENCES = 13,
	FA_WBEM_OP_ACTIVATE_FILTER = 14,
	FA_WBEM_OP_DEACTIVATE_FILTER = 15,
};
typedef enum fa_wbem_op_code fa_wbem_op_code;

typedef char fa_sys_id[FA_STRING_MEDIUM_SIZE];

typedef char fa_feature_id[FA_STRING_MEDIUM_SIZE];

typedef char fa_model_profile_id[FA_DESCRIPTION_STRING_SIZE];

enum fa_cim_primitive_data_types {
	CIM_BOOLEAN = 1,
	BOOLEAN_ARRAY = 2,
	CHAR16 = 3,
	CHAR16_ARRAY = 4,
	DATETIME = 5,
	DATETIME_ARRAY = 6,
	REAL32 = 7,
	REAL32_ARRAY = 8,
	REAL64 = 9,
	REAL64_ARRAY = 10,
	SINT16 = 11,
	SINT16_ARRAY = 12,
	SINT32 = 13,
	SINT32_ARRAY = 14,
	SINT64 = 15,
	SINT64_ARRAY = 16,
	SINT8 = 17,
	SINT8_ARRAY = 18,
	STRING = 19,
	STRING_ARRAY = 20,
	UINT16 = 21,
	UINT16_ARRAY = 22,
	CIM_UINT32 = 23,
	UINT32_ARRAY = 24,
	CIM_UINT64 = 25,
	UINT64_ARRAY = 26,
	UINT8 = 27,
	UINT8_ARRAY = 28,
};
typedef enum fa_cim_primitive_data_types fa_cim_primitive_data_types;

typedef char *undefined_length_string;

struct fa_primitive_value_union {
	fa_cim_primitive_data_types primitive_value_type;
	union {
		int bool_value;
		struct {
			u_int bool_array_value_len;
			int *bool_array_value_val;
		} bool_array_value;
		char char16_value;
		struct {
			u_int char16_array_value_len;
			char *char16_array_value_val;
		} char16_array_value;
		u_int datetime_value;
		struct {
			u_int datetime_array_value_len;
			u_int *datetime_array_value_val;
		} datetime_array_value;
		float real32_value;
		struct {
			u_int real32_array_value_len;
			float *real32_array_value_val;
		} real32_array_value;
		double real64_value;
		struct {
			u_int real64_array_value_len;
			double *real64_array_value_val;
		} real64_array_value;
		short sint16_value;
		struct {
			u_int sint16_array_value_len;
			short *sint16_array_value_val;
		} sint16_array_value;
		int sint32_value;
		struct {
			u_int sint32_array_value_len;
			int *sint32_array_value_val;
		} sint32_array_value;
		long sint64_value;
		struct {
			u_int sint64_array_value_len;
			long *sint64_array_value_val;
		} sint64_array_value;
		char sint8_value;
		struct {
			u_int sint8_array_value_len;
			char *sint8_array_value_val;
		} sint8_array_value;
		char *string_value;
		struct {
			u_int string_array_value_len;
			undefined_length_string *string_array_value_val;
		} string_array_value;
		u_short uint16_value;
		struct {
			u_int uint16_array_value_len;
			u_short *uint16_array_value_val;
		} uint16_array_value;
		u_int uint32_value;
		struct {
			u_int uint32_array_value_len;
			u_int *uint32_array_value_val;
		} uint32_array_value;
		u_long uint64_value;
		struct {
			u_int uint64_array_value_len;
			u_long *uint64_array_value_val;
		} uint64_array_value;
		char uint8_value;
		struct {
			u_int uint8_array_value_len;
			char *uint8_array_value_val;
		} uint8_array_value;
	} fa_primitive_value_union_u;
};
typedef struct fa_primitive_value_union fa_primitive_value_union;

struct fa_cim_primitive_value {
	fa_primitive_value_union value;
	int is_array;
	int is_empty;
	int is_null;
	int size;
};
typedef struct fa_cim_primitive_value fa_cim_primitive_value;

struct fa_cim_key_binding {
	char name[FA_STRING_MAX_SIZE];
	fa_cim_primitive_value value;
};
typedef struct fa_cim_key_binding fa_cim_key_binding;

typedef struct {
	u_int fa_cim_key_binding_array_len;
	fa_cim_key_binding *fa_cim_key_binding_array_val;
} fa_cim_key_binding_array;

struct fa_cim_class_objectpath {
	char host[FA_STRING_MAX_SIZE];
	char object_name[FA_STRING_MAX_SIZE];
	char name_space[FA_STRING_MAX_SIZE];
	fa_cim_key_binding_array keys;
};
typedef struct fa_cim_class_objectpath fa_cim_class_objectpath;

struct fa_cim_assoc_objectpath {
	fa_cim_key_binding_array properties;
	struct {
		u_int array_of_key_binding_arrays_len;
		fa_cim_key_binding_array *array_of_key_binding_arrays_val;
	} array_of_key_binding_arrays;
};
typedef struct fa_cim_assoc_objectpath fa_cim_assoc_objectpath;

enum fa_cim_object_path_type {
	CLASS_TYPE = 1,
	ASSOCIATION_TYPE = 2,
};
typedef enum fa_cim_object_path_type fa_cim_object_path_type;

struct fa_cim_objectpath {
	fa_cim_object_path_type object_path_type;
	union {
		fa_cim_class_objectpath class_objectpath;
		fa_cim_assoc_objectpath assoc_objectpath;
	} fa_cim_objectpath_u;
};
typedef struct fa_cim_objectpath fa_cim_objectpath;

typedef struct {
	u_int fa_cim_objectpath_array_len;
	fa_cim_objectpath *fa_cim_objectpath_array_val;
} fa_cim_objectpath_array;

enum fa_cim_value_data_type {
	PRIMITIVE = 1,
	CIM_OBJECT_PATH = 2,
	CIM_OBJECT_PATH_ARRAY = 3,
};
typedef enum fa_cim_value_data_type fa_cim_value_data_type;

struct fa_cim_value_union {
	fa_cim_value_data_type cim_value_type;
	union {
		fa_cim_primitive_value primitive_value;
		fa_cim_objectpath cop_value;
		fa_cim_objectpath_array cop_value_array;
	} fa_cim_value_union_u;
};
typedef struct fa_cim_value_union fa_cim_value_union;

struct fa_cim_argument {
	char name[FA_STRING_MAX_SIZE];
	fa_cim_value_union value;
};
typedef struct fa_cim_argument fa_cim_argument;

typedef struct {
	u_int fa_cim_argument_array_len;
	fa_cim_argument *fa_cim_argument_array_val;
} fa_cim_argument_array;

struct fa_cim_property {
	char name[FA_STRING_MAX_SIZE];
	fa_cim_value_union value;
	int size;
	int is_key;
	int is_reference;
};
typedef struct fa_cim_property fa_cim_property;

typedef struct {
	u_int fa_cim_property_array_len;
	fa_cim_property *fa_cim_property_array_val;
} fa_cim_property_array;

struct fa_cim_instance {
	char class_name[FA_STRING_MAX_SIZE];
	char alias_name[FA_STRING_MAX_SIZE];
	fa_cim_objectpath object_path;
	fa_cim_property_array properties;
};
typedef struct fa_cim_instance fa_cim_instance;

typedef struct {
	u_int fa_cim_instance_array_len;
	fa_cim_instance *fa_cim_instance_array_val;
} fa_cim_instance_array;

struct fa_cim_class {
	char name[FA_STRING_MAX_SIZE];
	char super_class_name[FA_STRING_MAX_SIZE];
	int is_association;
	fa_cim_property_array properties;
};
typedef struct fa_cim_class fa_cim_class;

struct fa_wbem_op_create_instance_arg {
	fa_cim_objectpath cim_objpath;
	fa_cim_instance cim_instance;
};
typedef struct fa_wbem_op_create_instance_arg fa_wbem_op_create_instance_arg;

struct fa_wbem_op_delete_instance_arg {
	fa_cim_objectpath cim_objpath;
};
typedef struct fa_wbem_op_delete_instance_arg fa_wbem_op_delete_instance_arg;

struct fa_wbem_op_get_instance_arg {
	fa_cim_objectpath cim_objpath;
	int local_only;
	int include_class_origin;
	struct {
		u_int property_list_len;
		undefined_length_string *property_list_val;
	} property_list;
	fa_cim_class cim_class;
};
typedef struct fa_wbem_op_get_instance_arg fa_wbem_op_get_instance_arg;

struct fa_wbem_op_set_instance_arg {
	fa_cim_objectpath cim_objpath;
	fa_cim_instance cim_instance;
	struct {
		u_int property_list_len;
		undefined_length_string *property_list_val;
	} property_list;
};
typedef struct fa_wbem_op_set_instance_arg fa_wbem_op_set_instance_arg;

struct fa_wbem_op_enumerate_instance_names_arg {
	fa_cim_objectpath cim_objpath;
	fa_cim_class cim_class;
};
typedef struct fa_wbem_op_enumerate_instance_names_arg fa_wbem_op_enumerate_instance_names_arg;

struct fa_wbem_op_enumerate_instances_arg {
	fa_cim_objectpath cim_objpath;
	int local_only;
	int include_class_origin;
	struct {
		u_int property_list_len;
		undefined_length_string *property_list_val;
	} property_list;
	fa_cim_class cim_class;
};
typedef struct fa_wbem_op_enumerate_instances_arg fa_wbem_op_enumerate_instances_arg;

struct fa_wbem_op_invoke_method_arg {
	fa_cim_objectpath cim_objpath;
	char *method_name;
	fa_cim_argument_array inArgs;
	fa_cim_argument_array outArgs;
};
typedef struct fa_wbem_op_invoke_method_arg fa_wbem_op_invoke_method_arg;

struct fa_wbem_op_associator_names_arg {
	fa_cim_objectpath association_name;
	fa_cim_objectpath object_name;
	char *result_class;
	char *role;
	char *result_role;
};
typedef struct fa_wbem_op_associator_names_arg fa_wbem_op_associator_names_arg;

struct fa_wbem_op_associators_arg {
	fa_cim_objectpath association_name;
	fa_cim_objectpath object_name;
	char *result_class;
	char *role;
	char *result_role;
	int include_class_origin;
	struct {
		u_int property_list_len;
		undefined_length_string *property_list_val;
	} property_list;
};
typedef struct fa_wbem_op_associators_arg fa_wbem_op_associators_arg;

struct fa_wbem_op_reference_names_arg {
	fa_cim_objectpath association_name;
	fa_cim_objectpath object_name;
	char *role;
};
typedef struct fa_wbem_op_reference_names_arg fa_wbem_op_reference_names_arg;

struct fa_wbem_op_references_arg {
	fa_cim_objectpath association_name;
	fa_cim_objectpath object_name;
	char *role;
	int include_class_origin;
	struct {
		u_int property_list_len;
		undefined_length_string *property_list_val;
	} property_list;
};
typedef struct fa_wbem_op_references_arg fa_wbem_op_references_arg;

struct fa_wbem_op_activate_filter_arg {
	char *query_string;
	char *event_type;
	fa_cim_objectpath class_path;
	int first_activation;
};
typedef struct fa_wbem_op_activate_filter_arg fa_wbem_op_activate_filter_arg;

struct fa_wbem_op_deactivate_filter_arg {
	char *query_string;
	char *event_type;
	fa_cim_objectpath class_path;
	int last_activation;
};
typedef struct fa_wbem_op_deactivate_filter_arg fa_wbem_op_deactivate_filter_arg;

struct fa_wbem_operations_req_union {
	fa_wbem_op_code wbem_operation_type;
	union {
		fa_wbem_op_create_instance_arg create_inst_arg;
		fa_wbem_op_delete_instance_arg delete_inst_arg;
		fa_wbem_op_get_instance_arg get_inst_arg;
		fa_wbem_op_set_instance_arg set_inst_arg;
		fa_wbem_op_enumerate_instance_names_arg enum_inst_names_arg;
		fa_wbem_op_enumerate_instances_arg enum_inst_arg;
		fa_wbem_op_invoke_method_arg invoke_method_arg;
		fa_wbem_op_associator_names_arg assoc_names_arg;
		fa_wbem_op_associators_arg associators_arg;
		fa_wbem_op_reference_names_arg ref_names_arg;
		fa_wbem_op_references_arg references_arg;
		fa_wbem_op_activate_filter_arg activate_filter_arg;
		fa_wbem_op_deactivate_filter_arg deactivate_filter_arg;
	} fa_wbem_operations_req_union_u;
};
typedef struct fa_wbem_operations_req_union fa_wbem_operations_req_union;

struct fa_forward_wbem_req_arg {
	char *provider_name;
	fa_sys_id sys_ID;
	fa_feature_id feature_ID;
	fa_model_profile_id model_profile_ID;
	fa_wbem_operations_req_union req;
};
typedef struct fa_forward_wbem_req_arg fa_forward_wbem_req_arg;

struct fa_wbem_op_create_instance_resp {
	fa_cim_objectpath object_path;
};
typedef struct fa_wbem_op_create_instance_resp fa_wbem_op_create_instance_resp;

struct fa_wbem_op_get_instance_resp {
	fa_cim_instance cim_instance;
};
typedef struct fa_wbem_op_get_instance_resp fa_wbem_op_get_instance_resp;

struct fa_wbem_op_enumerate_instance_names_resp {
	fa_cim_objectpath_array instance_names;
};
typedef struct fa_wbem_op_enumerate_instance_names_resp fa_wbem_op_enumerate_instance_names_resp;

struct fa_wbem_op_enumerate_instances_resp {
	fa_cim_instance_array instances;
};
typedef struct fa_wbem_op_enumerate_instances_resp fa_wbem_op_enumerate_instances_resp;

struct fa_wbem_op_invoke_method_resp {
	fa_cim_value_union return_value;
	fa_cim_argument_array outArgs;
};
typedef struct fa_wbem_op_invoke_method_resp fa_wbem_op_invoke_method_resp;

struct fa_wbem_op_associator_names_resp {
	fa_cim_objectpath_array associator_names;
};
typedef struct fa_wbem_op_associator_names_resp fa_wbem_op_associator_names_resp;

struct fa_wbem_op_associators_resp {
	fa_cim_instance_array associators;
};
typedef struct fa_wbem_op_associators_resp fa_wbem_op_associators_resp;

struct fa_wbem_op_reference_names_resp {
	fa_cim_objectpath_array reference_names;
};
typedef struct fa_wbem_op_reference_names_resp fa_wbem_op_reference_names_resp;

struct fa_wbem_op_references_resp {
	fa_cim_instance_array references;
};
typedef struct fa_wbem_op_references_resp fa_wbem_op_references_resp;

struct fa_wbem_op_initialize_resp {
	int return_code;
};
typedef struct fa_wbem_op_initialize_resp fa_wbem_op_initialize_resp;

struct fa_wbem_op_cleanup_resp {
	int return_code;
};
typedef struct fa_wbem_op_cleanup_resp fa_wbem_op_cleanup_resp;

struct fa_wbem_op_set_instance_resp {
	int return_code;
};
typedef struct fa_wbem_op_set_instance_resp fa_wbem_op_set_instance_resp;

struct fa_wbem_op_delete_instance_resp {
	int return_code;
};
typedef struct fa_wbem_op_delete_instance_resp fa_wbem_op_delete_instance_resp;

struct fa_wbem_op_activate_filter_resp {
	int return_code;
};
typedef struct fa_wbem_op_activate_filter_resp fa_wbem_op_activate_filter_resp;

struct fa_wbem_op_deactivate_filter_resp {
	int return_code;
};
typedef struct fa_wbem_op_deactivate_filter_resp fa_wbem_op_deactivate_filter_resp;

struct fa_wbem_operations_resp_union {
	fa_wbem_op_code type;
	union {
		fa_wbem_op_initialize_resp initialize_resp;
		fa_wbem_op_cleanup_resp cleanup_resp;
		fa_wbem_op_create_instance_resp create_inst_resp;
		fa_wbem_op_delete_instance_resp delete_instance_resp;
		fa_wbem_op_get_instance_resp get_inst_resp;
		fa_wbem_op_set_instance_resp set_instance_resp;
		fa_wbem_op_enumerate_instance_names_resp enum_inst_names_resp;
		fa_wbem_op_enumerate_instances_resp enum_inst_resp;
		fa_wbem_op_invoke_method_resp invoke_method_resp;
		fa_wbem_op_associator_names_resp assoc_names_resp;
		fa_wbem_op_associators_resp associators_resp;
		fa_wbem_op_reference_names_resp ref_names_resp;
		fa_wbem_op_references_resp references_resp;
		fa_wbem_op_activate_filter_resp activate_filter_resp;
		fa_wbem_op_deactivate_filter_resp deactivate_filter_resp;
	} fa_wbem_operations_resp_union_u;
};
typedef struct fa_wbem_operations_resp_union fa_wbem_operations_resp_union;

struct fa_exception {
	char *cim_error_type;
	int application_error_code;
	int application_error_subtype_code;
	char *error_description;
};
typedef struct fa_exception fa_exception;

struct fa_wbem_resp {
	fa_exception exception;
	fa_wbem_operations_resp_union resp;
};
typedef struct fa_wbem_resp fa_wbem_resp;

struct fa_acknowledgement {
	long returnCode;
	long unused1;
	long unused2;
	long unused3;
};
typedef struct fa_acknowledgement fa_acknowledgement;

struct fa_get_agent_sw_feat_req_arg {
	fa_sys_id sys_ID;
	fa_feature_id feature_ID;
};
typedef struct fa_get_agent_sw_feat_req_arg fa_get_agent_sw_feat_req_arg;

struct fa_get_agent_supported_model_profile_req_arg {
	fa_sys_id sys_ID;
	fa_feature_id feature_ID;
	fa_model_profile_id model_profile_ID;
};
typedef struct fa_get_agent_supported_model_profile_req_arg fa_get_agent_supported_model_profile_req_arg;

struct fa_fasys {
	fa_sys_id sys_ID;
	char *description;
	struct {
		u_int operational_status_len;
		u_int *operational_status_val;
	} operational_status;
	u_int startup_time;
};
typedef struct fa_fasys fa_fasys;

typedef struct {
	u_int fa_fasys_list_resp_len;
	fa_fasys *fa_fasys_list_resp_val;
} fa_fasys_list_resp;

struct fa_agent_info {
	fa_feature_id feature_ID;
	char name[FA_STRING_MAX_SIZE];
	char description[FA_DESCRIPTION_STRING_SIZE];
	char version_str[FA_STRING_MAX_SIZE];
	char product_name[FA_STRING_MAX_SIZE];
	char vendor[FA_STRING_MAX_SIZE];
	struct {
		u_int operational_status_len;
		u_int *operational_status_val;
	} operational_status;
	u_int install_date;
};
typedef struct fa_agent_info fa_agent_info;

typedef struct {
	u_int fa_get_agent_list_resp_len;
	fa_agent_info *fa_get_agent_list_resp_val;
} fa_get_agent_list_resp;

struct fa_agent_model_profile {
	fa_model_profile_id model_profile_ID;
	u_int registered_organization;
	char other_registered_organization[FA_STRING_MAX_SIZE];
	char registered_name[FA_STRING_MAX_SIZE];
	char registered_version[FA_STRING_MAX_SIZE];
	u_int major_version;
	u_int minor_version;
	u_int update;
	char mof_file_name[FA_STRING_MAX_SIZE];
	char description[FA_DESCRIPTION_STRING_SIZE];
	char element_name[FA_STRING_MAX_SIZE];
	char toplevel_element_class_name[FA_STRING_MAX_SIZE];
};
typedef struct fa_agent_model_profile fa_agent_model_profile;

typedef struct {
	u_int fa_agent_model_profile_list_resp_len;
	fa_agent_model_profile *fa_agent_model_profile_list_resp_val;
} fa_agent_model_profile_list_resp;

struct fa_get_agent_mof_resp {
	struct {
		u_int mof_contents_len;
		char *mof_contents_val;
	} mof_contents;
};
typedef struct fa_get_agent_mof_resp fa_get_agent_mof_resp;

struct ms_default_req_arg {
	char wwn[8];
	char *logical_name;
	struct {
		u_int strlist_len;
		listentry *strlist_val;
	} strlist;
};
typedef struct ms_default_req_arg ms_default_req_arg;

struct ms_rout_req_arg {
	char src_wwn[8];
	char dst_wwn[8];
};
typedef struct ms_rout_req_arg ms_rout_req_arg;

struct ms_gpath_req_arg {
	char src_wwn[8];
	char dst_wwn[8];
};
typedef struct ms_gpath_req_arg ms_gpath_req_arg;

struct ms_gsrout_req_arg {
	char in_wwn[8];
	char out_wwn[8];
	char dstsw_wwn[8];
};
typedef struct ms_gsrout_req_arg ms_gsrout_req_arg;

struct ms_delrout_req_arg {
	char port_wwn[8];
	char dstsw_wwn[8];
};
typedef struct ms_delrout_req_arg ms_delrout_req_arg;

struct ms_wwn_type_entry {
	char wwn[8];
	u_long type;
};
typedef struct ms_wwn_type_entry ms_wwn_type_entry;

typedef char c256ar[256];

struct ms_type_c256 {
	u_long type;
	c256ar carray;
};
typedef struct ms_type_c256 ms_type_c256;

struct ms_gswitch_msg {
	char wwn[8];
	u_int set_attribute;
	u_int did;
	u_int isPrincipal;
	char ib_ip[16];
	char ob_ip[16];
	char ib_mask[16];
	char ob_mask[16];
	char gateway[16];
	u_int isManagable;
	u_int switch_state;
	u_int switch_status;
	u_int switch_id;
	u_int switch_time;
	u_int switch_tz;
	char vendor_name[32];
	char model[32];
	char vsinfo[128];
	char firmware_version[32];
	char switch_name[32];
	u_int isZoningInstalled;
	char login_name[32];
	char login_password[32];
	u_int max_num_modules;
	u_int port_per_module;
	u_int port_count;
};
typedef struct ms_gswitch_msg ms_gswitch_msg;

enum destType {
	APIFC_DTYPE_SADDR = 0,
	APIFC_DTYPE_DID = 1,
	APIFC_DTYPE_SWID = 2,
	APIFC_DTYPE_PWWN = 3,
};
typedef enum destType destType;

struct destAddress {
	destType nDestType;
	union {
		char swwn[8];
		int did;
		int swid;
	} destAddress_u;
};
typedef struct destAddress destAddress;

struct ms_gswitch_msg2 {
	u_int ver;
	u_int length;
	char wwn[8];
	u_int set_attribute;
	u_int did;
	u_int isPrincipal;
	char ib_ip[16];
	char ob_ip[16];
	char ib_mask[16];
	char ob_mask[16];
	char gateway[16];
	u_int isManagable;
	u_int switch_state;
	u_int switch_status;
	u_int switch_id;
	u_int switch_time;
	u_int switch_tz;
	char vendor_name[32];
	char model[32];
	char vsinfo[128];
	char firmware_version[32];
	char switch_name[32];
	u_int isZoningInstalled;
	char login_name[32];
	char login_password[32];
	u_int max_num_modules;
	u_int port_per_module;
	u_int port_count;
	u_int start_slot;
	u_int isGrouped;
	license_key_set licenseKeySet;
	product_id_set productIDSet;
	u_int HWZoningCapabilities;
	u_int SWZoningCapabilities;
	u_int CurrentZoningEnforcement;
	u_int trunkingCapable;
	u_int fwEventsEnable;
	u_int EmbeddedSwitchType;
	char EmbSwInvariantName[8];
	u_int EmbSwSlotId;
	char EmbSwBaseIPAddr[16];
	u_int EmbSwBaseDomainId;
	u_int EmbSwEportMode;
	char EmbSwBoxSerialNumber[MAX_SERIAL_NUMBER_LEN];
	u_int ValidCertificationInstalled;
	char MfgSerialNumber[32];
	u_int qloopMode;
	char peerWwn[8];
	char portQlEnableBitMap[32];
	char setPortQlBitMask[32];
	char alpaBitMap[16];
	char mfg_name[32];
	char mfg_model[32];
};
typedef struct ms_gswitch_msg2 ms_gswitch_msg2;

struct ms_gswitch_msg_ng {
	ms_gswitch_msg2 gswitch_msg2;
	u_short beaconEnable;
	u_int upTime;
	char bootUpReason[32];
	int nAddressKnown;
	u_int lastConfigChangeTime;
	u_short rlsServiceEnable;
	u_short portLogEnable;
	u_int msCapability;
	char domainName[60];
	char nameServer[36];
	struct {
		u_int syslogIP_len;
		dotIP *syslogIP_val;
	} syslogIP;
	char *tsClockServer;
};
typedef struct ms_gswitch_msg_ng ms_gswitch_msg_ng;

struct ms_gport_msg {
	char wwn[8];
	u_int port;
	u_int set_attribute;
	u_int port_state;
	u_int port_status;
	u_int port_phys_state;
	u_int port_type;
	u_int port_speed;
	u_int port_distance;
	u_int tx_link_route_cost;
	u_int gbic_type;
	char gbic_serial[16];
	char gbic_vendor[16];
	u_int cos;
	u_int pid;
};
typedef struct ms_gport_msg ms_gport_msg;

struct ms_gflport_msg {
	u_int pid;
	char alpaBitMap[16];
	char privateDevBitMap[16];
};
typedef struct ms_gflport_msg ms_gflport_msg;

struct ms_plat_name {
	int name_len;
	c256ar plat_name;
};
typedef struct ms_plat_name ms_plat_name;

struct ms_ama_name {
	int name_len;
	c256ar ama_name;
};
typedef struct ms_ama_name ms_ama_name;

typedef struct {
	u_int ms_plat_name_list_len;
	ms_plat_name *ms_plat_name_list_val;
} ms_plat_name_list;

struct ms_plat_attrib {
	ms_plat_name plat_name;
	int plat_type;
	int ama_num;
	struct {
		u_int ama_name_list_len;
		ms_ama_name *ama_name_list_val;
	} ama_name_list;
	int ann_num;
	struct {
		u_int ann_list_len;
		pwwn_t *ann_list_val;
	} ann_list;
};
typedef struct ms_plat_attrib ms_plat_attrib;

struct ms_rpln_req {
	ms_plat_name plat_name;
	char node_wwn[8];
};
typedef struct ms_rpln_req ms_rpln_req;

struct ms_rplt_req {
	ms_plat_name plat_name;
	int plat_type;
};
typedef struct ms_rplt_req ms_rplt_req;

struct ms_rplm_req {
	ms_plat_name plat_name;
	ms_ama_name ama_name;
};
typedef struct ms_rplm_req ms_rplm_req;

struct ms_platall {
	int nEnabled;
	struct {
		u_int attributes_len;
		ms_plat_attrib *attributes_val;
	} attributes;
};
typedef struct ms_platall ms_platall;
#define PLAT_ACTIVATE 0
#define PLAT_DEACTIVATE 1

struct ms_splatinfo_req {
	int cmd;
	union {
		ms_rpln_req rpln_req;
		ms_rplt_req rplt_req;
		ms_rplm_req rplm_req;
		pwwn_t dpln_req;
		ms_rplm_req dplm_req;
		ms_plat_name dplml_req;
	} ms_splatinfo_req_u;
};
typedef struct ms_splatinfo_req ms_splatinfo_req;

struct c64_t {
	u_int top_int;
	u_int bottom_int;
};
typedef struct c64_t c64_t;

struct ms_req_pstats {
	pwwn_t wwn;
	int set_attribute;
};
typedef struct ms_req_pstats ms_req_pstats;

struct ms_resp_pstats {
	int rateSamplePeriod;
	c64_t rateTxFrame;
	c64_t rateRxFrame;
	c64_t rateTxPeakFrame;
	c64_t rateRxPeakFrame;
	c64_t rateTxByte;
	c64_t rateRxByte;
	c64_t rateTxPeakByte;
	c64_t rateRxPeakByte;
	c64_t cntTxByte;
	c64_t cntRxByte;
	c64_t cntTxFrame;
	c64_t cntRxFrame;
	c64_t cntBBCreditZero;
	c64_t cntInputBuffersFull;
	c64_t cntFBSYFrames;
	c64_t cntPBSYFrames;
	c64_t cntFRJTFrames;
	c64_t cntPRJTFrames;
	c64_t cntRxClass1Frames;
	c64_t cntRxClass2Frames;
	c64_t cntRxClass3Frames;
	c64_t cntClass3Discards;
	c64_t cntRxMcastFrames;
	c64_t cntTxMcastFrames;
};
typedef struct ms_resp_pstats ms_resp_pstats;

struct ms_req_perrs {
	pwwn_t wwn;
	int set_attribute;
};
typedef struct ms_req_perrs ms_req_perrs;

struct ms_resp_perrs {
	c64_t cntRxLinkResets;
	c64_t cntTxLinkResets;
	c64_t cntRxOfflineSequences;
	c64_t cntTxOfflineSequences;
	c64_t cntLinkFailures;
	c64_t cntInvalidCRCerrors;
	c64_t cntinvalidTxWords;
	c64_t cntPrimSeqProtoErrors;
	c64_t cntSignalLosses;
	c64_t cntSyncLosses;
	c64_t cntInvalidOrderedSets;
	c64_t cntRxFramesTooLong;
	c64_t cntRxTruncFrames;
	c64_t cntAddressIdErrors;
	c64_t cntDelimiterErrors;
	c64_t cntRxEncodingDisparityErr;
	c64_t cntTooManyRdys;
	c64_t cntRxCrcs;
	c64_t cntRxBadEofs;
	c64_t cntRxEncOutFrames;
	c64_t cntMcastTimedOuts;
	c64_t cntRxLCs;
};
typedef struct ms_resp_perrs ms_resp_perrs;
#define FW_MAX_STR 32
#define FW_MAX_STR2 72
#define WWN_LEN 8
#define CONFIG_LINE_LEN 256

struct fw_req_arg {
	u_char wwn[WWN_LEN];
	int class_area;
	int index;
	int level;
	int event_type;
	int alarm_matrix;
	int bs;
	int high;
	int low;
	int tb;
	char unit[FW_MAX_STR];
	int status;
	int bi;
	int bt;
	char config_line[CONFIG_LINE_LEN];
};
typedef struct fw_req_arg fw_req_arg;

struct fwConfigStruct {
	char default_unit[FW_MAX_STR];
	int default_tb;
	int default_low;
	int default_high;
	int default_bs;
	char custom_unit[FW_MAX_STR];
	int custom_tb;
	int custom_low;
	int custom_high;
	int custom_bs;
	int boundary_level;
	int default_changed;
	int default_exceeded;
	int default_below;
	int default_above;
	int default_inbetween;
	int custom_changed;
	int custom_exceeded;
	int custom_below;
	int custom_above;
	int custom_inbetween;
	int valid_alarm;
	int alarm_level;
};
typedef struct fwConfigStruct fwConfigStruct;

struct fwThStruct {
	int th_status;
	char th_name[FW_MAX_STR];
	char th_label[FW_MAX_STR];
	int th_cur_val;
	int th_last_event;
	int th_last_event_val;
	char th_last_event_time[FW_MAX_STR];
	int th_last_event_state;
	int th_bt;
	int th_bi;
};
typedef struct fwThStruct fwThStruct;

struct fwThStruct2 {
	int th_status;
	char th_name[FW_MAX_STR];
	char th_label[FW_MAX_STR2];
	int th_cur_val;
	int th_last_event;
	int th_last_event_val;
	char th_last_event_time[FW_MAX_STR];
	int th_last_event_state;
	int th_bt;
	int th_bi;
};
typedef struct fwThStruct2 fwThStruct2;

struct ms_sgroup_msg {
	char targetSwitchWwn[8];
	char name[33];
	u_int type;
	char wwnList[128];
};
typedef struct ms_sgroup_msg ms_sgroup_msg;

struct socketAddrStruct {
	u_long ip;
	u_short port;
	int heartBeatInterval;
};
typedef struct socketAddrStruct socketAddrStruct;

struct socketAddrStruct2 {
	char ip_address[64];
	u_short port;
	int heartBeatInterval;
};
typedef struct socketAddrStruct2 socketAddrStruct2;

struct eventSrvrMsg {
	struct socketAddrStruct socket;
	int heartBeatInterval;
};
typedef struct eventSrvrMsg eventSrvrMsg;

struct ms_fw_event_msg {
	pwwn_t targetWwn;
	pwwn_t proxyWwn;
	u_long srvrIp;
	u_short srvrPort;
};
typedef struct ms_fw_event_msg ms_fw_event_msg;

struct ms_fw_event_msg2 {
	pwwn_t targetWwn;
	pwwn_t proxyWwn;
	char srvrIp[40];
	u_short srvrPort;
};
typedef struct ms_fw_event_msg2 ms_fw_event_msg2;

struct license_req_t {
	char wwn[8];
	char l_key[RPC_LICENSE_LEN_MAX];
};
typedef struct license_req_t license_req_t;

struct lic_prod_req {
	char wwn[8];
	int feature;
};
typedef struct lic_prod_req lic_prod_req;

struct lic_prod_msg {
	char name[MAX_PRODUCTNAME_LEN];
	int TrailVersionTimeRemaining;
	license_key_set lk_list;
};
typedef struct lic_prod_msg lic_prod_msg;

struct api_license_t {
	license_key key;
	u_char lv_major;
	u_char lv_minor;
	u_char lv_revision;
	u_char lv_state;
	u_int l_map;
	u_int la_model;
	u_int la_type;
};
typedef struct api_license_t api_license_t;

struct msapi_sgget_req_t {
	pwwn_t tgt_wwn;
};
typedef struct msapi_sgget_req_t msapi_sgget_req_t;

struct msapi_sgset_req_t {
	pwwn_t tgt_wwn;
	char sg_name[SG_NAME_SIZE];
	int sg_type;
	int num_members;
	pwwn_t members[SG_MAX_MEMBERS];
};
typedef struct msapi_sgset_req_t msapi_sgset_req_t;

struct msapi_sgdel_req_t {
	pwwn_t tgt_wwn;
	char sg_name[SG_NAME_SIZE];
};
typedef struct msapi_sgdel_req_t msapi_sgdel_req_t;

struct msapi_sgrnm_req_t {
	pwwn_t tgt_wwn;
	char sg_name[SG_NAME_SIZE];
	char sg_newname[SG_NAME_SIZE];
};
typedef struct msapi_sgrnm_req_t msapi_sgrnm_req_t;

struct ms_download_start_cmd {
	pwwn_t targetWwn;
	int downloadType;
	int totalSize;
};
typedef struct ms_download_start_cmd ms_download_start_cmd;

struct ms_download_arg {
	pwwn_t targetWwn;
	int downloadId;
	int dataOffset;
	int dataChecksum;
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct ms_download_arg ms_download_arg;

struct ms_download_end_cmd {
	pwwn_t targetWwn;
	int downloadId;
};
typedef struct ms_download_end_cmd ms_download_end_cmd;

struct ms_download_rsp {
	int statusCode;
	int downloadId;
};
typedef struct ms_download_rsp ms_download_rsp;

struct ms_download_self_start_cmd {
	pwwn_t targetWwn;
	int downloadType;
	struct {
		u_int filepath_len;
		char *filepath_val;
	} filepath;
	struct {
		u_int hostname_len;
		char *hostname_val;
	} hostname;
	struct {
		u_int hostlogin_len;
		char *hostlogin_val;
	} hostlogin;
	struct {
		u_int password_len;
		char *password_val;
	} password;
};
typedef struct ms_download_self_start_cmd ms_download_self_start_cmd;

struct ms_download_self_end_cmd {
	pwwn_t targetWwn;
	int downloadId;
};
typedef struct ms_download_self_end_cmd ms_download_self_end_cmd;

struct ms_download_self_rsp {
	int statusCode;
	int downloadId;
};
typedef struct ms_download_self_rsp ms_download_self_rsp;

struct ms_upload_start_cmd {
	pwwn_t targetWwn;
	int uploadType;
};
typedef struct ms_upload_start_cmd ms_upload_start_cmd;

struct ms_upload_start_rsp {
	int statusCode;
	int uploadId;
	int totalSize;
};
typedef struct ms_upload_start_rsp ms_upload_start_rsp;

struct ms_upload_arg {
	pwwn_t targetWwn;
	int uploadId;
	int dataOffset;
	int desireSize;
};
typedef struct ms_upload_arg ms_upload_arg;

struct ms_upload_rsp {
	int statusCode;
	int uploadId;
	int dataOffset;
	int dataChecksum;
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct ms_upload_rsp ms_upload_rsp;

struct ms_upload_end_cmd {
	pwwn_t targetWwn;
	int uploadId;
};
typedef struct ms_upload_end_cmd ms_upload_end_cmd;

struct ms_upload_end_rsp {
	int statusCode;
	int uploaded;
};
typedef struct ms_upload_end_rsp ms_upload_end_rsp;
#define MAX_CERT_SIZE 2560

struct pki_cert_t {
	struct {
		u_int cert_len;
		char *cert_val;
	} cert;
};
typedef struct pki_cert_t pki_cert_t;

struct csr_msg {
	char wwn[8];
	pki_cert_t csr;
};
typedef struct csr_msg csr_msg;

struct ca_msg {
	char wwn[8];
	pki_cert_t ca;
};
typedef struct ca_msg ca_msg;

struct apisec_cntr_req {
	char wwn[8];
	int cmd;
};
typedef struct apisec_cntr_req apisec_cntr_req;

struct apisec_cntr_t {
	u_int telnet;
	u_int http;
	u_int api;
	u_int rsnmp;
	u_int wsnmp;
	u_int ses;
	u_int ms;
	u_int serial;
	u_int panel;
	u_int scc;
	u_int dcc;
	u_int vlogin;
};
typedef struct apisec_cntr_t apisec_cntr_t;

struct apisec_cntr2_t {
	u_int telnet;
	u_int http;
	u_int api;
	u_int rsnmp;
	u_int wsnmp;
	u_int ses;
	u_int ms;
	u_int serial;
	u_int panel;
	u_int scc;
	u_int dcc;
	u_int vlogin;
	u_int rcv_inv_ts;
	u_int rcv_inv_sign;
	u_int rcv_inv_cert;
	u_int slap_fail;
	u_int slap_bad_pkt;
	u_int ts_out_sync;
	u_int no_fcs;
	u_int inc_sec_db;
	u_int illegal_cmd;
};
typedef struct apisec_cntr2_t apisec_cntr2_t;

struct apisec_keycert_t {
	char wwn[8];
	pki_cert_t key;
	pki_cert_t crt;
};
typedef struct apisec_keycert_t apisec_keycert_t;

struct apisec_banner_req_t {
	pwwn_t wwn;
	struct {
		u_int banner_len;
		char *banner_val;
	} banner;
};
typedef struct apisec_banner_req_t apisec_banner_req_t;

struct apisec_banner_rsp_t {
	struct {
		u_int banner_len;
		char *banner_val;
	} banner;
};
typedef struct apisec_banner_rsp_t apisec_banner_rsp_t;

struct ms_sportinfo {
	int slotNum;
	int slotState;
};
typedef struct ms_sportinfo ms_sportinfo;

struct ms_sslot_t {
	char wwn[8];
	struct {
		u_int slotInfo_len;
		ms_sportinfo *slotInfo_val;
	} slotInfo;
};
typedef struct ms_sslot_t ms_sslot_t;

enum sfru_operation {
	SFRU_BEACON = 0,
	SFRU_FAN = 1,
	SFRU_FRU_INFO = 2,
	SFRU_HA = 3,
};
typedef enum sfru_operation sfru_operation;

enum sfru_fruType {
	SFRU_TYPE_BLADE = 0,
	SFRU_TYPE_SWITCH = 1,
	SFRU_TYPE_SLOT = 2,
	SFRU_TYPE_FAN = 3,
	SFRU_TYPE_PS = 4,
	SFRU_TYPE_CHASSIS = 5,
};
typedef enum sfru_fruType sfru_fruType;

enum sfru_fruValue {
	SFRU_VALUE_ON = 0,
	SFRU_VALUE_OFF = 1,
	SFRU_VALUE_ENABLE = 2,
	SFRU_VALUE_DISABLE = 3,
	SFRU_VALUE_FAILOVER = 4,
	SFRU_VALUE_SUPPID = 5,
	SFRU_VALUE_SUPPPN = 6,
	SFRU_VALUE_SUPPSN = 7,
	SFRU_VALUE_SUPPREV = 8,
	SFRU_VALUE_CHASSISSN = 9,
};
typedef enum sfru_fruValue sfru_fruValue;

struct fru_set_msg {
	char wwn[8];
	sfru_operation operation;
	sfru_fruType fruType;
	int fruIndex;
	int fruValueInt;
	char fruValueString[40];
};
typedef struct fru_set_msg fru_set_msg;

struct ms_gport2_msg {
	char wwn[8];
	u_int port;
	u_int set_attribute;
	u_int port_state;
	u_int port_status;
	u_int port_phys_state;
	u_int port_type;
	u_int port_speed;
	u_int port_distance;
	u_int tx_link_route_cost;
	u_int gbic_type;
	char gbic_serial[16];
	char gbic_vendor[16];
	u_int cos;
	u_int pid;
	u_int trunk_master;
	u_int qloopEnabled;
};
typedef struct ms_gport2_msg ms_gport2_msg;
#define API_PORT_NAME_MAX 36

struct ms_gport_ng_msg {
	char wwn[8];
	u_int port;
	u_int set_attribute;
	u_int port_state;
	u_int port_status;
	u_int port_phys_state;
	u_int port_type;
	u_int port_speed;
	u_int port_distance;
	u_int tx_link_route_cost;
	u_int gbic_type;
	char gbic_serial[16];
	char gbic_vendor[16];
	u_int cos;
	u_int pid;
	u_int trunk_master;
	u_int qloopEnabled;
	u_int port_cfg_flag;
	char port_name[API_PORT_NAME_MAX];
	int port_SFP_Temp;
	int port_SFP_Rxp;
	int port_SFP_Txp;
	int port_SFP_Current;
	int port_SFP_Voltage;
	int nFirmwareVersion;
	u_int uiPortFlag;
	u_int uiFabPortFlag;
};
typedef struct ms_gport_ng_msg ms_gport_ng_msg;

struct ms_gpa_msg {
	u_int uiNumOfFailures;
	u_long ulOffTime;
	u_long ulUpTime;
	u_long ulDownTime;
	u_long ulMTBF;
	u_long ulMTTF;
};
typedef struct ms_gpa_msg ms_gpa_msg;

struct ms2_req_arg {
	int ver;
	destAddress ms_fc_destAddrss;
	int tranxId;
	u_int flags;
	u_int unused1;
	u_int unused2;
	u_int unused3;
	u_int unused4;
	struct {
		u_int ms2req_len;
		char *ms2req_val;
	} ms2req;
};
typedef struct ms2_req_arg ms2_req_arg;

struct cal_request {
	destAddress target;
	struct {
		u_int request_xml_len;
		char *request_xml_val;
	} request_xml;
	u_int unused1;
	u_int unused2;
	u_int unused3;
	u_int unused4;
};
typedef struct cal_request cal_request;

enum tct_enum_t {
	TCT_TYPE_MIN = -1,
	TCT_TYPE_MAX = -1 + 1,
};
typedef enum tct_enum_t tct_enum_t;

struct tct_get_req_t {
	pwwn_t target;
	struct {
		u_int input_string_len;
		char *input_string_val;
	} input_string;
	int tranxId;
	int usingArr;
};
typedef struct tct_get_req_t tct_get_req_t;

struct tct_get_res_t {
	struct {
		u_int output_string_len;
		char *output_string_val;
	} output_string;
	int retcode;
};
typedef struct tct_get_res_t tct_get_res_t;

struct snmp_community {
	char snmp_ip[16];
	int access_level;
	c256ar snmp_community_str;
};
typedef struct snmp_community snmp_community;

struct snmp_access {
	char snmp_ip[16];
	int access;
};
typedef struct snmp_access snmp_access;
#define SSNMP_MIBCAPS 1
#define SSNMP_SYSDESCR 2
#define SSNMP_SYSLOCATION 3
#define SSNMP_SYSCONTACT 4
#define SSNMP_TRAPLEVEL 5
#define SSNMP_AUTHTRAPSENABLE 6
#define SSNMP_SYS_COMMUNITY 7
#define SSNMP_SYS_ACCESS 8

struct snmp_struct_t {
	u_int set_attribute;
	int mib_capability;
	c256ar sys_descr;
	c256ar sys_location;
	c256ar sys_contact;
	int sys_traplevel;
	int auth_trapsenabled;
	struct {
		u_int sys_community_len;
		snmp_community *sys_community_val;
	} sys_community;
	struct {
		u_int sys_access_len;
		snmp_access *sys_access_val;
	} sys_access;
};
typedef struct snmp_struct_t snmp_struct_t;
#define SFW_EMAIL_ADDRESS 1
#define SFW_EMAIL_STATUS 2

struct fw_email_struct_t {
	u_int set_attribute;
	int class_area;
	c256ar email_address;
	int email_status;
};
typedef struct fw_email_struct_t fw_email_struct_t;
#define SFW_FRUCFG_ALARMSTATE 1
#define SFW_FRUCFG_ALARMLEVEL 2
#define SFW_FRUCFG_ALARMFREQ 3
#define SFW_FRUCFG_TIMEBASE 4
#define SFW_FRUCFG_STATUS 5
#define SFW_FRUCFG_FLUSH 6
#define SFW_FRUCFG_CANCEL 7
#define SFW_FRUCFG_ALL 8
#define SFW_FRUCFG_ALLD 9

struct fw_frucfg_struct_t {
	u_int set_attribute;
	int fw_class;
	int index;
	int alarm_state;
	int alarm_level;
	int alarm_frequency;
	int time_base;
	int status;
};
typedef struct fw_frucfg_struct_t fw_frucfg_struct_t;
#define SENC_CHASSIS_NAME 1

struct enc_chassis_t {
	u_int set_attribute;
	char *chassis_name;
};
typedef struct enc_chassis_t enc_chassis_t;

enum xceiver_id {
	XVR_ID_GBIC = 1,
	XVR_ID_ONBOARD = 1 + 1,
	XVR_ID_XVR = 1 + 2,
};
typedef enum xceiver_id xceiver_id;

enum xceiver_conn {
	XVR_CONN_SC = 1,
	XVR_CONN_S1_CU = 1 + 1,
	XVR_CONN_S2_CU = 1 + 2,
	XVR_CONN_BNC_TNC = 1 + 3,
	XVR_CONN_COAX = 1 + 4,
	XVR_CONN_FIBERJACK = 1 + 5,
	XVR_CONN_LC = 1 + 6,
	XVR_CONN_MT_RJ = 1 + 7,
	XVR_CONN_MU = 1 + 8,
	XVR_CONN_SG = 1 + 9,
	XVR_CONN_OPT_PIGTAIL = 1 + 10,
	XVR_CONN_HSSDC_II = 0x20,
	XVR_CONN_CU_PIGTAIL = 0x20 + 1,
};
typedef enum xceiver_conn xceiver_conn;

enum xceiver_encoding {
	XVR_ENC_8B10B = 1,
	XVR_ENC_4B5B = 1 + 1,
	XVR_ENC_NRZ = 1 + 2,
	XVR_ENC_Manchester = 1 + 3,
};
typedef enum xceiver_encoding xceiver_encoding;

struct xceiver_info_t {
	xceiver_id identifer;
	xceiver_conn connector;
	char id[8];
	char *speeds;
	char *media;
	char *id_name;
	char *distance;
	xceiver_encoding encoding;
	int baud_rate;
	int length_9u;
	int length_9u_100;
	int length_50u;
	int length_62_5u;
	int length_cu;
	char *vendor_name;
	char vendor_oui[16];
	char *vendor_pn;
	char *vendor_rev;
	int wavelength;
	char *options;
	int br_max;
	int br_min;
	char *serial_num;
	char *date_code;
	int temperature;
	char *current;
	char *voltage;
	char *rx_power;
	char *tx_power;
};
typedef struct xceiver_info_t xceiver_info_t;
#define SLOG_LOGLEVEL 1
#define SLOG_LOGCLEAR 2

struct log_loglevel_t {
	u_int set_attribute;
	int log_level;
};
typedef struct log_loglevel_t log_loglevel_t;

struct api_pwd_t {
	struct {
		u_int pwd_len;
		char *pwd_val;
	} pwd;
};
typedef struct api_pwd_t api_pwd_t;

struct api_pwd_update_t {
	int level;
	struct {
		u_int pwd_len;
		char *pwd_val;
	} pwd;
};
typedef struct api_pwd_update_t api_pwd_update_t;

struct switch_gif_t {
	int GIFWidth;
	int GIFHeight;
	struct {
		u_int GIFBuf_len;
		u_char *GIFBuf_val;
	} GIFBuf;
};
typedef struct switch_gif_t switch_gif_t;
#define FW_REPORT_SWITCH 1
#define FW_REPORT_PORT_HEALTHY 2
#define FW_REPORT_PORT_MARGINAL 4
#define FW_REPORT_PORT_FAULTY 8
#define FW_REPORT_PORT_OFFLINE 16
#define FW_REPORT_PORT_LIST 32
#define FW_REPORT_PORT_ALL 64
#define FW_REPORT_SAM 128

struct fw_report_req_t {
	int fw_type;
	char *port_list;
	char *report_title;
};
typedef struct fw_report_req_t fw_report_req_t;

enum xceiver_input {
	XCEIVER_INP_USER_PORT = 0,
	XCEIVER_INP_SLASH_NOTATION = 1,
};
typedef enum xceiver_input xceiver_input;

struct gxceiver_info_req_t {
	xceiver_input input;
	union {
		int port_num;
		char slash_notation[80];
	} gxceiver_info_req_t_u;
};
typedef struct gxceiver_info_req_t gxceiver_info_req_t;

struct gport4_req_t {
	pwwn_t switch_wwn;
	pwwn_t port_wwn;
};
typedef struct gport4_req_t gport4_req_t;

struct ms_gport4_msg {
	char wwn[8];
	u_int port;
	u_int set_attribute;
	u_int port_state;
	u_int port_status;
	u_int port_phys_state;
	u_int port_type;
	u_int port_speed;
	u_int port_distance;
	u_int tx_link_route_cost;
	u_int gbic_type;
	char gbic_serial[16];
	char gbic_vendor[16];
	u_int cos;
	u_int pid;
	u_int trunk_master;
	u_int qloopEnabled;
	u_int port_cfg_flag;
	char port_name[API_PORT_NAME_MAX];
	int port_SFP_Temp;
	int port_SFP_Rxp;
	int port_SFP_Txp;
	int port_SFP_Current;
	int port_SFP_Voltage;
	int nFirmwareVersion;
	u_int uiPortFlag;
	u_int uiFabPortFlag;
	u_int trunk_deskew;
	u_int port_area;
	u_int port_user;
	char port_phys_location[16];
};
typedef struct ms_gport4_msg ms_gport4_msg;

struct gpl_fxport_entry {
	pwwn_t fxport_name;
	u_char reserved1;
	u_char fxport_module_type;
	u_char fxport_tx_type;
	u_char fxport_type;
};
typedef struct gpl_fxport_entry gpl_fxport_entry;

typedef struct {
	u_int gpl_fxport_list_len;
	gpl_fxport_entry *gpl_fxport_list_val;
} gpl_fxport_list;

struct ms_req_arg {
	ms_cmd_code cmd;
	union {
		ms_rout_req_arg grout_req_arg;
		ms_gpath_req_arg gpath_req_arg;
		ms_gsrout_req_arg gsrout_req_arg;
		ms_gfabric_msg gfabric_req_arg;
		ms_gsw_msg gsw_req_arg;
		ms_gswitch_msg gswitch_req_arg_AIX0;
		ms_gswitch_msg gswitch_req_arg;
		ms_gswitch_msg2 gswitch_req_arg2_AIX0;
		ms_gswitch_msg2 gswitch_req_arg2;
		pwwn_t gapi_arg;
		ms_gswitch_msg_ng gswitch_req_arg_ng_AIXO;
		ms_gswitch_msg_ng gswitch_req_arg_ng;
		ms_gport_msg gport_req_arg_AIX0;
		ms_gport_msg gport_req_arg;
		ms_gport2_msg sport2_req;
		ms_gport_ng_msg sport_ng_req;
		int gplat_info_req;
		ms_gflport_msg gflport_req_arg;
		ms_plat_name gpla_req_arg;
		ms_plat_attrib rpl_req_arg;
		ms_rpln_req rpln_req_arg;
		ms_rplt_req rplt_req_arg;
		ms_rplm_req rplm_req_arg;
		ms_plat_name dpl_req_arg;
		pwwn_t dpln_req_arg;
		ms_rplm_req dplm_req_arg;
		ms_plat_name dplml_req_arg;
		ms_req_pstats pstats_req_arg_AIX0;
		ms_req_pstats pstats_req_arg;
		u_int pid;
		u_int pid_AIX0;
		ms_req_perrs perrs_req_arg_AIX1;
		ms_req_perrs perrs_req_arg_AIX0;
		ms_req_perrs perrs_req_arg;
		fw_req_arg fw_req_AIX0;
		fw_req_arg fw_req_AIX1;
		fw_req_arg fw_req_AIX2;
		fw_req_arg fw_req_AIX3;
		fw_req_arg fw_req_AIX4;
		fw_req_arg fw_req_AIX5;
		fw_req_arg fw_req_AIX6;
		fw_req_arg fw_req_AIX7;
		fw_req_arg fw_req_AIX8;
		fw_req_arg fw_req_AIX9;
		fw_req_arg fw_req_AIX10;
		fw_req_arg fw_req_AIX11;
		fw_req_arg fw_req_AIX12;
		fw_req_arg fw_req_AIX13;
		fw_req_arg fw_req_AIX14;
		fw_req_arg fw_req_AIX15;
		fw_req_arg fw_req_AIX16;
		fw_req_arg fw_req_AIX17;
		fw_req_arg fw_req_AIX18;
		fw_req_arg fw_req_AIX19;
		fw_req_arg fw_req_AIX20;
		fw_req_arg fw_req_AIX21;
		fw_req_arg fw_req;
		ms_sgroup_msg sgroup_arg_AIX0;
		ms_sgroup_msg sgroup_arg_AIX1;
		ms_sgroup_msg sgroup_arg;
		ms_fw_event_msg fw_event_arg_AIX0;
		ms_fw_event_msg fw_event_arg_AIX1;
		ms_fw_event_msg fw_event_arg_AIX2;
		ms_fw_event_msg fw_event_arg;
		ms_fw_event_msg2 fw_event_arg2_AIX2;
		ms_fw_event_msg2 fw_event_arg2;
		license_req_t lic_req_AIX0;
		license_req_t lic_req_AIX1;
		license_req_t lic_req_AIX2;
		license_req_t lic_req;
		lic_prod_req prod_req_AIX0;
		lic_prod_req prod_req;
		msapi_sgget_req_t sgget_req;
		msapi_sgset_req_t sgset_req;
		msapi_sgdel_req_t sgdel_req;
		msapi_sgrnm_req_t sgrnm_req;
		ms_download_start_cmd download_start_arg;
		ms_download_arg download_packet_arg;
		ms_download_end_cmd download_end_arg_AIX0;
		ms_download_end_cmd download_end_arg;
		ms_download_self_start_cmd download_self_start_arg;
		ms_download_self_end_cmd download_self_end_arg;
		ms_upload_start_cmd upload_start_arg;
		ms_upload_arg upload_packet_arg;
		ms_upload_end_cmd upload_end_arg_AIX0;
		ms_upload_end_cmd upload_end_arg;
		pwwn_t vFwWwn;
		ms_gswitchdzb_req gswitch_dzb_arg_AIX0;
		ms_gswitchdzb_req gswitch_dzb_arg;
		csr_msg sec_csr_req;
		ca_msg sec_ca_req;
		apisec_cntr_req sec_cntr_req;
		apisec_cntr_req sec_cntr2_req;
		apisec_keycert_t sec_keycert_req;
		pwwn_t wwn;
		pwwn_t bannerWwn;
		apisec_banner_req_t sec_set_banner_req;
		ms_sslot_t sslot_req;
		ms_gswitch_msg gcp_arg;
		fru_set_msg fru_set_arg;
		ms_delrout_req_arg delrout_req_arg;
		ms_default_req_arg default_req_arg;
	} ms_req_arg_u;
};
typedef struct ms_req_arg ms_req_arg;

struct gapnl2_req_t {
	pwwn_t wwn_input_switch;
	pwwn_t wwn_port;
};
typedef struct gapnl2_req_t gapnl2_req_t;

enum gscsi_cmd_t {
	GSCSI_STD_INQ = 1,
	GSCSI_UNIT_NUMBER_PAGE = 1 + 1,
	GSCSI_DEVICE_ID_PAGE = 1 + 2,
};
typedef enum gscsi_cmd_t gscsi_cmd_t;

struct gscsi_string_req_t {
	pwwn_t device_wwn;
	gscsi_cmd_t gscsi_cmd;
};
typedef struct gscsi_string_req_t gscsi_string_req_t;

struct gattpsfp_req_t {
	pwwn_t wwn_input_switch;
	pwwn_t wwn_port;
};
typedef struct gattpsfp_req_t gattpsfp_req_t;

struct gapnl2_resp {
	pwwn_t wwn_output_switch;
	pwwn_t wwn_output_port;
	int port_number;
	int port_type;
};
typedef struct gapnl2_resp gapnl2_resp;

typedef struct {
	u_int gapnl2_resp_list_len;
	gapnl2_resp *gapnl2_resp_list_val;
} gapnl2_resp_list;

struct gscsi_string_resp_t {
	int retval;
	struct {
		u_int scsi_string_len;
		char *scsi_string_val;
	} scsi_string;
};
typedef struct gscsi_string_resp_t gscsi_string_resp_t;

enum phswitch_type_t {
	SWITCH_TYPE_PHANTOM = 0,
	SWITCH_TYPE_REAL = 1,
};
typedef enum phswitch_type_t phswitch_type_t;

struct gphswitchgrp_list {
	pwwn_t wwn_switch;
	u_int fabric_id;
	phswitch_type_t type;
};
typedef struct gphswitchgrp_list gphswitchgrp_list;

struct fcr_gphswitchgrp_resp {
	pwwn_t wwn_license;
	struct {
		u_int switch_list_len;
		gphswitchgrp_list *switch_list_val;
	} switch_list;
};
typedef struct fcr_gphswitchgrp_resp fcr_gphswitchgrp_resp;

enum portType_t {
	PORT_TYPE_EX = 0,
	PORT_TYPE_OTHER = 1,
};
typedef enum portType_t portType_t;

struct gpsfpl_resp {
	pwwn_t wwn_port;
	portType_t port_type;
	u_int fabric_id;
	char location[64];
	int is_reachable;
};
typedef struct gpsfpl_resp gpsfpl_resp;

typedef struct {
	u_int gpsfpl_resp_list_len;
	gpsfpl_resp *gpsfpl_resp_list_val;
} gpsfpl_resp_list;

typedef struct {
	u_int int_list_len;
	int *int_list_val;
} int_list;

struct ms_wwn_entry {
	char wwn[8];
	long attribute;
	long type;
	long misc;
};
typedef struct ms_wwn_entry ms_wwn_entry;

typedef struct {
	u_int ms_wwn_list_len;
	ms_wwn_entry *ms_wwn_list_val;
} ms_wwn_list;

struct fcr_fid_t {
	int fid;
	ms_wwn_list wwnlist;
	struct {
		u_int reserve_len;
		int *reserve_val;
	} reserve;
};
typedef struct fcr_fid_t fcr_fid_t;
#define EIF_IPADDRESS 0x00000002
#define EIF_NETMASK 0x00000100
#define EIF_GATEWAY 0x00000200

struct enet_interface_t {
	int index;
	int set_cmd;
	dotIP ipAddr;
	dotIP ipNetmask;
	dotIP ipGateway;
	int type;
	int realtime;
};
typedef struct enet_interface_t enet_interface_t;

typedef struct {
	u_int enet_interface_list_len;
	enet_interface_t *enet_interface_list_val;
} enet_interface_list;

struct fcr_switch_addition001_t {
	ms_wwn_entry wwn;
	int fcr_capable;
	enet_interface_list ips;
	struct {
		u_int reserve_len;
		int *reserve_val;
	} reserve;
};
typedef struct fcr_switch_addition001_t fcr_switch_addition001_t;

struct fcr_LSAN_t {
	int fid;
	char zoneName[128];
	ms_wwn_list zoneMembers;
};
typedef struct fcr_LSAN_t fcr_LSAN_t;

typedef struct {
	u_int fcr_LSAN_list_len;
	fcr_LSAN_t *fcr_LSAN_list_val;
} fcr_LSAN_list;

struct fcr_route_t {
	int fid;
	ms_wwn_entry principal_wwn;
	ms_wwn_entry nrport_wwn;
	int txport_pid;
	int linkcost;
};
typedef struct fcr_route_t fcr_route_t;

typedef struct {
	u_int fcr_route_list_len;
	fcr_route_t *fcr_route_list_val;
} fcr_route_list;
#define SFCR_EX_FID 1
#define SFCR_EX_DID 2
#define SFCR_EX_E_D_TOV 3
#define SFCR_EX_R_A_TOV 4
#define SFCR_EX_INTER_MODE 5
#define SFCR_EX_PID_FORMAT 6

struct fcr_ex_port_t {
	ms_wwn_entry wwn;
	int set_cmd;
	int fid;
	int did;
	int e_d_tov;
	int r_a_tov;
	int intermode;
	int pid_format;
};
typedef struct fcr_ex_port_t fcr_ex_port_t;

struct fcr_proxy_device_t {
	ms_wwn_entry sw_wwn;
	ms_wwn_entry fxport_wwn;
	int fid;
	int pid;
	int port_state;
};
typedef struct fcr_proxy_device_t fcr_proxy_device_t;

typedef struct {
	u_int fcr_proxy_device_list_len;
	fcr_proxy_device_t *fcr_proxy_device_list_val;
} fcr_proxy_device_list;

struct fcr_phy_device_t {
	ms_wwn_entry port_wwn;
	int phy_fid;
	int phy_pid;
	ms_wwn_entry node_wwn;
	fcr_proxy_device_list proxy_devices;
};
typedef struct fcr_phy_device_t fcr_phy_device_t;

struct fcr_gdevice2_req {
	u_int pid;
};
typedef struct fcr_gdevice2_req fcr_gdevice2_req;

typedef struct {
	u_int fcr_phy_device_list_len;
	fcr_phy_device_t *fcr_phy_device_list_val;
} fcr_phy_device_list;

struct fcr_portinfo {
	int slotNum;
	int slotState;
	int slotStatus;
	struct {
		u_int portWwns_len;
		pwwn_t *portWwns_val;
	} portWwns;
	char brcdPN[16];
	char brcdSN[16];
	char oemPN[24];
	char oemSN[24];
	char oemRev[8];
	char mfgLocation[24];
	char mfgDate[24];
	struct {
		u_int tempSensors_len;
		int *tempSensors_val;
	} tempSensors;
};
typedef struct fcr_portinfo fcr_portinfo;

struct fcr_slot_resp {
	char switch_wwn[8];
	struct {
		u_int slotInfo_len;
		fcr_portinfo *slotInfo_val;
	} slotInfo;
};
typedef struct fcr_slot_resp fcr_slot_resp;

enum fcr_phy_conn_type {
	PORT_TYPE_FC_STANDARD = 0,
	PORT_TYPE_FC_EX = 1,
	PORT_TYPE_FC_VIRTUAL = 2,
	PORT_TYPE_FC_IP = 3,
};
typedef enum fcr_phy_conn_type fcr_phy_conn_type;

struct fcr_gpl3_resp {
	pwwn_t fxport_name;
	fcr_phy_conn_type conn_type;
	int physical_index;
	int blade_index;
	u_char reserved1;
	u_char fxport_module_type;
	u_char fxport_tx_type;
	u_char fxport_type;
};
typedef struct fcr_gpl3_resp fcr_gpl3_resp;

typedef struct {
	u_int fcr_gpl3_list_len;
	fcr_gpl3_resp *fcr_gpl3_list_val;
} fcr_gpl3_list;

struct fcr_gdevice2_resp {
	char inq_data[256];
};
typedef struct fcr_gdevice2_resp fcr_gdevice2_resp;

struct csr_t {
	ms_wwn_entry wwn;
	pki_cert_t csr;
};
typedef struct csr_t csr_t;

typedef csr_t cert_t;

typedef struct {
	u_int csr_list_len;
	csr_t *csr_list_val;
} csr_list;

typedef struct {
	u_int cert_list_len;
	cert_t *cert_list_val;
} cert_list;

struct fc_ng2_req_arg {
	fc_ng2_cmd_code cmd;
	union {
		tct_get_req_t tct_get_req;
		snmp_struct_t snmp_set_req;
		fw_email_struct_t gfw_email_req;
		fw_email_struct_t sfw_email_req;
		fw_frucfg_struct_t gfw_frucfg_req;
		fw_frucfg_struct_t sfw_frucfg_req;
		log_loglevel_t slog_loglevel_req;
		enc_chassis_t senc_chassis_req;
		api_pwd_update_t swpwd;
		fw_report_req_t fw_report_req;
		gxceiver_info_req_t gxceiverinfo_req;
		struct {
			u_int cal_fc_req_len;
			char *cal_fc_req_val;
		} cal_fc_req;
		gapnl2_req_t gapnl2_req;
		gscsi_string_req_t gscsi_string_req;
		pwwn_t gphswitchgrp_req;
		pwwn_t glapn_req;
		pwwn_t glvnd_req;
		gattpsfp_req_t gattpsfp_req;
		pwwn_t gpsfpl_req;
		gport4_req_t gport4_req;
		pwwn_t gmodule2_req;
		pwwn_t gmodule3_req;
		pwwn_t gpl2_req;
		pwwn_t gswitch4_req;
		pwwn_t gapiversion2_req;
		ms_gswitch_msg_ng sswitch4_req;
		fcr_fid_t sfid_req;
		fcr_switch_addition001_t gsw_addi_req;
		fcr_switch_addition001_t ssw_addi_req;
		fcr_LSAN_t glsan_req;
		fcr_route_t gfcr_route_req;
		fcr_phy_device_t gphy_devive_req;
		fcr_fid_t gphy_device_list_req;
		fcr_phy_device_t gphy_devive_bn_req;
		fcr_ex_port_t gex_port_req;
		fcr_ex_port_t sex_port_req;
		csr_list sec_gcsr_req;
		csr_list sec_ccsr_req;
		cert_list sec_scert_req;
		ms_wwn_entry gvivt_req;
		ms_wwn_entry gavivt_req;
		fcr_LSAN_t galsan_req;
		fcr_phy_device_t gaphy_devive_req;
		fcr_fid_t gaphy_device_list_req;
		fcr_phy_device_t gaphy_devive_bn_req;
		pwwn_t gpl3_req;
		ms_gfab_topo_msg gfabrictopo_req;
		ms_gsw_topo_msg gswtopo_req;
		fa_sys_id fa_sys_req;
		fa_sys_id all_fa_agent_sw_feat_req;
		fa_get_agent_sw_feat_req_arg fa_agent_sw_feat_req;
		fa_get_agent_sw_feat_req_arg all_fa_agent_supported_model_profile_req;
		fa_get_agent_supported_model_profile_req_arg fa_agent_supported_model_profile_req;
		fa_get_agent_supported_model_profile_req_arg fa_agent_mof;
		fa_get_agent_supported_model_profile_req_arg get_mof_async_req_arg;
		fa_forward_wbem_req_arg forward_wbem_req_arg;
		fa_forward_wbem_req_arg forward_wbem_async_req_arg;
	} fc_ng2_req_arg_u;
};
typedef struct fc_ng2_req_arg fc_ng2_req_arg;

struct ms_gmal_resp {
	u_long listlen;
	struct {
		u_int gmal_list_len;
		c256ar *gmal_list_val;
	} gmal_list;
};
typedef struct ms_gmal_resp ms_gmal_resp;

typedef struct {
	u_int ms_wwn_type_res_len;
	ms_wwn_type_entry *ms_wwn_type_res_val;
} ms_wwn_type_res;

struct ms_gieil_c64 {
	char resv1[3];
	char listlen;
};
typedef struct ms_gieil_c64 ms_gieil_c64;

struct ms_gieil_resp {
	ms_gieil_c64 gieil_c64;
	struct {
		u_int listinfo_len;
		char *listinfo_val;
	} listinfo;
};
typedef struct ms_gieil_resp ms_gieil_resp;

struct ms_gperr_resp {
	long PortLinkFailures;
	long PortSyncLosses;
	long PortSigLosses;
	long PortPrimSeqProtoErrors;
	long PortInvalidTxWords;
	long PortInvalidCrcs;
	long PortDelimiterErrors;
	long PortAddressIdErrors;
	long PortLinkResetIns;
	long PortLinkResetOuts;
	long PortOlsIns;
	long PortOlsOuts;
};
typedef struct ms_gperr_resp ms_gperr_resp;

struct ms_gpst_resp {
	u_int PortTxWords;
	u_int PortRxWords;
	u_int PortTxFrames;
	u_int PortRxFrames;
	u_int PortRxC2Frames;
	u_int PortRxC3Frames;
	u_int PortRxLCs;
	u_int PortRxMcasts;
	u_int PortTooManyRdys;
	u_int PortNoTxCredits;
	u_int PortRxEncInFrs;
	u_int PortRxCrcs;
	u_int PortRxTruncs;
	u_int PortRxTooLongs;
	u_int PortRxBadEofs;
	u_int PortRxEncOutFrs;
	u_int PortRxBadOs;
	u_int PortC3Discards;
	u_int PortMcastTimedOuts;
	u_int PortTxMcasts;
};
typedef struct ms_gpst_resp ms_gpst_resp;

struct hop {
	int port;
	int domain;
};
typedef struct hop hop;

struct ms_grout_resp {
	int num_hops;
	struct {
		u_int hops_len;
		hop *hops_val;
	} hops;
};
typedef struct ms_grout_resp ms_grout_resp;

struct ms_gpath_resp {
	int num_ports;
	struct {
		u_int ports_len;
		int *ports_val;
	} ports;
};
typedef struct ms_gpath_resp ms_gpath_resp;

struct ms_gdevice_resp_api1 {
	char inq_data[36];
};
typedef struct ms_gdevice_resp_api1 ms_gdevice_resp_api1;

struct ms_gdevice_resp {
	char inq_data[RAPI_SCSISTRING_MAXLENGTH];
};
typedef struct ms_gdevice_resp ms_gdevice_resp;

struct msapi_sgget_resp_t {
	char sg_name[SG_NAME_SIZE];
	int sg_type;
	int num_members;
	pwwn_t members[SG_MAX_MEMBERS];
};
typedef struct msapi_sgget_resp_t msapi_sgget_resp_t;

struct fanentry {
	int FanRpm;
	int FanIntakeTemp;
	char brcdPN[16];
	char brcdSN[16];
	char oemPN[24];
	char oemSN[24];
};
typedef struct fanentry fanentry;

typedef int tempsensorentry;

struct psupplyentry {
	int PSupplyStatus;
	char brcdPN[16];
	char brcdSN[16];
	char oemPN[24];
	char oemSN[24];
};
typedef struct psupplyentry psupplyentry;

struct switch_enclosure_resp {
	char wwn[8];
	char EnclosureSerialNum[8];
	int EnclosureType;
	struct {
		u_int SwitchOids_len;
		pwwn_t *SwitchOids_val;
	} SwitchOids;
	struct {
		u_int fanlist_len;
		fanentry *fanlist_val;
	} fanlist;
	struct {
		u_int tempsensorlist_len;
		tempsensorentry *tempsensorlist_val;
	} tempsensorlist;
	struct {
		u_int psupplylist_len;
		psupplyentry *psupplylist_val;
	} psupplylist;
};
typedef struct switch_enclosure_resp switch_enclosure_resp;

struct fruHdrInfo {
	char brcdPN[16];
	char brcdSN[16];
	char oemPN[24];
	char oemSN[24];
	char oemID[12];
	char oemRev[8];
	int pwrCF;
	u_int swFruID;
	char mfgDate[24];
	char updateDate[24];
	int timeAlive;
	int timeAwake;
	u_short hdrVersion;
	u_short assyUnit;
};
typedef struct fruHdrInfo fruHdrInfo;

struct fanentry2 {
	int fanRpm;
	int fanIntakeTemp;
	struct fruHdrInfo fruHeader;
};
typedef struct fanentry2 fanentry2;

struct psupplyentry2 {
	int pwrSupplyStatus;
	struct fruHdrInfo fruHeader;
};
typedef struct psupplyentry2 psupplyentry2;

struct tempsensorentry2 {
	int tempValue;
	int location;
	int subLocation;
	int slotNumber;
	int state;
};
typedef struct tempsensorentry2 tempsensorentry2;

struct genbladeentry {
	int slotNumber;
	int bladeType;
	int state;
	int ownerSwitch;
	int reserved1;
	int reserved2;
	struct fruHdrInfo fruHeader;
};
typedef struct genbladeentry genbladeentry;

typedef fruHdrInfo wwnbladeentry2;

struct switch_enclosure2_resp {
	char wwn[8];
	char licenseId[8];
	int enclosureType;
	int numberOfCPs;
	struct {
		u_int switchOids_len;
		pwwn_t *switchOids_val;
	} switchOids;
	struct {
		u_int fanlist_len;
		fanentry2 *fanlist_val;
	} fanlist;
	struct {
		u_int tempsensorlist_len;
		tempsensorentry2 *tempsensorlist_val;
	} tempsensorlist;
	struct {
		u_int psupplylist_len;
		psupplyentry2 *psupplylist_val;
	} psupplylist;
	struct {
		u_int wwnbladelist_len;
		wwnbladeentry2 *wwnbladelist_val;
	} wwnbladelist;
	struct {
		u_int genbladelist_len;
		genbladeentry *genbladelist_val;
	} genbladelist;
};
typedef struct switch_enclosure2_resp switch_enclosure2_resp;

struct cp_info_resp {
	char wwn[8];
	int slotNumber;
	int state;
	int status;
	int fruState;
	int reserved1;
	int reserved2;
	char ipAddress[16];
	char mask[16];
	char gateway[16];
	char firmwareVersion[32];
	struct fruHdrInfo fruHeader;
};
typedef struct cp_info_resp cp_info_resp;

struct ms_portinfo {
	int slotNum;
	int slotState;
	int slotStatus;
	int minPort;
	int maxPort;
	char brcdPN[16];
	char brcdSN[16];
	char oemPN[24];
	char oemSN[24];
	char oemRev[8];
	char mfgLocation[24];
	char mfgDate[24];
	struct {
		u_int tempSensors_len;
		int *tempSensors_val;
	} tempSensors;
};
typedef struct ms_portinfo ms_portinfo;

struct ms_slot_resp {
	char wwn[8];
	struct {
		u_int slotInfo_len;
		ms_portinfo *slotInfo_val;
	} slotInfo;
};
typedef struct ms_slot_resp ms_slot_resp;

struct ms_resp_res {
	ms_cmd_code cmd;
	union {
		ms_wwn_type_res ms_wtl_resp_AIX0;
		ms_wwn_type_res ms_wtl_resp_AIX1;
		ms_wwn_type_res ms_wtl_resp;
		u_long ms_ulongresp_AIX0;
		u_long ms_ulongresp_AIX1;
		u_long ms_ulongresp_AIX2;
		u_long ms_ulongresp;
		u_long ms_ulong2resp[2];
		char c4resp[4];
		char c8resp[8];
		c256ar c256resp;
		ms_gmal_resp gmal_resp;
		ms_gieil_resp gieil_resp;
		ms_gpst_resp gpst_resp;
		ms_gperr_resp gperr_resp;
		ms_grout_resp grout_resp;
		ms_gpath_resp gpath_resp;
		ms_gfabric_msg gfabric_resp;
		ms_gsw_msg gsw_resp;
		ms_gswitch_msg gswitch_resp;
		ms_gswitch_msg2 gswitch_resp2;
		long gapi_resp;
		ms_gswitch_msg_ng gswitch_resp_ng;
		ms_gport_msg gport_resp;
		ms_gport2_msg gport2_resp;
		ms_gport_ng_msg gport_ng_resp;
		ms_gpa_msg gpa_resp;
		int port_resp_AIX0;
		int sport_resp;
		int gplat_info_resp;
		ms_platall platall_resp;
		ms_gflport_msg gflport_resp;
		ms_plat_name_list gpnl_resp;
		ms_plat_attrib gpla_resp;
		ms_resp_pstats pstats_resp;
		ms_gdevice_resp_api1 gdevice_resp;
		ms_gdevice_resp gdevice_resp2;
		ms_resp_perrs perrs_resp_AIX0;
		ms_resp_perrs perrs_resp;
		int licensed;
		fwConfigStruct fw_config;
		fwThStruct fw_thresh;
		fwThStruct2 fw_thresh2;
		ms_sgroup_msg sgroup_arg;
		api_license_t lic_get_resp;
		license_key_set lic_getall_resp;
		lic_prod_msg prod_msg;
		product_id_set prodall_msg;
		msapi_sgget_resp_t sgget_resp;
		ms_download_rsp download_rsp_AIX0;
		ms_download_rsp download_rsp_AIX1;
		ms_download_rsp download_rsp_AIX2;
		ms_download_rsp download_rsp;
		ms_download_self_rsp download_self_rsp_AIX0;
		ms_download_self_rsp download_self_rsp;
		ms_upload_start_rsp upload_start_rsp;
		ms_upload_rsp upload_rsp;
		ms_upload_end_rsp upload_end_rsp_AIX0;
		ms_upload_end_rsp upload_end_rsp;
		u_int firmware_status_rsp;
		ms_gswitchdzb_req gswitch_dzb_resp_AIX0;
		ms_gswitchdzb_req gswitch_dzb_resp;
		csr_msg sec_csr_resp;
		apisec_cntr_t sec_cntr_resp;
		apisec_cntr2_t sec_cntr_resp2;
		apisec_banner_rsp_t sec_banner_rsp;
		switch_enclosure_resp enclosure_resp;
		switch_enclosure2_resp enclosure2_resp;
		cp_info_resp cpInfo_resp;
		ms_slot_resp slot_resp;
		ms_sslot_t sslot_resp;
		u_int fru_resp;
	} ms_resp_res_u;
};
typedef struct ms_resp_res ms_resp_res;
#define SNS_WWN_LEN 8
#define SNS_ID_LEN 3
#define SNS_PN_LEN 8
#define SNS_SPN_LEN 255
#define SNS_NN_LEN 8
#define SNS_SNN_LEN 255
#define SNS_IPA_LEN 8
#define SNS_IP_LEN 16
#define SNS_FT_LEN 32

struct snsEntryBasic {
	u_char port_type;
	u_char port_id[SNS_ID_LEN];
	u_char port_name[SNS_PN_LEN];
	u_char node_name[SNS_NN_LEN];
	u_char ipa[SNS_IPA_LEN];
	u_char ip_address[SNS_IP_LEN];
	u_int class_of_service;
	u_char fc_4_map[SNS_FT_LEN];
	u_char ip_port[SNS_IP_LEN];
	u_char fx_port_name[SNS_PN_LEN];
	u_char reserved1;
	u_char hardaddress[SNS_ID_LEN];
};
typedef struct snsEntryBasic snsEntryBasic;

typedef struct {
	u_int snsEntryBasicList_len;
	snsEntryBasic *snsEntryBasicList_val;
} snsEntryBasicList;

struct snsEntryStruct {
	u_char port_type;
	u_char port_id[SNS_ID_LEN];
	u_char port_name[SNS_PN_LEN];
	u_char l_spn;
	char symbolic_port_name[SNS_SPN_LEN];
	u_char node_name[SNS_NN_LEN];
	u_char l_snn;
	char symbolic_node_name[SNS_SNN_LEN];
	u_char ipa[SNS_IPA_LEN];
	u_char ip_address[SNS_IP_LEN];
	u_int class_of_service;
	u_char fc_4_map[SNS_FT_LEN];
	u_char ip_port[SNS_IP_LEN];
	u_char fx_port_name[SNS_PN_LEN];
	u_char reserved1;
	u_char hardaddress[SNS_ID_LEN];
};
typedef struct snsEntryStruct snsEntryStruct;

typedef struct {
	u_int snsEntryList_len;
	snsEntryStruct *snsEntryList_val;
} snsEntryList;

struct fc_ng2_res_arg {
	fc_ng2_cmd_code cmd;
	union {
		tct_get_res_t tct_get_res;
		snmp_struct_t snmp_get_res;
		int snmp_set_res;
		fw_email_struct_t gfw_email_res;
		int sfw_email_res;
		fw_frucfg_struct_t gfw_frucfg_res;
		int sfw_frucfg_res;
		log_loglevel_t glog_loglevel_res;
		int sfw_loglevel_res;
		enc_chassis_t genc_chassis_res;
		int sfw_chassis_res;
		int pwd_res;
		switch_gif_t switch_gif_res;
		int fw_report_res;
		xceiver_info_t gxceiverinfo_res;
		struct {
			u_int cal_fc_res_len;
			char *cal_fc_res_val;
		} cal_fc_res;
		gapnl2_resp_list gapnl2_res;
		gscsi_string_resp_t gscsi_string_res;
		fcr_gphswitchgrp_resp gphswitchgrp_res;
		int_list fcr_glapn_res;
		ms_wwn_list glvnd_res;
		char gattpsfp_res[64];
		gpsfpl_resp_list gpsfpl_res;
		ms_gport4_msg gport4_res;
		ms_slot_resp gmodule_resp;
		fcr_slot_resp gmodule3_resp;
		gpl_fxport_list gpl2_resp;
		ms_gswitch_msg_ng gswitch4_resp;
		long gapiversion_resp;
		fcr_fid_t gfid_res;
		fcr_fid_t sfid_res;
		fcr_switch_addition001_t gsw_addi_res;
		fcr_switch_addition001_t ssw_addi_res;
		ms_wwn_list gpsl_res;
		fcr_LSAN_list glsan_res;
		fcr_route_list gfcr_route_res;
		fcr_phy_device_t gphy_devive_res;
		fcr_phy_device_list gphy_devivelist_res;
		fcr_phy_device_list gphy_devive_bn_res;
		fcr_ex_port_t gex_port_res;
		fcr_ex_port_t sex_port_res;
		csr_list sec_gcsr_res;
		csr_list sec_ccsr_res;
		cert_list sec_scert_res;
		snsEntryBasicList gvivt_res;
		snsEntryList gavivt_res;
		fcr_LSAN_list galsan_res;
		fcr_phy_device_t gaphy_devive_res;
		fcr_phy_device_list gaphy_devivelist_res;
		fcr_phy_device_list gaphy_devive_bn_res;
		fcr_gpl3_list gpl3_resp;
		ms_gfab_topo_msg gfabrictopo_resp;
		ms_gsw_topo_msg gswtopo_resp;
		fa_fasys_list_resp fasys_list;
		fa_fasys fa_fasys_resp;
		fa_get_agent_list_resp feature_list;
		fa_agent_info fa_agent_info_resp;
		fa_agent_model_profile_list_resp supported_model_profile_list;
		fa_agent_model_profile supported_model_profile;
		fa_get_agent_mof_resp agent_mof;
		fa_acknowledgement get_mof_ack;
		fa_wbem_resp wbem_resp;
		fa_acknowledgement wbem_req_ack;
	} fc_ng2_res_arg_u;
};
typedef struct fc_ng2_res_arg fc_ng2_res_arg;

struct ms_result {
	long retcode;
	char *status_msg;
	u_long resp_data_sz;
	ms_resp_res ms_response;
};
typedef struct ms_result ms_result;

struct ms2_result {
	long retcode;
	struct {
		u_int ms_response_len;
		char *ms_response_val;
	} ms_response;
};
typedef struct ms2_result ms2_result;

struct cal_result {
	long retcode;
	long retcode2;
	char *status_msg;
	struct {
		u_int response_xml_len;
		char *response_xml_val;
	} response_xml;
};
typedef struct cal_result cal_result;

enum ns_cmd_code {
	GALL_ID = 0x1001,
	GA_NXT = 0x0100,
	GID_A = 0x0101,
	GPN_ID = 0x0112,
	GNN_ID = 0x0113,
	GCS_ID = 0x0114,
	GFT_ID = 0x0117,
	GSPN_ID = 0x0118,
	GPT_ID = 0x011A,
	GIPP_ID = 0x011B,
	GFPN_ID = 0x011C,
	GHA_ID = 0x011D,
	GID_PN = 0x0121,
	GIPP_PN = 0x012B,
	GID_NN = 0x0131,
	GIP_NN = 0x0135,
	GIPA_NN = 0x0136,
	GSNN_NN = 0x0139,
	GNN_IP = 0x0153,
	GIPA_IP = 0x0156,
	GID_FT = 0x0171,
	GPN_FT = 0x0172,
	GNN_FT = 0x0173,
	GID_PT = 0x01A1,
	GID_IPP = 0x01B1,
	GPN_IPP = 0x01B2,
	RSPN_ID = 0x0218,
	RSNN_ID = 0x0239,
	GALL_NS = 0x300,
};
typedef enum ns_cmd_code ns_cmd_code;

struct ns_sspname {
	u_int pid;
	char sym_name[256];
};
typedef struct ns_sspname ns_sspname;

struct ns_ssnname {
	u_char node_name[SNS_NN_LEN];
	char sym_name[256];
};
typedef struct ns_ssnname ns_ssnname;

struct ns_req_arg {
	ns_cmd_code cmd;
	u_char port_id[SNS_ID_LEN];
	u_char node_name[SNS_NN_LEN];
	u_char port_name[SNS_PN_LEN];
	u_char ip_address[SNS_IP_LEN];
	u_char ip_port[SNS_IP_LEN];
	u_char port_type;
	u_char fc_4_type;
	u_char domain;
	ns_sspname sspname;
	ns_ssnname ssnname;
};
typedef struct ns_req_arg ns_req_arg;

struct snsSimpleEntryStruct {
	u_char port_type;
	u_char port_id[SNS_ID_LEN];
	u_char port_name[SNS_PN_LEN];
	u_char node_name[SNS_NN_LEN];
	u_char fx_port_name[SNS_PN_LEN];
};
typedef struct snsSimpleEntryStruct snsSimpleEntryStruct;

struct snsPortListStruct {
	u_char port_list_info;
	u_char port_id[SNS_ID_LEN];
};
typedef struct snsPortListStruct snsPortListStruct;

typedef struct {
	u_int snsPortListStructList_len;
	snsPortListStruct *snsPortListStructList_val;
} snsPortListStructList;

struct snsWwnListStruct {
	u_char port_list_info;
	u_char port_id[SNS_ID_LEN];
	u_int reserved1;
	u_char wwn[SNS_WWN_LEN];
};
typedef struct snsWwnListStruct snsWwnListStruct;

typedef struct {
	u_int snsWwnListStructList_len;
	snsWwnListStruct *snsWwnListStructList_val;
} snsWwnListStructList;

struct snsDAListStruct {
	u_char da_list_info;
	u_char domain_id;
	u_char area_id;
	u_char reserved2;
};
typedef struct snsDAListStruct snsDAListStruct;

typedef struct {
	u_int snsDAListStructList_len;
	snsDAListStruct *snsDAListStructList_val;
} snsDAListStructList;

struct ns_resp_res {
	ns_cmd_code cmd;
	union {
		struct {
			u_int snsSimpleEntry_len;
			snsSimpleEntryStruct *snsSimpleEntry_val;
		} snsSimpleEntry;
		snsEntryStruct snsEntry_AIX0;
		snsEntryStruct snsEntry_AIX1;
		snsEntryStruct snsEntry_AIX2;
		snsEntryStruct snsEntry_AIX3;
		snsEntryStruct snsEntry_AIX4;
		snsEntryStruct snsEntry_AIX5;
		snsEntryStruct snsEntry_AIX6;
		snsEntryStruct snsEntry_AIX7;
		snsEntryStruct snsEntry_AIX8;
		snsEntryStruct snsEntry_AIX9;
		snsEntryStruct snsEntry_AIX10;
		snsEntryStruct snsEntry_AIX11;
		snsEntryStruct snsEntry_AIX12;
		snsEntryStruct snsEntry_AIX13;
		snsEntryStruct snsEntry_AIX14;
		snsEntryStruct snsEntry_AIX15;
		snsEntryStruct snsEntry_AIX16;
		snsEntryStruct snsEntry_AIX17;
		snsEntryStruct snsEntry_AIX18;
		snsEntryStruct snsEntry;
		snsPortListStructList plist_AIX0;
		snsPortListStructList plist_AIX1;
		snsPortListStructList plist;
		snsWwnListStructList wlist_AIX0;
		snsWwnListStructList wlist;
		snsDAListStructList dalist;
	} ns_resp_res_u;
};
typedef struct ns_resp_res ns_resp_res;

struct ns_result {
	int retcode;
	char *status_msg;
	u_long resp_data_sz;
	ns_resp_res ns_response;
};
typedef struct ns_result ns_result;

enum rtrap_cmd_code {
	RTRAP_REGISTER = 0x1000,
	RTRAP_UNREGISTER = 0x1000 + 1,
};
typedef enum rtrap_cmd_code rtrap_cmd_code;

struct rtrap_req_arg {
	rtrap_cmd_code cmd;
	int trap_type;
	int trap_address_type;
	int trap_priority;
	u_int ip_address;
	int ip_port_num;
	u_char wwn[WWN_LEN];
	int ct_command;
	int ct_subcommand;
};
typedef struct rtrap_req_arg rtrap_req_arg;

struct rtrap_resp_res {
	rtrap_cmd_code cmd;
	union {
		int tmp_AIX0;
		int tmp;
	} rtrap_resp_res_u;
};
typedef struct rtrap_resp_res rtrap_resp_res;

struct rtrap_result {
	int retcode;
	char *status_msg;
	u_long resp_data_sz;
	rtrap_resp_res rtrap_response;
};
typedef struct rtrap_result rtrap_result;

enum mps_cmd_code {
	GET_DIGITAL_CERT = 0x000,
	SEC_API_AUTH = 0x001,
	IS_PRIMARY_FCS = 0x002,
	CHG_FCS_PWD = 0x003,
	CHG_NONFCS_PWD = 0x004,
	GET_MPS_ST = 0x100,
	STRT_MPS_CHG = 0x101,
	END_MPS_CHG = 0x102,
	VAL_MPS_CHG = 0x103,
	COM_MPS_CHG = 0x104,
	ABORT_MPS_CHG = 0x105,
	ACT_MPS_CHG = 0x106,
	MPS_VERSION = 0x107,
	CREATE_PLCY = 0x110,
	DEL_PLCY = 0x111,
	ADD_PLCY_MEMB = 0x112,
	RM_PLCY_MEMB = 0x113,
	GET_PLCY_SET = 0x115,
	GET_DB_STATUS = 0x116,
	SET_SNMP_STR = 0x120,
	GET_DIGITAL_CERT2 = 0x125,
	VER_RESET = 0x126,
	GET_FAB_INFO = 0x127,
	SEC_ENABLE = 0x128,
	SEC_DISABLE = 0x129,
	VERIFY_PASS = 0x130,
};
typedef enum mps_cmd_code mps_cmd_code;

enum sec_plcy_type {
	WORKING = 0x0,
	ACTIVE = 0x1,
};
typedef enum sec_plcy_type sec_plcy_type;

struct mps_plcy_t {
	struct {
		u_int name_len;
		char *name_val;
	} name;
	sec_plcy_type plcytype;
	struct {
		u_int plcy_list_len;
		char *plcy_list_val;
	} plcy_list;
};
typedef struct mps_plcy_t mps_plcy_t;

struct api_cert_t {
	pki_cert_t apicert;
	long rand;
};
typedef struct api_cert_t api_cert_t;

struct mps_domain_info {
	char switch_wwn[8];
	u_char is_fcs;
	u_char is_primary;
	u_char is_ready;
	u_char is_busy;
	u_char is_error;
	u_char is_unknown;
	u_char is_noresp;
};
typedef struct mps_domain_info mps_domain_info;

struct mps_fabric_info {
	int active_size;
	int defined_size;
	int max_active_size;
	int max_defined_size;
	struct {
		u_int domain_info_len;
		mps_domain_info *domain_info_val;
	} domain_info;
};
typedef struct mps_fabric_info mps_fabric_info;
#define MAX_SNMP_STR_LEN 64
#define MAX_SNMP_STR 6
#define SNMP_BUF_LEN 384

struct api_snmp_t {
	int num_str;
	char buf[SNMP_BUF_LEN];
};
typedef struct api_snmp_t api_snmp_t;

struct sec_api_auth_t {
	u_char pwd[1024];
	int pwdlen;
};
typedef struct sec_api_auth_t sec_api_auth_t;
#define MAX_STAMP_LEN 128

struct sec_version_stamp_t {
	char stamp[MAX_STAMP_LEN];
};
typedef struct sec_version_stamp_t sec_version_stamp_t;

struct secDbSt_t {
	int lastCmd;
	int cmdReturnCode;
};
typedef struct secDbSt_t secDbSt_t;

struct user_pass_t {
	char *user_pass;
};
typedef struct user_pass_t user_pass_t;

struct mps_sec_enable_t {
	struct {
		u_int user_pass_len;
		user_pass_t *user_pass_val;
	} user_pass;
	char *fcs_list;
	int flags;
};
typedef struct mps_sec_enable_t mps_sec_enable_t;

struct apiPortLogStr {
	struct {
		u_int str_len;
		char *str_val;
	} str;
};
typedef struct apiPortLogStr apiPortLogStr;

struct mps_req_arg {
	mps_cmd_code cmd;
	union {
		sec_api_auth_t pwd_req;
		api_pwd_t chg_pwd_req_AIX0;
		api_pwd_t chg_pwd_req;
		mps_plcy_t plcy_req_AIX0;
		mps_plcy_t plcy_req_AIX1;
		mps_plcy_t plcy_req_AIX2;
		mps_plcy_t plcy_req;
		u_int type;
		api_snmp_t snmp_req;
		mps_sec_enable_t sec_enable_req;
		sec_api_auth_t sec_disable_req;
		user_pass_t verify_pass_req;
	} mps_req_arg_u;
};
typedef struct mps_req_arg mps_req_arg;

struct mps_resp_arg {
	mps_cmd_code cmd;
	union {
		api_cert_t cert_resp_hack;
		api_cert_t cert_resp;
		auth_res auth_resp;
		u_int is_fcs;
		u_int sec_state;
		sec_version_stamp_t sec_version;
		secDbSt_t db_status;
		mps_plcy_t plcy_resp;
		mps_fabric_info mps_fabric_info_resp;
	} mps_resp_arg_u;
};
typedef struct mps_resp_arg mps_resp_arg;

struct mps_result {
	long retcode;
	char *status_msg;
	u_long resp_data_sz;
	mps_resp_arg mps_response;
};
typedef struct mps_result mps_result;

enum diag_cmd_code {
	DIAG_START_PORT = 0x0101,
	DIAG_STOP_PORT = 0x0102,
	DIAG_GET_PORT_PROFILE = 0x0103,
	DIAG_GET_PORT_STATUS = 0x0104,
};
typedef enum diag_cmd_code diag_cmd_code;

struct diag_common_params {
	int config_interval;
	int config_iteration;
	int config_timeout;
};
typedef struct diag_common_params diag_common_params;

struct diag_port_key {
	pwwn_t targetSwitchWwn;
	int targetArea;
};
typedef struct diag_port_key diag_port_key;

enum diag_portDiagPattern {
	PORT_PATTERN_DEFAULT = 0,
	PORT_PATTERN_BYTE_FILL = 1,
	PORT_PATTERN_WORD_FILL = 2,
	PORT_PATTERN_QUAD_FILL = 3,
	PORT_PATTERN_BYTE_NOT = 4,
	PORT_PATTERN_WORD_NOT = 5,
	PORT_PATTERN_QUAD_NOT = 6,
	PORT_PATTERN_BYTE_RAMP = 7,
	PORT_PATTERN_WORD_RAMP = 8,
	PORT_PATTERN_QUAD_RAMP = 9,
	PORT_PATTERN_BYTE_LFSR = 10,
	PORT_PATTERN_RANDOM = 11,
	PORT_PATTERN_CRPAT = 12,
	PORT_PATTERN_CSPAT = 13,
	PORT_PATTERN_CHALF_SQ = 14,
	PORT_PATTERN_CQTR_SQ = 15,
	PORT_PATTERN_RDRAM_PAT = 16,
	PORT_PATTERN_JCRPAT = 17,
	PORT_PATTERN_JCJTPAT = 18,
	PORT_PATTERN_JCSPAT = 19,
	PORT_PATTERN_PORT_DIAG_PATTERN_MAX = 20,
};
typedef enum diag_portDiagPattern diag_portDiagPattern;

struct diag_port_params {
	diag_common_params common_params;
	diag_portDiagPattern pattern;
	u_int patternSize;
	u_int seed;
};
typedef struct diag_port_params diag_port_params;

struct diag_start_port_req {
	diag_port_key key;
	diag_port_params params;
};
typedef struct diag_start_port_req diag_start_port_req;

struct diag_request {
	diag_cmd_code cmd;
	union {
		diag_start_port_req start_port_req;
		diag_port_key port_key_AIX0;
		diag_port_key port_key_AIX1;
		diag_port_key port_key;
	} diag_request_u;
};
typedef struct diag_request diag_request;

struct diag_resp_res {
	diag_cmd_code cmd;
	union {
		char *profile;
		char *status;
	} diag_resp_res_u;
};
typedef struct diag_resp_res diag_resp_res;

struct diag_result {
	long retcode;
	diag_resp_res response;
};
typedef struct diag_result diag_result;

struct arrEnable_t {
	u_int ip;
	u_short port;
};
typedef struct arrEnable_t arrEnable_t;

enum arrEnableOptions {
	ARR_FLAG_KEEPSOCKOPEN = 1,
};
typedef enum arrEnableOptions arrEnableOptions;

struct arrEnable2_t {
	u_int ip;
	u_short port;
	arrEnableOptions options;
};
typedef struct arrEnable2_t arrEnable2_t;

struct arrEnable3_t {
	char ip_address[64];
	u_short port;
	arrEnableOptions options;
};
typedef struct arrEnable3_t arrEnable3_t;

struct _fdmi_attr {
	u_short attrType;
	u_short attrLength;
	struct {
		u_int attrValue_len;
		char *attrValue_val;
	} attrValue;
};
typedef struct _fdmi_attr _fdmi_attr;

struct fdmi_ghat_result {
	struct {
		u_int portName_len;
		pwwn_t *portName_val;
	} portName;
	struct {
		u_int hbaAttr_len;
		_fdmi_attr *hbaAttr_val;
	} hbaAttr;
};
typedef struct fdmi_ghat_result fdmi_ghat_result;

struct fdmi_getallnhba_result {
	struct {
		u_int hbaResult_len;
		fdmi_ghat_result *hbaResult_val;
	} hbaResult;
};
typedef struct fdmi_getallnhba_result fdmi_getallnhba_result;

struct _fdmi_attr_minimum {
	pwwn_t hbaId;
	pwwn_t nodeName;
};
typedef struct _fdmi_attr_minimum _fdmi_attr_minimum;

struct fdmi_getnextnhba_result {
	struct {
		u_int fdmiMin_len;
		_fdmi_attr_minimum *fdmiMin_val;
	} fdmiMin;
};
typedef struct fdmi_getnextnhba_result fdmi_getnextnhba_result;

struct fdmi_getonehba_result {
	fdmi_ghat_result hbaResult;
};
typedef struct fdmi_getonehba_result fdmi_getonehba_result;

struct fdmi_getoneport_result {
	struct {
		u_int portAttr_len;
		_fdmi_attr *portAttr_val;
	} portAttr;
};
typedef struct fdmi_getoneport_result fdmi_getoneport_result;

struct fdmi_getnextnhba_req {
	pwwn_t hbaId;
	u_int numOfEntries;
};
typedef struct fdmi_getnextnhba_req fdmi_getnextnhba_req;

struct fdmi_getonehba_req {
	pwwn_t hbaId;
};
typedef struct fdmi_getonehba_req fdmi_getonehba_req;

struct fdmi_getallnhba_req {
	pwwn_t hbaId;
	u_int numOfEntries;
};
typedef struct fdmi_getallnhba_req fdmi_getallnhba_req;

struct fdmi_getoneport_req {
	pwwn_t hbaId;
	pwwn_t portName;
};
typedef struct fdmi_getoneport_req fdmi_getoneport_req;

enum fdmi_cmd_code {
	FDMI_GETNEXTNHBA = 0x100,
	FDMI_GETONEHBA = 0x101,
	FDMI_GETALLNEXTNHBA = 0x102,
	FDMI_GETONEPORT = 0x103,
};
typedef enum fdmi_cmd_code fdmi_cmd_code;

struct fdmi_request {
	fdmi_cmd_code cmd;
	union {
		fdmi_getnextnhba_req getnextnhba_req;
		fdmi_getonehba_req getonehba_req;
		fdmi_getallnhba_req getallnhba_req;
		fdmi_getoneport_req getoneport_req;
	} fdmi_request_u;
};
typedef struct fdmi_request fdmi_request;

struct fdmi_resp_res {
	fdmi_cmd_code cmd;
	union {
		fdmi_getnextnhba_result getnextnhba_resp;
		fdmi_getonehba_result getonehba_resp;
		fdmi_getallnhba_result getallnhba_resp;
		fdmi_getoneport_result getoneport_resp;
	} fdmi_resp_res_u;
};
typedef struct fdmi_resp_res fdmi_resp_res;

struct fdmi_result {
	long retcode;
	char *status_msg;
	fdmi_resp_res fdmi_resp;
};
typedef struct fdmi_result fdmi_result;

enum log_type_t {
	LOG_TYPE_MIN = -1,
	LOG_TYPE_SW_ERR = -1 + 1,
	LOG_TYPE_SW_PORT = -1 + 2,
	LOG_TYPE_SW_FRU = -1 + 3,
	LOG_TYPE_SW_SUPPORT_SHOW = -1 + 4,
	LOG_TYPE_MAX = -1 + 5,
};
typedef enum log_type_t log_type_t;

struct log_get_req_t {
	pwwn_t target;
	log_type_t logType;
	int port;
	u_long startTs;
	u_long endTs;
	int tranxId;
};
typedef struct log_get_req_t log_get_req_t;

struct log_get_res_t {
	int retcode;
};
typedef struct log_get_res_t log_get_res_t;
#define APM_OHSIZE 64

struct apm_handle_t {
	char data[APM_OHSIZE];
};
typedef struct apm_handle_t apm_handle_t;

typedef u_int apm_pid_t;

typedef c64_t apmuint64_t;

enum apm_objtype_t {
	APM_OBJTYPE_MIN = 0,
	APM_OBJTYPE_DIR = 1,
	APM_EEMON_STATIC = 10,
	APM_EEMON_DYNAMIC = 11,
	APM_FLTMON = 12,
	APM_OBJTYPE_ANY = 999,
	APM_OBJTYPE_MAX = 1000,
};
typedef enum apm_objtype_t apm_objtype_t;

enum apm_flttype_t {
	APM_FLT_INVTYP = 0,
	APM_FLT_SCSIREAD = 10,
	APM_FLT_SCSIWRITE = 11,
	APM_FLT_SCSIRDWR = 12,
	APM_FLT_SCSI = 13,
	APM_FLT_IP = 14,
	APM_FLT_RAW = 15,
	APM_FLT_TYPMAX = 1000,
};
typedef enum apm_flttype_t apm_flttype_t;

enum apm_apmc_t {
	APM_APMC_MIN = -1,
	APM_APMC_STA_EE = -1 + 1,
	APM_APMC_DYN_EE = -1 + 2,
	APM_APMC_FLT = -1 + 3,
	APM_APMC_MAX = -1 + 4,
};
typedef enum apm_apmc_t apm_apmc_t;

enum apm_dpmh_t {
	APM_DPMH_MIN = -1,
	APM_DPMH_DEL = 1,
	APM_DPMH_RESET = 2,
	APM_DPMH_MAX = 10,
};
typedef enum apm_dpmh_t apm_dpmh_t;

enum apm_err_enum_t {
	APM_ERR_MIN = -1,
	APM_ERR_NO_LICENSE = -1 + 1,
	APM_ERR_INVALID_PARM = -1 + 2,
	APM_ERR_PSD_CALL_FAIL = -1 + 3,
	APM_ERR_MAX = -1 + 4,
};
typedef enum apm_err_enum_t apm_err_enum_t;

struct apm_eemon_static_t {
	apm_handle_t handle;
	apm_pid_t e_sid;
	apm_pid_t e_did;
	u_char e_state;
	u_char e_rsvd[3];
	apmuint64_t e_trans;
	apmuint64_t e_recv;
	apmuint64_t e_crcerr;
	apmuint64_t e_transrate;
	apmuint64_t e_recvrate;
};
typedef struct apm_eemon_static_t apm_eemon_static_t;

struct apm_eemon_dynamic_t {
	apm_handle_t handle;
	pwwn_t e_srcwwn;
	pwwn_t e_dstwwn;
	u_char e_state;
	u_char e_rsvd[3];
	apmuint64_t e_trans;
	apmuint64_t e_recv;
	apmuint64_t e_crcerr;
	apmuint64_t e_transrate;
	apmuint64_t e_recvrate;
};
typedef struct apm_eemon_dynamic_t apm_eemon_dynamic_t;

struct apm_fltmon_t {
	apm_handle_t handle;
	pwwn_t f_srcwwn;
	u_int f_port;
	u_char f_state;
	u_char f_rsvd[3];
	apm_flttype_t f_type;
	struct {
		u_int f_string_len;
		char *f_string_val;
	} f_string;
	apmuint64_t f_frcount;
	apmuint64_t f_frrate;
};
typedef struct apm_fltmon_t apm_fltmon_t;

struct apm_new_entry_t {
	apm_objtype_t obj_type;
	int op_flags;
	apm_pid_t spid;
	apm_pid_t dpid;
	pwwn_t swwn;
	pwwn_t dwwn;
	int domain;
	int port;
	apm_flttype_t flt_type;
	struct {
		u_int filter_len;
		char *filter_val;
	} filter;
};
typedef struct apm_new_entry_t apm_new_entry_t;

struct apm_gpmc_byhandle_req_t {
	struct {
		u_int handle_list_len;
		apm_handle_t *handle_list_val;
	} handle_list;
};
typedef struct apm_gpmc_byhandle_req_t apm_gpmc_byhandle_req_t;

struct apm_gpmc_see_res_t {
	int retcode;
	struct {
		u_int result_list_len;
		int *result_list_val;
	} result_list;
	struct {
		u_int content_list_len;
		apm_eemon_static_t *content_list_val;
	} content_list;
	u_int startTs;
	u_int endTs;
};
typedef struct apm_gpmc_see_res_t apm_gpmc_see_res_t;

struct apm_gpmc_dee_res_t {
	int retcode;
	struct {
		u_int result_list_len;
		int *result_list_val;
	} result_list;
	struct {
		u_int content_list_len;
		apm_eemon_dynamic_t *content_list_val;
	} content_list;
	u_int startTs;
	u_int endTs;
};
typedef struct apm_gpmc_dee_res_t apm_gpmc_dee_res_t;

struct apm_gpmc_ff_res_t {
	int retcode;
	struct {
		u_int result_list_len;
		int *result_list_val;
	} result_list;
	struct {
		u_int content_list_len;
		apm_fltmon_t *content_list_val;
	} content_list;
	u_int startTs;
	u_int endTs;
};
typedef struct apm_gpmc_ff_res_t apm_gpmc_ff_res_t;

struct apm_gpmc_generic_res_t {
	int retcode;
};
typedef struct apm_gpmc_generic_res_t apm_gpmc_generic_res_t;

struct apm_gpmc_bytype_req_t {
	apm_objtype_t obj_type;
};
typedef struct apm_gpmc_bytype_req_t apm_gpmc_bytype_req_t;

struct apm_gpmc_bytype_res_t {
	apm_objtype_t apmType;
	union {
		apm_gpmc_see_res_t see_res;
		apm_gpmc_dee_res_t dee_res;
		apm_gpmc_ff_res_t ff_res;
		apm_gpmc_generic_res_t min_res_AIX0;
		apm_gpmc_generic_res_t min_res_AIX1;
		apm_gpmc_generic_res_t min_res;
	} apm_gpmc_bytype_res_t_u;
};
typedef struct apm_gpmc_bytype_res_t apm_gpmc_bytype_res_t;

struct apm_apmc_req_t {
	struct {
		u_int entry_list_len;
		apm_new_entry_t *entry_list_val;
	} entry_list;
};
typedef struct apm_apmc_req_t apm_apmc_req_t;

struct apm_apmc_res_t {
	int retcode;
	struct {
		u_int result_list_len;
		int *result_list_val;
	} result_list;
	struct {
		u_int handle_list_len;
		apm_handle_t *handle_list_val;
	} handle_list;
	u_int startTs;
	u_int endTs;
};
typedef struct apm_apmc_res_t apm_apmc_res_t;

struct apm_dpmh_req_t {
	int op_code;
	struct {
		u_int handle_list_len;
		apm_handle_t *handle_list_val;
	} handle_list;
};
typedef struct apm_dpmh_req_t apm_dpmh_req_t;

struct apm_dpmh_res_t {
	int retcode;
	struct {
		u_int result_list_len;
		int *result_list_val;
	} result_list;
	u_int startTs;
	u_int endTs;
};
typedef struct apm_dpmh_res_t apm_dpmh_res_t;

struct apm_domctr_t {
	pwwn_t isl_dest_switch;
	apmuint64_t isl_dest_words;
};
typedef struct apm_domctr_t apm_domctr_t;

struct apm_gpm_isl_entry_t {
	apm_handle_t isl_handle;
	u_int isl_port;
	pwwn_t isl_switch;
	u_short isl_nlinks;
	u_short isl_flags;
	u_short isl_samplefactor;
	u_long isl_creationtime;
	apmuint64_t isl_words;
	struct {
		u_int isl_dom_counter_list_len;
		apm_domctr_t *isl_dom_counter_list_val;
	} isl_dom_counter_list;
};
typedef struct apm_gpm_isl_entry_t apm_gpm_isl_entry_t;

struct apm_gpm_isl_res_t {
	int retcode;
	char *status_msg;
	struct {
		u_int isl_list_len;
		apm_gpm_isl_entry_t *isl_list_val;
	} isl_list;
};
typedef struct apm_gpm_isl_res_t apm_gpm_isl_res_t;

enum apm_isl_set_type_t {
	ISL_MONITOR_MODE = 0,
	ISL_MONITOR_RESET_COUNTER = 1,
	ISL_MONITOR_RESET_ALLCOUNTER = 2,
};
typedef enum apm_isl_set_type_t apm_isl_set_type_t;

enum apm_isl_mode_type_t {
	ISL_MONITOR_ENABLE = 0x100,
	ISL_MONITOR_DISABLE = 0x200,
};
typedef enum apm_isl_mode_type_t apm_isl_mode_type_t;

struct apm_isl_mode_t {
	pwwn_t switch_wwn;
	apm_isl_mode_type_t mode;
};
typedef struct apm_isl_mode_t apm_isl_mode_t;

struct apm_isl_set_t {
	apm_isl_set_type_t cmd;
	union {
		apm_isl_mode_t monitor_mode;
		apm_handle_t handle1;
	} apm_isl_set_t_u;
};
typedef struct apm_isl_set_t apm_isl_set_t;

struct apm_isl_set_res_t {
	int retcode;
	char *status_msg;
};
typedef struct apm_isl_set_res_t apm_isl_set_res_t;

struct ie_entry {
	char wwn[8];
	u_long type;
	u_int domain;
	char ip[20];
	char firmwareVersion[4];
};
typedef struct ie_entry ie_entry;

struct ie_list_result {
	long retcode;
	char *status_msg;
	u_char secSanEnabled;
	struct {
		u_int ieList_len;
		ie_entry *ieList_val;
	} ieList;
};
typedef struct ie_list_result ie_list_result;

struct cfg_size_result {
	long retcode;
	char *status_msg;
	int cfg_size;
	int max_size;
};
typedef struct cfg_size_result cfg_size_result;

enum ficon_cmd {
	GET_FICON_FEATURE = 0,
	SET_FICON_FEATURE = 1,
};
typedef enum ficon_cmd ficon_cmd;

struct ficon_feature_req_t {
	ficon_cmd cmd;
	char wwn[8];
	u_int mode;
};
typedef struct ficon_feature_req_t ficon_feature_req_t;

struct ficon_feature_result_t {
	long retcode;
	char *status_msg;
	u_int mode;
	u_int capable;
};
typedef struct ficon_feature_result_t ficon_feature_result_t;

enum ficon_cmd_scope {
	FICON_FABRIC = 0,
	FICON_SWITCH = 0 + 1,
	FICON_PORT = 0 + 2,
};
typedef enum ficon_cmd_scope ficon_cmd_scope;

struct ficon_req_t {
	ficon_cmd_scope scope;
	char wwn[8];
	int index;
};
typedef struct ficon_req_t ficon_req_t;

struct swapped_port_t {
	int area;
	int port;
	int slot;
	int slotport;
};
typedef struct swapped_port_t swapped_port_t;

struct swapped_port_result_t {
	long retcode;
	char *status_msg;
	struct {
		u_int swappedPortList_len;
		swapped_port_t *swappedPortList_val;
	} swappedPortList;
};
typedef struct swapped_port_result_t swapped_port_result_t;

struct rnid_entry_t {
	int index;
	pwwn_t i_port_wwn;
	pwwn_t i_node_wwn;
	pwwn_t c_port_wwn;
	pwwn_t c_node_wwn;
	u_int incidentPid;
	u_int options;
	char protocol;
	char stClass;
	char port;
	char flag;
	char type[6];
	char model[3];
	char manufacture[3];
	char manufacturePlant[2];
	char sequence[12];
	char tag[2];
};
typedef struct rnid_entry_t rnid_entry_t;

struct rnid_switch_list_t {
	char switchWwn[8];
	struct {
		u_int entryList_len;
		rnid_entry_t *entryList_val;
	} entryList;
};
typedef struct rnid_switch_list_t rnid_switch_list_t;

struct api_rnid_list_t {
	struct {
		u_int switchList_len;
		rnid_switch_list_t *switchList_val;
	} switchList;
};
typedef struct api_rnid_list_t api_rnid_list_t;

struct rnid_result_t {
	long retcode;
	char *status_msg;
	api_rnid_list_t rnidList;
};
typedef struct rnid_result_t rnid_result_t;

struct api_switch_rnid_entry_t {
	int switch_rnid_index;
	char switchWwn[8];
	char nid_flags;
	char node_parameters[3];
	char type_number[6];
	char model_number[3];
	char manufacture[3];
	char plant_of_manufacture[2];
	char sequence_number[12];
	char tag[2];
};
typedef struct api_switch_rnid_entry_t api_switch_rnid_entry_t;

struct api_switch_rnid_t {
	char switchWwn[8];
	struct {
		u_int switchRnidEntryList_len;
		api_switch_rnid_entry_t *switchRnidEntryList_val;
	} switchRnidEntryList;
};
typedef struct api_switch_rnid_t api_switch_rnid_t;

struct switch_rnid_result_t {
	long retcode;
	char *status_msg;
	struct {
		u_int switchRnidList_len;
		api_switch_rnid_t *switchRnidList_val;
	} switchRnidList;
};
typedef struct switch_rnid_result_t switch_rnid_result_t;

struct lirr_entry_t {
	int index;
	pwwn_t i_port_wwn;
	pwwn_t c_port_wwn;
	u_long portId;
	u_char portType;
	u_int options;
};
typedef struct lirr_entry_t lirr_entry_t;

struct lirr_switch_list_t {
	char switchWwn[8];
	struct {
		u_int entryList_len;
		lirr_entry_t *entryList_val;
	} entryList;
};
typedef struct lirr_switch_list_t lirr_switch_list_t;

struct api_lirr_list_t {
	struct {
		u_int switchList_len;
		lirr_switch_list_t *switchList_val;
	} switchList;
};
typedef struct api_lirr_list_t api_lirr_list_t;

struct lirr_result_t {
	long retcode;
	char *status_msg;
	api_lirr_list_t lirrList;
};
typedef struct lirr_result_t lirr_result_t;

struct rlir_entry_t {
	pwwn_t i_port_wwn;
	pwwn_t c_port_wwn;
	char format;
	char link_failure_type;
	u_int i_vspp_port;
	u_int transaction_ID;
	u_int ts_format;
	u_int ts_sec;
	u_int ts_msec;
};
typedef struct rlir_entry_t rlir_entry_t;

struct rlir_switch_list_t {
	char switchWwn[8];
	struct {
		u_int entryList_len;
		rlir_entry_t *entryList_val;
	} entryList;
};
typedef struct rlir_switch_list_t rlir_switch_list_t;

struct api_rlir_list_t {
	struct {
		u_int switchList_len;
		rlir_switch_list_t *switchList_val;
	} switchList;
};
typedef struct api_rlir_list_t api_rlir_list_t;

struct rlir_result_t {
	long retcode;
	char *status_msg;
	api_rlir_list_t rlirList;
};
typedef struct rlir_result_t rlir_result_t;

struct route_info_result_t {
	long retcode;
	char *status_msg;
	int numOfEntries;
	struct {
		u_int routeInfo_len;
		char *routeInfo_val;
	} routeInfo;
};
typedef struct route_info_result_t route_info_result_t;

struct fabric_stability_result_t {
	long retcode;
	char *status_msg;
	int isReconfiguring;
	int isUnstable;
	int addressKnown;
};
typedef struct fabric_stability_result_t fabric_stability_result_t;
#define HBA_MGMT_MAX_FIELD 256
#define HBA_MGMT_MAX_PACKET 61440

enum hba_mgmt_code {
	HBA_MGMT_GENERIC = 0x1,
	HBA_MGMT_VERIFY_FIRM = 0x122,
	HBA_MGMT_LOAD_FIRM = 0x123,
	HBA_MGMT_SSR = 0x133,
};
typedef enum hba_mgmt_code hba_mgmt_code;

enum hba_mgmt_flags {
	HBA_MGMT_SRD_FLAG = 0x1,
	HBA_MGMT_LAST_FRAG_FLAG = 0x2,
	HBA_MGMT_RESET_FLAG = 0x4,
};
typedef enum hba_mgmt_flags hba_mgmt_flags;

struct hba_resource_t {
	int cmd;
	pwwn_t targetHBA;
	u_int flags;
	int seq;
	struct {
		u_int resource_len;
		char *resource_val;
	} resource;
	char *filename;
};
typedef struct hba_resource_t hba_resource_t;

struct hba_mgmt_req_t {
	hba_mgmt_code cmd;
	union {
		hba_resource_t req;
		hba_resource_t ver_req;
		hba_resource_t load_req;
		hba_resource_t image;
	} hba_mgmt_req_t_u;
};
typedef struct hba_mgmt_req_t hba_mgmt_req_t;

struct hba_mgmt_resp_t {
	hba_mgmt_code cmd;
	union {
		int status;
	} hba_mgmt_resp_t_u;
};
typedef struct hba_mgmt_resp_t hba_mgmt_resp_t;

struct hba_mgmt_result {
	long retcode;
	char *status_msg;
	u_long resp_data_sz;
	hba_mgmt_resp_t response;
};
typedef struct hba_mgmt_result hba_mgmt_result;

struct GIF_t {
	long retcode;
	struct {
		u_int GIFBuf_len;
		u_char *GIFBuf_val;
	} GIFBuf;
	int GIFWidth;
	int GIFHeight;
};
typedef struct GIF_t GIF_t;

struct dhchap_secret_t {
	long retcode;
	char *secret;
};
typedef struct dhchap_secret_t dhchap_secret_t;

struct dhchap_secret_req_t {
	char reserved[8];
	int reserved2;
};
typedef struct dhchap_secret_req_t dhchap_secret_req_t;


#ifdef __cplusplus
extern "C" {
#endif

#include <rpc/xdr.h>

#ifdef __cplusplus
}
#endif

#define RAPIPROG 1289700000
#define RAPIVERS_1 1

#if defined(__STDC__) || defined(__cplusplus)
#define RAUTHENTICATE 1
extern  auth_res * rauthenticate_1(char **, CLIENT *);
extern  auth_res * rauthenticate_1_svc(char **, struct svc_req *);
#define RFABRIC_NAME 2
extern  u_char * rfabric_name_1(void *, CLIENT *);
extern  u_char * rfabric_name_1_svc(void *, struct svc_req *);
#define RSWITCH_NAME 3
extern  u_char * rswitch_name_1(void *, CLIENT *);
extern  u_char * rswitch_name_1_svc(void *, struct svc_req *);
#define RSWITCH_SFVERSION 4
extern  sfversion_res * rswitch_sfversion_1(u_char *, CLIENT *);
extern  sfversion_res * rswitch_sfversion_1_svc(u_char *, struct svc_req *);
#define RAUTHENTICATE2 5
extern  auth_res2 * rauthenticate2_1(char **, CLIENT *);
extern  auth_res2 * rauthenticate2_1_svc(char **, struct svc_req *);
#define RPASSWORD_CHALLENGE 6
extern  auth_res2 * rpassword_challenge_1(char **, CLIENT *);
extern  auth_res2 * rpassword_challenge_1_svc(char **, struct svc_req *);
#define RAD_LOGIN 7
extern  auth_res3 * rad_login_1(char **, CLIENT *);
extern  auth_res3 * rad_login_1_svc(char **, struct svc_req *);
#define RGROUP_CREATE 10
extern  rapi_res * rgroup_create_1(rgroup_info *, CLIENT *);
extern  rapi_res * rgroup_create_1_svc(rgroup_info *, struct svc_req *);
#define RGROUP_ADD 11
extern  rapi_res * rgroup_add_1(rgroup_info *, CLIENT *);
extern  rapi_res * rgroup_add_1_svc(rgroup_info *, struct svc_req *);
#define RGROUP_REMOVE 12
extern  rapi_res * rgroup_remove_1(rgroup_info *, CLIENT *);
extern  rapi_res * rgroup_remove_1_svc(rgroup_info *, struct svc_req *);
#define RGROUP_DELETE 13
extern  rapi_res * rgroup_delete_1(rgroup_info *, CLIENT *);
extern  rapi_res * rgroup_delete_1_svc(rgroup_info *, struct svc_req *);
#define RGROUP_EXISTS 14
extern  rapi_res * rgroup_exists_1(rgroup_info *, CLIENT *);
extern  rapi_res * rgroup_exists_1_svc(rgroup_info *, struct svc_req *);
#define RGROUP_LIST 15
extern  rapi_listret * rgroup_list_1(int *, CLIENT *);
extern  rapi_listret * rgroup_list_1_svc(int *, struct svc_req *);
#define RGROUP_LIST_MEMBERS 16
extern  rapi_listret * rgroup_list_members_1(rgroup_info *, CLIENT *);
extern  rapi_listret * rgroup_list_members_1_svc(rgroup_info *, struct svc_req *);
#define RCFG_ENABLE 17
extern  rapi_res * rcfg_enable_1(char **, CLIENT *);
extern  rapi_res * rcfg_enable_1_svc(char **, struct svc_req *);
#define RCFG_DISABLE 18
extern  rapi_res * rcfg_disable_1(void *, CLIENT *);
extern  rapi_res * rcfg_disable_1_svc(void *, struct svc_req *);
#define RCFG_CLEAR 19
extern  rapi_res * rcfg_clear_1(void *, CLIENT *);
extern  rapi_res * rcfg_clear_1_svc(void *, struct svc_req *);
#define RGROUP_TYPE 20
extern  zobj_type_ret * rgroup_type_1(char **, CLIENT *);
extern  zobj_type_ret * rgroup_type_1_svc(char **, struct svc_req *);
#define RGETCURRENT_CFG 21
extern  EnCfg_Name_ret * rgetcurrent_cfg_1(void *, CLIENT *);
extern  EnCfg_Name_ret * rgetcurrent_cfg_1_svc(void *, struct svc_req *);
#define RCFG_SAVE 22
extern  rapi_res * rcfg_save_1(void *, CLIENT *);
extern  rapi_res * rcfg_save_1_svc(void *, struct svc_req *);
#define RGROUP_TRANS_START 23
extern  rapi_res * rgroup_trans_start_1(void *, CLIENT *);
extern  rapi_res * rgroup_trans_start_1_svc(void *, struct svc_req *);
#define RGROUP_TRANS_COMMIT 24
extern  rapi_res * rgroup_trans_commit_1(void *, CLIENT *);
extern  rapi_res * rgroup_trans_commit_1_svc(void *, struct svc_req *);
#define RGROUP_TRANS_END 25
extern  rapi_res * rgroup_trans_end_1(void *, CLIENT *);
extern  rapi_res * rgroup_trans_end_1_svc(void *, struct svc_req *);
#define RGROUP_TRANS_VALIDATE 26
extern  zobj_validate_ret * rgroup_trans_validate_1(void *, CLIENT *);
extern  zobj_validate_ret * rgroup_trans_validate_1_svc(void *, struct svc_req *);
#define RGETCURRENT_CFG_CONT 27
extern  EnCfg_Name_ret * rgetcurrent_cfg_cont_1(void *, CLIENT *);
extern  EnCfg_Name_ret * rgetcurrent_cfg_cont_1_svc(void *, struct svc_req *);
#define RZONE_INFO 28
extern  zone_info_rep * rzone_info_1(zone_info_req *, CLIENT *);
extern  zone_info_rep * rzone_info_1_svc(zone_info_req *, struct svc_req *);
#define RGROUP_ACTIVE_TYPE 29
extern  zobj_type_ret * rgroup_active_type_1(char **, CLIENT *);
extern  zobj_type_ret * rgroup_active_type_1_svc(char **, struct svc_req *);
#define RGROUP_CREATE_NOLIMIT 30
extern  rapi_res * rgroup_create_nolimit_1(rgroup_info_nolimit *, CLIENT *);
extern  rapi_res * rgroup_create_nolimit_1_svc(rgroup_info_nolimit *, struct svc_req *);
#define RGROUP_ADD_NOLIMIT 31
extern  rapi_res * rgroup_add_nolimit_1(rgroup_info_nolimit *, CLIENT *);
extern  rapi_res * rgroup_add_nolimit_1_svc(rgroup_info_nolimit *, struct svc_req *);
#define RGROUP_REMOVE_NOLIMIT 32
extern  rapi_res * rgroup_remove_nolimit_1(rgroup_info_nolimit *, CLIENT *);
extern  rapi_res * rgroup_remove_nolimit_1_svc(rgroup_info_nolimit *, struct svc_req *);
#define RGROUP_DELETE_NOLIMIT 33
extern  rapi_res * rgroup_delete_nolimit_1(rgroup_info_nolimit *, CLIENT *);
extern  rapi_res * rgroup_delete_nolimit_1_svc(rgroup_info_nolimit *, struct svc_req *);
#define RGROUP_EXISTS_NOLIMIT 34
extern  rapi_res * rgroup_exists_nolimit_1(rgroup_info_nolimit *, CLIENT *);
extern  rapi_res * rgroup_exists_nolimit_1_svc(rgroup_info_nolimit *, struct svc_req *);
#define RGROUP_LIST_MEMBERS_NOLIMIT 35
extern  rapi_listret * rgroup_list_members_nolimit_1(rgroup_info_nolimit *, CLIENT *);
extern  rapi_listret * rgroup_list_members_nolimit_1_svc(rgroup_info_nolimit *, struct svc_req *);
#define RCFG_SIZE 36
extern  cfg_size_result * rcfg_size_1(void *, CLIENT *);
extern  cfg_size_result * rcfg_size_1_svc(void *, struct svc_req *);
#define RGET_ZONEDB_DUMP 37
extern  zonedb_dump_ret * rget_zonedb_dump_1(void *, CLIENT *);
extern  zonedb_dump_ret * rget_zonedb_dump_1_svc(void *, struct svc_req *);
#define RGET_ZONEDB_CHECKSUM 38
extern  zonedb_checksum_ret * rget_zonedb_checksum_1(int *, CLIENT *);
extern  zonedb_checksum_ret * rget_zonedb_checksum_1_svc(int *, struct svc_req *);
#define RMGMT_SVR_REQUEST 40
extern  ms_result * rmgmt_svr_request_1(ms_req_arg *, CLIENT *);
extern  ms_result * rmgmt_svr_request_1_svc(ms_req_arg *, struct svc_req *);
#define RMGMT_SVR_REQUEST2 41
extern  ms2_result * rmgmt_svr_request2_1(ms2_req_arg *, CLIENT *);
extern  ms2_result * rmgmt_svr_request2_1_svc(ms2_req_arg *, struct svc_req *);
#define RCAL_REQUEST 42
extern  cal_result * rcal_request_1(cal_request *, CLIENT *);
extern  cal_result * rcal_request_1_svc(cal_request *, struct svc_req *);
#define RGROUP_EXPUNGE 43
extern  rapi_res * rgroup_expunge_1(rgroup_info_nolimit *, CLIENT *);
extern  rapi_res * rgroup_expunge_1_svc(rgroup_info_nolimit *, struct svc_req *);
#define RGET_ZONEDB_TRANS_DUMP 44
extern  zonedb_dump_ret * rget_zonedb_trans_dump_1(void *, CLIENT *);
extern  zonedb_dump_ret * rget_zonedb_trans_dump_1_svc(void *, struct svc_req *);
#define RGET_CFG_TRANS_SHOW 45
extern  zone_trans_owner * rget_cfg_trans_show_1(void *, CLIENT *);
extern  zone_trans_owner * rget_cfg_trans_show_1_svc(void *, struct svc_req *);
#define RGROUP_CP_REN 46
extern  rapi_res * rgroup_cp_ren_1(rgroup_copy_t *, CLIENT *);
extern  rapi_res * rgroup_cp_ren_1_svc(rgroup_copy_t *, struct svc_req *);
#define RCFGLOAD 47
extern  rapi_res * rcfgload_1(rcfg_load_t *, CLIENT *);
extern  rapi_res * rcfgload_1_svc(rcfg_load_t *, struct svc_req *);
#define RZONE_ASYNC 48
extern  rapi_res * rzone_async_1(rzone_asynch_t *, CLIENT *);
extern  rapi_res * rzone_async_1_svc(rzone_asynch_t *, struct svc_req *);
#define NS_SVR_REQUEST 60
extern  ns_result * ns_svr_request_1(ns_req_arg *, CLIENT *);
extern  ns_result * ns_svr_request_1_svc(ns_req_arg *, struct svc_req *);
#define APM_GPMC_SEE 80
extern  apm_gpmc_see_res_t * apm_gpmc_see_1(apm_gpmc_byhandle_req_t *, CLIENT *);
extern  apm_gpmc_see_res_t * apm_gpmc_see_1_svc(apm_gpmc_byhandle_req_t *, struct svc_req *);
#define APM_GPMC_DEE 81
extern  apm_gpmc_dee_res_t * apm_gpmc_dee_1(apm_gpmc_byhandle_req_t *, CLIENT *);
extern  apm_gpmc_dee_res_t * apm_gpmc_dee_1_svc(apm_gpmc_byhandle_req_t *, struct svc_req *);
#define APM_GPMC_FF 82
extern  apm_gpmc_ff_res_t * apm_gpmc_ff_1(apm_gpmc_byhandle_req_t *, CLIENT *);
extern  apm_gpmc_ff_res_t * apm_gpmc_ff_1_svc(apm_gpmc_byhandle_req_t *, struct svc_req *);
#define APM_GPMC_BYTYPE 83
extern  apm_gpmc_bytype_res_t * apm_gpmc_bytype_1(apm_gpmc_bytype_req_t *, CLIENT *);
extern  apm_gpmc_bytype_res_t * apm_gpmc_bytype_1_svc(apm_gpmc_bytype_req_t *, struct svc_req *);
#define APM_APMC 84
extern  apm_apmc_res_t * apm_apmc_1(apm_apmc_req_t *, CLIENT *);
extern  apm_apmc_res_t * apm_apmc_1_svc(apm_apmc_req_t *, struct svc_req *);
#define APM_DPMH 85
extern  apm_dpmh_res_t * apm_dpmh_1(apm_dpmh_req_t *, CLIENT *);
extern  apm_dpmh_res_t * apm_dpmh_1_svc(apm_dpmh_req_t *, struct svc_req *);
#define APM_GET_ISL 86
extern  apm_gpm_isl_res_t * apm_get_isl_1(void *, CLIENT *);
extern  apm_gpm_isl_res_t * apm_get_isl_1_svc(void *, struct svc_req *);
#define APM_SET_ISL 87
extern  apm_isl_set_res_t * apm_set_isl_1(apm_isl_set_t *, CLIENT *);
extern  apm_isl_set_res_t * apm_set_isl_1_svc(apm_isl_set_t *, struct svc_req *);
#define LOG_GET 90
extern  log_get_res_t * log_get_1(log_get_req_t *, CLIENT *);
extern  log_get_res_t * log_get_1_svc(log_get_req_t *, struct svc_req *);
#define RTRAP_SVR_REQUEST 100
extern  rtrap_result * rtrap_svr_request_1(rtrap_req_arg *, CLIENT *);
extern  rtrap_result * rtrap_svr_request_1_svc(rtrap_req_arg *, struct svc_req *);
#define REVNT_SVR_CREATE 120
extern  rapi_res * revnt_svr_create_1(socketAddrStruct *, CLIENT *);
extern  rapi_res * revnt_svr_create_1_svc(socketAddrStruct *, struct svc_req *);
#define REVNT_SVR_DELETE 121
extern  rapi_res * revnt_svr_delete_1(socketAddrStruct *, CLIENT *);
extern  rapi_res * revnt_svr_delete_1_svc(socketAddrStruct *, struct svc_req *);
#define REVNT_SVR_CREATE2 122
extern  rapi_res * revnt_svr_create2_1(socketAddrStruct2 *, CLIENT *);
extern  rapi_res * revnt_svr_create2_1_svc(socketAddrStruct2 *, struct svc_req *);
#define REVNT_SVR_DELETE2 123
extern  rapi_res * revnt_svr_delete2_1(socketAddrStruct2 *, CLIENT *);
extern  rapi_res * revnt_svr_delete2_1_svc(socketAddrStruct2 *, struct svc_req *);
#define RMPS_SVR_REQUEST 125
extern  mps_result * rmps_svr_request_1(mps_req_arg *, CLIENT *);
extern  mps_result * rmps_svr_request_1_svc(mps_req_arg *, struct svc_req *);
#define RAUTHENTICATESEC 126
extern  mps_result * rauthenticatesec_1(mps_req_arg *, CLIENT *);
extern  mps_result * rauthenticatesec_1_svc(mps_req_arg *, struct svc_req *);
#define RPLATSETINFO 127
extern  ms_result * rplatsetinfo_1(ms_splatinfo_req *, CLIENT *);
extern  ms_result * rplatsetinfo_1_svc(ms_splatinfo_req *, struct svc_req *);
#define RENABLE_ARR 151
extern  int * renable_arr_1(arrEnable_t *, CLIENT *);
extern  int * renable_arr_1_svc(arrEnable_t *, struct svc_req *);
#define RENABLE_ARR2 152
extern  int * renable_arr2_1(arrEnable2_t *, CLIENT *);
extern  int * renable_arr2_1_svc(arrEnable2_t *, struct svc_req *);
#define RENABLE_ARR3 153
extern  int * renable_arr3_1(arrEnable3_t *, CLIENT *);
extern  int * renable_arr3_1_svc(arrEnable3_t *, struct svc_req *);
#define RFDMIINFO 128
extern  fdmi_result * rfdmiinfo_1(fdmi_request *, CLIENT *);
extern  fdmi_result * rfdmiinfo_1_svc(fdmi_request *, struct svc_req *);
#define DIAG_SVC_REQUEST 150
extern  diag_result * diag_svc_request_1(diag_request *, CLIENT *);
extern  diag_result * diag_svc_request_1_svc(diag_request *, struct svc_req *);
#define IE_LIST 160
extern  ie_list_result * ie_list_1(void *, CLIENT *);
extern  ie_list_result * ie_list_1_svc(void *, struct svc_req *);
#define ROUTE_INFO 161
extern  route_info_result_t * route_info_1(void *, CLIENT *);
extern  route_info_result_t * route_info_1_svc(void *, struct svc_req *);
#define FABRIC_STABILITY 165
extern  fabric_stability_result_t * fabric_stability_1(void *, CLIENT *);
extern  fabric_stability_result_t * fabric_stability_1_svc(void *, struct svc_req *);
#define FICON_RNID_INFO 170
extern  rnid_result_t * ficon_rnid_info_1(ficon_req_t *, CLIENT *);
extern  rnid_result_t * ficon_rnid_info_1_svc(ficon_req_t *, struct svc_req *);
#define FICON_LIRR_INFO 171
extern  lirr_result_t * ficon_lirr_info_1(ficon_req_t *, CLIENT *);
extern  lirr_result_t * ficon_lirr_info_1_svc(ficon_req_t *, struct svc_req *);
#define FICON_RLIR_INFO 172
extern  rlir_result_t * ficon_rlir_info_1(ficon_req_t *, CLIENT *);
extern  rlir_result_t * ficon_rlir_info_1_svc(ficon_req_t *, struct svc_req *);
#define FICON_FEATURE_INFO 173
extern  ficon_feature_result_t * ficon_feature_info_1(ficon_feature_req_t *, CLIENT *);
extern  ficon_feature_result_t * ficon_feature_info_1_svc(ficon_feature_req_t *, struct svc_req *);
#define FICON_SWITCH_RNID_INFO 174
extern  switch_rnid_result_t * ficon_switch_rnid_info_1(ficon_req_t *, CLIENT *);
extern  switch_rnid_result_t * ficon_switch_rnid_info_1_svc(ficon_req_t *, struct svc_req *);
#define FICON_PORT_SWAP_INFO 175
extern  swapped_port_result_t * ficon_port_swap_info_1(ficon_req_t *, CLIENT *);
extern  swapped_port_result_t * ficon_port_swap_info_1_svc(ficon_req_t *, struct svc_req *);
#define HBA_MGMT 200
extern  hba_mgmt_result * hba_mgmt_1(hba_mgmt_req_t *, CLIENT *);
extern  hba_mgmt_result * hba_mgmt_1_svc(hba_mgmt_req_t *, struct svc_req *);
#define GET_SWITCHGIF 201
extern  GIF_t * get_switchgif_1(void *, CLIENT *);
extern  GIF_t * get_switchgif_1_svc(void *, struct svc_req *);
#define GET_DHCHAP_SECRET 202
extern  dhchap_secret_t * get_dhchap_secret_1(dhchap_secret_req_t *, CLIENT *);
extern  dhchap_secret_t * get_dhchap_secret_1_svc(dhchap_secret_req_t *, struct svc_req *);
extern int rapiprog_1_freeresult (SVCXPRT *, xdrproc_t, caddr_t);

#else /* K&R C */
#define RAUTHENTICATE 1
extern  auth_res * rauthenticate_1();
extern  auth_res * rauthenticate_1_svc();
#define RFABRIC_NAME 2
extern  u_char * rfabric_name_1();
extern  u_char * rfabric_name_1_svc();
#define RSWITCH_NAME 3
extern  u_char * rswitch_name_1();
extern  u_char * rswitch_name_1_svc();
#define RSWITCH_SFVERSION 4
extern  sfversion_res * rswitch_sfversion_1();
extern  sfversion_res * rswitch_sfversion_1_svc();
#define RAUTHENTICATE2 5
extern  auth_res2 * rauthenticate2_1();
extern  auth_res2 * rauthenticate2_1_svc();
#define RPASSWORD_CHALLENGE 6
extern  auth_res2 * rpassword_challenge_1();
extern  auth_res2 * rpassword_challenge_1_svc();
#define RAD_LOGIN 7
extern  auth_res3 * rad_login_1();
extern  auth_res3 * rad_login_1_svc();
#define RGROUP_CREATE 10
extern  rapi_res * rgroup_create_1();
extern  rapi_res * rgroup_create_1_svc();
#define RGROUP_ADD 11
extern  rapi_res * rgroup_add_1();
extern  rapi_res * rgroup_add_1_svc();
#define RGROUP_REMOVE 12
extern  rapi_res * rgroup_remove_1();
extern  rapi_res * rgroup_remove_1_svc();
#define RGROUP_DELETE 13
extern  rapi_res * rgroup_delete_1();
extern  rapi_res * rgroup_delete_1_svc();
#define RGROUP_EXISTS 14
extern  rapi_res * rgroup_exists_1();
extern  rapi_res * rgroup_exists_1_svc();
#define RGROUP_LIST 15
extern  rapi_listret * rgroup_list_1();
extern  rapi_listret * rgroup_list_1_svc();
#define RGROUP_LIST_MEMBERS 16
extern  rapi_listret * rgroup_list_members_1();
extern  rapi_listret * rgroup_list_members_1_svc();
#define RCFG_ENABLE 17
extern  rapi_res * rcfg_enable_1();
extern  rapi_res * rcfg_enable_1_svc();
#define RCFG_DISABLE 18
extern  rapi_res * rcfg_disable_1();
extern  rapi_res * rcfg_disable_1_svc();
#define RCFG_CLEAR 19
extern  rapi_res * rcfg_clear_1();
extern  rapi_res * rcfg_clear_1_svc();
#define RGROUP_TYPE 20
extern  zobj_type_ret * rgroup_type_1();
extern  zobj_type_ret * rgroup_type_1_svc();
#define RGETCURRENT_CFG 21
extern  EnCfg_Name_ret * rgetcurrent_cfg_1();
extern  EnCfg_Name_ret * rgetcurrent_cfg_1_svc();
#define RCFG_SAVE 22
extern  rapi_res * rcfg_save_1();
extern  rapi_res * rcfg_save_1_svc();
#define RGROUP_TRANS_START 23
extern  rapi_res * rgroup_trans_start_1();
extern  rapi_res * rgroup_trans_start_1_svc();
#define RGROUP_TRANS_COMMIT 24
extern  rapi_res * rgroup_trans_commit_1();
extern  rapi_res * rgroup_trans_commit_1_svc();
#define RGROUP_TRANS_END 25
extern  rapi_res * rgroup_trans_end_1();
extern  rapi_res * rgroup_trans_end_1_svc();
#define RGROUP_TRANS_VALIDATE 26
extern  zobj_validate_ret * rgroup_trans_validate_1();
extern  zobj_validate_ret * rgroup_trans_validate_1_svc();
#define RGETCURRENT_CFG_CONT 27
extern  EnCfg_Name_ret * rgetcurrent_cfg_cont_1();
extern  EnCfg_Name_ret * rgetcurrent_cfg_cont_1_svc();
#define RZONE_INFO 28
extern  zone_info_rep * rzone_info_1();
extern  zone_info_rep * rzone_info_1_svc();
#define RGROUP_ACTIVE_TYPE 29
extern  zobj_type_ret * rgroup_active_type_1();
extern  zobj_type_ret * rgroup_active_type_1_svc();
#define RGROUP_CREATE_NOLIMIT 30
extern  rapi_res * rgroup_create_nolimit_1();
extern  rapi_res * rgroup_create_nolimit_1_svc();
#define RGROUP_ADD_NOLIMIT 31
extern  rapi_res * rgroup_add_nolimit_1();
extern  rapi_res * rgroup_add_nolimit_1_svc();
#define RGROUP_REMOVE_NOLIMIT 32
extern  rapi_res * rgroup_remove_nolimit_1();
extern  rapi_res * rgroup_remove_nolimit_1_svc();
#define RGROUP_DELETE_NOLIMIT 33
extern  rapi_res * rgroup_delete_nolimit_1();
extern  rapi_res * rgroup_delete_nolimit_1_svc();
#define RGROUP_EXISTS_NOLIMIT 34
extern  rapi_res * rgroup_exists_nolimit_1();
extern  rapi_res * rgroup_exists_nolimit_1_svc();
#define RGROUP_LIST_MEMBERS_NOLIMIT 35
extern  rapi_listret * rgroup_list_members_nolimit_1();
extern  rapi_listret * rgroup_list_members_nolimit_1_svc();
#define RCFG_SIZE 36
extern  cfg_size_result * rcfg_size_1();
extern  cfg_size_result * rcfg_size_1_svc();
#define RGET_ZONEDB_DUMP 37
extern  zonedb_dump_ret * rget_zonedb_dump_1();
extern  zonedb_dump_ret * rget_zonedb_dump_1_svc();
#define RGET_ZONEDB_CHECKSUM 38
extern  zonedb_checksum_ret * rget_zonedb_checksum_1();
extern  zonedb_checksum_ret * rget_zonedb_checksum_1_svc();
#define RMGMT_SVR_REQUEST 40
extern  ms_result * rmgmt_svr_request_1();
extern  ms_result * rmgmt_svr_request_1_svc();
#define RMGMT_SVR_REQUEST2 41
extern  ms2_result * rmgmt_svr_request2_1();
extern  ms2_result * rmgmt_svr_request2_1_svc();
#define RCAL_REQUEST 42
extern  cal_result * rcal_request_1();
extern  cal_result * rcal_request_1_svc();
#define RGROUP_EXPUNGE 43
extern  rapi_res * rgroup_expunge_1();
extern  rapi_res * rgroup_expunge_1_svc();
#define RGET_ZONEDB_TRANS_DUMP 44
extern  zonedb_dump_ret * rget_zonedb_trans_dump_1();
extern  zonedb_dump_ret * rget_zonedb_trans_dump_1_svc();
#define RGET_CFG_TRANS_SHOW 45
extern  zone_trans_owner * rget_cfg_trans_show_1();
extern  zone_trans_owner * rget_cfg_trans_show_1_svc();
#define RGROUP_CP_REN 46
extern  rapi_res * rgroup_cp_ren_1();
extern  rapi_res * rgroup_cp_ren_1_svc();
#define RCFGLOAD 47
extern  rapi_res * rcfgload_1();
extern  rapi_res * rcfgload_1_svc();
#define RZONE_ASYNC 48
extern  rapi_res * rzone_async_1();
extern  rapi_res * rzone_async_1_svc();
#define NS_SVR_REQUEST 60
extern  ns_result * ns_svr_request_1();
extern  ns_result * ns_svr_request_1_svc();
#define APM_GPMC_SEE 80
extern  apm_gpmc_see_res_t * apm_gpmc_see_1();
extern  apm_gpmc_see_res_t * apm_gpmc_see_1_svc();
#define APM_GPMC_DEE 81
extern  apm_gpmc_dee_res_t * apm_gpmc_dee_1();
extern  apm_gpmc_dee_res_t * apm_gpmc_dee_1_svc();
#define APM_GPMC_FF 82
extern  apm_gpmc_ff_res_t * apm_gpmc_ff_1();
extern  apm_gpmc_ff_res_t * apm_gpmc_ff_1_svc();
#define APM_GPMC_BYTYPE 83
extern  apm_gpmc_bytype_res_t * apm_gpmc_bytype_1();
extern  apm_gpmc_bytype_res_t * apm_gpmc_bytype_1_svc();
#define APM_APMC 84
extern  apm_apmc_res_t * apm_apmc_1();
extern  apm_apmc_res_t * apm_apmc_1_svc();
#define APM_DPMH 85
extern  apm_dpmh_res_t * apm_dpmh_1();
extern  apm_dpmh_res_t * apm_dpmh_1_svc();
#define APM_GET_ISL 86
extern  apm_gpm_isl_res_t * apm_get_isl_1();
extern  apm_gpm_isl_res_t * apm_get_isl_1_svc();
#define APM_SET_ISL 87
extern  apm_isl_set_res_t * apm_set_isl_1();
extern  apm_isl_set_res_t * apm_set_isl_1_svc();
#define LOG_GET 90
extern  log_get_res_t * log_get_1();
extern  log_get_res_t * log_get_1_svc();
#define RTRAP_SVR_REQUEST 100
extern  rtrap_result * rtrap_svr_request_1();
extern  rtrap_result * rtrap_svr_request_1_svc();
#define REVNT_SVR_CREATE 120
extern  rapi_res * revnt_svr_create_1();
extern  rapi_res * revnt_svr_create_1_svc();
#define REVNT_SVR_DELETE 121
extern  rapi_res * revnt_svr_delete_1();
extern  rapi_res * revnt_svr_delete_1_svc();
#define REVNT_SVR_CREATE2 122
extern  rapi_res * revnt_svr_create2_1();
extern  rapi_res * revnt_svr_create2_1_svc();
#define REVNT_SVR_DELETE2 123
extern  rapi_res * revnt_svr_delete2_1();
extern  rapi_res * revnt_svr_delete2_1_svc();
#define RMPS_SVR_REQUEST 125
extern  mps_result * rmps_svr_request_1();
extern  mps_result * rmps_svr_request_1_svc();
#define RAUTHENTICATESEC 126
extern  mps_result * rauthenticatesec_1();
extern  mps_result * rauthenticatesec_1_svc();
#define RPLATSETINFO 127
extern  ms_result * rplatsetinfo_1();
extern  ms_result * rplatsetinfo_1_svc();
#define RENABLE_ARR 151
extern  int * renable_arr_1();
extern  int * renable_arr_1_svc();
#define RENABLE_ARR2 152
extern  int * renable_arr2_1();
extern  int * renable_arr2_1_svc();
#define RENABLE_ARR3 153
extern  int * renable_arr3_1();
extern  int * renable_arr3_1_svc();
#define RFDMIINFO 128
extern  fdmi_result * rfdmiinfo_1();
extern  fdmi_result * rfdmiinfo_1_svc();
#define DIAG_SVC_REQUEST 150
extern  diag_result * diag_svc_request_1();
extern  diag_result * diag_svc_request_1_svc();
#define IE_LIST 160
extern  ie_list_result * ie_list_1();
extern  ie_list_result * ie_list_1_svc();
#define ROUTE_INFO 161
extern  route_info_result_t * route_info_1();
extern  route_info_result_t * route_info_1_svc();
#define FABRIC_STABILITY 165
extern  fabric_stability_result_t * fabric_stability_1();
extern  fabric_stability_result_t * fabric_stability_1_svc();
#define FICON_RNID_INFO 170
extern  rnid_result_t * ficon_rnid_info_1();
extern  rnid_result_t * ficon_rnid_info_1_svc();
#define FICON_LIRR_INFO 171
extern  lirr_result_t * ficon_lirr_info_1();
extern  lirr_result_t * ficon_lirr_info_1_svc();
#define FICON_RLIR_INFO 172
extern  rlir_result_t * ficon_rlir_info_1();
extern  rlir_result_t * ficon_rlir_info_1_svc();
#define FICON_FEATURE_INFO 173
extern  ficon_feature_result_t * ficon_feature_info_1();
extern  ficon_feature_result_t * ficon_feature_info_1_svc();
#define FICON_SWITCH_RNID_INFO 174
extern  switch_rnid_result_t * ficon_switch_rnid_info_1();
extern  switch_rnid_result_t * ficon_switch_rnid_info_1_svc();
#define FICON_PORT_SWAP_INFO 175
extern  swapped_port_result_t * ficon_port_swap_info_1();
extern  swapped_port_result_t * ficon_port_swap_info_1_svc();
#define HBA_MGMT 200
extern  hba_mgmt_result * hba_mgmt_1();
extern  hba_mgmt_result * hba_mgmt_1_svc();
#define GET_SWITCHGIF 201
extern  GIF_t * get_switchgif_1();
extern  GIF_t * get_switchgif_1_svc();
#define GET_DHCHAP_SECRET 202
extern  dhchap_secret_t * get_dhchap_secret_1();
extern  dhchap_secret_t * get_dhchap_secret_1_svc();
extern int rapiprog_1_freeresult ();
#endif /* K&R C */

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_auth_res (XDR *, auth_res*);
extern  bool_t xdr_auth_res2 (XDR *, auth_res2*);
extern  bool_t xdr_auth_res3 (XDR *, auth_res3*);
extern  bool_t xdr_pwwn_t (XDR *, pwwn_t);
extern  bool_t xdr_dotIP (XDR *, dotIP);
extern  bool_t xdr_sfversion_res (XDR *, sfversion_res*);
extern  bool_t xdr_zo_type (XDR *, zo_type*);
extern  bool_t xdr_rgroup_info (XDR *, rgroup_info*);
extern  bool_t xdr_rgroup_info_nolimit (XDR *, rgroup_info_nolimit*);
extern  bool_t xdr_rgroup_copy_op_t (XDR *, rgroup_copy_op_t*);
extern  bool_t xdr_rgroup_copy_t (XDR *, rgroup_copy_t*);
extern  bool_t xdr_rcfg_load_t (XDR *, rcfg_load_t*);
extern  bool_t xdr_rzone_asynch_op_t (XDR *, rzone_asynch_op_t*);
extern  bool_t xdr_rzone_asynch_union (XDR *, rzone_asynch_union*);
extern  bool_t xdr_rzone_asynch_t (XDR *, rzone_asynch_t*);
extern  bool_t xdr_license_key (XDR *, license_key*);
extern  bool_t xdr_license_key_set (XDR *, license_key_set*);
extern  bool_t xdr_fabric_discover_depth (XDR *, fabric_discover_depth*);
extern  bool_t xdr_pmodule_msg (XDR *, pmodule_msg*);
extern  bool_t xdr_ms_gsw_msg (XDR *, ms_gsw_msg*);
extern  bool_t xdr_ms_gfabric_msg (XDR *, ms_gfabric_msg*);
extern  bool_t xdr_ms_port_msg (XDR *, ms_port_msg*);
extern  bool_t xdr_ms_pm_topo_msg (XDR *, ms_pm_topo_msg*);
extern  bool_t xdr_ms_gsw_topo_msg (XDR *, ms_gsw_topo_msg*);
extern  bool_t xdr_ms_gfab_topo_msg (XDR *, ms_gfab_topo_msg*);
extern  bool_t xdr_product_id_set (XDR *, product_id_set*);
extern  bool_t xdr_rapi_res (XDR *, rapi_res*);
extern  bool_t xdr_listentry (XDR *, listentry*);
extern  bool_t xdr_rapi_listret (XDR *, rapi_listret*);
extern  bool_t xdr_TypeDfltZone (XDR *, TypeDfltZone*);
extern  bool_t xdr_TypeZoningCap (XDR *, TypeZoningCap*);
extern  bool_t xdr_TypeZoningEnf (XDR *, TypeZoningEnf*);
extern  bool_t xdr_opZone (XDR *, opZone*);
extern  bool_t xdr_zone_info_req (XDR *, zone_info_req*);
extern  bool_t xdr_zone_info_rep (XDR *, zone_info_rep*);
extern  bool_t xdr_ms_gswitchdzb_req (XDR *, ms_gswitchdzb_req*);
extern  bool_t xdr_zobj_type_ret (XDR *, zobj_type_ret*);
extern  bool_t xdr_zobj_validate_ret (XDR *, zobj_validate_ret*);
extern  bool_t xdr_EnCfg_Name_ret (XDR *, EnCfg_Name_ret*);
extern  bool_t xdr_zonedb_dump_ret (XDR *, zonedb_dump_ret*);
extern  bool_t xdr_zonedb_checksum_ret (XDR *, zonedb_checksum_ret*);
extern  bool_t xdr_zone_trans_owner (XDR *, zone_trans_owner*);
extern  bool_t xdr_ms_cmd_code (XDR *, ms_cmd_code*);
extern  bool_t xdr_fc_ng2_cmd_code (XDR *, fc_ng2_cmd_code*);
extern  bool_t xdr_fa_wbem_op_code (XDR *, fa_wbem_op_code*);
extern  bool_t xdr_fa_sys_id (XDR *, fa_sys_id);
extern  bool_t xdr_fa_feature_id (XDR *, fa_feature_id);
extern  bool_t xdr_fa_model_profile_id (XDR *, fa_model_profile_id);
extern  bool_t xdr_fa_cim_primitive_data_types (XDR *, fa_cim_primitive_data_types*);
extern  bool_t xdr_undefined_length_string (XDR *, undefined_length_string*);
extern  bool_t xdr_fa_primitive_value_union (XDR *, fa_primitive_value_union*);
extern  bool_t xdr_fa_cim_primitive_value (XDR *, fa_cim_primitive_value*);
extern  bool_t xdr_fa_cim_key_binding (XDR *, fa_cim_key_binding*);
extern  bool_t xdr_fa_cim_key_binding_array (XDR *, fa_cim_key_binding_array*);
extern  bool_t xdr_fa_cim_class_objectpath (XDR *, fa_cim_class_objectpath*);
extern  bool_t xdr_fa_cim_assoc_objectpath (XDR *, fa_cim_assoc_objectpath*);
extern  bool_t xdr_fa_cim_object_path_type (XDR *, fa_cim_object_path_type*);
extern  bool_t xdr_fa_cim_objectpath (XDR *, fa_cim_objectpath*);
extern  bool_t xdr_fa_cim_objectpath_array (XDR *, fa_cim_objectpath_array*);
extern  bool_t xdr_fa_cim_value_data_type (XDR *, fa_cim_value_data_type*);
extern  bool_t xdr_fa_cim_value_union (XDR *, fa_cim_value_union*);
extern  bool_t xdr_fa_cim_argument (XDR *, fa_cim_argument*);
extern  bool_t xdr_fa_cim_argument_array (XDR *, fa_cim_argument_array*);
extern  bool_t xdr_fa_cim_property (XDR *, fa_cim_property*);
extern  bool_t xdr_fa_cim_property_array (XDR *, fa_cim_property_array*);
extern  bool_t xdr_fa_cim_instance (XDR *, fa_cim_instance*);
extern  bool_t xdr_fa_cim_instance_array (XDR *, fa_cim_instance_array*);
extern  bool_t xdr_fa_cim_class (XDR *, fa_cim_class*);
extern  bool_t xdr_fa_wbem_op_create_instance_arg (XDR *, fa_wbem_op_create_instance_arg*);
extern  bool_t xdr_fa_wbem_op_delete_instance_arg (XDR *, fa_wbem_op_delete_instance_arg*);
extern  bool_t xdr_fa_wbem_op_get_instance_arg (XDR *, fa_wbem_op_get_instance_arg*);
extern  bool_t xdr_fa_wbem_op_set_instance_arg (XDR *, fa_wbem_op_set_instance_arg*);
extern  bool_t xdr_fa_wbem_op_enumerate_instance_names_arg (XDR *, fa_wbem_op_enumerate_instance_names_arg*);
extern  bool_t xdr_fa_wbem_op_enumerate_instances_arg (XDR *, fa_wbem_op_enumerate_instances_arg*);
extern  bool_t xdr_fa_wbem_op_invoke_method_arg (XDR *, fa_wbem_op_invoke_method_arg*);
extern  bool_t xdr_fa_wbem_op_associator_names_arg (XDR *, fa_wbem_op_associator_names_arg*);
extern  bool_t xdr_fa_wbem_op_associators_arg (XDR *, fa_wbem_op_associators_arg*);
extern  bool_t xdr_fa_wbem_op_reference_names_arg (XDR *, fa_wbem_op_reference_names_arg*);
extern  bool_t xdr_fa_wbem_op_references_arg (XDR *, fa_wbem_op_references_arg*);
extern  bool_t xdr_fa_wbem_op_activate_filter_arg (XDR *, fa_wbem_op_activate_filter_arg*);
extern  bool_t xdr_fa_wbem_op_deactivate_filter_arg (XDR *, fa_wbem_op_deactivate_filter_arg*);
extern  bool_t xdr_fa_wbem_operations_req_union (XDR *, fa_wbem_operations_req_union*);
extern  bool_t xdr_fa_forward_wbem_req_arg (XDR *, fa_forward_wbem_req_arg*);
extern  bool_t xdr_fa_wbem_op_create_instance_resp (XDR *, fa_wbem_op_create_instance_resp*);
extern  bool_t xdr_fa_wbem_op_get_instance_resp (XDR *, fa_wbem_op_get_instance_resp*);
extern  bool_t xdr_fa_wbem_op_enumerate_instance_names_resp (XDR *, fa_wbem_op_enumerate_instance_names_resp*);
extern  bool_t xdr_fa_wbem_op_enumerate_instances_resp (XDR *, fa_wbem_op_enumerate_instances_resp*);
extern  bool_t xdr_fa_wbem_op_invoke_method_resp (XDR *, fa_wbem_op_invoke_method_resp*);
extern  bool_t xdr_fa_wbem_op_associator_names_resp (XDR *, fa_wbem_op_associator_names_resp*);
extern  bool_t xdr_fa_wbem_op_associators_resp (XDR *, fa_wbem_op_associators_resp*);
extern  bool_t xdr_fa_wbem_op_reference_names_resp (XDR *, fa_wbem_op_reference_names_resp*);
extern  bool_t xdr_fa_wbem_op_references_resp (XDR *, fa_wbem_op_references_resp*);
extern  bool_t xdr_fa_wbem_op_initialize_resp (XDR *, fa_wbem_op_initialize_resp*);
extern  bool_t xdr_fa_wbem_op_cleanup_resp (XDR *, fa_wbem_op_cleanup_resp*);
extern  bool_t xdr_fa_wbem_op_set_instance_resp (XDR *, fa_wbem_op_set_instance_resp*);
extern  bool_t xdr_fa_wbem_op_delete_instance_resp (XDR *, fa_wbem_op_delete_instance_resp*);
extern  bool_t xdr_fa_wbem_op_activate_filter_resp (XDR *, fa_wbem_op_activate_filter_resp*);
extern  bool_t xdr_fa_wbem_op_deactivate_filter_resp (XDR *, fa_wbem_op_deactivate_filter_resp*);
extern  bool_t xdr_fa_wbem_operations_resp_union (XDR *, fa_wbem_operations_resp_union*);
extern  bool_t xdr_fa_exception (XDR *, fa_exception*);
extern  bool_t xdr_fa_wbem_resp (XDR *, fa_wbem_resp*);
extern  bool_t xdr_fa_acknowledgement (XDR *, fa_acknowledgement*);
extern  bool_t xdr_fa_get_agent_sw_feat_req_arg (XDR *, fa_get_agent_sw_feat_req_arg*);
extern  bool_t xdr_fa_get_agent_supported_model_profile_req_arg (XDR *, fa_get_agent_supported_model_profile_req_arg*);
extern  bool_t xdr_fa_fasys (XDR *, fa_fasys*);
extern  bool_t xdr_fa_fasys_list_resp (XDR *, fa_fasys_list_resp*);
extern  bool_t xdr_fa_agent_info (XDR *, fa_agent_info*);
extern  bool_t xdr_fa_get_agent_list_resp (XDR *, fa_get_agent_list_resp*);
extern  bool_t xdr_fa_agent_model_profile (XDR *, fa_agent_model_profile*);
extern  bool_t xdr_fa_agent_model_profile_list_resp (XDR *, fa_agent_model_profile_list_resp*);
extern  bool_t xdr_fa_get_agent_mof_resp (XDR *, fa_get_agent_mof_resp*);
extern  bool_t xdr_ms_default_req_arg (XDR *, ms_default_req_arg*);
extern  bool_t xdr_ms_rout_req_arg (XDR *, ms_rout_req_arg*);
extern  bool_t xdr_ms_gpath_req_arg (XDR *, ms_gpath_req_arg*);
extern  bool_t xdr_ms_gsrout_req_arg (XDR *, ms_gsrout_req_arg*);
extern  bool_t xdr_ms_delrout_req_arg (XDR *, ms_delrout_req_arg*);
extern  bool_t xdr_ms_wwn_type_entry (XDR *, ms_wwn_type_entry*);
extern  bool_t xdr_c256ar (XDR *, c256ar);
extern  bool_t xdr_ms_type_c256 (XDR *, ms_type_c256*);
extern  bool_t xdr_ms_gswitch_msg (XDR *, ms_gswitch_msg*);
extern  bool_t xdr_destType (XDR *, destType*);
extern  bool_t xdr_destAddress (XDR *, destAddress*);
extern  bool_t xdr_ms_gswitch_msg2 (XDR *, ms_gswitch_msg2*);
extern  bool_t xdr_ms_gswitch_msg_ng (XDR *, ms_gswitch_msg_ng*);
extern  bool_t xdr_ms_gport_msg (XDR *, ms_gport_msg*);
extern  bool_t xdr_ms_gflport_msg (XDR *, ms_gflport_msg*);
extern  bool_t xdr_ms_plat_name (XDR *, ms_plat_name*);
extern  bool_t xdr_ms_ama_name (XDR *, ms_ama_name*);
extern  bool_t xdr_ms_plat_name_list (XDR *, ms_plat_name_list*);
extern  bool_t xdr_ms_plat_attrib (XDR *, ms_plat_attrib*);
extern  bool_t xdr_ms_rpln_req (XDR *, ms_rpln_req*);
extern  bool_t xdr_ms_rplt_req (XDR *, ms_rplt_req*);
extern  bool_t xdr_ms_rplm_req (XDR *, ms_rplm_req*);
extern  bool_t xdr_ms_platall (XDR *, ms_platall*);
extern  bool_t xdr_ms_splatinfo_req (XDR *, ms_splatinfo_req*);
extern  bool_t xdr_c64_t (XDR *, c64_t*);
extern  bool_t xdr_ms_req_pstats (XDR *, ms_req_pstats*);
extern  bool_t xdr_ms_resp_pstats (XDR *, ms_resp_pstats*);
extern  bool_t xdr_ms_req_perrs (XDR *, ms_req_perrs*);
extern  bool_t xdr_ms_resp_perrs (XDR *, ms_resp_perrs*);
extern  bool_t xdr_fw_req_arg (XDR *, fw_req_arg*);
extern  bool_t xdr_fwConfigStruct (XDR *, fwConfigStruct*);
extern  bool_t xdr_fwThStruct (XDR *, fwThStruct*);
extern  bool_t xdr_fwThStruct2 (XDR *, fwThStruct2*);
extern  bool_t xdr_ms_sgroup_msg (XDR *, ms_sgroup_msg*);
extern  bool_t xdr_socketAddrStruct (XDR *, socketAddrStruct*);
extern  bool_t xdr_socketAddrStruct2 (XDR *, socketAddrStruct2*);
extern  bool_t xdr_eventSrvrMsg (XDR *, eventSrvrMsg*);
extern  bool_t xdr_ms_fw_event_msg (XDR *, ms_fw_event_msg*);
extern  bool_t xdr_ms_fw_event_msg2 (XDR *, ms_fw_event_msg2*);
extern  bool_t xdr_license_req_t (XDR *, license_req_t*);
extern  bool_t xdr_lic_prod_req (XDR *, lic_prod_req*);
extern  bool_t xdr_lic_prod_msg (XDR *, lic_prod_msg*);
extern  bool_t xdr_api_license_t (XDR *, api_license_t*);
extern  bool_t xdr_msapi_sgget_req_t (XDR *, msapi_sgget_req_t*);
extern  bool_t xdr_msapi_sgset_req_t (XDR *, msapi_sgset_req_t*);
extern  bool_t xdr_msapi_sgdel_req_t (XDR *, msapi_sgdel_req_t*);
extern  bool_t xdr_msapi_sgrnm_req_t (XDR *, msapi_sgrnm_req_t*);
extern  bool_t xdr_ms_download_start_cmd (XDR *, ms_download_start_cmd*);
extern  bool_t xdr_ms_download_arg (XDR *, ms_download_arg*);
extern  bool_t xdr_ms_download_end_cmd (XDR *, ms_download_end_cmd*);
extern  bool_t xdr_ms_download_rsp (XDR *, ms_download_rsp*);
extern  bool_t xdr_ms_download_self_start_cmd (XDR *, ms_download_self_start_cmd*);
extern  bool_t xdr_ms_download_self_end_cmd (XDR *, ms_download_self_end_cmd*);
extern  bool_t xdr_ms_download_self_rsp (XDR *, ms_download_self_rsp*);
extern  bool_t xdr_ms_upload_start_cmd (XDR *, ms_upload_start_cmd*);
extern  bool_t xdr_ms_upload_start_rsp (XDR *, ms_upload_start_rsp*);
extern  bool_t xdr_ms_upload_arg (XDR *, ms_upload_arg*);
extern  bool_t xdr_ms_upload_rsp (XDR *, ms_upload_rsp*);
extern  bool_t xdr_ms_upload_end_cmd (XDR *, ms_upload_end_cmd*);
extern  bool_t xdr_ms_upload_end_rsp (XDR *, ms_upload_end_rsp*);
extern  bool_t xdr_pki_cert_t (XDR *, pki_cert_t*);
extern  bool_t xdr_csr_msg (XDR *, csr_msg*);
extern  bool_t xdr_ca_msg (XDR *, ca_msg*);
extern  bool_t xdr_apisec_cntr_req (XDR *, apisec_cntr_req*);
extern  bool_t xdr_apisec_cntr_t (XDR *, apisec_cntr_t*);
extern  bool_t xdr_apisec_cntr2_t (XDR *, apisec_cntr2_t*);
extern  bool_t xdr_apisec_keycert_t (XDR *, apisec_keycert_t*);
extern  bool_t xdr_apisec_banner_req_t (XDR *, apisec_banner_req_t*);
extern  bool_t xdr_apisec_banner_rsp_t (XDR *, apisec_banner_rsp_t*);
extern  bool_t xdr_ms_sportinfo (XDR *, ms_sportinfo*);
extern  bool_t xdr_ms_sslot_t (XDR *, ms_sslot_t*);
extern  bool_t xdr_sfru_operation (XDR *, sfru_operation*);
extern  bool_t xdr_sfru_fruType (XDR *, sfru_fruType*);
extern  bool_t xdr_sfru_fruValue (XDR *, sfru_fruValue*);
extern  bool_t xdr_fru_set_msg (XDR *, fru_set_msg*);
extern  bool_t xdr_ms_gport2_msg (XDR *, ms_gport2_msg*);
extern  bool_t xdr_ms_gport_ng_msg (XDR *, ms_gport_ng_msg*);
extern  bool_t xdr_ms_gpa_msg (XDR *, ms_gpa_msg*);
extern  bool_t xdr_ms2_req_arg (XDR *, ms2_req_arg*);
extern  bool_t xdr_cal_request (XDR *, cal_request*);
extern  bool_t xdr_tct_enum_t (XDR *, tct_enum_t*);
extern  bool_t xdr_tct_get_req_t (XDR *, tct_get_req_t*);
extern  bool_t xdr_tct_get_res_t (XDR *, tct_get_res_t*);
extern  bool_t xdr_snmp_community (XDR *, snmp_community*);
extern  bool_t xdr_snmp_access (XDR *, snmp_access*);
extern  bool_t xdr_snmp_struct_t (XDR *, snmp_struct_t*);
extern  bool_t xdr_fw_email_struct_t (XDR *, fw_email_struct_t*);
extern  bool_t xdr_fw_frucfg_struct_t (XDR *, fw_frucfg_struct_t*);
extern  bool_t xdr_enc_chassis_t (XDR *, enc_chassis_t*);
extern  bool_t xdr_xceiver_id (XDR *, xceiver_id*);
extern  bool_t xdr_xceiver_conn (XDR *, xceiver_conn*);
extern  bool_t xdr_xceiver_encoding (XDR *, xceiver_encoding*);
extern  bool_t xdr_xceiver_info_t (XDR *, xceiver_info_t*);
extern  bool_t xdr_log_loglevel_t (XDR *, log_loglevel_t*);
extern  bool_t xdr_api_pwd_t (XDR *, api_pwd_t*);
extern  bool_t xdr_api_pwd_update_t (XDR *, api_pwd_update_t*);
extern  bool_t xdr_switch_gif_t (XDR *, switch_gif_t*);
extern  bool_t xdr_fw_report_req_t (XDR *, fw_report_req_t*);
extern  bool_t xdr_xceiver_input (XDR *, xceiver_input*);
extern  bool_t xdr_gxceiver_info_req_t (XDR *, gxceiver_info_req_t*);
extern  bool_t xdr_gport4_req_t (XDR *, gport4_req_t*);
extern  bool_t xdr_ms_gport4_msg (XDR *, ms_gport4_msg*);
extern  bool_t xdr_gpl_fxport_entry (XDR *, gpl_fxport_entry*);
extern  bool_t xdr_gpl_fxport_list (XDR *, gpl_fxport_list*);
extern  bool_t xdr_ms_req_arg (XDR *, ms_req_arg*);
extern  bool_t xdr_gapnl2_req_t (XDR *, gapnl2_req_t*);
extern  bool_t xdr_gscsi_cmd_t (XDR *, gscsi_cmd_t*);
extern  bool_t xdr_gscsi_string_req_t (XDR *, gscsi_string_req_t*);
extern  bool_t xdr_gattpsfp_req_t (XDR *, gattpsfp_req_t*);
extern  bool_t xdr_gapnl2_resp (XDR *, gapnl2_resp*);
extern  bool_t xdr_gapnl2_resp_list (XDR *, gapnl2_resp_list*);
extern  bool_t xdr_gscsi_string_resp_t (XDR *, gscsi_string_resp_t*);
extern  bool_t xdr_phswitch_type_t (XDR *, phswitch_type_t*);
extern  bool_t xdr_gphswitchgrp_list (XDR *, gphswitchgrp_list*);
extern  bool_t xdr_fcr_gphswitchgrp_resp (XDR *, fcr_gphswitchgrp_resp*);
extern  bool_t xdr_portType_t (XDR *, portType_t*);
extern  bool_t xdr_gpsfpl_resp (XDR *, gpsfpl_resp*);
extern  bool_t xdr_gpsfpl_resp_list (XDR *, gpsfpl_resp_list*);
extern  bool_t xdr_int_list (XDR *, int_list*);
extern  bool_t xdr_ms_wwn_entry (XDR *, ms_wwn_entry*);
extern  bool_t xdr_ms_wwn_list (XDR *, ms_wwn_list*);
extern  bool_t xdr_fcr_fid_t (XDR *, fcr_fid_t*);
extern  bool_t xdr_enet_interface_t (XDR *, enet_interface_t*);
extern  bool_t xdr_enet_interface_list (XDR *, enet_interface_list*);
extern  bool_t xdr_fcr_switch_addition001_t (XDR *, fcr_switch_addition001_t*);
extern  bool_t xdr_fcr_LSAN_t (XDR *, fcr_LSAN_t*);
extern  bool_t xdr_fcr_LSAN_list (XDR *, fcr_LSAN_list*);
extern  bool_t xdr_fcr_route_t (XDR *, fcr_route_t*);
extern  bool_t xdr_fcr_route_list (XDR *, fcr_route_list*);
extern  bool_t xdr_fcr_ex_port_t (XDR *, fcr_ex_port_t*);
extern  bool_t xdr_fcr_proxy_device_t (XDR *, fcr_proxy_device_t*);
extern  bool_t xdr_fcr_proxy_device_list (XDR *, fcr_proxy_device_list*);
extern  bool_t xdr_fcr_phy_device_t (XDR *, fcr_phy_device_t*);
extern  bool_t xdr_fcr_gdevice2_req (XDR *, fcr_gdevice2_req*);
extern  bool_t xdr_fcr_phy_device_list (XDR *, fcr_phy_device_list*);
extern  bool_t xdr_fcr_portinfo (XDR *, fcr_portinfo*);
extern  bool_t xdr_fcr_slot_resp (XDR *, fcr_slot_resp*);
extern  bool_t xdr_fcr_phy_conn_type (XDR *, fcr_phy_conn_type*);
extern  bool_t xdr_fcr_gpl3_resp (XDR *, fcr_gpl3_resp*);
extern  bool_t xdr_fcr_gpl3_list (XDR *, fcr_gpl3_list*);
extern  bool_t xdr_fcr_gdevice2_resp (XDR *, fcr_gdevice2_resp*);
extern  bool_t xdr_csr_t (XDR *, csr_t*);
extern  bool_t xdr_cert_t (XDR *, cert_t*);
extern  bool_t xdr_csr_list (XDR *, csr_list*);
extern  bool_t xdr_cert_list (XDR *, cert_list*);
extern  bool_t xdr_fc_ng2_req_arg (XDR *, fc_ng2_req_arg*);
extern  bool_t xdr_ms_gmal_resp (XDR *, ms_gmal_resp*);
extern  bool_t xdr_ms_wwn_type_res (XDR *, ms_wwn_type_res*);
extern  bool_t xdr_ms_gieil_c64 (XDR *, ms_gieil_c64*);
extern  bool_t xdr_ms_gieil_resp (XDR *, ms_gieil_resp*);
extern  bool_t xdr_ms_gperr_resp (XDR *, ms_gperr_resp*);
extern  bool_t xdr_ms_gpst_resp (XDR *, ms_gpst_resp*);
extern  bool_t xdr_hop (XDR *, hop*);
extern  bool_t xdr_ms_grout_resp (XDR *, ms_grout_resp*);
extern  bool_t xdr_ms_gpath_resp (XDR *, ms_gpath_resp*);
extern  bool_t xdr_ms_gdevice_resp_api1 (XDR *, ms_gdevice_resp_api1*);
extern  bool_t xdr_ms_gdevice_resp (XDR *, ms_gdevice_resp*);
extern  bool_t xdr_msapi_sgget_resp_t (XDR *, msapi_sgget_resp_t*);
extern  bool_t xdr_fanentry (XDR *, fanentry*);
extern  bool_t xdr_tempsensorentry (XDR *, tempsensorentry*);
extern  bool_t xdr_psupplyentry (XDR *, psupplyentry*);
extern  bool_t xdr_switch_enclosure_resp (XDR *, switch_enclosure_resp*);
extern  bool_t xdr_fruHdrInfo (XDR *, fruHdrInfo*);
extern  bool_t xdr_fanentry2 (XDR *, fanentry2*);
extern  bool_t xdr_psupplyentry2 (XDR *, psupplyentry2*);
extern  bool_t xdr_tempsensorentry2 (XDR *, tempsensorentry2*);
extern  bool_t xdr_genbladeentry (XDR *, genbladeentry*);
extern  bool_t xdr_wwnbladeentry2 (XDR *, wwnbladeentry2*);
extern  bool_t xdr_switch_enclosure2_resp (XDR *, switch_enclosure2_resp*);
extern  bool_t xdr_cp_info_resp (XDR *, cp_info_resp*);
extern  bool_t xdr_ms_portinfo (XDR *, ms_portinfo*);
extern  bool_t xdr_ms_slot_resp (XDR *, ms_slot_resp*);
extern  bool_t xdr_ms_resp_res (XDR *, ms_resp_res*);
extern  bool_t xdr_snsEntryBasic (XDR *, snsEntryBasic*);
extern  bool_t xdr_snsEntryBasicList (XDR *, snsEntryBasicList*);
extern  bool_t xdr_snsEntryStruct (XDR *, snsEntryStruct*);
extern  bool_t xdr_snsEntryList (XDR *, snsEntryList*);
extern  bool_t xdr_fc_ng2_res_arg (XDR *, fc_ng2_res_arg*);
extern  bool_t xdr_ms_result (XDR *, ms_result*);
extern  bool_t xdr_ms2_result (XDR *, ms2_result*);
extern  bool_t xdr_cal_result (XDR *, cal_result*);
extern  bool_t xdr_ns_cmd_code (XDR *, ns_cmd_code*);
extern  bool_t xdr_ns_sspname (XDR *, ns_sspname*);
extern  bool_t xdr_ns_ssnname (XDR *, ns_ssnname*);
extern  bool_t xdr_ns_req_arg (XDR *, ns_req_arg*);
extern  bool_t xdr_snsSimpleEntryStruct (XDR *, snsSimpleEntryStruct*);
extern  bool_t xdr_snsPortListStruct (XDR *, snsPortListStruct*);
extern  bool_t xdr_snsPortListStructList (XDR *, snsPortListStructList*);
extern  bool_t xdr_snsWwnListStruct (XDR *, snsWwnListStruct*);
extern  bool_t xdr_snsWwnListStructList (XDR *, snsWwnListStructList*);
extern  bool_t xdr_snsDAListStruct (XDR *, snsDAListStruct*);
extern  bool_t xdr_snsDAListStructList (XDR *, snsDAListStructList*);
extern  bool_t xdr_ns_resp_res (XDR *, ns_resp_res*);
extern  bool_t xdr_ns_result (XDR *, ns_result*);
extern  bool_t xdr_rtrap_cmd_code (XDR *, rtrap_cmd_code*);
extern  bool_t xdr_rtrap_req_arg (XDR *, rtrap_req_arg*);
extern  bool_t xdr_rtrap_resp_res (XDR *, rtrap_resp_res*);
extern  bool_t xdr_rtrap_result (XDR *, rtrap_result*);
extern  bool_t xdr_mps_cmd_code (XDR *, mps_cmd_code*);
extern  bool_t xdr_sec_plcy_type (XDR *, sec_plcy_type*);
extern  bool_t xdr_mps_plcy_t (XDR *, mps_plcy_t*);
extern  bool_t xdr_api_cert_t (XDR *, api_cert_t*);
extern  bool_t xdr_mps_domain_info (XDR *, mps_domain_info*);
extern  bool_t xdr_mps_fabric_info (XDR *, mps_fabric_info*);
extern  bool_t xdr_api_snmp_t (XDR *, api_snmp_t*);
extern  bool_t xdr_sec_api_auth_t (XDR *, sec_api_auth_t*);
extern  bool_t xdr_sec_version_stamp_t (XDR *, sec_version_stamp_t*);
extern  bool_t xdr_secDbSt_t (XDR *, secDbSt_t*);
extern  bool_t xdr_user_pass_t (XDR *, user_pass_t*);
extern  bool_t xdr_mps_sec_enable_t (XDR *, mps_sec_enable_t*);
extern  bool_t xdr_apiPortLogStr (XDR *, apiPortLogStr*);
extern  bool_t xdr_mps_req_arg (XDR *, mps_req_arg*);
extern  bool_t xdr_mps_resp_arg (XDR *, mps_resp_arg*);
extern  bool_t xdr_mps_result (XDR *, mps_result*);
extern  bool_t xdr_diag_cmd_code (XDR *, diag_cmd_code*);
extern  bool_t xdr_diag_common_params (XDR *, diag_common_params*);
extern  bool_t xdr_diag_port_key (XDR *, diag_port_key*);
extern  bool_t xdr_diag_portDiagPattern (XDR *, diag_portDiagPattern*);
extern  bool_t xdr_diag_port_params (XDR *, diag_port_params*);
extern  bool_t xdr_diag_start_port_req (XDR *, diag_start_port_req*);
extern  bool_t xdr_diag_request (XDR *, diag_request*);
extern  bool_t xdr_diag_resp_res (XDR *, diag_resp_res*);
extern  bool_t xdr_diag_result (XDR *, diag_result*);
extern  bool_t xdr_arrEnable_t (XDR *, arrEnable_t*);
extern  bool_t xdr_arrEnableOptions (XDR *, arrEnableOptions*);
extern  bool_t xdr_arrEnable2_t (XDR *, arrEnable2_t*);
extern  bool_t xdr_arrEnable3_t (XDR *, arrEnable3_t*);
extern  bool_t xdr__fdmi_attr (XDR *, _fdmi_attr*);
extern  bool_t xdr_fdmi_ghat_result (XDR *, fdmi_ghat_result*);
extern  bool_t xdr_fdmi_getallnhba_result (XDR *, fdmi_getallnhba_result*);
extern  bool_t xdr__fdmi_attr_minimum (XDR *, _fdmi_attr_minimum*);
extern  bool_t xdr_fdmi_getnextnhba_result (XDR *, fdmi_getnextnhba_result*);
extern  bool_t xdr_fdmi_getonehba_result (XDR *, fdmi_getonehba_result*);
extern  bool_t xdr_fdmi_getoneport_result (XDR *, fdmi_getoneport_result*);
extern  bool_t xdr_fdmi_getnextnhba_req (XDR *, fdmi_getnextnhba_req*);
extern  bool_t xdr_fdmi_getonehba_req (XDR *, fdmi_getonehba_req*);
extern  bool_t xdr_fdmi_getallnhba_req (XDR *, fdmi_getallnhba_req*);
extern  bool_t xdr_fdmi_getoneport_req (XDR *, fdmi_getoneport_req*);
extern  bool_t xdr_fdmi_cmd_code (XDR *, fdmi_cmd_code*);
extern  bool_t xdr_fdmi_request (XDR *, fdmi_request*);
extern  bool_t xdr_fdmi_resp_res (XDR *, fdmi_resp_res*);
extern  bool_t xdr_fdmi_result (XDR *, fdmi_result*);
extern  bool_t xdr_log_type_t (XDR *, log_type_t*);
extern  bool_t xdr_log_get_req_t (XDR *, log_get_req_t*);
extern  bool_t xdr_log_get_res_t (XDR *, log_get_res_t*);
extern  bool_t xdr_apm_handle_t (XDR *, apm_handle_t*);
extern  bool_t xdr_apm_pid_t (XDR *, apm_pid_t*);
extern  bool_t xdr_apmuint64_t (XDR *, apmuint64_t*);
extern  bool_t xdr_apm_objtype_t (XDR *, apm_objtype_t*);
extern  bool_t xdr_apm_flttype_t (XDR *, apm_flttype_t*);
extern  bool_t xdr_apm_apmc_t (XDR *, apm_apmc_t*);
extern  bool_t xdr_apm_dpmh_t (XDR *, apm_dpmh_t*);
extern  bool_t xdr_apm_err_enum_t (XDR *, apm_err_enum_t*);
extern  bool_t xdr_apm_eemon_static_t (XDR *, apm_eemon_static_t*);
extern  bool_t xdr_apm_eemon_dynamic_t (XDR *, apm_eemon_dynamic_t*);
extern  bool_t xdr_apm_fltmon_t (XDR *, apm_fltmon_t*);
extern  bool_t xdr_apm_new_entry_t (XDR *, apm_new_entry_t*);
extern  bool_t xdr_apm_gpmc_byhandle_req_t (XDR *, apm_gpmc_byhandle_req_t*);
extern  bool_t xdr_apm_gpmc_see_res_t (XDR *, apm_gpmc_see_res_t*);
extern  bool_t xdr_apm_gpmc_dee_res_t (XDR *, apm_gpmc_dee_res_t*);
extern  bool_t xdr_apm_gpmc_ff_res_t (XDR *, apm_gpmc_ff_res_t*);
extern  bool_t xdr_apm_gpmc_generic_res_t (XDR *, apm_gpmc_generic_res_t*);
extern  bool_t xdr_apm_gpmc_bytype_req_t (XDR *, apm_gpmc_bytype_req_t*);
extern  bool_t xdr_apm_gpmc_bytype_res_t (XDR *, apm_gpmc_bytype_res_t*);
extern  bool_t xdr_apm_apmc_req_t (XDR *, apm_apmc_req_t*);
extern  bool_t xdr_apm_apmc_res_t (XDR *, apm_apmc_res_t*);
extern  bool_t xdr_apm_dpmh_req_t (XDR *, apm_dpmh_req_t*);
extern  bool_t xdr_apm_dpmh_res_t (XDR *, apm_dpmh_res_t*);
extern  bool_t xdr_apm_domctr_t (XDR *, apm_domctr_t*);
extern  bool_t xdr_apm_gpm_isl_entry_t (XDR *, apm_gpm_isl_entry_t*);
extern  bool_t xdr_apm_gpm_isl_res_t (XDR *, apm_gpm_isl_res_t*);
extern  bool_t xdr_apm_isl_set_type_t (XDR *, apm_isl_set_type_t*);
extern  bool_t xdr_apm_isl_mode_type_t (XDR *, apm_isl_mode_type_t*);
extern  bool_t xdr_apm_isl_mode_t (XDR *, apm_isl_mode_t*);
extern  bool_t xdr_apm_isl_set_t (XDR *, apm_isl_set_t*);
extern  bool_t xdr_apm_isl_set_res_t (XDR *, apm_isl_set_res_t*);
extern  bool_t xdr_ie_entry (XDR *, ie_entry*);
extern  bool_t xdr_ie_list_result (XDR *, ie_list_result*);
extern  bool_t xdr_cfg_size_result (XDR *, cfg_size_result*);
extern  bool_t xdr_ficon_cmd (XDR *, ficon_cmd*);
extern  bool_t xdr_ficon_feature_req_t (XDR *, ficon_feature_req_t*);
extern  bool_t xdr_ficon_feature_result_t (XDR *, ficon_feature_result_t*);
extern  bool_t xdr_ficon_cmd_scope (XDR *, ficon_cmd_scope*);
extern  bool_t xdr_ficon_req_t (XDR *, ficon_req_t*);
extern  bool_t xdr_swapped_port_t (XDR *, swapped_port_t*);
extern  bool_t xdr_swapped_port_result_t (XDR *, swapped_port_result_t*);
extern  bool_t xdr_rnid_entry_t (XDR *, rnid_entry_t*);
extern  bool_t xdr_rnid_switch_list_t (XDR *, rnid_switch_list_t*);
extern  bool_t xdr_api_rnid_list_t (XDR *, api_rnid_list_t*);
extern  bool_t xdr_rnid_result_t (XDR *, rnid_result_t*);
extern  bool_t xdr_api_switch_rnid_entry_t (XDR *, api_switch_rnid_entry_t*);
extern  bool_t xdr_api_switch_rnid_t (XDR *, api_switch_rnid_t*);
extern  bool_t xdr_switch_rnid_result_t (XDR *, switch_rnid_result_t*);
extern  bool_t xdr_lirr_entry_t (XDR *, lirr_entry_t*);
extern  bool_t xdr_lirr_switch_list_t (XDR *, lirr_switch_list_t*);
extern  bool_t xdr_api_lirr_list_t (XDR *, api_lirr_list_t*);
extern  bool_t xdr_lirr_result_t (XDR *, lirr_result_t*);
extern  bool_t xdr_rlir_entry_t (XDR *, rlir_entry_t*);
extern  bool_t xdr_rlir_switch_list_t (XDR *, rlir_switch_list_t*);
extern  bool_t xdr_api_rlir_list_t (XDR *, api_rlir_list_t*);
extern  bool_t xdr_rlir_result_t (XDR *, rlir_result_t*);
extern  bool_t xdr_route_info_result_t (XDR *, route_info_result_t*);
extern  bool_t xdr_fabric_stability_result_t (XDR *, fabric_stability_result_t*);
extern  bool_t xdr_hba_mgmt_code (XDR *, hba_mgmt_code*);
extern  bool_t xdr_hba_mgmt_flags (XDR *, hba_mgmt_flags*);
extern  bool_t xdr_hba_resource_t (XDR *, hba_resource_t*);
extern  bool_t xdr_hba_mgmt_req_t (XDR *, hba_mgmt_req_t*);
extern  bool_t xdr_hba_mgmt_resp_t (XDR *, hba_mgmt_resp_t*);
extern  bool_t xdr_hba_mgmt_result (XDR *, hba_mgmt_result*);
extern  bool_t xdr_GIF_t (XDR *, GIF_t*);
extern  bool_t xdr_dhchap_secret_t (XDR *, dhchap_secret_t*);
extern  bool_t xdr_dhchap_secret_req_t (XDR *, dhchap_secret_req_t*);

#else /* K&R C */
extern bool_t xdr_auth_res ();
extern bool_t xdr_auth_res2 ();
extern bool_t xdr_auth_res3 ();
extern bool_t xdr_pwwn_t ();
extern bool_t xdr_dotIP ();
extern bool_t xdr_sfversion_res ();
extern bool_t xdr_zo_type ();
extern bool_t xdr_rgroup_info ();
extern bool_t xdr_rgroup_info_nolimit ();
extern bool_t xdr_rgroup_copy_op_t ();
extern bool_t xdr_rgroup_copy_t ();
extern bool_t xdr_rcfg_load_t ();
extern bool_t xdr_rzone_asynch_op_t ();
extern bool_t xdr_rzone_asynch_union ();
extern bool_t xdr_rzone_asynch_t ();
extern bool_t xdr_license_key ();
extern bool_t xdr_license_key_set ();
extern bool_t xdr_fabric_discover_depth ();
extern bool_t xdr_pmodule_msg ();
extern bool_t xdr_ms_gsw_msg ();
extern bool_t xdr_ms_gfabric_msg ();
extern bool_t xdr_ms_port_msg ();
extern bool_t xdr_ms_pm_topo_msg ();
extern bool_t xdr_ms_gsw_topo_msg ();
extern bool_t xdr_ms_gfab_topo_msg ();
extern bool_t xdr_product_id_set ();
extern bool_t xdr_rapi_res ();
extern bool_t xdr_listentry ();
extern bool_t xdr_rapi_listret ();
extern bool_t xdr_TypeDfltZone ();
extern bool_t xdr_TypeZoningCap ();
extern bool_t xdr_TypeZoningEnf ();
extern bool_t xdr_opZone ();
extern bool_t xdr_zone_info_req ();
extern bool_t xdr_zone_info_rep ();
extern bool_t xdr_ms_gswitchdzb_req ();
extern bool_t xdr_zobj_type_ret ();
extern bool_t xdr_zobj_validate_ret ();
extern bool_t xdr_EnCfg_Name_ret ();
extern bool_t xdr_zonedb_dump_ret ();
extern bool_t xdr_zonedb_checksum_ret ();
extern bool_t xdr_zone_trans_owner ();
extern bool_t xdr_ms_cmd_code ();
extern bool_t xdr_fc_ng2_cmd_code ();
extern bool_t xdr_fa_wbem_op_code ();
extern bool_t xdr_fa_sys_id ();
extern bool_t xdr_fa_feature_id ();
extern bool_t xdr_fa_model_profile_id ();
extern bool_t xdr_fa_cim_primitive_data_types ();
extern bool_t xdr_undefined_length_string ();
extern bool_t xdr_fa_primitive_value_union ();
extern bool_t xdr_fa_cim_primitive_value ();
extern bool_t xdr_fa_cim_key_binding ();
extern bool_t xdr_fa_cim_key_binding_array ();
extern bool_t xdr_fa_cim_class_objectpath ();
extern bool_t xdr_fa_cim_assoc_objectpath ();
extern bool_t xdr_fa_cim_object_path_type ();
extern bool_t xdr_fa_cim_objectpath ();
extern bool_t xdr_fa_cim_objectpath_array ();
extern bool_t xdr_fa_cim_value_data_type ();
extern bool_t xdr_fa_cim_value_union ();
extern bool_t xdr_fa_cim_argument ();
extern bool_t xdr_fa_cim_argument_array ();
extern bool_t xdr_fa_cim_property ();
extern bool_t xdr_fa_cim_property_array ();
extern bool_t xdr_fa_cim_instance ();
extern bool_t xdr_fa_cim_instance_array ();
extern bool_t xdr_fa_cim_class ();
extern bool_t xdr_fa_wbem_op_create_instance_arg ();
extern bool_t xdr_fa_wbem_op_delete_instance_arg ();
extern bool_t xdr_fa_wbem_op_get_instance_arg ();
extern bool_t xdr_fa_wbem_op_set_instance_arg ();
extern bool_t xdr_fa_wbem_op_enumerate_instance_names_arg ();
extern bool_t xdr_fa_wbem_op_enumerate_instances_arg ();
extern bool_t xdr_fa_wbem_op_invoke_method_arg ();
extern bool_t xdr_fa_wbem_op_associator_names_arg ();
extern bool_t xdr_fa_wbem_op_associators_arg ();
extern bool_t xdr_fa_wbem_op_reference_names_arg ();
extern bool_t xdr_fa_wbem_op_references_arg ();
extern bool_t xdr_fa_wbem_op_activate_filter_arg ();
extern bool_t xdr_fa_wbem_op_deactivate_filter_arg ();
extern bool_t xdr_fa_wbem_operations_req_union ();
extern bool_t xdr_fa_forward_wbem_req_arg ();
extern bool_t xdr_fa_wbem_op_create_instance_resp ();
extern bool_t xdr_fa_wbem_op_get_instance_resp ();
extern bool_t xdr_fa_wbem_op_enumerate_instance_names_resp ();
extern bool_t xdr_fa_wbem_op_enumerate_instances_resp ();
extern bool_t xdr_fa_wbem_op_invoke_method_resp ();
extern bool_t xdr_fa_wbem_op_associator_names_resp ();
extern bool_t xdr_fa_wbem_op_associators_resp ();
extern bool_t xdr_fa_wbem_op_reference_names_resp ();
extern bool_t xdr_fa_wbem_op_references_resp ();
extern bool_t xdr_fa_wbem_op_initialize_resp ();
extern bool_t xdr_fa_wbem_op_cleanup_resp ();
extern bool_t xdr_fa_wbem_op_set_instance_resp ();
extern bool_t xdr_fa_wbem_op_delete_instance_resp ();
extern bool_t xdr_fa_wbem_op_activate_filter_resp ();
extern bool_t xdr_fa_wbem_op_deactivate_filter_resp ();
extern bool_t xdr_fa_wbem_operations_resp_union ();
extern bool_t xdr_fa_exception ();
extern bool_t xdr_fa_wbem_resp ();
extern bool_t xdr_fa_acknowledgement ();
extern bool_t xdr_fa_get_agent_sw_feat_req_arg ();
extern bool_t xdr_fa_get_agent_supported_model_profile_req_arg ();
extern bool_t xdr_fa_fasys ();
extern bool_t xdr_fa_fasys_list_resp ();
extern bool_t xdr_fa_agent_info ();
extern bool_t xdr_fa_get_agent_list_resp ();
extern bool_t xdr_fa_agent_model_profile ();
extern bool_t xdr_fa_agent_model_profile_list_resp ();
extern bool_t xdr_fa_get_agent_mof_resp ();
extern bool_t xdr_ms_default_req_arg ();
extern bool_t xdr_ms_rout_req_arg ();
extern bool_t xdr_ms_gpath_req_arg ();
extern bool_t xdr_ms_gsrout_req_arg ();
extern bool_t xdr_ms_delrout_req_arg ();
extern bool_t xdr_ms_wwn_type_entry ();
extern bool_t xdr_c256ar ();
extern bool_t xdr_ms_type_c256 ();
extern bool_t xdr_ms_gswitch_msg ();
extern bool_t xdr_destType ();
extern bool_t xdr_destAddress ();
extern bool_t xdr_ms_gswitch_msg2 ();
extern bool_t xdr_ms_gswitch_msg_ng ();
extern bool_t xdr_ms_gport_msg ();
extern bool_t xdr_ms_gflport_msg ();
extern bool_t xdr_ms_plat_name ();
extern bool_t xdr_ms_ama_name ();
extern bool_t xdr_ms_plat_name_list ();
extern bool_t xdr_ms_plat_attrib ();
extern bool_t xdr_ms_rpln_req ();
extern bool_t xdr_ms_rplt_req ();
extern bool_t xdr_ms_rplm_req ();
extern bool_t xdr_ms_platall ();
extern bool_t xdr_ms_splatinfo_req ();
extern bool_t xdr_c64_t ();
extern bool_t xdr_ms_req_pstats ();
extern bool_t xdr_ms_resp_pstats ();
extern bool_t xdr_ms_req_perrs ();
extern bool_t xdr_ms_resp_perrs ();
extern bool_t xdr_fw_req_arg ();
extern bool_t xdr_fwConfigStruct ();
extern bool_t xdr_fwThStruct ();
extern bool_t xdr_fwThStruct2 ();
extern bool_t xdr_ms_sgroup_msg ();
extern bool_t xdr_socketAddrStruct ();
extern bool_t xdr_socketAddrStruct2 ();
extern bool_t xdr_eventSrvrMsg ();
extern bool_t xdr_ms_fw_event_msg ();
extern bool_t xdr_ms_fw_event_msg2 ();
extern bool_t xdr_license_req_t ();
extern bool_t xdr_lic_prod_req ();
extern bool_t xdr_lic_prod_msg ();
extern bool_t xdr_api_license_t ();
extern bool_t xdr_msapi_sgget_req_t ();
extern bool_t xdr_msapi_sgset_req_t ();
extern bool_t xdr_msapi_sgdel_req_t ();
extern bool_t xdr_msapi_sgrnm_req_t ();
extern bool_t xdr_ms_download_start_cmd ();
extern bool_t xdr_ms_download_arg ();
extern bool_t xdr_ms_download_end_cmd ();
extern bool_t xdr_ms_download_rsp ();
extern bool_t xdr_ms_download_self_start_cmd ();
extern bool_t xdr_ms_download_self_end_cmd ();
extern bool_t xdr_ms_download_self_rsp ();
extern bool_t xdr_ms_upload_start_cmd ();
extern bool_t xdr_ms_upload_start_rsp ();
extern bool_t xdr_ms_upload_arg ();
extern bool_t xdr_ms_upload_rsp ();
extern bool_t xdr_ms_upload_end_cmd ();
extern bool_t xdr_ms_upload_end_rsp ();
extern bool_t xdr_pki_cert_t ();
extern bool_t xdr_csr_msg ();
extern bool_t xdr_ca_msg ();
extern bool_t xdr_apisec_cntr_req ();
extern bool_t xdr_apisec_cntr_t ();
extern bool_t xdr_apisec_cntr2_t ();
extern bool_t xdr_apisec_keycert_t ();
extern bool_t xdr_apisec_banner_req_t ();
extern bool_t xdr_apisec_banner_rsp_t ();
extern bool_t xdr_ms_sportinfo ();
extern bool_t xdr_ms_sslot_t ();
extern bool_t xdr_sfru_operation ();
extern bool_t xdr_sfru_fruType ();
extern bool_t xdr_sfru_fruValue ();
extern bool_t xdr_fru_set_msg ();
extern bool_t xdr_ms_gport2_msg ();
extern bool_t xdr_ms_gport_ng_msg ();
extern bool_t xdr_ms_gpa_msg ();
extern bool_t xdr_ms2_req_arg ();
extern bool_t xdr_cal_request ();
extern bool_t xdr_tct_enum_t ();
extern bool_t xdr_tct_get_req_t ();
extern bool_t xdr_tct_get_res_t ();
extern bool_t xdr_snmp_community ();
extern bool_t xdr_snmp_access ();
extern bool_t xdr_snmp_struct_t ();
extern bool_t xdr_fw_email_struct_t ();
extern bool_t xdr_fw_frucfg_struct_t ();
extern bool_t xdr_enc_chassis_t ();
extern bool_t xdr_xceiver_id ();
extern bool_t xdr_xceiver_conn ();
extern bool_t xdr_xceiver_encoding ();
extern bool_t xdr_xceiver_info_t ();
extern bool_t xdr_log_loglevel_t ();
extern bool_t xdr_api_pwd_t ();
extern bool_t xdr_api_pwd_update_t ();
extern bool_t xdr_switch_gif_t ();
extern bool_t xdr_fw_report_req_t ();
extern bool_t xdr_xceiver_input ();
extern bool_t xdr_gxceiver_info_req_t ();
extern bool_t xdr_gport4_req_t ();
extern bool_t xdr_ms_gport4_msg ();
extern bool_t xdr_gpl_fxport_entry ();
extern bool_t xdr_gpl_fxport_list ();
extern bool_t xdr_ms_req_arg ();
extern bool_t xdr_gapnl2_req_t ();
extern bool_t xdr_gscsi_cmd_t ();
extern bool_t xdr_gscsi_string_req_t ();
extern bool_t xdr_gattpsfp_req_t ();
extern bool_t xdr_gapnl2_resp ();
extern bool_t xdr_gapnl2_resp_list ();
extern bool_t xdr_gscsi_string_resp_t ();
extern bool_t xdr_phswitch_type_t ();
extern bool_t xdr_gphswitchgrp_list ();
extern bool_t xdr_fcr_gphswitchgrp_resp ();
extern bool_t xdr_portType_t ();
extern bool_t xdr_gpsfpl_resp ();
extern bool_t xdr_gpsfpl_resp_list ();
extern bool_t xdr_int_list ();
extern bool_t xdr_ms_wwn_entry ();
extern bool_t xdr_ms_wwn_list ();
extern bool_t xdr_fcr_fid_t ();
extern bool_t xdr_enet_interface_t ();
extern bool_t xdr_enet_interface_list ();
extern bool_t xdr_fcr_switch_addition001_t ();
extern bool_t xdr_fcr_LSAN_t ();
extern bool_t xdr_fcr_LSAN_list ();
extern bool_t xdr_fcr_route_t ();
extern bool_t xdr_fcr_route_list ();
extern bool_t xdr_fcr_ex_port_t ();
extern bool_t xdr_fcr_proxy_device_t ();
extern bool_t xdr_fcr_proxy_device_list ();
extern bool_t xdr_fcr_phy_device_t ();
extern bool_t xdr_fcr_gdevice2_req ();
extern bool_t xdr_fcr_phy_device_list ();
extern bool_t xdr_fcr_portinfo ();
extern bool_t xdr_fcr_slot_resp ();
extern bool_t xdr_fcr_phy_conn_type ();
extern bool_t xdr_fcr_gpl3_resp ();
extern bool_t xdr_fcr_gpl3_list ();
extern bool_t xdr_fcr_gdevice2_resp ();
extern bool_t xdr_csr_t ();
extern bool_t xdr_cert_t ();
extern bool_t xdr_csr_list ();
extern bool_t xdr_cert_list ();
extern bool_t xdr_fc_ng2_req_arg ();
extern bool_t xdr_ms_gmal_resp ();
extern bool_t xdr_ms_wwn_type_res ();
extern bool_t xdr_ms_gieil_c64 ();
extern bool_t xdr_ms_gieil_resp ();
extern bool_t xdr_ms_gperr_resp ();
extern bool_t xdr_ms_gpst_resp ();
extern bool_t xdr_hop ();
extern bool_t xdr_ms_grout_resp ();
extern bool_t xdr_ms_gpath_resp ();
extern bool_t xdr_ms_gdevice_resp_api1 ();
extern bool_t xdr_ms_gdevice_resp ();
extern bool_t xdr_msapi_sgget_resp_t ();
extern bool_t xdr_fanentry ();
extern bool_t xdr_tempsensorentry ();
extern bool_t xdr_psupplyentry ();
extern bool_t xdr_switch_enclosure_resp ();
extern bool_t xdr_fruHdrInfo ();
extern bool_t xdr_fanentry2 ();
extern bool_t xdr_psupplyentry2 ();
extern bool_t xdr_tempsensorentry2 ();
extern bool_t xdr_genbladeentry ();
extern bool_t xdr_wwnbladeentry2 ();
extern bool_t xdr_switch_enclosure2_resp ();
extern bool_t xdr_cp_info_resp ();
extern bool_t xdr_ms_portinfo ();
extern bool_t xdr_ms_slot_resp ();
extern bool_t xdr_ms_resp_res ();
extern bool_t xdr_snsEntryBasic ();
extern bool_t xdr_snsEntryBasicList ();
extern bool_t xdr_snsEntryStruct ();
extern bool_t xdr_snsEntryList ();
extern bool_t xdr_fc_ng2_res_arg ();
extern bool_t xdr_ms_result ();
extern bool_t xdr_ms2_result ();
extern bool_t xdr_cal_result ();
extern bool_t xdr_ns_cmd_code ();
extern bool_t xdr_ns_sspname ();
extern bool_t xdr_ns_ssnname ();
extern bool_t xdr_ns_req_arg ();
extern bool_t xdr_snsSimpleEntryStruct ();
extern bool_t xdr_snsPortListStruct ();
extern bool_t xdr_snsPortListStructList ();
extern bool_t xdr_snsWwnListStruct ();
extern bool_t xdr_snsWwnListStructList ();
extern bool_t xdr_snsDAListStruct ();
extern bool_t xdr_snsDAListStructList ();
extern bool_t xdr_ns_resp_res ();
extern bool_t xdr_ns_result ();
extern bool_t xdr_rtrap_cmd_code ();
extern bool_t xdr_rtrap_req_arg ();
extern bool_t xdr_rtrap_resp_res ();
extern bool_t xdr_rtrap_result ();
extern bool_t xdr_mps_cmd_code ();
extern bool_t xdr_sec_plcy_type ();
extern bool_t xdr_mps_plcy_t ();
extern bool_t xdr_api_cert_t ();
extern bool_t xdr_mps_domain_info ();
extern bool_t xdr_mps_fabric_info ();
extern bool_t xdr_api_snmp_t ();
extern bool_t xdr_sec_api_auth_t ();
extern bool_t xdr_sec_version_stamp_t ();
extern bool_t xdr_secDbSt_t ();
extern bool_t xdr_user_pass_t ();
extern bool_t xdr_mps_sec_enable_t ();
extern bool_t xdr_apiPortLogStr ();
extern bool_t xdr_mps_req_arg ();
extern bool_t xdr_mps_resp_arg ();
extern bool_t xdr_mps_result ();
extern bool_t xdr_diag_cmd_code ();
extern bool_t xdr_diag_common_params ();
extern bool_t xdr_diag_port_key ();
extern bool_t xdr_diag_portDiagPattern ();
extern bool_t xdr_diag_port_params ();
extern bool_t xdr_diag_start_port_req ();
extern bool_t xdr_diag_request ();
extern bool_t xdr_diag_resp_res ();
extern bool_t xdr_diag_result ();
extern bool_t xdr_arrEnable_t ();
extern bool_t xdr_arrEnableOptions ();
extern bool_t xdr_arrEnable2_t ();
extern bool_t xdr_arrEnable3_t ();
extern bool_t xdr__fdmi_attr ();
extern bool_t xdr_fdmi_ghat_result ();
extern bool_t xdr_fdmi_getallnhba_result ();
extern bool_t xdr__fdmi_attr_minimum ();
extern bool_t xdr_fdmi_getnextnhba_result ();
extern bool_t xdr_fdmi_getonehba_result ();
extern bool_t xdr_fdmi_getoneport_result ();
extern bool_t xdr_fdmi_getnextnhba_req ();
extern bool_t xdr_fdmi_getonehba_req ();
extern bool_t xdr_fdmi_getallnhba_req ();
extern bool_t xdr_fdmi_getoneport_req ();
extern bool_t xdr_fdmi_cmd_code ();
extern bool_t xdr_fdmi_request ();
extern bool_t xdr_fdmi_resp_res ();
extern bool_t xdr_fdmi_result ();
extern bool_t xdr_log_type_t ();
extern bool_t xdr_log_get_req_t ();
extern bool_t xdr_log_get_res_t ();
extern bool_t xdr_apm_handle_t ();
extern bool_t xdr_apm_pid_t ();
extern bool_t xdr_apmuint64_t ();
extern bool_t xdr_apm_objtype_t ();
extern bool_t xdr_apm_flttype_t ();
extern bool_t xdr_apm_apmc_t ();
extern bool_t xdr_apm_dpmh_t ();
extern bool_t xdr_apm_err_enum_t ();
extern bool_t xdr_apm_eemon_static_t ();
extern bool_t xdr_apm_eemon_dynamic_t ();
extern bool_t xdr_apm_fltmon_t ();
extern bool_t xdr_apm_new_entry_t ();
extern bool_t xdr_apm_gpmc_byhandle_req_t ();
extern bool_t xdr_apm_gpmc_see_res_t ();
extern bool_t xdr_apm_gpmc_dee_res_t ();
extern bool_t xdr_apm_gpmc_ff_res_t ();
extern bool_t xdr_apm_gpmc_generic_res_t ();
extern bool_t xdr_apm_gpmc_bytype_req_t ();
extern bool_t xdr_apm_gpmc_bytype_res_t ();
extern bool_t xdr_apm_apmc_req_t ();
extern bool_t xdr_apm_apmc_res_t ();
extern bool_t xdr_apm_dpmh_req_t ();
extern bool_t xdr_apm_dpmh_res_t ();
extern bool_t xdr_apm_domctr_t ();
extern bool_t xdr_apm_gpm_isl_entry_t ();
extern bool_t xdr_apm_gpm_isl_res_t ();
extern bool_t xdr_apm_isl_set_type_t ();
extern bool_t xdr_apm_isl_mode_type_t ();
extern bool_t xdr_apm_isl_mode_t ();
extern bool_t xdr_apm_isl_set_t ();
extern bool_t xdr_apm_isl_set_res_t ();
extern bool_t xdr_ie_entry ();
extern bool_t xdr_ie_list_result ();
extern bool_t xdr_cfg_size_result ();
extern bool_t xdr_ficon_cmd ();
extern bool_t xdr_ficon_feature_req_t ();
extern bool_t xdr_ficon_feature_result_t ();
extern bool_t xdr_ficon_cmd_scope ();
extern bool_t xdr_ficon_req_t ();
extern bool_t xdr_swapped_port_t ();
extern bool_t xdr_swapped_port_result_t ();
extern bool_t xdr_rnid_entry_t ();
extern bool_t xdr_rnid_switch_list_t ();
extern bool_t xdr_api_rnid_list_t ();
extern bool_t xdr_rnid_result_t ();
extern bool_t xdr_api_switch_rnid_entry_t ();
extern bool_t xdr_api_switch_rnid_t ();
extern bool_t xdr_switch_rnid_result_t ();
extern bool_t xdr_lirr_entry_t ();
extern bool_t xdr_lirr_switch_list_t ();
extern bool_t xdr_api_lirr_list_t ();
extern bool_t xdr_lirr_result_t ();
extern bool_t xdr_rlir_entry_t ();
extern bool_t xdr_rlir_switch_list_t ();
extern bool_t xdr_api_rlir_list_t ();
extern bool_t xdr_rlir_result_t ();
extern bool_t xdr_route_info_result_t ();
extern bool_t xdr_fabric_stability_result_t ();
extern bool_t xdr_hba_mgmt_code ();
extern bool_t xdr_hba_mgmt_flags ();
extern bool_t xdr_hba_resource_t ();
extern bool_t xdr_hba_mgmt_req_t ();
extern bool_t xdr_hba_mgmt_resp_t ();
extern bool_t xdr_hba_mgmt_result ();
extern bool_t xdr_GIF_t ();
extern bool_t xdr_dhchap_secret_t ();
extern bool_t xdr_dhchap_secret_req_t ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_REMAPI_H_RPCGEN */
