/*
 *
 *    Copyright (c) 2006 by Brocade Communications Systems, Inc.
 *    All rights reserved.
 *
 *    Module name: sa_mgmt.h
 *
 *    Description: sa_mgmt Header file
 *
 */

#ifndef _SA_MGMT_H_
#define _SA_MGMT_H_

#define SA_MGMT_HEADER_SIZE 192

/* Define all the Application return codes here */
typedef enum sa_mgmt_status {
	SA_MGMT_SUCCESS=0,
	SA_MGMT_FAILED=1,
	SA_MGMT_INVALID_ARG=2,
	SA_MGMT_MEMALLOC_FAILED=3,
	SA_MGMT_SEND_FAILED=4
}sa_mgmt_status_t;

typedef struct {
	unsigned int type;
	unsigned int length;
} type_len_t;

/* All char * below should be null terminated strings */
typedef struct {
	char *rte_version;
	char *rte_description;
	char *app_description;
	char *app_version;
	char *app_product_name;
	char *app_vendor;
}sa_mgmt_app_info_t;

typedef enum sa_mgmt_app_status {
	SA_MGMT_APP_STATUS_OK=2,
	SA_MGMT_APP_STATUS_ERROR=13
}sa_mgmt_app_status_t;

#define REGISTERED_ORGANIZATION_OTHER 3
#define REGISTERED_ORGANIZATION_DMTF 4

#define OTHER_REG_ORGANIZATION_BROCADE "Brocade Communication Systems, Inc."


/* All char * below should be null terminated strings */
/*
typedef struct _sa_mgmt_app_info_t{
	char *rte_version;
	char *rte_description;

	char *app_description;
	char *app_version;
	char *app_product_name;
	char *app_vendor;
}sa_mgmt_app_info_t;
*/


typedef struct _sa_mgmt_profile_t {

	unsigned int registered_organization; 
	char * other_registered_organization;

	/* Data model name */
	char * registered_name;

	/* User friendly name for the profile */
	char * element_name;

	/* Data model version */
	unsigned int major_version;
	unsigned int minor_version;
	unsigned int update_version;

	/* MOF filename for this data model */
	char *mof_filename;

	/* Description of the model supported */
	char *profile_description;

	char *top_level_classname;
} sa_mgmt_profile_t;

 

typedef void (*sa_mgmt_wbem_req_cb_t)(char *buffer, int len, void *req_ctx); 

/* Application will fill in the status in app_status */
typedef void (*sa_mgmt_app_status_cb_t)(sa_mgmt_app_status_t *app_status);

/* Callback on successful initialization */
typedef void (*sa_mgmt_init_complete_cb_t)(sa_mgmt_status_t app_status);
/* Callback on CP failover */
typedef void (*sa_mgmt_cp_failover_cb_t)(void);
/* Callback on failure to connection with CP */
typedef void (*sa_mgmt_conn_fail_cb_t)(void);

/* response callback registration */

/* Sets the function pointer that would be invoked when a WBEM request is 
   received from CAL. */
extern void sa_mgmt_set_wbem_req_cb(sa_mgmt_wbem_req_cb_t  wbem_req_cb);
/* Set the function pointer that would be invoked when the application status 
   request is received from CAL.
*/
extern void sa_mgmt_set_app_status_cb(sa_mgmt_app_status_cb_t  status_cb);

/* Set the function pointer that would be invoked when initialization is
 * complete (successful or otherwise) */
extern void sa_mgmt_set_init_complete_cb(sa_mgmt_init_complete_cb_t  init_cb);

/* Set the function pointer that would be invoked when CP failover is has 
 * happened */
extern void sa_mgmt_set_cp_failover_cb(sa_mgmt_cp_failover_cb_t  failover_cb);

/* Set the function pointer that would be invoked when connection to CP has
 * failed */
extern void sa_mgmt_set_cp_conn_fail_cb(sa_mgmt_conn_fail_cb_t  conn_fail_cb);

/* synchronous APIs */

/* Application will use the following function to allocate the send buffers for
   sa_mgmt_send_wbemresp(). This will help us in avoiding buf copy. Library 
   would allocate the space for its header and then return the pointer for the 
   Application to fill in the payload */
extern void *sa_mgmt_alloc_buffer(int size);
/* Free should not be called by the Application in a normal scenario, the 
   library would take care of freeing it, Application can call free if there 
   is error scenarios and the buffer needs to be freed before calling 
   sa_mgmt_send_wbemresp().
*/
extern void sa_mgmt_free_buffer(void *ptr);

/* asynchrnous APIs */

/* Application should call sa_mgmt_init() when it comes up followed by a
   registration (sa_mgmt_register)
*/

extern sa_mgmt_status_t sa_mgmt_init(void);
/* Application should call sa_mgmt_deinit() normally during graceful shutdown.
   Currently it does nothing, but may be some cleanup would be done in future
   using this function by the library.
*/
extern sa_mgmt_status_t sa_mgmt_deinit(void);

/* Application when it comes up should use the following to register the
   application info when it comes up (after calling sa_mgmt_init) */
extern sa_mgmt_status_t sa_mgmt_register(sa_mgmt_app_info_t *app_info, 
								    sa_mgmt_profile_t *profile_array,
									int num_profiles);

/* This would be used to send asynchronous events to host. Only critical
   events would be sent, things like progress events would not be sent to host
   event_str should be a null terminated string
*/

extern sa_mgmt_status_t sa_mgmt_send_event(char *event_str);

/* This will be used to by application to send the wbem response back to
   the host. The req_ctx should be same as that filled for the corresponding
   request.
   The buffer should be allocated using sa_mgmt_alloc_buffer() and should
   not be freed by the application
*/
extern sa_mgmt_status_t sa_mgmt_send_wbemresp(char *buffer, int len, 
	void *req_ctx, unsigned int seq, unsigned int offset, unsigned int flags);

#endif /* _SA_MGMT_H_ */
