/*
 * Copyright (c) 1996-2006 Brocade Communications Systems, Inc.
 * All rights reserved.
 *
 * Description:
 *    This file contains the datastructures, definitions
 *    needed by the DMM license support. It mainly tells about
 *	  the user context structure and related APIs.
 *
 */

#ifndef __DMM_LIC_CTXT_H__
#define __DMM_LIC_CTXT_H__

#include <cs/cscn.h>

#define DMM_LIC_TIMER_SIZE		100
#define DMM_LIC_TRANSID_MAX		0xFFFF
#define DMM_LIC_ERR_TIME_OUT	1
#define DMM_LIC_UCONTEXT_SIZE	16
#define TRANSACTION_ID(x)  (x == DMM_LIC_TRANSID_MAX ? (1) : (++x))

/* Structure for User Context */
typedef struct dmm_user_context {
	int		msgid;
	void	*uctx;
	uint16_t	index;
	uint16_t	trans_id;
	cs_cn_tmr_hdl_t timer_handle;
} dmm_usr_ctxt_t;

/* APIs related to User Context */
void dmm_lic_context_release(dmm_usr_ctxt_t *ctxt);
void dmm_lic_reset_index();
dmm_usr_ctxt_t *dmm_lic_allocate_context(void);
dmm_usr_ctxt_t *dmm_lic_find_context(uint32_t xid);
dmm_usr_ctxt_t *dmm_lic_get_valid_context();

#endif /* __DMM_LIC_CTXT_H__ */
