
#!/bin/sh
#   This is the POST1 script generated through XSL for BUILDID: 161
#
#   Required local variables
#
nPost=0
exit_status=0
slot=0
slot_message=""
blade=
logFile=/tmp/post1Log


#
#	Check for fwdl in progress
#
baddev=`bootenv BadRootDev 2>/dev/null`
softupgrade=`bootenv SoftUpgrade 2>/dev/null`

#
#   getPlatform() function
#
getPlatform()
{
#
#   Should be pizzabox
#
if [ $1 == 0 ]
then
_abc=`/sbin/sin | \
    /bin/grep Platform | \
    /usr/bin/cut -d" " -f2 | \
    /usr/bin/cut -d"," -f1`

case $_abc in

"SWBD162" )
blade="WEDGE64"
;;

"SWBD169" )
blade="CHEWBACCA"
;;

"SWBD170" )
blade="CHEWBACCA24"
;;

* )
blade="UNKNOWN"
;;
esac

else
#
#   Should be chassis
#
case $2 in

"171" )
blade="WEDGE64"
;;

"190" )
blade="CHEWBACCA"
;;

"196" )
blade="CHEWBACCA24"
;;

* )
blade="UNKNOWN"
;;
esac

fi
}

#
#   Post_cleanup() function
#
post_cleanup()
{
    if [ $?child ]
    then
        /bin/kill $child
    fi

    #
    #  display all performed test result
    #
    _current_time=`/bin/date \+\%s`
    _date=`/bin/date`
    _duration=`/usr/bin/expr $_current_time - $startTime`
    _minute=`/usr/bin/expr $_duration / 60`
    _hour=`/usr/bin/expr $_minute / 60`
    _sec=`/usr/bin/expr $_duration % 60`
    _minute=`/usr/bin/expr $_minute % 60`
    /bin/echo "POST1:$slot_message script has been ABORTED $_date took ($_hour:$_minute:$_sec)"
    /bin/echo "POST1:$slot_message script has been ABORTED $_date took ($_hour:$_minute:$_sec)" >> $logFile.$slot
    /bin/echo "POST1:$slot_message Completed totally $nPost diagnostic tests..."
    /bin/echo "POST1:$slot_message Completed totally $nPost diagnostic tests..." >> $logFile.$slot
    if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "PHAROS" ] || [ "$blade" = "PHAROS_LITE" ] || [ "$blade" = "BLAZER3" ] || [ "$blade" = "KESTREL3" ] ; }
    then
    	$smmi -reg DIAG_STATUS_ID -data POST_FAILINIT
    fi
    if [ "$blade" = "SHENLONG" ]
    then
    	$smmi -reg DIAG_STATUS_ID -data POST_FAILINIT
    	/bin/echo "Shenlong POST1:set IAG_STATUS_ID -data POST_FAILINIT" >>  $logFile.$slot
    fi
    exit 1
}

#
#   checkStatus of the command and setup exit_status variable
#
checkStatus()
{
    export child=$!
    wait $child
    rval=$?

    case $rval in
    139 | 237 )
        /bin/echo "POST1:$slot_message $* SKIPPED due to known issue ($rval). Please, run following command manually..."
        /bin/echo "POST1:$slot_message $* SKIPPED due to known issue ($rval). Please, run following command manually..." >>  $logFile.$slot
        ;;
    0 )
        status=PASSED
        ;;
    * )
        status=FAILED
        exit_status=`/usr/bin/expr $exit_status + 1`
	    if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "BLAZER3" ] ; }
	    then
	        $smmi -reg DIAG_STATUS_ID -data $1 
        fi
        if { [ "$blade" = "PHAROS" ] || [ "$blade" = "PHAROS_LITE" ] ; }
        then
            $smmi -reg DIAG_STATUS_ID -data POST1_FAIL1
            exit $exit_status
        fi
        if [ "$blade" = "SHENLONG" ] 
	    then
	        $smmi -reg DIAG_STATUS_ID -data $1 
	        /bin/echo "Shenlong POST1: set DIAG_STATUS_ID -data command_args 1" >>  $logFile.$slot
        fi
	    ;;
    esac

    if [ $rval -gt 127 ]
    then
        rval=`/usr/bin/expr $rval - 256`
    fi

    /bin/echo "POST1:$slot_message Test: $* Status: $status (exit_status $rval)..." >> $logFile.$slot
    /bin/echo "$status" >> $logFile.$slot.$status
}

trap "" 2
trap post_cleanup INT TERM KILL

#
#   Fill slot variable from FABOS_SLOTNO
#
if [ $?FABOS_SLOTNO ]
then
    slot=$FABOS_SLOTNO
fi
#
#   Fill bladeId variable from Param passed
#
if [ -n "$1" ]
then
    bladeId=$1
fi

#
#   Identify blade here
#
getPlatform $slot $bladeId

#
#   Cleanup the old log file
#
if [ -f $logFile.$slot ]
then
    /bin/rm $logFile.$slot
fi

if [ $blade = UNKNOWN ]; then
    /bin/echo "POST1: Blade is UNKNOWN Slot=$slot Blade=$blade" >> $logFile.$slot
    #   Not an error; We dont define the platform, POST1 test list; We continue to enable the blade/system
    sleep 5
    exit 0
fi

#
#	Prevent post from running when fw commit is in progress
#
#if [ -n "$baddev" -o -n "$softupgrade" ]
#then
#	/bin/touch /tmp/fwcommit
#fi

#if [ -f "/tmp/fwcommit" ]
#then
#	/bin/echo "POST1 skipped due to firmwarecommit in progress $_date" >> $logFile.$slot
#	sleep 5
#	exit 0
#fi

#
#   Sourcing diagcommon.sh
#
home="/fabos/share"
util="diagcommon.sh"
ok=0
for f in "./$util" "$FABOSHOME/share/$util" "$home/$util" ; do
    if [ -r $f ] ; then
        . $f
        ok=1
        break;
    fi
done
if [ $ok -ne 1 ] ; then
    /bin/echo "POST1: Could not locate $util; Aborting"
    /bin/echo "POST1: Could not locate $util; Aborting" >> $logFile.$slot
    exit 3
fi

#
#  Check post level control register from FPGA 0xc0
#  if 0x00 or 0x01 exit post1
#
smmi=`commandPath setmmi`
gmmi=`commandPath getmmi`
setdbg=`commandPath setdbg`
$setdbg DIAG 1
if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "KESTREL3" ] ; }
then
  state=`$gmmi -reg "POST CONFIG"| cut -d" " -f2`
  state1=`expr $state / 63`
   case $state1 in
        0 | 1 ) exit 0;;
	     *) ;;
   esac
fi
if { [ "$blade" = "PHAROS" ] || [ "$blade" = "PHAROS_LITE" ] || [ "$blade" = "BLAZER3" ] ; }
then
    state=`$gmmi -reg "POST CONFIG"| cut -d" " -f2`
    case $state in
        0 | 1 ) exit 0;;
        *) ;;
    esac
fi
if [ "$blade" = "SHENLONG" ]
then
  state=`$gmmi -reg "POST CONFIG"| cut -d" " -f2`
  /bin/echo "Shenlong POST1: get "POST CONFIG"" >>  $logFile.$slot
  state1=`expr $state / 63`
  case $state1 in
        0 | 1 ) exit 0;;
	     *) ;;
   esac
fi

#
#   Check Pizzabox/Chassis variant during runtime; isMultiBlade is defined in diagcommon.sh
#   Also setup slot_message variable
#
multiBlade=`isMultiBlade`
if [ $multiBlade = TRUE ]
then
    slot_message="Slot $slot"
    export syntax="$0 -slot [slot] essScript"
else
    export syntax="$0 essScript"
fi

#
#   Export Environment variables
#
DIAG_POST=1 ; export DIAG_POST
DIAG_USR_FAILLIM=1 ; export DIAG_USR_FAILLIM

#
#   Add blade identifiers to our Log file for debugging purpose; Zero means pizzabox
#
/bin/echo "POST1:$slot_message running for platform: $blade, Slot#: $slot, Logfile: $logFile"  >> $logFile.$slot

#
#   Setup commandPaths
#
cmd=`commandPath exec_diag`
setdbg=`commandPath setdbg`
$setdbg DIAG 1

#
#   Start message to the user
#
startTime=`/bin/date \+\%s`
_date=`/bin/date`
/bin/echo "" >> $logFile.$slot
/bin/echo "POST1:$slot_message started running $_date"
/bin/echo "POST1:$slot_message started running $_date" >> $logFile.$slot
if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "PHAROS" ] || [ "$blade" = "PHAROS_LITE" ] || [ "$blade" = "BLAZER3" ] || [ "$blade" = "KESTREL3" ] ; }
then
     $smmi -reg DIAG_STATUS_ID -data POST_INIT
fi

if [ "$blade" = "SHENLONG" ]
then
     $smmi -reg DIAG_STATUS_ID -data POST_INIT
     /bin/echo "Shenlong POST1:set DIAG_STATUS_ID -data POST_INIT" >>  $logFile.$slot
fi
#
#   Check whether VF is enabled
#   If VF enabled, get the number fabid of the default switch
#   from a parse of the lscfg --show command.
#
VFOUTPUT=`lscfg --show 2> /dev/null`

if [ "$VFOUTPUT" != "" ]
then
	fabid=`lscfg --show | \
	/bin/grep ds | \
	/usr/bin/tr " " "\n" | \
	/bin/grep ds | \
	/usr/bin/cut -d"(" -f1`
	if [ $fabid -ne $CURRENT_VF ]
	then
		export CURRENT_VF=$fabid
	fi
fi

#
#   Reset Error on each port
#
/bin/echo "POST1:$slot_message Clearing errors" >> $logFile.$slot
$cmd diagclearerror $slot > /dev/null


if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "PHAROS" ] || [ "$blade" = "PHAROS_LITE" ] || [ "$blade" = "BLAZER3" ] || [ "$blade" = "KESTREL3" ] ; }
then
      $smmi -reg DIAG_STATUS_ID -data POST_TEST1
fi

if [ "$blade" = "SHENLONG" ]
then
      $smmi -reg DIAG_STATUS_ID -data POST_TEST1
      /bin/echo "Shenlong POST1:set DIAG_STATUS_ID -data POST_TEST1" >>  $logFile.$slot
fi
#
#   Execute command-set as per platform
#
case $blade in

#
#   Platform: Platform name not found
#
"UNKNOWN" )
echo "POST1 Script error: Could not determine blade (Parameters: Slot=$slot, Blade=$blade). Aborting" >> $logFile.$slot
exit 4
;;


#
#   Platform: WEDGE64
#
"WEDGE64" )

#
#   Test: Setupfortest
#

cmd3=`commandPath exec_diag`

_date=`/bin/date`
/bin/echo "POST1:$_date:$slot_message Test - Running Setupfortest (Silent)" >> $logFile.$slot
$cmd3 usdsetupfortest --slot $slot -test_step 2 -post 1 >> $logFile.$slot
status_local=$?

if [ $status_local -ne 0 ]
then 
    exit_status=`/usr/bin/expr $exit_status + 1`
fi

#
#   Test: Turboramtest
#

cmd3=`commandPath exec_diag`

nPost=`/usr/bin/expr $nPost + 1`
_date=`/bin/date`
/bin/echo "POST1:$_date:$slot_message Test #$nPost - Running Turboramtest" >> $logFile.$slot
/bin/echo "POST1:$_date:$slot_message Test #$nPost - Running Turboramtest"
$cmd3 turboramtest 2>&1 >> $logFile.$slot &
checkStatus turboramtest 2>&1
;;

#
#   Platform: CHEWBACCA
#
"CHEWBACCA" )

#
#   Test: Setupfortest
#

cmd3=`commandPath exec_diag`

_date=`/bin/date`
/bin/echo "POST1:$_date:$slot_message Test - Running Setupfortest (Silent)" >> $logFile.$slot
$cmd3 usdsetupfortest --slot $slot -test_step 2 -post 1 >> $logFile.$slot
status_local=$?

if [ $status_local -ne 0 ]
then 
    exit_status=`/usr/bin/expr $exit_status + 1`
fi

#
#   Test: Turboramtest
#

cmd3=`commandPath exec_diag`

nPost=`/usr/bin/expr $nPost + 1`
_date=`/bin/date`
/bin/echo "POST1:$_date:$slot_message Test #$nPost - Running Turboramtest" >> $logFile.$slot
/bin/echo "POST1:$_date:$slot_message Test #$nPost - Running Turboramtest"
$cmd3 turboramtest 2>&1 >> $logFile.$slot &
checkStatus turboramtest 2>&1
;;

#
#   Platform: CHEWBACCA24
#
"CHEWBACCA24" )

#
#   Test: Setupfortest
#

cmd3=`commandPath exec_diag`

_date=`/bin/date`
/bin/echo "POST1:$_date:$slot_message Test - Running Setupfortest (Silent)" >> $logFile.$slot
$cmd3 usdsetupfortest --slot $slot -test_step 2 -post 1 >> $logFile.$slot
status_local=$?

if [ $status_local -ne 0 ]
then 
    exit_status=`/usr/bin/expr $exit_status + 1`
fi

#
#   Test: Turboramtest
#

cmd3=`commandPath exec_diag`

nPost=`/usr/bin/expr $nPost + 1`
_date=`/bin/date`
/bin/echo "POST1:$_date:$slot_message Test #$nPost - Running Turboramtest" >> $logFile.$slot
/bin/echo "POST1:$_date:$slot_message Test #$nPost - Running Turboramtest"
$cmd3 turboramtest 2>&1 >> $logFile.$slot &
checkStatus turboramtest 2>&1
;;

esac

if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "PHAROS" ] || [ "$blade" = "PHAROS_LITE" ] || [ "$blade" = "BLAZER3" ] || [ "$blade" = "KESTREL3" ] ; }
then
    $smmi -reg DIAG_STATUS_ID -data POST_TEST2

    if [ $exit_status -ne 0 ]
    then 
        $smmi -reg DIAG_STATUS_ID -data POST_FAIL2
    fi 
fi

if [ "$blade" = "SHENLONG" ]
then
    $smmi -reg DIAG_STATUS_ID -data POST_TEST2
    /bin/echo "Shenlong POST1:set DIAG_STATUS_ID -data POST_TEST2" >>  $logFile.$slot
    if [ $exit_status -ne 0 ]
    then 
        $smmi -reg DIAG_STATUS_ID -data POST_FAIL2
        /bin/echo "Shenlong POST1:set DIAG_STATUS_ID -data POST_FAIL2"
    fi 
fi

#
#   Display completed test count
#
/bin/echo "POST1:$slot_message  ********** $slot_message POST Summary  **********" >> $logFile.$slot
/bin/echo "POST1:$slot_message Completed totally $nPost diagnostic tests..." >> $logFile.$slot

#
#   If exit_status > 0, report FAILED
#
if [ $exit_status -ne 0 ]
then
    status=FAILED
	#	copy the POST log to permanent storage for FA
	/fabos/link_bin/sync
	/bin/cp $logFile.$slot /var/log
	/fabos/link_bin/sync
else
    status=PASSED
fi

#
#   Display final exit_status
#
_current_time=`/bin/date \+\%s`
_date=`/bin/date`
_duration=`/usr/bin/expr $_current_time - $startTime`
_minute=`/usr/bin/expr $_duration / 60`
_hour=`/usr/bin/expr $_minute / 60`
_sec=`/usr/bin/expr $_duration % 60`
_minute=`/usr/bin/expr $_minute % 60`
/bin/echo "POST1:$slot_message Script $status with exit status of $exit_status $_date took ($_hour:$_minute:$_sec)"
/bin/echo "POST1:$slot_message Script $status with exit_status of $exit_status $_date took ($_hour:$_minute:$_sec)" >> $logFile.$slot
/bin/echo "" >> $logFile.$slot

#
#   Return with the error code (Zero shows no error)
#
exit $exit_status
