#! /bin/sh
DEFAULTFREQ=60   # Default frequency is 60 minutes ( once per hour)
runno=1
MTRACER=0
if [ ! -d /var/log/mstatdir ]; then
	/bin/mkdir /var/log/mstatdir
fi
/bin/cat /proc/cmdline | /bin/grep -q MEMDUMPENABLE
if [ $? -eq 0 ]; then
    MDUMPEN=`/bin/cat /proc/cmdline | /bin/sed 's:^.*MEMDUMPENABLE=\([YyNn]*\):\1:'`
    if [[ $MDUMPEN == [Nn][oO]* ]]; then
    	    echo " Memory Dump disabled" >> /var/log/mstatdir/memorystatus
	    exit 0;
    fi
fi

export FABOS_SWITCHNO=-1
export CURRENT_VF=255
export CHASSIS_ROLEID=0
export ROLE_ID=root

/bin/cat /proc/cmdline | /bin/grep -q MSTATFREQ
if [ $? -eq 0 ]; then
    MEMDUMPFREQ=`/bin/cat /proc/cmdline | /bin/sed 's:^.*MSTATFREQ=\([0-9]\+\).*:\1:'`
    if [ -z "${MEMDUMPFREQ}" ] || [ -z "${MEMDUMPFREQ+xxx}" ]; then
	    MEMDUMPFREQ=$DEFAULTFREQ;
    fi
    echo "Using command line value of $MEMDUMPFREQ minutes to dump memory status" >> /var/log/mstatdir/memorystatus
else
    MEMDUMPFREQ=$DEFAULTFREQ;
    echo "Using Default value of $MEMDUMPFREQ minutes to dump memory status" >> /var/log/mstatdir/memorystatus
fi

if [ "`bootenv bootargs |grep fablog`" != "" ]; then
	str=`bootenv bootargs`
	for i in $str; do
		if echo $i | grep fablog &> /dev/null; then
			MTRACER=`echo $i |grep fablog | awk '{print $1}' | cut -d "=" -f 2 2> /dev/null`
		fi
	done
fi

#if the frequency of data collection is more than once every 10 minutes, we rotate the logs every hour
if [ "${MEMDUMPFREQ}" -lt 10 ]; then
    if [ -f /etc/cron.daily/logrotate ]; then 
	/bin/mv /etc/cron.daily/logrotate /etc/cron.hourly/logrotate
    fi
    /bin/sync;
    echo "Rotating the logs every hour due to user setting" >> /var/log/mstatdir/memorystatus
else 
    if [ -f /etc/cron.hourly/logrotate ]; then
	/bin/mv /etc/cron.hourly/logrotate /etc/cron.daily/logrotate
    fi
    /bin/sync;
fi
#while [ 1 ] ;
#do
#	echo "Running memorystatus daemon ";
	if [ $MTRACER -eq 2 ]; then
		echo "Output of /proc/fablog/kmem/vstats: `date +%F--%T`" >> /var/log/mstatdir/memorystatus
		echo "===============================================" >> /var/log/mstatdir/memorystatus
		cat /proc/fablog/kmem/vstats >> /var/log/mstatdir/memorystatus
		echo "" >> /var/log/mstatdir/memorystatus
		echo "Output of /proc/fablog/kmem/kstats: `date +%F--%T`" >> /var/log/mstatdir/memorystatus
		echo "===============================================" >> /var/log/mstatdir/memorystatus
		cat /proc/fablog/kmem/kstats >> /var/log/mstatdir/memorystatus
		echo "" >> /var/log/mstatdir/memorystatus
	fi
	echo "Output of /proc/buddyinfo: `date +%F--%T`" >> /var/log/mstatdir/memorystatus
	echo "===============================================" >> /var/log/mstatdir/memorystatus
	cat /proc/buddyinfo >> /var/log/mstatdir/memorystatus
	echo "" >> /var/log/mstatdir/memorystatus
#cache memory check
        totalmem=`cat /proc/meminfo | grep MemTota | awk '{print $2}'`
        cachemem=`cat /proc/meminfo | grep -i cached | grep -v Swap | awk '{print $2}'`
        freemem=`cat /proc/meminfo | grep MemFree | awk '{print $2}'`
        let fthresh=($totalmem * 10)/100
        let cthresh=($totalmem * 35)/100
        if [ $freemem -lt $fthresh -a $cachemem -gt $cthresh ]; then
                echo "Cache size more than threshold : $cthresh . Clearing it" >> /var/log/mstatdir/memorystatus	
		echo "Output of /proc/meminfo: `date +%F--%T`" >> /var/log/mstatdir/memorystatus
		echo "=============================================" >> /var/log/mstatdir/memorystatus
		cat /proc/meminfo  >> /var/log/mstatdir/memorystatus
		echo 3 > /proc/sys/vm/drop_caches
	fi;
	echo "" >> /var/log/mstatdir/memorystatus
	echo "PageAllocator Info: `date +%F--%T`" >> /var/log/mstatdir/memorystatus
	echo "===============================================" >> /var/log/mstatdir/memorystatus
	cat /proc/buddyinfo | grep DMA | awk '{ for(i = 1; i < NF; i++) { if (i > 4) { SUM += $i * (2 ** (i - 5))} } } END { print  "Mem available in page allocator: " SUM / 256 "MB "}' >> /var/log/mstatdir/memorystatus
	echo "" >> /var/log/mstatdir/memorystatus
	echo "Output of /proc/meminfo: `date +%F--%T`" >> /var/log/mstatdir/memorystatus
	echo "=============================================" >> /var/log/mstatdir/memorystatus
	cat /proc/meminfo  >> /var/log/mstatdir/memorystatus
	echo "" >> /var/log/mstatdir/memorystatus
    if [ -f "/proc/vmallocinfo" ]; then
	echo "Output of /proc/vmallocinfo: `date +%F--%T`" >> /var/log/mstatdir/memorystatus
	echo "=============================================" >> /var/log/mstatdir/memorystatus
	cat /proc/vmallocinfo | awk '{ SUM += $2} END { print " "; print "Mem used in Vmalloc: " SUM / 1048576 "MB "}' >> /var/log/mstatdir/memorystatus
	echo "" >> /var/log/mstatdir/memorystatus
    fi;
    if [ -f "/bin/slabinfo" ]; then
	echo "Output of /bin/slabinfo (Top 20): `date +%F--%T`" >> /var/log/mstatdir/memorystatus
	echo "=====================================================" >> /var/log/mstatdir/memorystatus
	/bin/slabinfo -S | head -20 >> /var/log/mstatdir/memorystatus
	echo "" >> /var/log/mstatdir/memorystatus
    fi;
	echo "Output of /proc/slabinfo MEM used in SLUB: `date +%F--%T`" >> /var/log/mstatdir/memorystatus
	echo "=====================================================" >> /var/log/mstatdir/memorystatus
	cat /proc/slabinfo | grep -v "<active_objs>" | awk '{ SUM += $3 * $4} END {print " "; print "Mem used in SLUB: " SUM / 1048576 "MB"}' >> /var/log/mstatdir/memorystatus
	echo "" >> /var/log/mstatdir/memorystatus
    if [ -f "/bin/procrank" ]; then
	echo "procrank_startrun_$runno" >> /var/log/mstatdir/memorystatus
	echo "Output of /bin/procrank: `date +%F--%T`" >> /var/log/mstatdir/memorystatus
	echo "======================================================" >> /var/log/mstatdir/memorystatus
	/bin/procrank -R     >> /var/log/mstatdir/memorystatus
	echo "procrank_endrun_$runno" >> /var/log/mstatdir/memorystatus
	echo "" >> /var/log/mstatdir/memorystatus
    fi;
	if [ -d "/proc/mlt" ]; then
		echo "Output of /bin/mlt -s 20 (Top 20): `date +%F--%T`" >> /var/log/mstatdir/memorystatus
		echo "=======================================================" >> /var/log/mstatdir/memorystatus
		/bin/mlt -s 20 >> /var/log/mstatdir/memorystatus
		export memrows=`/bin/mlt -s 20 | awk '{if(NR > 9) print $0}' | head -n -16 | awk -f /usr/bin/awkmemstatus`;
		if [ ! -z "${memrows}" ]; then
		echo "" >> /var/log/mstatdir/memorystatus
		echo "Rows $memrows  are more than threshold 50MB" >> /var/log/mstatdir/memorystatus ;
		for i in ${memrows}
		do
			/bin/mlt -d $i  >> /var/log/mstatdir/memorystatus
			echo "" >> /var/log/mstatdir/memorystatus
		done;
		fi;
		echo "" >> /var/log/mstatdir/memorystatus
		echo "Output of /bin/mlt -t 20 (Top 20): `date +%F--%T`" >> /var/log/mstatdir/memorystatus
		echo "=======================================================" >> /var/log/mstatdir/memorystatus
		/bin/mlt -t 20 >> /var/log/mstatdir/memorystatus
		export kmallocrows=`/bin/mlt -t 20 | awk '{if(NR > 9) print $0}' | head -n -16 | awk -f /usr/bin/awkkmalloccount`;
	fi

	if [ -d "/proc/mlt_kl" ]; then
		echo "Output of /bin/mlt_kl -s 20 (Top 20): `date +%F--%T`" >> /var/log/mstatdir/memorystatus
		echo "=======================================================" >> /var/log/mstatdir/memorystatus
		/bin/mlt_kl -s 20 >> /var/log/mstatdir/memorystatus
		export memrows=`/bin/mlt_kl -s 20 | awk '{if(NR > 6) print $0}' | awk -f /usr/bin/awkmemstatus`;
		if [ ! -z "${memrows}" ]; then
		echo "" >> /var/log/mstatdir/memorystatus
		echo "Rows $memrows  are more than threshold 50MB" >> /var/log/mstatdir/memorystatus ;
		for i in ${memrows}
		do
			/bin/mlt_kl -d $i  >> /var/log/mstatdir/memorystatus
			echo "" >> /var/log/mstatdir/memorystatus
		done;
		fi;
		echo "" >> /var/log/mstatdir/memorystatus
		echo "Output of /bin/mlt_kl -t 20 (Top 20): `date +%F--%T`" >> /var/log/mstatdir/memorystatus
		echo "=======================================================" >> /var/log/mstatdir/memorystatus
		/bin/mlt_kl -t 20 >> /var/log/mstatdir/memorystatus
		export kmallocrows=`/bin/mlt_kl -t 20 | awk '{if(NR > 6) print $0}' | awk -f /usr/bin/awkkmalloccount`;

		if [ ! -z "${kmallocrows}" ]; then
		echo "" >> /var/log/mstatdir/memorystatus
		echo "Rows $kmallocrows  are more than threshold 20K" >> /var/log/mstatdir/memorystatus ;
		for i in ${kmallocrows}
		do
			/bin/mlt_kl -d $i  >> /var/log/mstatdir/memorystatus
			echo "" >> /var/log/mstatdir/memorystatus
		done;
		fi;
	fi

	if [ -d "/proc/mlt_vm" ]; then
		echo "Output of /bin/mlt_vm -s 20 (Top 20): `date +%F--%T`" >> /var/log/mstatdir/memorystatus
		echo "=======================================================" >> /var/log/mstatdir/memorystatus
		/bin/mlt_vm -s 20 >> /var/log/mstatdir/memorystatus
		export memrows=`/bin/mlt_vm -s 20 | awk '{if(NR > 6) print $0}' | awk -f /usr/bin/awkmemstatus`;
		if [ ! -z "${memrows}" ]; then
		echo "" >> /var/log/mstatdir/memorystatus
		echo "Rows $memrows  are more than threshold 50MB" >> /var/log/mstatdir/memorystatus ;
		for i in ${memrows}
		do
			/bin/mlt_vm -d $i  >> /var/log/mstatdir/memorystatus
			echo "" >> /var/log/mstatdir/memorystatus
		done;
		fi;
		echo "" >> /var/log/mstatdir/memorystatus
		echo "Output of /bin/mlt_vm -t 20 (Top 20): `date +%F--%T`" >> /var/log/mstatdir/memorystatus
		echo "=======================================================" >> /var/log/mstatdir/memorystatus
		/bin/mlt_vm -t 20 >> /var/log/mstatdir/memorystatus
		export kmallocrows=`/bin/mlt_vm -t 20 | awk '{if(NR > 6) print $0}' | awk -f /usr/bin/awkkmalloccount`;

		if [ ! -z "${kmallocrows}" ]; then
		echo "" >> /var/log/mstatdir/memorystatus
		echo "Rows $kmallocrows  are more than threshold 20K" >> /var/log/mstatdir/memorystatus ;
		for i in ${kmallocrows}
		do
			/bin/mlt_vm -d $i  >> /var/log/mstatdir/memorystatus
			echo "" >> /var/log/mstatdir/memorystatus
		done;
		fi;
	fi
    echo "" >> /var/log/mstatdir/memorystatus
	echo "Ten big files in /tmp: `date +%F--%T`" >> /var/log/mstatdir/memorystatus
	echo "============================================" >> /var/log/mstatdir/memorystatus
	/bin/ls -lrS /tmp | tail -10  >> /var/log/mstatdir/memorystatus
	echo "" >> /var/log/mstatdir/memorystatus
	echo "-------------------------------------------------------------------------------" >> /var/log/mstatdir/memorystatus
	echo "" >> /var/log/mstatdir/memorystatus

	echo "" >> /var/log/mstatdir/memorystatus

	if [ -f /fabos/cliexec/esmcmd ]; then
		echo "Extension Memory Usage: `date +%F--%T`" >> /var/log/mstatdir/memorystatus
		echo "============================================" >> /var/log/mstatdir/memorystatus
		echo "ESMd Memory Usage:" >> /var/log/mstatdir/memorystatus
		/fabos/cliexec/esmcmd mem info >> /var/log/mstatdir/memorystatus
		echo "" >> /var/log/mstatdir/memorystatus
		echo "DP Memory Pools:" >> /var/log/mstatdir/memorystatus
		/fabos/cliexec/esmcmd dbgcmd pools >> /var/log/mstatdir/memorystatus
		echo "" >> /var/log/mstatdir/memorystatus
		echo "DP DRAM2 Memory:" >> /var/log/mstatdir/memorystatus
		/fabos/cliexec/esmcmd dbgcmd dram2 >> /var/log/mstatdir/memorystatus
		echo "" >> /var/log/mstatdir/memorystatus
	fi

	#sleep $((MEMDUMPFREQ * 60));
	#runno=$((runno + 1));
#done;
