#!/bin/bash
export PATH=/bin:/usr/bin:/usr/sbin:/fabos/bin:/fabos/link_bin:
export ROLE_ID=root

isVFEnabled=0
STS_ERR=255
STS_OK=0
SPSM_RECORD_FABRIC_1="/var/log/spsm_record_fabric_1"
SPSM_RECORD_FABRIC_2="/var/log/spsm_record_fabric_2"
SPSM_RECORD_MGMT_1="/var/log/spsm_record_mgmt_1"
SPSM_RECORD_MGMT_2="/var/log/spsm_record_mgmt_2"
tempfile="/tmp/spsm_tempfile`/bin/date +\"%s\"`"
typeset -i alive=0
STATUS[0]="Idle"
STATUS[1]="Active"
#Management Policy Variables
IDLE_SHELL_SESSIONS=0
ACTIVE_SHELL_SESSIONS=0
typeset -i APP_SESSIONS=0
standby=no;

#Fabric Policy Variables
FPORTS_CHASSIS=0
FID_LIST="128"

setcontext() {
	if [ "$1" != "chassis" ]
	then
		SW_CONTEXT_RC=`lscfg_util --switch $1`
		eval $(lscfg_util --switch $1)
	else
		eval $(lscfg_util --chassis)
	fi
	export ROLE_ID=root
}

for_all_contexts() {
	if [ $isVFEnabled == 1 ] ; then
	
		for FID in ${FID_LIST} ; do
			setcontext $FID
			export ROLE_ID=root
			$@
		done
	else
		export ROLE_ID=root
		$@
	fi
}

preRequisites() {
	if [ -e /fabos/link_sbin/lscfg_test ]
	then
		/bin/rm /fabos/link_sbin/lscfg_test
	fi

	/bin/ln -s /fabos/cliexec/lscfg_util /fabos/link_sbin/lscfg_test 2> spsm_tmpfile
	export PATH=/fabos/link_bin:/bin:/usr/bin:/sbin:/usr/sbin:/fabos/link_abin:/fabos/link_sbin:/fabos/link_rbin:/fabos/factory:/fabos/xtool
	if [ "$(lscfg_test --vf_enabled 2> spsm_tmpfile)" = 'VF is enabled.' ]; then
		HOME_VF=128
		setcontext chassis
		export HOME_VF
		isVFEnabled=1
		FID_LIST=$(lscfg_test --all | awk ' / [0-9] / {print $2} ')
	else
		HOME_VF=
		export HOME_VF
		CURRENT_VF=128
	fi
	/fabos/cliexec/hashow | grep Local | grep Standby > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		standby=yes;
	fi

	rm spsm_tmpfile
}

record_shell_sessions() {
	typeset -i i=1 
	date >> $SPSM_RECORD_MGMT_1
	echo -e "\n Shell sessions:" >> $SPSM_RECORD_MGMT_1
	echo -e "  Shell Sessions Count: "$SessionsCount", Idle "$IDLE_SHELL_SESSIONS", Active "$ACTIVE_SHELL_SESSIONS"\n" >> $SPSM_RECORD_MGMT_1
	echo -e	"  STATUS\tTTY\tIDLE_TIME\tFROM" >> $SPSM_RECORD_MGMT_1
    while [ $i -le "$idle_session_count" ]
	do 
		echo -e "  Idle\t\t"${idle_tty[$i]}"\t"${idle_session_time[$i]}"\t\t"${idle_from[$i]}"" >> $SPSM_RECORD_MGMT_1
		i=i+1
	done

	typeset -i i=1 
    while [ $i -le "$active_session_count" ]
	do 
		echo -e "  Active\t"${active_tty[$i]}"\t"${active_session_time[$i]}"\t\t"${active_from[$i]}"" >> $SPSM_RECORD_MGMT_1
		i=i+1
	done
	echo -e "\n"  >> $SPSM_RECORD_MGMT_1
}

scan_shell_sessions() {
	LOC_FILE="/tmp/spsm_wout.`/bin/date +\"%s\"`"

	SessionsCount=0
	idle_session_count=0
	active_session_count=0
	typeset -i i=0
	typeset -i active_session_count=0
	typeset -i idle_session_count=0
	/usr/bin/w -fh > ${LOC_FILE}
	{
		while read u_a[$i] tty_a[$i] from_a[$i] login_a[$i] idle_a[$i] j_a[$i] p_a[$i] c_a[$i]
		do
			idle_time=${idle_a[$i]}
			case $idle_time in
				# No need to compare with scan period for session idle for days.
				# The scan period range from 1 to 24 hours.
				*days)
					idle_session_count=idle_session_count+1
					idle_session_time[$idle_session_count]=$idle_time
					idle_tty[$idle_session_count]=${tty_a[$i]}
					idle_from[$idle_session_count]=${from_a[$i]}
					;;
				#The session which are idle for hours compare with scan period to mark it idle.
				*m)
					temp=`echo $idle_time | cut -f 1 -d m`
					hrs=${temp%:*}
					mins=${temp#*:}
					current_period=`expr $hrs \* 60 \* 60 + $mins \* 60`
					if [ $current_period -ge $scan_period ]
					then
						idle_session_count=idle_session_count+1
						idle_session_time[$idle_session_count]=$idle_time
						idle_tty[$idle_session_count]=${tty_a[$i]}
						idle_from[$idle_session_count]=${from_a[$i]}
					else
						active_session_count=active_session_count+1
						active_session_time[$active_session_count]=$idle_time
						active_tty[$active_session_count]=${tty_a[$i]}
						active_from[$active_session_count]=${from_a[$i]}
					fi
					
					;;
				# The sessions which are idle only for few minutes and seconds are considered active.
				# No need of comparison with scan period.
				# Ends with s means seconds. No string is minutes.
				*s)
					temp=`echo $idle_time | cut -f 1 -d s`
					secs=${temp%.*}
					if [ $secs -ge $scan_period ]
					then
						idle_session_count=idle_session_count+1
						idle_session_time[$idle_session_count]=$idle_time
						idle_tty[$idle_session_count]=${tty_a[$i]}
						idle_from[$idle_session_count]=${from_a[$i]}
					else
						active_session_count=active_session_count+1
						active_session_time[$active_session_count]=$idle_time
						active_tty[$active_session_count]=${tty_a[$i]}
						active_from[$active_session_count]=${from_a[$i]}
					fi
					;;
				*)
					temp=$idle_time
					mins=${temp%:*}
					secs=${temp#*:}
					current_period=`expr $mins \* 60 + $secs`
					if [ $current_period -ge $scan_period ]
					then
						idle_session_count=idle_session_count+1
						idle_session_time[$idle_session_count]=$idle_time
						idle_tty[$idle_session_count]=${tty_a[$i]}
						idle_from[$idle_session_count]=${from_a[$i]}
					else	
						active_session_count=active_session_count+1
						active_session_time[$active_session_count]=$idle_time
						active_tty[$active_session_count]=${tty_a[$i]}
						active_from[$active_session_count]=${from_a[$i]}
					fi
					;;
			esac
			i=i+1
		done
	} < ${LOC_FILE}
	SessionsCount=$i
	IDLE_SHELL_SESSIONS=$idle_session_count
	ACTIVE_SHELL_SESSIONS=$active_session_count
#	printf "SessionsCount %d Idle %d Active %d\n" "$SessionsCount" "$idle_session_count" "$active_session_count"
	record_shell_sessions
	/bin/rm $LOC_FILE
}

#APP_SESSIONS
scan_app_sessions() {
	if [ -x "/fabos/sbin/webdhelper" ]; then
		TEST=1
	else
		ln -s /fabos/libexec/webdconfigure /fabos/sbin/webdhelper
	fi
	/fabos/sbin/webdhelper webdstore printAll 1 > $tempfile
	APP_SESSIONS=`cat $tempfile | grep "Total items in store DB:" | cut -f 6 -d " "`
	echo -e " Application sessions:" >> $SPSM_RECORD_MGMT_1
	echo -e "  Application sessions count: $APP_SESSIONS\n" >> $SPSM_RECORD_MGMT_1
	cat $tempfile | \
		awk ' /SessionIp|User|AgentName|LoginTimeStamp|SessionId|Current_VF/ {print " ", $0} \
			  /Timeleft/ {printf "\t  %s\n\n", $0} ' | tr '\t' ' '  >> $SPSM_RECORD_MGMT_1
	rm $tempfile
}


Mgmt_policy() {
	if [ $isVFEnabled == 1 ] ; then
		setcontext chassis
	fi
	mv $SPSM_RECORD_MGMT_1 $SPSM_RECORD_MGMT_2 2>/dev/null
	scan_shell_sessions
	if [ $standby = no ]
	then
		scan_app_sessions
	fi
	if [ $ACTIVE_SHELL_SESSIONS -ne 0 ] || [ $APP_SESSIONS -ne 0 ]
	then
		alive=1
	else
		alive=0
	fi
	echo " Management Policy status: ${STATUS[$alive]}" >> $SPSM_RECORD_MGMT_1
#	printf "ActiveShells %d ActiveApps %d\n" "$ACTIVE_SHELL_SESSIONS" "$APP_SESSIONS"
#	cat $SPSM_RECORD_MGMT_1
}

scan_FPORTS() {
	switchshow > $tempfile 2>&1

	count=`cat $tempfile | grep F-Port | wc -l | tr -d ' '`
	FPORTS_CHASSIS=`expr $FPORTS_CHASSIS + $count`
	FPORT_COUNT[$CURRENT_VF]=$count;
	FPORTS[$CURRENT_VF]=`cat $tempfile |  grep "F-" | awk ' / [0-9]. / {print $1}' | tr '\n' ' '`

	rm $tempfile
	
}

scan_traffic_in_FPORTS() {
	scan_FPORTS
	for port in ${FPORTS[$CURRENT_VF]}
	do
		PORT_TRAFFIC_DATA[$port]=`portstatsshow -i $port | grep "stat_wtx\|stat_wrx" | awk '{print $1, $2}' | tr '\n' ';'`
	done
}


record_fabric_data() {
	date >> $SPSM_RECORD_FABRIC_1
	if [ $standby = no ]
	then
		slotshow  > $tempfile 2>&1
		pizzabox=`cat $tempfile | grep "Not supported on this platform" | wc -l`
		if [ $pizzabox -eq 0 ]
		then
			slotstatus=`cat $tempfile | grep "POWERING UP\|LOADING\|DIAG RUNNING\|INITIALIZING" | wc -l`
			if [ $slotstatus -ne 0 ]
			then
				alive=1
			fi
		fi
		rm $tempfile 2>&1
	fi
	for FID in ${FID_LIST}
	do
		for port in ${FPORTS[$FID]}
		do
			echo -e " FID $FID: Port $port: ${PORT_TRAFFIC_DATA[$port]}" >> $SPSM_RECORD_FABRIC_1
			tmpvar=`echo -e " FID $FID: Port $port: ${PORT_TRAFFIC_DATA[$port]}"`
			if [ -e $SPSM_RECORD_FABRIC_2 ]
			then
				grep '$tmpvar' $SPSM_RECORD_FABRIC_2
				match=`grep '$tmpvar' $SPSM_RECORD_FABRIC_2 | wc -l | tr -d ' '`
				if [ $match -ne 0 ]
				then
					alive=1
				fi
			else
				alive=1
			fi
		done
	done

}

fabric_policy() {
	mv $SPSM_RECORD_FABRIC_1 $SPSM_RECORD_FABRIC_2	2>/dev/null
	for_all_contexts scan_traffic_in_FPORTS
	record_fabric_data
	echo -e "\n Fabric Policy status: ${STATUS[$alive]}" >> $SPSM_RECORD_FABRIC_1
}

cat_file() {
	if [ -e $1 ]
	then
		/bin/cat $1
	else
		echo "Empty Record"
	fi

	echo ""
}

show_record() {
	case $1 in
		fabric)
			echo ""
			echo "****************"
			echo "Fabric Record 1:"
			echo "****************"
			cat_file $SPSM_RECORD_FABRIC_1
			echo "****************"
			echo "Fabric Record 2:"
			echo "****************"
			cat_file $SPSM_RECORD_FABRIC_2
			;;
		mgmt)
			echo ""
			echo "********************"
			echo "Management Record 1:"
			echo "********************"
			cat_file $SPSM_RECORD_MGMT_1
			echo "********************"
			echo "Management Record 2:"
			echo "********************"
			cat_file $SPSM_RECORD_MGMT_2
			;;
		all)
			show_record fabric
			show_record mgmt
			;;
	esac
}
#main
case $1 in
	fabric)
		scan_period=$2 #in seconds
		preRequisites
		if [ $standby = no ]
		then
			fabric_policy
		fi
		echo "Alive: $alive"
		;;
	mgmt)
		scan_period=$2
		preRequisites
		Mgmt_policy
		echo "Alive: $alive"
		;;
	record)
		show_record $2
		;;
	*)
		echo "Invalid Arg"
		exit
		;;
esac


