#!/bin/sh
#
#    Copyright (c) 1996-2011 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#    File name:   ssave_infra.sh.in
#    Module name: utils/support
#
#    This file expected to be invoked by supportsave infrastructure to 
#    collect FOS/NOS infrastructure
#    related data for switch post fiaure analysis
#
#
PATH=/bin:/usr/bin:/usr/sbin:/fabos/bin:/fabos/link_bin:

ssaveutil="/fabos/cliexec/ssave_util.sh"

#
#include ssave utility
#
if [ -e "$ssaveutil" ]
then
    . $ssaveutil
    rc=$?
    if [ $rc -ne 0 ]
    then
      echo "Error -- $ssaveutil err=$rc"
      exit 3
    fi
else
    echo "Error -- could not locate ssave common library $ssaveutil"
    exit 3
fi
# *******************************************
# Collect cmsh data
# *******************************************
cmsh_cmd_exec()
{
    echo -e "*****************************************************************"
    echo -e "cmsh -e $@ :"
    echo -e "*****************************************************************"
    time /fabos/bin/cmsh -e "$@"
    echo -e "\n\n\n\n"
}

CMSHCMD=cmsh_cmd_exec


do_bladevershow() {
 # Do not run on standby CP.
 if [ "$STANDBY" = "TRUE" ]
 then
    return
 fi

 # If we are running on Saturn, get blade version for all AP blades.
 if [ $sw_platform == 42 ] || [ $sw_platform == 62 ] || [ $sw_platform == 77 ]
 then
    _cmd=`commandPath slotshow`
    ap1=`$_cmd | /bin/grep AP | wc -l`
    if [ $ap1 -gt 0 ]
    then
        for val in `$_cmd | /bin/grep AP | /bin/grep ENABLED | /usr/bin/cut -c1-5`
        do
            $CHASSISCMD bladevershow $val
        done
    /bin/echo ""
    fi
  else
    # Check if we are running on Sprint
    if [ $sw_platform = 46 ]  || [ $sw_platform = 95 ] || [ $sw_platform = 96 ] || [ $sw_platform = 97 ] || [ $sw_platform = 116 ] || [ $sw_platform = 107 ]
    then
       $CHASSISCMD bladevershow
    fi
  fi
}


# *******************************************
# Collect  FCIP blade port info supportsave data
# *******************************************
function get_fcip_port_info()
{
  if [ -d /proc/fabos/blade/0 ]
  then
      $ECHO "Mini-chassis system"
      
      $CHASSISCMD /bin/cat /proc/fabos/blade/0/info

      $CHASSISCMD /bin/cat /proc/fabos/blade/0/pt_prop
  else
      $ECHO "chassis"
      /fabos/link_bin/slotshow | grep "75" | cut -d ' ' -f3 >> /tmp/tmp_file
      for slot in `cat /tmp/tmp_file`
      do
	  $ECHO "slot-$slot-info :"
	  $CHASSISCMD /bin/cat /proc/fabos/blade/$slot/info
	  $EHCO "slot-$slot-pt_prop :"
	  $CHASSISCMD /bin/cat /proc/fabos/blade/$slot/pt_prop
      done
  fi
  if [ -f /tmp/tmp_file ]
  then
      rm -f /tmp/tmp_file
  else
      $ECHO "/tmp/tmp_file do not exit"
      $ECHO ""
  fi
}


# *******************************************
# Collect pre supportsave data
# *******************************************
start_pre()
{
    system_info

    # output ssave_util.sh log
    $CATFILE $ssutil_log

    # output previous supportsave log
    $CATFILE_RM /var/log/sslog.old

    # output previous suportsave ftp debug logs
    $ECHO "supportsave ftp debug log"
    $CATFILE_RM /var/log/ss_ftp_dbg_log

    # output supportsave error log /tmp/ss.log
    $ECHO "supportsave transfer log messages /tmp/ss.log"
    $CATFILE_RM /tmp/ss.log

    # ouput supportsave.conf
    $CATFILE /etc/fabos-private/supportsave-default.conf

    if [ $MULTIBLADE == "TRUE" ]
    then
      # Output of RON
      $CHASSISCMD /fabos/sbin/ron --show
    fi

    if [ "$STANDBY" = "FALSE" ]
    then
	if [ -e /usr/bin/errlogutest ]
	then
            /bin/rm /usr/bin/errlogutest
    	fi

	/bin/ln -s /fabos/cliexec/raslogt /usr/bin/errlogutest 2> /dev/null

	$CHASSISCMD /sbin/errlogutest -a2

	$CATFILE /tmp/errlogutestoutput.txt

	$CATFILE /proc/raslog/inq/hdr
	$CATFILE /proc/raslog/raslogd/hdr
	$CATFILE /proc/raslog/raslogd/msg
	$CATFILE /etc/raslog.conf

    fi

    # ouput console log
    if [ "$FABOS_OFF" = "FALSE" ]
    then
        $CHASSISCMD  /fabos/cliexec/catconsole /proc/consolelog | grep -Ev "Mail Recipient|Mail From Address|User name"

	if [ $sw_platform = 148  -o $sw_platform = 171 -o $sw_platform = 178 ]; then
            $CHASSISCMD  /fabos/cliexec/catconsole /proc/dp0_consolelog
            $CHASSISCMD  /fabos/cliexec/catconsole /proc/dp1_consolelog
	fi

	$CHASSISCMD /fabos/cliexec/errdumpall

	#rasadmin Config
	$CHASSISCMD /fabos/sbin/rasadmin --show -disabled

	$CHASSISCMD /fabos/sbin/rasadmin --show -syslog
    fi

    $CATFILE /var/log/config_updown.log
    $CATFILE /var/log/config_library.log
    $CATFILE /var/log/config_library.log.save
    $CATFILE /mnt/var/log/config_library.log
    $CATFILE /mnt/var/log/config_library.log.save

    $CHASSISCMD /usr/bin/ipcs -m

    #output /proc/trace/ubuffers
    $CATFILE /proc/trace/ubuffers

    #output /proc/trace/kbuffers
    $CATFILE /proc/trace/kbuffers

    #output /proc/trace/tplist
    $CATFILE /proc/trace/tplist

    #Collect tracecfg
    $CATFILE /etc/fabos/trace.conf
    $CHASSISCMD /sbin/tracecfg -p

  # Collect tracecfg log file
    if [ -e "/var/log/tracecfg.log" ]
    then
	$CATFILE /var/log/tracecfg.log
    fi

    #Collect dropq message
    $CATFILE /proc/raslog/dropq/msg

    # Switch configuraton switch-conf.xx, vf-conf.xx
    $CATFILE /etc/fabos/config/vf-conf.$sw_platform

    $CATFILE /etc/fabos/config/switch-conf.$sw_platform

    $CATFILE /etc/fabos/config/vf-conf.$sw_platform.save

    $CATFILE /etc/fabos/config/switch-conf.$sw_platform.save

    $CATFILE /etc/fabos/config/vf-conf-new.$sw_platform

    $CATFILE /etc/fabos/config/vf-conf-new.$sw_platform.save

    # Default switch configuration switch-conf, vf-conf, system-conf
    $CATFILE /etc/fabos/config/vf-conf

    $CATFILE /etc/fabos/config/system-conf

    $CATFILE /etc/fabos/config/switch-conf

    # syslock dump
    if [ -f /proc/syslock/status ]; then
	$CHASSISCMD  /bin/cat /proc/syslock/status | /bin/grep -vE "INIT|UNLO"
    fi
  
    # hasmtest dump
    $CHASSISCMD  /fabos/rbin/hasmtest dump 1

    # hasm.log
    $CATFILE /var/log/hasm.log

    # shm.log
    $CATFILE /var/log/shm.log

    # fsslo.log
	$CATFILE /var/log/fsslo.log

    # hadump.panic
	$CATFILE /var/log/hadump.panic

    # hasm.log.save
    $CATFILE /var/log/hasm.log.save

    if [ $isWM = yes ]; then

      # MLT stats
      $ECHO "Dumping MLT (Memory Leak Tracking) Information - KMALLOC SIZE SORTED"

      mlt_enabled=$(/bin/mlt -s 20 | grep -c "MLT not enabled") 2>/dev/null
      if [ $mlt_enabled -eq 0 ]
      then
	  $ECHO "MLT is not abled"
      else

	$CHASSISCMD /bin/mlt -s 20
	for(( i = 1 ; i < 21; i++ ))
		do
			$CHASSISCMD /bin/mlt -d $i
		done
	$ECHO "Dumping MLT (Memory Leak Tracking) Information - KMALLOC COUNT SORTED"
	$CHASSISCMD /bin/mlt -t 20
	for(( i = 1 ; i < 21; i++ ))
		do
			$CHASSISCMD /bin/mlt -d $i
		done
	$ECHO "Dumping MLT (Memory Leak Tracking) Error Stats"
	$CATFILE /proc/mlt/stats

        # MLT KL stats
	$ECHO "Dumping MLT (Memory Leak Tracking) Kmalloc large Info - SIZE SORTED"
	$CHASSISCMD /bin/mlt_kl -s 20
	for(( i = 1 ; i < 21; i++ ))
	do
          $CHASSISCMD /bin/mlt_kl -d $i
	done

	$ECHO "Dumping MLT (Memory Leak Tracking) kamlloc large Info - COUNT SORTED"
	$CHASSISCMD /bin/mlt_kl -t 20
	for(( i = 1 ; i < 21; i++ ))
	do
          $CHASSISCMD /bin/mlt_kl -d $i
	done

	$ECHO "Dumping MLT (Memory Leak Tracking) Error Stats"
	$CATFILE /proc/mlt_kl/stats

        # MLT VM stats
	$ECHO "Dumping MLT (Memory Leak Tracking) vmalloc Info - SIZE SORTED"
	$CHASSISCMD /bin/mlt_vm -s 20
	for(( i = 1 ; i < 21; i++ ))
	do
          $CHASSISCMD /bin/mlt_vm -d $i
	done

	$ECHO "Dumping MLT (Memory Leak Tracking) vamlloc Info - COUNT SORTED"
	$CHASSISCMD /bin/mlt_vm -t 20
	for(( i = 1 ; i < 21; i++ ))
	do
          $CHASSISCMD /bin/mlt_vm -d $i
	done

	$ECHO "Dumping MLT (Memory Leak Tracking) Error Stats"
	$CATFILE /proc/mlt_vm/stats
      fi
    fi

    # fsslo.log in secondary partition
    $CATFILE /mnt/var/log/fsslo.log

    # hasm.log in secondary partition
    $CATFILE /mnt/var/log/hasm.log

    # shm.log in secondary partition
    $CATFILE /mnt/var/log/shm.log

  # ISC related /proc entries
    $CATFILE /proc/isc/SWBD$sw_platform/sap
    $CATFILE /proc/isc/SWBD$sw_platform/epd
    $CATFILE /proc/isc/SWBD$sw_platform/dropped
    $CATFILE /proc/isc/SWBD$sw_platform/logged

    $CATFILE /proc/hasm/ham

    $CATFILE /var/log/bc.history

    $CATFILE /var/log/bc.history.prev

    $CATFILE /mnt/var/log/bc.history

    $CATFILE /mnt/var/log/bc.history.prev

    # need make this to be SS module
    $ECHO "/proc/fabos/blade/$slot/info & pt-prop:"
    $CHASSISCMD get_fcip_port_info

    # fwdl.log
    $CATFILE /var/log/fwdl.log

    # fwdl.log.save
    $CATFILE /var/log/fwdl.log.save
    # fwdl.log in secondary partition
    $CATFILE /mnt/var/log/fwdl.log

    # fwdl.log.save in secondary partition
    $CATFILE /mnt/var/log/fwdl.log.save

	#ras_ffdc.conf
	$CATFILE /etc/fabos/ras_ffdc.conf

    # Dump the memorystatus files

    for memfile in `/bin/ls -tr /var/log/mstatdir/memorystatus*`
      do
     	   $CATFILE $memfile
      done

    # syslog IP address config
    $CHASSISCMD /fabos/sbin/syslogadmin --show -ip

    # fabos.log, fabos scrip log
    $CATFILE /var/log/fabos.log
    $CATFILE /tmp/insmod.log

    pizzabox=$(/fabos/link_bin/hashow | grep -c "Not supported on this platform") 2>/dev/null
    if [ $pizzabox -eq 1 ]
    then
	$CHASSISCMD	/fabos/link_bin/vlan --show
    fi

    # Collect FFDC Trace OD files
    if [ $isWM = yes ]
    then
	start_trace_od
    else
	start_trace_ata
    fi
}

# *******************************************
# Collect CLP related data file
# *******************************************
start_clp()
{
    $CATFILE /var/log/clp.log
    $CATFILE /var/log/license.log
    $CATFILE /var/log/license.log.save
    $CATFILE /etc/fabos/clp.conf
    $CHASSISCMD /fabos/cliexec/licadmin -d
}

# *******************************************
# Collect RASLOG
# *******************************************
start_raslog()
{
    $CATFILE /etc/raslog.int /etc/raslog.ext	
}

# *******************************************
# Collect INFRA User data
# *******************************************
start_infra_user()
{
    $ECHO "start_infra_user"
}

# *******************************************
# Collect INFRA Internal supportsave data
# *******************************************
start_infra_internal()
{
    $ECHO "start_infra_internal"
}

# *******************************************
# Collect FOS config
# *******************************************
start_infra_foscfg()
{
	$CHASSISCMD /fabos/cliexec/configshow -all | /bin/cat # the cat at end of pipe avoids more's paging

	$CATFILE /var/log/config_updown.log

	$CATFILE /var/log/config_updown.log.save

	$CATFILE /mnt/var/log/config_updown.log

	$CATFILE /mnt/var/log/config_updown.log.save

	#the below get executed only if configshow fails
	#cat chassis section of config file
	temp=`/bin/ls /tmp/config_chassis*`
	for file in $temp
	do
		$CATFILE $file
	done

	#cat default switch section of config file
	temp=`/bin/ls /tmp/sw*`
	for file in $temp
	do
		$CATFILE $file
	done
}


start_trace_od()
{
    FILE_SIZE_50M=52428800

    if [ $fabos_off = no ]
    then
        Date=`date +%Y%m%d%H%M`
        $CHASSISCMD /fabos/cliexec/rasod -d -w-2 -m3 -y4 -t 180 -o /var/trace/tracess.$Date.trc.od
    fi

    if [ ! -e "/var/trace/trace_id.dat" ]
    then
        echo "File: /var/trace/trace_id.dat not found"
        $CHASSISCMD /fabos/rbin/tracedbadd -e
    fi

    nfile=`ls -l /var/trace/* | wc -l`
    mnt_nfile=`ls -l /mnt/var/trace/* | wc -l`

    $ECHO "/var/trace od file=$nfile /mnt/var/trace od file=$mnt_nfile"

    if [ "$mnt_nfile" -eq 0 ]
    then
        $ECHO "No trace FFDC OD found " > /mnt/var/trace/ffdc_trace_od
    fi

    if [ "$nfile" -eq 0 ]
    then
        $ECHO "No trace found " > /var/trace/ffdc_trace_od
        $CHASSISCMD tar -cvf /var/log/TRACE_FFDC_OD.tar /var/trace/ffdc_trace_od /mnt/var/trace/*
    else
        free_space=`/bin/df --block-size=1 /| grep -v Filesystem | awk '{print $4}'`
        estimate_tarsize=`tar -czf - /var/trace/* /mnt/var/trace/* | wc -c 2> /dev/null`

        min_size=`/usr/bin/expr $free_space - $FILE_SIZE_50M`

	$ECHO "CF free space=$free_space eistimate trace od size=$estimate_tarsize available CF=$min_size"

        # In the case of not enough CF, just need to collect tracess.xxxxx.xx file
        if [ $free_space -lt $estimate_tarsize ]
        then
            $ECHO "Not enough free CF=$free_space for all traceod=$estmate_tarsize, collect tracess od only"
            $CHASSISCMD tar -cvf /var/log/TRACE_FFDC_OD.tar /var/trace/tracess* /var/trace/trace_id.dat

            /fabos/cliexec/errlogtest -i TRCE-5022 -a $Date
            return;
        fi

        # tar tracepd & tracess only if estimate tar > (freespace - 50MB)
        if [ $estimate_tarsize -gt $min_size ]
        then
	    $ECHO "Not enough free CF=$free_space for all traceod=$estmate_tarsize, collect tracess and tracepd"
            $CHASSISCMD tar -cvf /var/log/TRACE_FFDC_OD.tar /var/trace/tracess* /var/trace/trace_id.dat
            pdfile=`ls -l /var/trace/tracepd* | wc -l`
            if [ "$pdfile" -ge 1 ] ;then
                $CHASSISCMD tar -rvf /var/log/TRACE_FFDC_OD.tar /var/trace/tracepd*
            fi
            /fabos/cliexec/errlogtest -i TRCE-5022 -a $Date
        else
	    # tar all trace od files
	    $ECHO "free CF=$free_space trace od size=$estmate_tarsize, collect all trace od files"
            $CHASSISCMD tar -cvf /var/log/TRACE_FFDC_OD.tar /var/trace/* /mnt/var/trace/*

	    # Moved the removal of traceod* files to RAS_POST module in case upload failure
        fi
    fi
}

#
# collect FOS oFF SS trace data file
#
start_trace_ata()
{
    # collect tracedump here if FOS OFF SS is invoked. If FOS is ON, trace should be collected as
    # defined in supportsave.conf
    if [ $fabos_off = no ]
    then
#	$ECHO "FOS is on, trace files are collected as supportsave.conf defined" > /var/trace/ffdc_trace_od
#        tar -cvf /var/log/TRACE_FFDC_OD.tar /var/trace/ffdc_trace_od
	return;
    fi

    #CTRACE_OLD,/bin/cat /var/tracedump.dmp, , ,N,Y,N,Y,Y,3,
    #CTRACE_OLD_MNT,/bin/cat /mnt/var/tracedump.dmp, , ,N,Y,N,N,Y,3,
    #CTRACE_NEW,/fabos/sbin/tracedump -z; /bin/cat /var/tracedump.dmp, , ,N,Y,N,Y,Y,4,

    Date=`date +%Y%m%d%H%M`
    dmpfile=/var/trace/tracess.$Date.old.tracedump.dmp
    /bin/cp /var/tracedump.dmp $dmpfile
    $CHASSISCMD gzip -f $dmpfile

    if [ -f "$dmpfile.gz" ]
    then
	$CHASSISCMD tar -cvf /var/log/TRACE_FFDC_OD.tar $dmpfile.gz
    else
	$ECHO "$dmpfile.gz does not exist"
    fi

    /fabos/sbin/tracedump -z;
    Date=`date +%Y%m%d%H%M`
    dmpfile=/var/trace/tracess.$Date.new.tracedump.dmp
    /bin/cp /var/tracedump.dmp $dmpfile
    $CHASSISCMD gzip -f $dmpfile
    if [ -f "$dmpfile.gz" ]
    then
	$CHASSISCMD tar -rvf /var/log/TRACE_FFDC_OD.tar $dmpfile.gz
    else
	$ECHO "$dmpfile.gz does not exist"
    fi

    Date=`date +%Y%m%d%H%M`
    dmpfile=/var/trace/tracess.$Date.mnt.tracedump.dmp
    /bin/cp /var/tracedump.dmp $dmpfile
    $CHASSISCMD gzip -f $dmpfile
    if [ -f "$dmpfile.gz" ]
    then
	$CHASSISCMD tar -rvf /var/log/TRACE_FFDC_OD.tar $dmpfile.gz
    else
	$ECHO "$dmpfile.gz does not exist"
    fi

    /bin/rm -f /var/trace/tracess.*
}

# *******************************************
# Collect post supportsave data
# *******************************************
start_post()
{     
    if [ "$FABOS_OFF" = "FALSE" ]
    then
      $CHASSISCMD  /fabos/cliexec/catconsole /proc/consolelog | grep -Ev "Mail Recipient|Mail From Address|User name"
    fi

    if [ $sw_platform = 148  -o $sw_platform = 171 ]; then
        $CHASSISCMD  /fabos/cliexec/catconsole /proc/dp0_consolelog

        $CHASSISCMD  /fabos/cliexec/catconsole /proc/dp1_consolelog
    fi

    $CATFILE_RM /var/log/assert.log

    $CATFILE /var/log/config_updown.log

   # Print /var/log/messages
    file_no="`ls /var/log/messages*`"
    for file in $file_no ; do
	$CATFILE $file
    done

    if [ "$FABOS_OFF" = "FALSE" ]
    then
      $CHASSISCMD /fabos/cliexec/errdumpall

      # Collect the Audit logs
      $CHASSISCMD	/fabos/sbin/auditcfg --show
      $CHASSISCMD	/fabos/sbin/auditdump -s
    fi

    # SPSM log
    $CATFILE /var/log/sysrmd.log
    $CHASSISCMD /fabos/sbin/spsm --show
    $CHASSISCMD /fabos/sbin/spsm --history 1

    # Removing the traceod* files here instead of RAS modules
    # to avoid missing of trace files in case of SS upload failed.
    if [ $isWM = yes ]; then
      $ECHO "Removing the traceod* files "
      /bin/rm -f /var/trace/*.od      >/dev/null 2>&1
      /bin/rm -f /var/trace/tracepd*  >/dev/null 2>&1
      /bin/rm -f /mnt/var/trace/*.od  >/dev/null 2>&1
      /bin/rm -f /mnt/var/trace/ffdc_trace_od  >/dev/null 2>&1
    fi

    $CATFILE /var/log/ss_ftp_dbg_log

    # SS utility (ftp, zip, tar ..) CLI error log */
    $CATFILE /var/log/ss.log

    # SS log
    $CATFILE /var/log/sslog

    # SS module CLI log
    $CATFILE /var/log/ssave.sh.log

    # record SS module statistic and display at end of RAS_MOST */
    $CATFILE_RM /var/log/ss_module_log
}

#silicond support
silicond_dump ()
{
		PID= ps ax | grep silicond | awk '{print $1}'
		kill -10 $PID
}
# To handle multiple params
# for param in $@
#  do
#    if [ "$param" = "--of" ]
#    then
#      outf_enable=1	 
#    fi
#  done

#Adding support for silicond stats
# silicond_dump	
 for param in $@
  do
    if [ "$param" = "--pre" ]
    then
      $EXEC_GROUP start_pre
    fi

    if [ "$param" = "--raslog" ]
    then
      $EXEC_GROUP start_raslog
    fi

    if [ "$param" = "--internal" ]
    then
	$EXEC_GROUP start_infra_internal
    fi

    if [ "$param" = "--clp" ]
    then
      $EXEC_GROUP start_clp
    fi

    if [ "$param" = "--foscfg" ]
    then
	$EXEC_GROUP start_infra_foscfg
    fi

    if [ "$param" = "--post" ]
    then
	$EXEC_GROUP start_post
    fi

    RETVAL=`echo $?`
    exit $RETVAL
  done

