#
#    Copyright (c) 1996-2012 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#    File name:   ssave_util.sh
#    Module name: utils/support
#
#    This file contains several useful functions used by the
#    support save related scripts.  They are stuck here
#    to save some disk image space.  To optimize execution time
#    copy this file into each of the command scripts instead.
#
#
PATH=/bin:/usr/bin:/usr/sbin:/fabos/bin:/fabos/link_bin:

#set ROLE to root pass remaining RBAC checks. Don't do it before rbac_check
export ROLE_ID=root

CHASSISCMD=""
SWITCHCMD=""

# Set default to pizzabox (slot = 0)
BP_BLADES="0"
#TTY="/dev/null"
TTY=$(tty)
if [ "$TTY" = "not a tty" ]
then
	TTY="/dev/null"
fi
cliidx=0
ssutil_log=/var/log/ssave.sh.log

RETVAL=0
CAT=/bin/cat
ECHO=echo
DATE=/bin/date
 
export HOME=/root
export LOGNAME=root
export PWD=/root
export TERM=vt100
export LOGIN_ID=root

######################################################################################
# NAME
#    isMultiBlade - Output TRUE if product has multiple blades
#
# SYNOPSIS
#    isMultiBlade
#
# DESCRIPTION
#    This function parses the output of the sin command to extract the
#    SWBD value for this platform, then it uses that information to
#    determine a TRUE/FALSE answer.
#
# OPERANDS
#    NONE
#####################################################################################
isMultiBlade()
{
  pizzabox=$(/fabos/link_bin/hashow | grep -c "Not supported on this platform") 2>/dev/null
  if [ $pizzabox -eq 1 ]
  then
      /bin/echo "FALSE"
  else
      /bin/echo "TRUE"
  fi
}

MULTIBLADE=`isMultiBlade`

# commandPath
#
# Get full path to FABOS command
# $1 command name
#
commandPath () {
  # First try fabos/cliexec/command
  if [ "$FABOSHOME" = "" ]
  then
    _cmd="$_default_home/cliexec/$1"
  else
    _cmd="$FABOSHOME/cliexec/$1"
  fi
  if [ -x $_cmd ]
  then
    /bin/echo $_cmd
    return 0
  fi

  # No luck -- try fabos/sbin/command
  if [ "$FABOSHOME" = "" ]
  then
    _cmd="$_default_home/sbin/$1"
  else
    _cmd="$FABOSHOME/sbin/$1"
  fi
  if [ -x $_cmd ]
  then
    /bin/echo $_cmd
    return 0
  fi

  # No luck -- try fabos/bin/command
  if [ "$FABOSHOME" = "" ]
  then
    _cmd="$_default_home/bin/$1"
  else
    _cmd="$FABOSHOME/bin/$1"
  fi
  if [ -x $_cmd ]
  then
    /bin/echo $_cmd
    return 0
  fi

  # Still no luck try fabos/command
  if [ "$FABOSHOME" = "" ]
  then
    _cmd="$_default_home/$1"
  else
    _cmd="$FABOSHOME/$1"
  fi
  if [ -x $_cmd ]
  then
    /bin/echo $_cmd
    return 0
  fi

  # Still no luck try fabos/share
  if [ "$FABOSHOME" = "" ]
  then
    _cmd="$_default_home/share/$1"
  else
    _cmd="$FABOSHOME/share/$1"
  fi
  if [ -x $_cmd ]
  then
    /bin/echo $_cmd
    return 0
  fi

  # Still no luck try fabos/factory
  if [ "$FABOSHOME" = "" ]
  then
    _cmd="$_default_home/factory/$1"
  else
    _cmd="$FABOSHOME/factory/$1"
  fi
  if [ -x $_cmd ]
  then
    /bin/echo $_cmd
    return 0
  fi

  # Still no luck try /bin
  if [ -x /bin/$1 ]
  then
    /bin/echo /bin/$1
    return 0
  fi

  # Still no luck try /usr/bin
  if [ -x /usr/bin/$1 ]
  then
    /bin/echo /usr/bin/$1
    return 0
  fi

  # Last but not least try plain old command.
  _cmd="$1"
  if [ -x $_cmd ]
  then
    /bin/echo $_cmd
    return 0
  fi

  # Ok we give up now.
  err "Could not find: $_cmd"
  return 3

}

######################################################################################
# NAME
#    setcontext - setup switch context enviroment
#
# SYNOPSIS
#    set_context FID | chassis
#
# DESCRIPTION
#    This function to set switch context
#
# OPERANDS
#    FID | chassis
#####################################################################################
setcontext()
{
    if [ "$1" != "chassis" ]; then
        SW_CONTEXT_RC=`lscfg_util --switch $1`
        eval $(lscfg_util --switch $1)
    else
        eval $(lscfg_util --chassis)
    fi
    export ROLE_ID=root
}

######################################################################################
# NAME
#    cmd_nonvf - None VF mode switch cmd
#
# SYNOPSIS
#    cmd_nonvf cmd cmd-arg ..

# DESCRIPTION
#
# OPERANDS
#    cmd cmd-arg ..
#####################################################################################
cmd_nonvf() {
    $ECHO "********************************************************"
    clicmd=${1##*/}
    $ECHO -e "SWITCHCMD $@:"
    $DATE -u
    $ECHO "********************************************************"
    $ECHO -n . > $TTY
    let cliidx++
    $ECHO "$cliidx $SS_MODULE SW $@"  >> $ssutil_log
    $ECHO -e "$@:"	 
    time $@

    rc=$?
    if [ $rc -ne 0 ]; then
        $ECHO "CLI ERR:$rc, $@" >> $ssutil_log
    fi
    $ECHO ""
    $ECHO -e "** SS CMD END **"
}



######################################################################################
# NAME
#    cmd_nonvf - None VF mode chassis cmd
#
# SYNOPSIS
#    cmd_nonvf cmd cmd-arg ..
#
# DESCRIPTION
#
# OPERANDS
#    cmd cmd-arg ..
#####################################################################################
cmd_nonvf_ch() {
    $ECHO "********************************************************"
    clicmd=${1##*/}
    $ECHO -e "CHASSISCMD $@:"
    $DATE -u
    $ECHO "********************************************************"
    $ECHO -n . > $TTY
    let cliidx++
    $ECHO "$cliidx $SS_MODULE CH $@"  >> $ssutil_log
    $ECHO -e "$@:"	 
    time $@

    rc=$?
    if [ $rc -ne 0 ]; then
        $ECHO "CLI ERR:$rc, $@" >> $ssutil_log
    fi
    $ECHO ""
    $ECHO -e "** SS CMD END **"
}


######################################################################################
# NAME
#    cmd_chassis - VF mode chassis cmd
#
# SYNOPSIS
#    cmd_chassis cmd cmd-arg ..
#
# DESCRIPTION
#
# OPERANDS
#    cmd cmd-arg ..
#####################################################################################
cmd_chassis()
{
    setcontext chassis
    $ECHO "********************************************************"
    clicmd=${1##*/}
    $ECHO -e "CHASSISCMD $@:"
    #$ECHO -e "$clicmd $2 $3 $4 $5 $6 $7 $8 $9:"
    $DATE -u
    $ECHO "********************************************************"
    $ECHO -n . > $TTY
    newline=1
    #$ECHO  "$@:" > $TTY
    let cliidx++
    $ECHO "$cliidx $SS_MODULE CH $@" >> $ssutil_log
    $ECHO -e "$@:"	
    time $@

    rc=$?
    if [ $rc -ne 0 ]
    then
      $ECHO "CLI ERR:$rc $@" >> $ssutil_log
    fi
    $ECHO ""
    $ECHO -e "** SS CMD END **"
}

##################################################################################
# NAME
#    cmd_iterate_all - VF mode switch cmd to iterate through all switch instances
#
# SYNOPSIS
#    cmd_iterate_all cmd cmd-arg ..
#
# DESCRIPTION
#
# OPERANDS
#    cmd  cmd-arg ..
#####################################################################################
cmd_iterate_all()
{
    $ECHO "********************************************************"
    clicmd=${1##*/}
    $ECHO -e "SWITCHCMD $@:"
    #$ECHO -e "$clicmd $2 $3 $4 $5 $6 $7 $8 $9:"
    $DATE -u
    $ECHO "********************************************************"
    CUR_SW_INST=0
    while [ $CUR_SW_INST -le $NUM_SW_INSTANCE ]
    do
        FABID=`lscfg_test --fid $CUR_SW_INST`

        if [ $FABID -ne -1 ]
        then
            setcontext $FABID
      
             if [ "$SW_CONTEXT_RC" = "-1" ]; then
      	        # FID permission denied for user, skip this FID
      	        echo "skipping FID $FABID... "
	        let CUR_SW_INST++
	        continue			
             fi	 			 
      
             $ECHO "CURRENT CONTEXT -- $CUR_SW_INST , $FABID" >> $ssutil_log
             $ECHO "CURRENT CONTEXT -- $CUR_SW_INST , $FABID"
             $ECHO -n . > $TTY
             newline=1
             #$ECHO  "$@:" > $TTY
             let cliidx++
             $ECHO "$cliidx $SS_MODULE SW $@"  >> $ssutil_log
             $ECHO -e "$@:"	
             time $@

             rc=$?
             if [ $rc -ne 0 ]; then
	         $ECHO "CLI ERR:$rc, $@"  >> $ssutil_log
             fi

         fi
         let CUR_SW_INST++
    done
    $ECHO ""
    $ECHO -e "** SS CMD END **"
}

cmd_confd_ex()
{
     time cmd_confd $@
}

CONFDCMD="cmd_confd_ex"

######################################################################################
# NAME
#    group_show - Invoke group of CMD, the sequence of CMD in the group
#    will be logged
#
# SYNOPSIS
#    $EXEC_GROUP group_name
#
# DESCRIPTION
#
# OPERANDS
#    group_name
#####################################################################################
group_show()
{
    $ECHO "********************************************************"
    $ECHO $SS_MODULE Group: $1
    $DATE -u
    $ECHO "********************************************************"
    $ECHO "********************************************************" >> $ssutil_log
    $ECHO $SS_MODULE Group: $1						     >> $ssutil_log
    $DATE -u							     >> $ssutil_log
    $ECHO "********************************************************" >> $ssutil_log

    cliidx=0
    time $1
    #$ECHO -e "\n" > $TTY
    $ECHO "============================================================================="  >> $ssutil_log
    $ECHO "vmstat:"						      >> $ssutil_log
    vmstat							      >> $ssutil_log
    $ECHO "loadavg:"						      >> $ssutil_log
    /bin/cat /proc/loadavg					      >> $ssutil_log
    $ECHO "/tmp usage:"						      >> $ssutil_log
    du -h /tmp							      >> $ssutil_log
    $ECHO "============================================================================="  >> $ssutil_log
    $ECHO "$SS_MODULE Group End: $1"					      >> $ssutil_log
    $DATE -u                                                             >> $ssutil_log
    $ECHO "********************************************************"  >> $ssutil_log

    $ECHO "$SS_MODULE Group End: $1"
    $DATE -u
    $ECHO "********************************************************"

    newline=1
    if [ $newline -eq 1 ]
    then
        $ECHO  " " > $TTY
    fi

    RETVAL=`echo $?`
}
EXEC_GROUP=group_show


######################################################################################
# NAME
#    catfile (CATFILE) - display a file if it exist.
#
# SYNOPSIS
#    $CATFILE full_file_name_path
#
# DESCRIPTION
#
# OPERANDS
#    full_file_name_path
#####################################################################################
catfile()
{
  
  if [ -f $1 ]; then
      $CHASSISCMD  $CAT $1
  fi
}
CATFILE=catfile

######################################################################################
# NAME
#    catfile_rm (CATFILE_RM) - display a file if it exist. Remove the file aftward.
#
# SYNOPSIS
#    CATFILE_RM full_file_name_path
#
# DESCRIPTION
#
# OPERANDS
#    full_file_name_path
#####################################################################################
catfile_rm()
{
    if [ -f $1 ]; then
        $CHASSISCMD  $CAT $1
		/bin/rm	$1
	else
		/bin/echo "File $1 not found"
    fi
}
CATFILE_RM=catfile_rm

######################################################################################
# NAME
#    catproc (CATPROC) - display proc file entries
#
# SYNOPSIS
#    $CATFILE full_procfile_name_path
#
# DESCRIPTION
#   Similar to CATFILE but supports wildcard characters
#
# OPERANDS
#    full_procfile_name_path
#####################################################################################
catproc()
{
  $CHASSISCMD  $CAT $*
}
CATPROC=catproc

######################################################################################
# NAME
#    system_info - display system info
#
# SYNOPSIS
#    system_info
#
# DESCRIPTION
#
# OPERANDS
#    NONE
#####################################################################################
system_info()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Standby CP: $STANDBY"
     $ECHO "FABOS OFF: $FABOS_OFF"
     $ECHO "WMEM switch=$isWM"
     $ECHO "Date:"
     $DATE -u
}

##################################################################
# ssave_util Main Function to setup the generic info
##################################################################

### check fabos on/off mode
FABOS_OFF="FALSE"
/fabos/sbin/chkconfig | grep "fabos " | grep off > /dev/null 2>&1
if [ $? -eq 0 ]; then
    FABOS_OFF="TRUE"
fi

### set standby flag
STANDBY=TRUE
if [ $FABOS_OFF == "FALSE" ]; then
	if /fabos/sbin/hashow | /bin/grep  Active > /dev/null 2>&1 ; then
		STANDBY=FALSE
	fi
fi

### set platform
#sw_platform=`/sbin/sin 2>/dev/null | /bin/grep SWBD | /usr/bin/cut -d ' ' -f 2 | cut -d ',' -f 1 | /usr/bin/cut -c 5-7`
sw_platform=`/sbin/sin 2>/dev/null | sed -n 's/^.*SWBD\([^,]*\),.*/\1/p'`
SW_PLATFORM=$sw_platform

BP_PLATFORM="FALSE"
case $sw_platform in
	36|47|50|55|68|85|88|89) BP_PLATFORM="TRUE" ;;
esac

isWM=no
if [ -e /dev/wm_dumper ]; then
    isWM=yes;
fi

bp_enabled()
{
    if [ $STANDBY == "FALSE" ]; then
	BP_BLADES=`slotshow | grep "LC" | grep "ENABLED" | cut -d ' ' -f3`
    fi
}
### Find the ENABLED BP in the system
if [ $MULTIBLADE == "TRUE" ]
then
	bp_enabled
fi
if [ -e /fabos/link_sbin/lscfg_test ]; then
    /bin/rm /fabos/link_sbin/lscfg_test
fi

if [ -x /fabos/cliexec/lscfg_util ]; then
	/bin/ln -s /fabos/cliexec/lscfg_util /fabos/link_sbin/lscfg_test 2> /dev/null
fi

export PATH=/fabos/link_bin:/bin:/usr/bin:/sbin:/usr/sbin:/fabos/link_abin:/fabos/link_sbin:/fabos/factory:/fabos/xtool
if [ "$(lscfg_test --vf_enabled 2> /dev/null)" = 'VF is enabled.' ]; then
    NUM_SW_INSTANCE=`lscfg_test --max`
    HOME_VF=128
    export HOME_VF
else
    HOME_VF=
    export HOME_VF
fi
if [ "$HOME_VF" = "" ]
then
    $ECHO "Non-VF"
    $ECHO "======================"
    SWITCHCMD="cmd_nonvf"
    CHASSISCMD="cmd_nonvf_ch"
else
    $ECHO "VF"
    $ECHO "======================"
    SWITCHCMD="cmd_iterate_all"
    CHASSISCMD="cmd_chassis"
fi

SSCMD="/fabos/cliexec/sscmd"

export HOME_VF
