#! /bin/sh
#
#	Copyright (c) 1996-2018 Brocade Communications Systems, Inc.
#	All rights reserved.
#
#		This script can function as a simple switch monitor. It can be
#	used to check switch state/condition and notify the user accrodingly.
#	This script is invoked every 30 mins, like a cron job.

NULL=/dev/null
#Add Utility functions here

#
# swbd
#
# Retrieve the current system platform name, of the form "SWBDn", where n
# is cardinal number, assuming a sin/hinv input stream.
#
swbd() {
    sed -n -e 's/^.\+\(SWBD[[:digit:]]\{1,\}\).\+$/\1/gp'
}

# Determine the system platform identifier.
SWBD=`/sbin/sin | swbd 2> ${NULL}`

monitor_eth_traffic() {
	case ${SWBD##SWBD} in
	'165' | '166')
		FMC_CFG=$(/fabos/cliexec/config get system.eth_rate_limit 2)
		if [ "$FMC_CFG" = "1" ] ; then
			soc_dir="/sys/devices/ffe000000.soc"
			pcd_red_ctr="pcd_plcr_red"
			pcd_yellow_ctr="pcd_plcr_yellow"

			# Get ETH0 and ETH3 device addresses.
			eth0_dev_addr=`cat /sys/class/net/eth0/device_addr`
			eth3_dev_addr=`cat /sys/class/net/eth3/device_addr`

			# Get Frame Manager Directory in sysfs
			eth0_fman_dir="${eth0_dev_addr:0:4}"
			eth3_fman_dir="${eth3_dev_addr:0:4}"

			# Get Yellow and Red frame drop counter for Management Ports
			eth0_red_ctr=`cat $soc_dir/${eth0_fman_dir}00000.fman/statistics/$pcd_red_ctr| cut -f4 -d' '`
			eth0_yellow_ctr=`cat $soc_dir/${eth0_fman_dir}00000.fman/statistics/$pcd_yellow_ctr| cut -f4 -d' '`

			if [[ "$eth0_fman_dir" != "$eth3_fman_dir" ]]; then
				eth3_red_ctr=`cat $soc_dir/${eth3_fman_dir}00000.fman/statistics/$pcd_red_ctr| cut -f4 -d' '`
				eth3_yellow_ctr=`cat $soc_dir/${eth3_fman_dir}00000.fman/statistics/$pcd_yellow_ctr| cut -f4 -d' '`
			else
				eth3_red_ctr=$eth0_red_ctr
				eth3_yellow_ctr=$eth0_yellow_ctr
			fi

			if [[ $eth0_red_ctr -ge 100 || $eth3_red_ctr -ge 100 || $eth0_yellow_ctr -ge 5000 || $eth3_yellow_ctr -ge 5000 ]]; then
				/fabos/cliexec/errlogtest -i SEC-1346
			fi

			# Reset Policer Statistics
			echo 0 |/usr/bin/tee -a $soc_dir/${eth0_fman_dir}00000.fman/statistics/pcd_plcr_*
			if [[ "$eth0_fman_dir" != "$eth3_fman_dir" ]]; then
				echo 0 |/usr/bin/tee -a $soc_dir/${eth3_fman_dir}00000.fman/statistics/pcd_plcr_*
			fi
		fi
		;;
	*)
		;;
	esac
}

# Main stars here
monitor_eth_traffic

exit 0
