#!/bin/sh
#
#  Panic Dump - UP Load Pre-Fabos parameters.
#  Certain parameters can be obtained before fabos and we should
#  collect them and process before fabos.
#  Typically this script is called in /etc/init.d/fabos, just after
#  loading panicdump-module and consolelog-module
#

MISC_FILE=/core_files/panic/system_sym  # if you change this, also change
                                # corresponding entry in pdul_misc_pre.sh and
                                # pdul_misc_post.sh and pdcheck.sh

PD_TEMP_ERRLOG_FILE=/tmp/pd_temp_errlog

#
# Let us record our start date
#
printf "Section=Startup time: `/bin/date`\n" > /proc/consolelog

#
# Log the Version in pd_misc
#

consolelog(){
	# copy a line at a time to /proc/consolelog
	# We need to do this because of the "interesting" way consolelog is
	# implemented. If we have a later version of GNU sed that
	# implements the "-u" switch we could use that instead.
	while read -r line
	do
		printf "%s\n" "$line" > /proc/consolelog
	done
}
/fabos/bin/version | /bin/sed -e 's/:/=/' -e '/^[ \t]*$/q' | consolelog

# remove older file if it exists
/bin/rm -f /core_files/.misc_file
# This can be deleted after 6.1, bld 24 is dead
/bin/rm -f /core_files/misc_file.core
