#!/bin/bash
TESTTYPE=""
INPUTFILE=""
OUTPUTFILE=""
TEMPLATEFILE=""
DEBUGFILE=""
KATDEMO=""
SHAREDOBJKEYGENPATH="/fabos/rbin/snmpddbg kdf"
KATTESTUTIL="/fabos/rbin/snmpddbg kat"
KATTESTUTILDEMO="/fabos/rbin/snmpddbg kat demo"
declare -i FileHeaderPos=0

ReqEngineID1=""
ReqEngineIDDottedFormat1=""
ReqPasswordLen1=""
declare -a ReqfileArry1
declare -a PassArry1
declare -a SharedObjKey1=()

ReqEngineID2=""
ReqEngineIDDottedFormat2=""
ReqPasswordLen2=""
declare -a ReqfileArry2
declare -a PassArry2
declare -a SharedObjKey2

TemplateEngineID1=""
TemplatePasswordLen1=""
TemplateEngineID2=""
TemplatePasswordLen2=""
declare -a TemplatefileArry1
declare -a TemplatePassArry1
declare -a TemplateSharedObjKey1
declare -a TemplatefileArry2
declare -a TemplatePassArry2
declare -a TemplateSharedObjKey2

function LOG {
	if [[ ${#DEBUGFILE} != 0 ]]; then
		echo $@ 1>>$DEBUGFILE
	fi
}

while getopts t:f:o:d:i: arg; do
	case "$arg" in
		t)
		 TESTTYPE=$OPTARG
		 LOG $TESTTYPE
		 ;;
		f)
		 INPUTFILE=$OPTARG
		 LOG $INPUTFILE
		 ;;
		o)
		 OUTPUTFILE=$OPTARG
		 LOG $OUTPUTFILE
		 ;;
		d)
		 DEBUGFILE=$OPTARG
		 LOG $DEBUGFILE
		 ;;
		i)
		 KATDEMO=$OPTARG
		 LOG $KATDEMO
		 ;;
		*)
		 LOG "Error options"
		 exit 0
		 ;;
	esac
done

function readInputFile {
	local Counter=0
	while read line; do
		if (( ${#line} )); then
			ReqfileArry[$Counter]=$line
			((Counter+=1))
		fi
	done < "$INPUTFILE"
}

#Input file parsing
function inputFileParsing {
	local Counter=0
	local lin=0
	local section=0
	local tempArry=()
	if [[ ${#ReqfileArry} == 0 ]]; then
		return -1
	fi
	for i in "${ReqfileArry[@]}"; do
		case "$i" in
            *"Generated on"* )
        				     ((FileHeaderPos=$Counter - 1)) 
        esac

		tempArry[0]=$(echo $i | cut -d"=" -f1 | tr -d [[:space:]])
		tempArry[1]=$(echo $i | cut -d"=" -f2 | tr -d [[:space:]])
		LOG "Line:$Counter '${tempArry[0]}' '${tempArry[1]}'"
		if [[ ${tempArry[0]} == "engineID" ]]; then
			((section+=1))
			((lin=0))
		fi
		if [[ $section == 1 ]]; then
			if [[ ${tempArry[0]} == "password" ]]; then
				PassArry1[$lin]=${tempArry[1]}
				((lin+=1))
			elif [[ ${tempArry[0]} == "engineID" ]]; then
				ReqEngineID1=${tempArry[1]}
			elif [[ ${tempArry[0]} == "passwordLen" ]]; then
				ReqPasswordLen1=${tempArry[1]}
			fi
		elif [[ $section == 2 ]]; then
			if [[ ${tempArry[0]} == "password" ]]; then
				PassArry2[$lin]=${tempArry[1]}
				((lin+=1))
			elif [[ ${tempArry[0]} == "engineID" ]]; then
				ReqEngineID2=${tempArry[1]}
			elif [[ ${tempArry[0]} == "passwordLen" ]]; then
				ReqPasswordLen2=${tempArry[1]}
			fi
		fi
		((Counter+=1))
	done
}

#Engine id  reformatting
function engineIDFormating {
	local tEngineID=""
	local tsection=$2
	local tStr1=""
	local tStr=""

	tEngineID=$1
	LOG "---EngineID formation---"
	for i in `seq 0 2 ${#tEngineID}`; do
		tStr=${tEngineID:$i:2}
		if (( ${#tStr} )); then
			if [[ $i -eq 0 ]]; then
				tStr1=$tStr
			else
				tStr1="$tStr1:$tStr"
			fi
		fi
	done

	LOG "$tStr1"

	if [[ $tsection == 1 ]]; then
		ReqEngineIDDottedFormat1=$tStr1
	elif [[ $tsection == 2 ]]; then
		ReqEngineIDDottedFormat2=$tStr1
	fi

	LOG "ReqEngineIDDottedFormat1= '$section' '$ReqEngineIDDottedFormat1'"
	LOG "ReqEngineIDDottedFormat2= '$section' '$ReqEngineIDDottedFormat2'"
}

function generateSharedObjKey {
	local tsection=$2
	local Counter=0
	local tPassArry=()
	local tSharedObjKey=()
	local tEngineIDDottedFormat=""
	local tStr1=""
	local tStr=""
	
	tEngineIDDottedFormat=$1

	LOG "---generating shared object key---"

	if [[ $tsection == 1 ]]; then
		tPassArry=("${PassArry1[@]}")
	elif [[ $tsection == 2 ]]; then
		tPassArry=("${PassArry2[@]}")
	fi

	for i in "${tPassArry[@]}"; do
		LOG $i
       		tStr1=$($SHAREDOBJKEYGENPATH $tEngineIDDottedFormat ${tPassArry[$Counter]})
		tStr=$(echo $tStr1 | cut -d ":" -f 1 | tr -d [[:space:]])
        	if [[ $tStr == "Success" ]]; then
                	tSharedObjKey[$Counter]=$(echo $tStr1 | cut -d ":" -f 2 | tr -d [[:space:]])
	        else
        	        LOG "Error in generating Password for Password-$Counter: ${tPassArry[$Counter]}"
                	tSharedObjKey[$Counter]=""
	        fi  
        	((Counter+=1))
	done

	if [[ $tsection == 1 ]]; then
		SharedObjKey1=("${tSharedObjKey[@]}")
	elif [[ $tsection == 2 ]]; then
		SharedObjKey2=("${tSharedObjKey[@]}")
	fi
}

function dumpData {

	LOG "---printing password array---"
	LOG "EngineID: $ReqEngineID1 $ReqEngineIDDottedFormat1"
	LOG "PasswordLen: '$ReqPasswordLen1'"
	Counter=0
	for i in "${PassArry1[@]}"; do
		LOG "Password-$Counter: '$i'"
		LOG "SharedObjKey-$Counter: '${SharedObjKey1[$Counter]}'"
		((Counter+=1))
	done

	LOG "EngineID: $ReqEngineID2 $ReqEngineIDDottedFormat2"
	LOG "PasswordLen: '$ReqPasswordLen2'"
	Counter=0
	for i in "${PassArry2[@]}"; do
		LOG "Password-$Counter: '$i'"
		LOG "SharedObjKey-$Counter: '${SharedObjKey2[$Counter]}'"
		((Counter+=1))
	done
}

function generatingRespFile {
	local Counter=0
	if [[ -e $OUTPUTFILE ]]; then
		rm $OUTPUTFILE
		LOG "unlinking the file"
	fi
	LOG "---Generating response file---"
	for i in `seq 0 $FileHeaderPos`; do
		echo ${ReqfileArry[$i]} 1>> $OUTPUTFILE
	done
	now=$(date)
	echo "# Generated on $now" 1>> $OUTPUTFILE
	echo 1>> $OUTPUTFILE
	echo 1>> $OUTPUTFILE
	echo "[engineID = $ReqEngineID1]" 1>> $OUTPUTFILE
	echo "[passwordLen = $ReqPasswordLen1]" 1>> $OUTPUTFILE
	echo 1>> $OUTPUTFILE
	((Counter=0))
	for i in "${PassArry1[@]}"; do
		echo "COUNT = $Counter" 1>> $OUTPUTFILE
		echo "password = $i" 1>> $OUTPUTFILE
		echo "Shared_key = ${SharedObjKey1[$Counter]}" 1>> $OUTPUTFILE
		echo 1>> $OUTPUTFILE
		((Counter+=1))
	done
	echo 1>> $OUTPUTFILE
	echo "[engineID = $ReqEngineID2]" 1>> $OUTPUTFILE
	echo "[passwordLen = $ReqPasswordLen2]" 1>> $OUTPUTFILE
	echo 1>> $OUTPUTFILE
	((Counter=0))
	for i in "${PassArry2[@]}"; do
		echo "COUNT = $Counter" 1>> $OUTPUTFILE
		echo "password = $i" 1>> $OUTPUTFILE
		echo "Shared_key = ${SharedObjKey2[$Counter]}" 1>> $OUTPUTFILE
		echo 1>> $OUTPUTFILE
		((Counter+=1))
	done
}

if [[ ${#TESTTYPE} == 0 ]]; then
	LOG "Error test type"
	exit 0
elif [[ $TESTTYPE == "KDF" &&  ${#INPUTFILE} == 0 ]]; then
	LOG "Error no input file name"
	exit 0
elif [[ $TESTTYPE == "KDF" &&  ${#OUTPUTFILE} == 0 ]]; then
	LOG "Error no output file name"
	exit 0
fi
if [[ $TESTTYPE == "KAT" && $KATDEMO == "demo" ]]; then
	retmsg=`$KATTESTUTILDEMO`
	echo "$retmsg"
	echo "$retmsg" | grep -i "success" > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		ret=0
	else
		ret=-1
	fi
	exit $ret
elif [[ $TESTTYPE == "KAT" ]]; then
	retmsg=`$KATTESTUTIL`
	echo "$retmsg"
	echo "$retmsg" | grep -i "success" > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		ret=0
	else
		ret=-1
	fi
	exit $ret
elif [[ $TESTTYPE == "KDF" ]]; then
	readInputFile 

	inputFileParsing 

	engineIDFormating $ReqEngineID1 1 
	engineIDFormating $ReqEngineID2 2

	generateSharedObjKey $ReqEngineIDDottedFormat1 1
	generateSharedObjKey $ReqEngineIDDottedFormat2 2

	dumpData

	generatingRespFile 

fi
