#!/bin/sh
#
#    Copyright (c) 1996-2001 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#    Script to start/stop SNMP daemon
#



#
# pidofproc <program>
# Find pids of the program
#

pidofproc()
{
    if [ -f /var/run/$1.pid ] ; then
	pid=`head -1 /var/run/$1.pid`
	if [ "$pid" != "" ] ; then
	    echo $pid
	    return 0
	fi
    fi
}

#
# killproc <program>
# Kill the program
#
killproc()
{
    pid=`pidofproc $1`

    if [ "$pid" != "" ] ; then
	if ps h $pid >/dev/null 2>&1; then
		kill -TERM $pid > /dev/null 2>&1
	    kill -KILL $pid > /dev/null 2>&1
	fi
    fi

    # remove pid file if any.
    rm -f /var/run/$1.pid
}
sw=$2
ECHO=echo
#
# main
#
case "$1" in

'start')

    $ECHO "Starting snmpd:\n"
    snmpd -s $sw 
    $ECHO "."
    ;;

'stop')
    $ECHO "Stopping snmpd ...\n"
    killproc snmpd.$sw
    $ECHO "done."
    ;;

'restart')

    $ECHO "Re-starting snmpd:\n"
    killproc snmpd.$sw
    sleep 10
    snmpd -s $sw
    $ECHO "done."
    ;;

*)
    echo "Usage: $0 {start | stop | restart  <sno> }"
    ;;

esac
