#!/bin/sh
PATH=/bin:/usr/bin:/usr/sbin:/fabos/bin:/fabos/link_bin:

#set ROLE to root pass remaining RBAC checks. Don't do it before rbac_check
export ROLE_ID=root

CHASSISCMD=""
TTY=$(tty)
if [ "$TTY" = "not a tty" ]
then
	TTY="/dev/null"
fi
newline=0
cliidx=0
ssutil_log=/var/log/ssave.sh.log

retval=0
ECHO="echo"
#
# copied from /fabos/src/setup/profile
#
setcontext()
{
    if [ "$1" != "chassis" ]
    then
		export FABOS_SWITCHNO=$2
		export CURRENT_VF=$1
		export CHASSIS_ROLEID=0
    else
		export FABOS_SWITCHNO=-1
		export CURRENT_VF=255
		export CHASSIS_ROLEID=0
    fi
	export ROLE_ID=root
}


######################################################################################
# NAME
#    cmd_nonvf - None VF mode switch cmd
#
# SYNOPSIS
#    cmd_nonvf cmd cmd-arg ..

# DESCRIPTION
#
cmd_nonvf() {
    $ECHO "********************************************************"
    clicmd=${1##*/}
    $ECHO -e "SWITCHCMD $@:"
    /bin/date
    $ECHO "********************************************************"
    $ECHO -n . > $TTY
    let cliidx++
    $ECHO "$cliidx $SS_MODULE SW $@"  >> $ssutil_log
    $ECHO -e "$@:"
    time $@

    rc=$?
    if [ $rc -ne 0 ]; then
        $ECHO "CLI ERR:$rc, $@" >> $ssutil_log
    fi
    $ECHO ""
    $ECHO -e "** SS CMD END **"
}



######################################################################################
# NAME
#    cmd_nonvf - None VF mode chassis cmd
#
# SYNOPSIS
#    cmd_nonvf cmd cmd-arg ..
#
# DESCRIPTION
#
# OPERANDS
#    cmd cmd-arg ..
#####################################################################################
cmd_nonvf_ch() {
    $ECHO "********************************************************"
    clicmd=${1##*/}
    $ECHO -e "CHASSISCMD $@:"
    /bin/date
    $ECHO "********************************************************"
    $ECHO -n . > $TTY
    let cliidx++
    $ECHO "$cliidx $SS_MODULE CH $@"  >> $ssutil_log
    $ECHO -e "$@:"
    time $@

    rc=$?
    if [ $rc -ne 0 ]; then
        $ECHO "CLI ERR:$rc, $@" >> $ssutil_log
    fi
    $ECHO ""
    $ECHO -e "** SS CMD END **"
}


######################################################################################
# NAME
#    cmd_chassis - VF mode chassis cmd
#
# SYNOPSIS
#    cmd_chassis cmd cmd-arg ..
#
# DESCRIPTION
#
# OPERANDS
#    cmd cmd-arg ..
#####################################################################################
cmd_chassis()
{
    setcontext chassis
    $ECHO "********************************************************"
    clicmd=${1##*/}
    $ECHO -e "CHASSISCMD $@:"
    #$ECHO -e "$clicmd $2 $3 $4 $5 $6 $7 $8 $9:"
    /bin/date
    $ECHO "********************************************************"
    $ECHO -n . > $TTY
    newline=1
    #$ECHO  "$@:" > $TTY
    let cliidx++
    $ECHO "$cliidx $SS_MODULE CH $@" >> $ssutil_log
    $ECHO -e "$@:"
    time $@

    rc=$?
    if [ $rc -ne 0 ]
    then
      $ECHO "CLI ERR:$rc $@" >> $ssutil_log
    fi
    $ECHO ""
    $ECHO -e "** SS CMD END **"
}

##################################################################################
# NAME
#    cmd_iterate_all - VF mode switch cmd to iterate through all switch instances
#
# SYNOPSIS
#    cmd_iterate_all cmd cmd-arg ..
#
# DESCRIPTION
#
# OPERANDS
#    cmd  cmd-arg ..
#####################################################################################
#
# cmd to iterate through all switch instances
#
#
cmd_iterate_all() {
	$SSCMD $@ "--sscommand=3" -l$sshowlog -a -i$TTY -c$cliidx
	let cliidx++
	newline=1
}

catfile()
{
	if [ -f $1 ]; then
		$CHASSISCMD /bin/cat $1
	else
		/bin/echo "File $1 not found"
	fi
}
CATFILE=catfile

catfile_rm()
{
	if [ -f $1 ]; then
		$CHASSISCMD /bin/cat $1
		/bin/rm $1
	else
		/bin/echo "File $1 not found"
	fi
}
CATFILE_RM=catfile_rm

group_show() {
    $ECHO "********************************************************"
    $ECHO $1
    $ECHO "********************************************************"
    $ECHO "********************************************************" >> $ssutil_log
    $ECHO $1 >> $ssutil_log
    $ECHO "********************************************************" >> $ssutil_log
    /bin/date  >> $ssutil_log
    cliidx=0
    time $1
    #$ECHO -e "\n" > $TTY
    $ECHO "============================================================================="  >> $ssutil_log
    $ECHO "vmstat:"						      >> $ssutil_log
    vmstat							      >> $ssutil_log
    $ECHO "loadavg:"						      >> $ssutil_log
    /bin/cat /proc/loadavg					      >> $ssutil_log
    $ECHO "/tmp usage:"						      >> $ssutil_log
    du -h /tmp							      >> $ssutil_log
    $ECHO "============================================================================="  >> $ssutil_log
    $ECHO "$SS_MODULE Group End: $1"				      >> $ssutil_log
    /bin/date                                                              >> $ssutil_log
    $ECHO "********************************************************"  >> $ssutil_log

    $ECHO "$SS_MODULE Group End: $1"
    /bin/date
    $ECHO "********************************************************"

    newline=1
    if [ $newline -eq 1 ]
    then
        $ECHO  " " > $TTY
    fi

    RETVAL=`echo $?`
}
EXEC_GROUP=group_show


# IMP Note - This function can get stuck when called for core-blade slot (e.g. Slot#7 on Allegiance) from Standby CP of Gen6 chassis
asic_db_blade_type_() {

   # initialize to unknown blade id & type
    bladeid=0
    blade_type=""
    num_anvils=0
    num_zeus=0
    num_condors=0
    num_pinballs=0
    num_c2s=0

    if test -f /proc/fabos/blade/$1/info; then

        # ref. blade id is defined in linux/include/brocade/swbd.h
        bladeid=`cat /proc/fabos/blade/$1/info | /bin/grep --binary-files=text bladeId | sed 's/[^0-9]//g'`

      case "$bladeid" in
		"213" ) blade_type="a-wing";;	# a-wing
        "186" ) blade_type="harpoon";;  # harpoon
        "154" ) blade_type="skybolt";;  # skybolt blade is 0...
        "37" ) blade_type="despina";num_c2s=1;;
        "55" ) blade_type="larissa";num_c2s=2;;
        "51" ) blade_type="triton";num_c2s=2;;
        "46" ) blade_type="hydra";num_c2s=2;;
        "56" ) blade_type="spirit";num_c2s=1;;
        "59" ) blade_type="tomahawk";num_c2s=1;;
        "53" ) blade_type="thor";num_c2s=9;;
        "52" ) blade_type="proteus";num_c2s=4;;
        "29" ) blade_type="sprint";num_condors=2;num_pinballs=2;; # sprint
        "27" ) blade_type="viking";num_condors=6;; # viking
        "24" ) blade_type="marathon";num_condors=2;num_pinballs=2;;   # marathon
		  # "33" ) blade_type="scimitar";num_condors=2;num_pinballs=2;;
        "38" ) blade_type="sabre";num_condors=2;num_pinballs=2;;
        "45" ) blade_type="elara";num_c2s=1;num_anvils=3;num_zeus=3;; # Elara
        "74" ) blade_type="europa";num_c2s=1;num_anvils=3;num_zeus=3;;
        "69" ) blade_type="spike";num_c2s=1;;
        "75" ) blade_type="striker";num_c2s=1;;
        "42" ) blade_type="mace";num_c2s=2;;
        "43" ) blade_type="lance";num_c2s=2;;
        "31" ) blade_type="ironman";num_condors=1;;   # ironman
        "18" ) blade_type="electron";num_condors=2;;   # 32-ports condor
        "16" ) blade_type="neutron";num_condors=2;;  # core condors
        "36" ) blade_type="positron";num_condors=2;;  # 48-ports condor
        "39" ) blade_type="xenon";num_condors=2;;  # xenon
        * ) blade_type="others";num_condors=1;; # pulsar/stealth/proton
      esac

    fi
    # return status
    if [ "$blade_type" = "" ]; then
        echo_xx 2> /dev/null;
    else
        echo 2> /dev/null
    fi
}


# *******************************************
# Collect  FCIP blade port info supportsave data
# *******************************************
function get_fcip_port_info()
{
	if [ -d /proc/fabos/blade/0 ]
		then
			$ECHO "Mini-chassis system"

			$CHASSISCMD /bin/cat /proc/fabos/blade/0/info

			$CHASSISCMD /bin/cat /proc/fabos/blade/0/pt_prop
	else
		$ECHO "chassis"
		/fabos/link_bin/slotshow | grep "75" | cut -d ' ' -f3 >> /tmp/tmp_file
		for slot in `cat /tmp/tmp_file`
			do
			$ECHO "slot-$slot-info :"
			$CHASSISCMD /bin/cat /proc/fabos/blade/$slot/info
			$EHCO "slot-$slot-pt_prop :"
			$CHASSISCMD /bin/cat /proc/fabos/blade/$slot/pt_prop
		done
	fi
	if [ -f /tmp/tmp_file ]
		then
		rm -f /tmp/tmp_file
	else
		$ECHO "/tmp/tmp_file do not exit"
		$ECHO ""
	fi
}

# *******************************************
# Collect pre supportsave data
# *******************************************
start_pre()
{

    $ECHO "Platform: $sw_platform"
    $ECHO "Standby CP: $standby"
    $ECHO "Date:"
    /bin/date

    # output and remove previous SS log
    $CATFILE_RM /var/log/sslog.old

    # SS utility (ftp, zip, tar ..) CLI error log */
    $CATFILE_RM /var/log/ss.log

    # SS module CLI log
    $CATFILE_RM /var/log/ssave.sh.log

    $CATFILE_RM /var/log/ss_ftp_dbg_log

    # ouput supportsave.conf
    $CATFILE /etc/fabos/supportsave-default.conf

    $CHASSISCMD /sbin/hwclock

	# Output of RON
	$CHASSISCMD	/fabos/sbin/ron --show

	# Collect FFDC Trace OD files
	# Moved trace collection from end to here to collect traces if
	# SS fails/timeouts anywhere below as tracelogs are important
	if [ $isWM = yes ]; then
		start_trace_od
	else
		start_trace_ata
	fi

    if [ $standby = no ]
    then
	if [ -e /usr/bin/errlogutest ]
	then
            /bin/rm /usr/bin/errlogutest
    	fi

	/bin/ln -s /fabos/cliexec/raslogt /usr/bin/errlogutest 2> /dev/null

	$CHASSISCMD /usr/bin/errlogutest -a2

	$CATFILE /tmp/errlogutestoutput.txt

	if [ -e /usr/bin/errlogutest ]
	then
	    /bin/rm /usr/bin/errlogutest
	fi
	$CATFILE /proc/raslog/inq/hdr
	$CATFILE /proc/raslog/raslogd/hdr
	$CATFILE /proc/raslog/raslogd/msg
	$CATFILE /etc/raslog.conf
    fi

    # ouput console log
    if [ $fabos_off = no ]
    then
    $CHASSISCMD  /fabos/cliexec/catconsole /proc/consolelog | grep -Ev "Mail Recipient|Mail From Address|User name"

    if [ $sw_platform = 148  -o $sw_platform = 171 -o $sw_platform = 178 ]; then
        $CHASSISCMD  /fabos/cliexec/catconsole /proc/dp0_consolelog
        $CHASSISCMD  /fabos/cliexec/catconsole /proc/dp1_consolelog
    fi

    $CHASSISCMD /fabos/cliexec/errdumpall

	#rasadmin Config
	$CHASSISCMD /fabos/sbin/rasadmin --show -disabled

	$CHASSISCMD /fabos/sbin/rasadmin --show -syslog
    fi

    $CATFILE /var/log/config_updown.log
    $CATFILE /var/log/config_library.log
    $CATFILE /var/log/config_library.log.save
    $CATFILE /mnt/var/log/config_library.log
    $CATFILE /mnt/var/log/config_library.log.save

    $CHASSISCMD /usr/bin/ipcs -m

    #output /proc/trace/ubuffers
    $CATFILE /proc/trace/ubuffers

    #output /proc/trace/kbuffers
    $CATFILE /proc/trace/kbuffers

    #output /proc/trace/tplist
    $CATFILE /proc/trace/tplist

    #Collect tracecfg
    $CATFILE /etc/fabos/trace.conf
    $CHASSISCMD /sbin/tracecfg -p

    # Collect tracecfg log file
    if [ -e "/var/log/tracecfg.log" ]
    then
	$CATFILE /var/log/tracecfg.log
    fi

    #Collect dropq message
    $CATFILE /proc/raslog/dropq/msg

    # Switch configuraton switch-conf.xx, vf-conf.xx
    $CATFILE /etc/fabos/config/vf-conf.$sw_platform

    $CATFILE /etc/fabos/config/switch-conf.$sw_platform

    $CATFILE /etc/fabos/config/vf-conf.$sw_platform.save

    $CATFILE /etc/fabos/config/switch-conf.$sw_platform.save

    $CATFILE /etc/fabos/config/vf-conf-new.$sw_platform

    $CATFILE /etc/fabos/config/vf-conf-new.$sw_platform.save

    # Default switch configuration switch-conf, vf-conf, system-conf
    $CATFILE /etc/fabos/config/vf-conf

    $CATFILE /etc/fabos/config/system-conf

    $CATFILE /etc/fabos/config/switch-conf

    # syslock dump
    if [ -f /proc/syslock/status ]; then
	$CHASSISCMD  /bin/cat /proc/syslock/status | /bin/grep -vE "INIT|UNLO"
    fi

    # hasmtest dump
    $CHASSISCMD  /fabos/rbin/hasmtest dump 1

    # hasm.log
    $CATFILE /var/log/hasm.log

    # shm.log
    $CATFILE /var/log/shm.log

    # fsslo.log
	$CATFILE /var/log/fsslo.log

    # hadump.panic
	$CATFILE /var/log/hadump.panic

    # hasm.log.save
    $CATFILE /var/log/hasm.log.save

  if [ $isWM = yes ]; then

	# MLT stats
	if [ ! -d "/proc/mlt" ] ; then
		$ECHO "MLT not enabled"
	else
		$ECHO "Dumping MLT (Memory Leak Tracking) Information - KMALLOC SIZE SORTED"
		$CHASSISCMD /bin/mlt -s 20
		for(( i = 1 ; i < 21; i++ ))
			do
				$CHASSISCMD /bin/mlt -d $i
			done
		$ECHO "Dumping MLT (Memory Leak Tracking) Information - KMALLOC COUNT SORTED"
		$CHASSISCMD /bin/mlt -t 20
		for(( i = 1 ; i < 21; i++ ))
			do
				$CHASSISCMD /bin/mlt -d $i
			done
		$ECHO "Dumping MLT (Memory Leak Tracking) Error Stats"
		$CATFILE /proc/mlt/stats
	fi

	# MLT KL stats
	if [ ! -d "/proc/mlt_kl" ] ; then
		$ECHO "MLT_KL not enabled. Can be enabled by adding mlt_kl to boot args"
	else
	    $ECHO "Dumping MLT (Memory Leak Tracking) Kmalloc large Info - SIZE SORTED"
	    $CHASSISCMD /bin/mlt_kl -s 20
	    for(( i = 1 ; i < 21; i++ ))
	    do
	        $CHASSISCMD /bin/mlt_kl -d $i
	    done

	    $ECHO "Dumping MLT (Memory Leak Tracking) kamlloc large Info - COUNT SORTED"
	    $CHASSISCMD /bin/mlt_kl -t 20
	    for(( i = 1 ; i < 21; i++ ))
	    do
	        $CHASSISCMD /bin/mlt_kl -d $i
	    done

	    $ECHO "Dumping MLT (Memory Leak Tracking) Error Stats"
	    $CATFILE /proc/mlt_kl/stats
	fi

	# MLT VM stats
	if [ ! -d "/proc/mlt_vm" ] ; then
		$ECHO "MLT_VM not enabled. Can be enabled by adding mlt_vm to boot args"
	else
	    $ECHO "Dumping MLT (Memory Leak Tracking) vmalloc Info - SIZE SORTED"
	    $CHASSISCMD /bin/mlt_vm -s 20
	    for(( i = 1 ; i < 21; i++ ))
	    do
	        $CHASSISCMD /bin/mlt_vm -d $i
	    done

	    $ECHO "Dumping MLT (Memory Leak Tracking) vamlloc Info - COUNT SORTED"
	    $CHASSISCMD /bin/mlt_vm -t 20
	    for(( i = 1 ; i < 21; i++ ))
	    do
	        $CHASSISCMD /bin/mlt_vm -d $i
	    done

	    $ECHO "Dumping MLT (Memory Leak Tracking) Error Stats"
	    $CATFILE /proc/mlt_vm/stats
	fi
  fi

    # fsslo.log in secondary partition
    $CATFILE /mnt/var/log/fsslo.log

    # hasm.log in secondary partition
    $CATFILE /mnt/var/log/hasm.log

    # shm.log in secondary partition
    $CATFILE /mnt/var/log/shm.log


    # ISC related /proc entries
    $CATFILE /proc/isc/SWBD$sw_platform/sap
    $CATFILE /proc/isc/SWBD$sw_platform/epd
    $CATFILE /proc/isc/SWBD$sw_platform/dropped
    $CATFILE /proc/isc/SWBD$sw_platform/logged

    $CATFILE /proc/hasm/ham

    $CATFILE /var/log/bc.history

    $CATFILE /var/log/bc.history.prev

    $CATFILE /mnt/var/log/bc.history

    $CATFILE /mnt/var/log/bc.history.prev

    $ECHO "/proc/fabos/blade/$slot/info & pt-prop:"
    $CHASSISCMD get_fcip_port_info

	# fwdl.log
    $CATFILE /var/log/fwdl.log

    # fwdl.log.save
    $CATFILE /var/log/fwdl.log.save

    # fwdl.log in secondary partition
    $CATFILE /mnt/var/log/fwdl.log

    # fwdl.log.save in secondary partition
    $CATFILE /mnt/var/log/fwdl.log.save

	#ras_ffdc.conf
	$CATFILE /etc/fabos/ras_ffdc.conf

    # Dump the memorystatus files

    for memfile in `/bin/ls -tr /var/log/mstatdir/memorystatus*`
      do
     	   $CATFILE $memfile
      done

   # syslog IP address config
   $CHASSISCMD /fabos/sbin/syslogadmin --show -ip

    # fabos.log, fabos scrip log
    $CATFILE /var/log/fabos.log
    $CATFILE /tmp/insmod.log

	pizzabox=$(/fabos/link_bin/hashow | grep -c "Not supported on this platform") 2>/dev/null
	if [ $pizzabox -eq 1 ];then
	$CHASSISCMD	/fabos/link_bin/vlan --show
	fi

	$CATFILE /var/log/license.log
	$CATFILE /var/log/license.log.save
	$CHASSISCMD /fabos/cliexec/licadmin -d

}

start_trace_od()
{
    FILE_SIZE_50M=52428800

    if [ $fabos_off = no ]
    then
        Date=`/bin/date +%Y%m%d%H%M`
        $CHASSISCMD /fabos/cliexec/rasod -d -w-2 -m3 -y4 -t 180 -o /var/trace/tracess.$Date.trc.od
    fi

    if [ ! -e "/var/trace/trace_id.dat" ]
    then
        echo "File: /var/trace/trace_id.dat not found"
        $CHASSISCMD /fabos/rbin/tracedbadd -e
    fi

    nfile=`ls -l /var/trace/* | wc -l`
    mnt_nfile=`ls -l /mnt/var/trace/* | wc -l`

    $ECHO "/var/trace od file=$nfile /mnt/var/trace od file=$mnt_nfile"

    if [ "$mnt_nfile" -eq 0 ]
    then
        $ECHO "No trace FFDC OD found " > /mnt/var/trace/ffdc_trace_od
    fi

    if [ "$nfile" -eq 0 ]
    then
        $ECHO "No trace found " > /var/trace/ffdc_trace_od
        $CHASSISCMD tar -cvf /var/log/TRACE_FFDC_OD.tar /var/trace/ffdc_trace_od /mnt/var/trace/*
    else
        free_space=`/bin/df --block-size=1 /| grep -v Filesystem | awk '{print $4}'`
        estimate_tarsize=`tar -czf - /var/trace/* /mnt/var/trace/* | wc -c 2> /dev/null`

        min_size=`/usr/bin/expr $free_space - $FILE_SIZE_50M`

	$ECHO "CF free space=$free_space eistimate trace od size=$estimate_tarsize available CF=$min_size"

        # In the case of not enough CF, just need to collect tracess.xxxxx.xx file
        if [ $free_space -lt $estimate_tarsize ]
        then
            $ECHO "Not enough free CF=$free_space for all traceod=$estmate_tarsize, collect tracess od only"
            $CHASSISCMD tar -cvf /var/log/TRACE_FFDC_OD.tar /var/trace/tracess* /var/trace/trace_id.dat
            /fabos/cliexec/errlogtest -i TRCE-5022 -a $Date
            return;
        fi

        # tar tracepd & tracess only if estimate tar > (freespace - 50MB)
        if [ $estimate_tarsize -gt $min_size ]
        then
	    $ECHO "Not enough free CF=$free_space for all traceod=$estmate_tarsize, collect tracess and tracepd"
            $CHASSISCMD tar -cvf /var/log/TRACE_FFDC_OD.tar /var/trace/tracess* /var/trace/trace_id.dat
            pdfile=`ls -l /var/trace/tracepd* | wc -l`
            if [ "$pdfile" -ge 1 ] ;then
                $CHASSISCMD tar -rvf /var/log/TRACE_FFDC_OD.tar /var/trace/tracepd*
            fi
            /fabos/cliexec/errlogtest -i TRCE-5022 -a $Date
        else
	    # tar all trace od files
	    $ECHO "free CF=$free_space trace od size=$estmate_tarsize, collect all trace od files"
            $CHASSISCMD tar -cvf /var/log/TRACE_FFDC_OD.tar /var/trace/* /mnt/var/trace/*

	    # Moved the removal of traceod* files to RAS_POST module
        fi
    fi
}

#
# collect FOS oFF SS trace data file
#
start_trace_ata()
{
    # collect tracedump here if FOS OFF SS is invoked. If FOS is ON, trace should be collected as
    # defined in supportsave.conf
    if [ $fabos_off = no ]
    then
#	$ECHO "FOS is on, trace files are collected as supportsave.conf defined" > /var/trace/ffdc_trace_od
#        tar -cvf /var/log/TRACE_FFDC_OD.tar /var/trace/ffdc_trace_od
	return;
    fi

    #CTRACE_OLD,/bin/cat /var/tracedump.dmp, , ,N,Y,N,Y,Y,3,
    #CTRACE_OLD_MNT,/bin/cat /mnt/var/tracedump.dmp, , ,N,Y,N,N,Y,3,
    #CTRACE_NEW,/fabos/sbin/tracedump -z; /bin/cat /var/tracedump.dmp, , ,N,Y,N,Y,Y,4,

    Date=`/bin/date +%Y%m%d%H%M`
    dmpfile=/var/trace/tracess.$Date.old.tracedump.dmp
    /bin/cp /var/tracedump.dmp $dmpfile
    $CHASSISCMD gzip -f $dmpfile

    if [ -f "$dmpfile.gz" ]; then
	$CHASSISCMD tar -cvf /var/log/TRACE_FFDC_OD.tar $dmpfile.gz
    else
	$ECHO "$dmpfile.gz does not exist"
    fi


    /fabos/sbin/tracedump -z;
    Date=`/bin/date +%Y%m%d%H%M`
    dmpfile=/var/trace/tracess.$Date.new.tracedump.dmp
    /bin/cp /var/tracedump.dmp $dmpfile
    $CHASSISCMD gzip -f $dmpfile
    if [ -f "$dmpfile.gz" ]; then
	$CHASSISCMD tar -rvf /var/log/TRACE_FFDC_OD.tar $dmpfile.gz
    else
	$ECHO "$dmpfile.gz does not exist"
    fi

    Date=`/bin/date +%Y%m%d%H%M`
    dmpfile=/var/trace/tracess.$Date.mnt.tracedump.dmp
    /bin/cp /var/tracedump.dmp $dmpfile
    $CHASSISCMD gzip -f $dmpfile
    if [ -f "$dmpfile.gz" ]; then
	$CHASSISCMD tar -rvf /var/log/TRACE_FFDC_OD.tar $dmpfile.gz
    else
	$ECHO "$dmpfile.gz does not exist"
    fi

    /bin/rm -f /var/trace/tracess.*
}


# *******************************************
# Collect post supportsave data
# *******************************************
start_post()
{

    $CATFILE /var/log/config_updown.log

    $CATFILE /var/log/ag_desc.txt

    $CHASSISCMD  /fabos/cliexec/catconsole /proc/consolelog | grep -Ev "Mail Recipient|Mail From Address|User name"

    if [ -f /var/log/prev_consolelog ]; then
    $CATFILE /var/log/prev_consolelog | grep -Ev "Mail Recipient|Mail From Address|User name"
    fi

    if [ $sw_platform = 148  -o $sw_platform = 171 -o $sw_platform = 178 ]; then
        $CHASSISCMD  /fabos/cliexec/catconsole /proc/dp0_consolelog

        $CHASSISCMD  /fabos/cliexec/catconsole /proc/dp1_consolelog
    fi

    $CATFILE_RM /var/log/assert.log

    # Print /var/log/messages
    file_no="`ls /var/log/messages*`"
    for file in $file_no ; do
	$CATFILE $file
    done

    file_no="`ls /mnt/var/log/messages*`"
    for file in $file_no ; do
	$CATFILE $file
    done

    $CHASSISCMD  /fabos/cliexec/errdumpall

    # Collect the Audit logs
    $CHASSISCMD	/fabos/sbin/auditcfg --show
    $CHASSISCMD	/fabos/sbin/auditdump -s

	# SPSM log
	$CATFILE /var/log/sysrmd.log
	$CHASSISCMD /fabos/sbin/spsm --show
	$CHASSISCMD /fabos/sbin/spsm --history show
	$CHASSISCMD /fabos/sbin/spsm --record all

    $CATFILE /var/log/ss_ftp_dbg_log

    # SS utility (ftp, zip, tar ..) CLI error log */
    $CATFILE /var/log/ss.log

    # SS log
    $CATFILE /var/log/sslog

    # SS module CLI log
    $CATFILE /var/log/ssave.sh.log

    # record SS module statistic and display at end of RAS_MOST */
    $CATFILE_RM /var/log/ss_module_log

    # Removing the traceod* files here instead of RAS modules
    # to avoid missing of trace files in case of SS upload failed.
    $ECHO "Removing the traceod* files "
    /bin/rm -f /var/trace/*.od      >/dev/null 2>&1
    /bin/rm -f /var/trace/tracepd*  >/dev/null 2>&1
    /bin/rm -f /mnt/var/trace/*.od  >/dev/null 2>&1
    /bin/rm -f /mnt/var/trace/ffdc_trace_od  >/dev/null 2>&1
}



# *******************************************
# Collect fabric service
# *******************************************
# ZONE_LOG,/fabos/cliexec/zone evlogshow, , ,Y,Y,Y,Y,Y,1,
# RCS_LOG,/fabos/cliexec/rcscmd logshow, , ,Y,Y,Y,Y,N,1,
# NS_EVLOG,/fabos/cliexec/ns allevlog, , ,Y,Y,Y,Y,Y,1,
# FSPF_LOG,/fabos/rbin/fspfstateshow , , ,Y,Y,N,Y,Y,1,
# MSDUMP,/fabos/cliexec/ms dump, , ,Y,N,N,Y,Y,1,
# *******************************************
start_fabric_service()
{
    $SWITCHCMD /fabos/cliexec/zone evlogshow

	$SWITCHCMD /fabos/cliexec/zone tdztransshow

    $SWITCHCMD /fabos/cliexec/rcscmd logshow

    $SWITCHCMD /fabos/cliexec/ns allevlog

    $SWITCHCMD /fabos/cliexec/ns nshashstats -pid

    $SWITCHCMD /fabos/cliexec/ns nshashstats -pwwn

    $SWITCHCMD /fabos/cliexec/ns nshashstats -di

    $SWITCHCMD /fabos/cliexec/ns geptstatsshow -all

    $SWITCHCMD /fabos/cliexec/ns setmaxiu

	$SWITCHCMD /fabos/cliexec/ns locporttitagshow -all

	$SWITCHCMD /fabos/cliexec/ns nschassiswideqoshstatus

    $CHASSISCMD /fabos/rbin/fspfstateshow

    $SWITCHCMD /fabos/link_bin/iodshow

    $SWITCHCMD /fabos/link_bin/dlsshow

    $SWITCHCMD /fabos/cliexec/ufcs ufcs_state

    if [ $standby = no ]
      then
        $SWITCHCMD /fabos/bin/ess fab_hello_show
    fi

    if [ $standby = no ]
      then
	  $CHASSISCMD  /fabos/cliexec/ms dump
    fi

    $SWITCHCMD /fabos/cliexec/ns nsdevlog

    $SWITCHCMD /fabos/cliexec/ns condb --db -sw

    $SWITCHCMD /fabos/cliexec/ns condb --dump
}


# *******************************************
# Collect diag
# *******************************************
#DIAGLOG,/bin/cat /tmp/post* /var/log/verify* /var/log/burnin*, , ,Y,Y,N,N,Y,2,
#BURNINSTAT,/fabos/link_sbin/burninstatus, , ,N,N,N,Y,Y,2,
#BURNINERR,/fabos/link_bin/burninerrshow, , ,Y,N,N,Y,Y,2,
# *******************************************
start_diag()
{
    $ECHO "-------CURRENT POST LOGS-------"
    $CHASSISCMD /bin/cat /tmp/post*
    $ECHO "-------Backed-up POST logs before switch boot-------"
    # Print /var/tmp/post*
    file_no="`ls /var/tmp/post*`"
    for file in $file_no ; do
        $CATFILE_RM $file
    done

    $ECHO "-------FAILED POST LOG-------"
    $CHASSISCMD /bin/cat /var/log/post*

    $ECHO "------HOLDOFFSCRIPT LOG------"
    $CHASSISCMD /bin/cat /var/log/diag_holdoff*

    $CHASSISCMD  /bin/cat /var/log/verify*

    $CHASSISCMD  /bin/cat /var/log/burnin*
    # For Skybolt DP logs
    if [ $sw_platform = 148 -o $sw_platform = 171 ]; then
        $CHASSISCMD  /bin/cat /var/log/rc_plb_m2
        $CHASSISCMD  /bin/cat /var/log/rc_plb_m8
        $CHASSISCMD  /bin/cat /var/log/rc_fcippathtest
        $CHASSISCMD  /bin/cat /var/log/rc_plb_m2.fail
        $CHASSISCMD  /bin/cat /var/log/rc_plb_m8.fail
        $CHASSISCMD  /bin/cat /var/log/rc_fcippathtest.fail
	elif [ $sw_platform = 165 ] || [ $sw_platform = 166 ] || [ $sw_platform = 169 ]; then
		$ECHO "-------DP LOGS-------"
		$CHASSISCMD  /bin/cat /var/log/dpdd.log.*
		$ECHO "-------FCIPLED LOGS-------"
		$CHASSISCMD  /bin/cat /var/log/hrpfcipled.*
		$ECHO "-------BIST LOGS-------"
		$CHASSISCMD  /bin/cat /var/log/bist_*.log
		$ECHO "-------PLB LOGS-------"
		$CHASSISCMD  /bin/cat /var/log/plb_*.log
		$ECHO "-------HRPPLB LOGS-------"
		$CHASSISCMD  /bin/cat /var/log/hrpplb.dplog.*
		$ECHO "-------HRPFCIP DPLOGS-------"
		$CHASSISCMD  /bin/cat /var/log/hrpfcip.dplog.*
		$ECHO "-------HRPFCIP CPLOGS-------"
		$CHASSISCMD  /bin/cat /var/log/hrpfcip.cplog.*
    elif [ $sw_platform = 178 ]; then
                $ECHO "-------DP LOGS-------"
                $CHASSISCMD  /bin/cat /var/log/dpdd.log.*
                $ECHO "-------FCIPLED LOGS-------"
                $CHASSISCMD  /bin/cat /var/log/a_wingfcipled.*
                $ECHO "-------BIST LOGS-------"
                $CHASSISCMD  /bin/cat /var/log/diag_bist.log.*
                $ECHO "-------PLB LOGS-------"
                $CHASSISCMD  /bin/cat /var/log/diag_plb.log.*
                $ECHO "-------A_WINGPLB LOGS-------"
                $CHASSISCMD  /bin/cat /var/log/a_wingplb.dplog.*
                $ECHO "-------A_WINGFCIP DPLOGS-------"
                $CHASSISCMD  /bin/cat /var/log/a_wingfcip.dplog.*
                $ECHO "-------A_WINGFCIP CPLOGS-------"
                $CHASSISCMD  /bin/cat /var/log/a_wingfcip.cplog.*
    fi

    if [ $standby = no ]
    then
      $CHASSISCMD /fabos/sbin/burninstatus

      $CHASSISCMD  /fabos/bin/burninerrshow
    fi
}

# *******************************************
# Collect VF
# *******************************************
#VFCHASSISCMD,/fabos/bin/vfchassis_port_map, , ,Y,Y,N,Y,Y,2,
#VFSWITCH,/fabos/bin/vfswitch_port_info, , ,Y,Y,N,Y,Y,2,
# *******************************************
start_vf()
{
    $CHASSISCMD /fabos/rbin/vfchassis_port_map

    $CHASSISCMD  /fabos/rbin/vfswitch_port_info

    $CHASSISCMD /bin/cat /proc/fabos/lpm/lif_tree

    $CHASSISCMD /bin/cat /proc/fabos/lpm/lif_info

    $CHASSISCMD /bin/cat /proc/fabos/lpm/lif_tables
}

# *******************************************
# Collect ASIC reg dump
# *******************************************
# Test the blade capability. ( TODO)
# Need to identify if blade support proc-entry based db cmd, and
# Need to identify blade feature capability
# Input: slot#
# Return:  If Ok, blade_type & blade_id is set properly for the slot
# Otherwise, bladeid ==0, and blade_type == ""

# IMP Note - This function can get stuck when called for core-blade slot (e.g. Slot#7 on Allegiance) from Standby CP of Gen6 chassis
asic_db_blade_type_() {

   # initialize to unknown blade id & type
	bladeid=0
	blade_type=""
	num_anvils=0
	num_zeus=0
	num_condors=0
	num_pinballs=0
	num_c2s=0

	if test -f /proc/fabos/blade/$1/info; then

		# ref. blade id is defined in linux/include/brocade/swbd.h
		bladeid=`cat /proc/fabos/blade/$1/info | /bin/grep --binary-files=text bladeId | sed 's/[^0-9]//g'`

      case "$bladeid" in
		"213" ) blade_type="a-wing";;	# a-wing
		"186" ) blade_type="harpoon";;  # harpoon
		"154" ) blade_type="skybolt";;  # skybolt blade is 0...
		"37" ) blade_type="despina";num_c2s=1;;
		"55" ) blade_type="larissa";num_c2s=2;;
		"51" ) blade_type="triton";num_c2s=2;;
		"46" ) blade_type="hydra";num_c2s=2;;
		"56" ) blade_type="spirit";num_c2s=1;;
		"59" ) blade_type="tomahawk";num_c2s=1;;
		"53" ) blade_type="thor";num_c2s=9;;
		"52" ) blade_type="proteus";num_c2s=4;;
		"77" ) blade_type="quattro";num_c2s=4;;
		"29" ) blade_type="sprint";num_condors=2;num_pinballs=2;; # sprint
		"27" ) blade_type="viking";num_condors=6;; # viking
		"24" ) blade_type="marathon";num_condors=2;num_pinballs=2;;   # marathon
		"33" ) blade_type="scimitar";num_condors=2;num_pinballs=2;;
		"38" ) blade_type="sabre";num_condors=2;num_pinballs=2;;
		"45" ) blade_type="elara";num_c2s=1;num_anvils=3;num_zeus=3;; # Elara
		"74" ) blade_type="europa";num_c2s=1;num_anvils=3;num_zeus=3;;
		"69" ) blade_type="spike";num_c2s=1;;
		"75" ) blade_type="striker";num_c2s=1;;
		"42" ) blade_type="mace";num_c2s=2;;
		"43" ) blade_type="lance";num_c2s=2;;
		"31" ) blade_type="ironman";num_condors=1;;   # ironman
		"18" ) blade_type="electron";num_condors=2;;   # 32-ports condor
		"16" ) blade_type="neutron";num_condors=2;;  # core condors
		"36" ) blade_type="positron";num_condors=2;;  # 48-ports condor
		"39" ) blade_type="xenon";num_condors=2;;  # xenon
		* ) blade_type="others";num_condors=1;; # pulsar/stealth/proton
      esac

	fi
	# return status
	if [ "$blade_type" = "" ]; then
		$ECHO_xx 2> /dev/null;
	else
		$ECHO 2> /dev/null
	fi
}

start_asic_db_cmd() {

	# Do not dump database on standby CP.
	if [ $standby = yes ]
	then
		return
	fi

  # Capture the error counters across two polling interval.
##	sloterrshow -c2 -r


  # If db script not present, can't dump database
	if [ ! -e /fabos/link_sbin/db ]; then
		return
	fi

  export DB_SILENT_ERR=1
  cd /proc/fabos/blade
  regdumpcount=0
  c1regdmpcnt=0
  for i in `ls -d [0-9]* | sort -n` ; do
	#
	# no shell cmd should intervene between asic_db_blade_type and
	# check for return status stored in $?.
	# Note: "db" work on proc path slot#/mini#/chip#
	# This script assumes the following for ALL blade type.
	# The script has to be modified if the assumption becomes false.
    # 1) The following chip assigment per miniswitch
		# chip# = 0 => condor
		# chip# = 1 => pinball
		# chip# = 2 => flipper
	# 2) each mini has only 1 instance of a certain asic.

	# Capture bladeportmap for each blade to aid debugging backend links.
##	$ECHO  +++++++++++++++++ Bladeportmap "$i" ++++++++++++++++++++++++
##	$CHASSISCMD bladeportmap $i

	asic_db_blade_type_ $i
	if [ "$?" -eq 0 ]; then
		count=0
		while [ $count -lt $num_c2s ]
		do
			$ECHO  +++++++++++++++++ Asic Chip "$i"/$count/0 Regdump ++++++++++++++++++++++++
			$CHASSISCMD /fabos/sbin/c2regdump "$i"/$count/0
			$CHASSISCMD mv /var/regdump.dmp /var/c2regdump.dmp."$i".$count
			$CHASSISCMD gzip -f /var/c2regdump.dmp."$i".$count
			(( regdumpcount += 1 ))
			(( count += 1 ))
		done

		count=0
		while [ $count -lt $num_condors ]
		do
			$ECHO " "
			$ECHO  +++++++++++++++++ Asic Chip "$i"/$count/0 RTE database ++++++++++++++++++++++++
			$CHASSISCMD /fabos/link_rbin/asicswdump -s $i -m $count -g 0
			$ECHO " "
			$ECHO  +++++++++++++++++ Asic Chip "$i"/$count/0 Regdump ++++++++++++++++++++++++
			    (( count += 1 ))
		done
	fi
  done
  unset DB_SILENT_ERR

  if [ $regdumpcount -gt 0 ]
  then
  	#
	# Move all C2 reg dumps into a tar ball
	#
	/bin/cp /fabos/cliexec/c2hregdecode /var/
	/bin/cp /fabos/cliexec/c2hregcmp /var/

	tar -cvPf /tmp/C2REGDUMP.tar /var/c2regdump*gz /var/c2hregdecode /var/c2hregcmp 2> /dev/null

	/bin/rm /var/c2regdump*gz
	/bin/rm /var/c2hregdecode
	/bin/rm /var/c2hregcmp
	sync
	else
	$ECHO "No condor2 chips on this switch" > /var/c2emptyregdump.txt
	tar -cvf /tmp/C2REGDUMP.tar /var/c2emptyregdump.txt 2> /dev/null
	/bin/rm /var/c2emptyregdump.txt
	sync
  fi

  if [ $c1regdmpcnt -gt 0 ]
  then
    #
    # Move all C1 reg dumps into a tar ball
    #
    /bin/cp /fabos/cliexec/c1hregdecode /var/
    /bin/cp /fabos/cliexec/c1hregcmp /var/

    tar -cvPf /tmp/C1REGDUMP.tar /var/c1regdump*gz /var/c1hregdecode /var/c1hregcmp 2> /dev/null

    /bin/rm /var/c1regdump*gz
    /bin/rm /var/c1hregdecode
    /bin/rm /var/c1hregcmp
	sync
	else
    $ECHO "No condor chips on this switch" > /var/c1emptyregdump.txt
    tar -cvf /tmp/C1REGDUMP.tar /var/c1emptyregdump.txt 2> /dev/null
    /bin/rm /var/c1emptyregdump.txt
	sync
  fi
}

# *******************************************
# Collect REGDUMP/C2REGDUMP
# *******************************************
#C2REGDUMP,/bin/touch -c /tmp/c2regdump.tar,/bin/rm -f /tmp/c2regdump.tar,/tmp/c2regdump.tar,N,N,N,Y,Y,1,
#REGDUMP,/bin/touch -c /tmp/regdump.tar,/bin/rm -f /tmp/regdump.tar,/tmp/regdump.tar,N,N,N,Y,Y,1,
# *******************************************
start_regdump()
{
	/bin/touch -c /tmp/$1.tar
	if [ ! -f /tmp/$1.tar ]
	then
	return 255
	fi
	return 0
}

# *******************************************
# Terminate prior core_dump.sh scripts
# *******************************************
# *******************************************
kill_old_core_dump()
{
	dp0_ip="dp0"
	dp1_ip="dp1"
	echo "kill_old_core_dump:start"
	if [ $sw_platform = 148 -o $sw_platform = 165 -o $sw_platform = 166 -o $sw_platform = 171 ]; then
		# Check to see if there are still core_dump.sh scripts running from prior
		# failed support save efforts. If so, kill each pid before starting new
		# captures.
		KILLPIDS0=(`$CHASSISCMD rsh -n ${dp0_ip} ps | grep "core_dump" |grep -v "grep" | awk {'print $1'}`)
		if [ ${#KILLPIDS0[@]} -gt 0 ]
		then
			echo "Killing pids ${KILLPIDS0[@]}"
			$CHASSISCMD rsh -n $dp0_ip kill -9 ${KILLPIDS0[@]}
		fi
		KILLPIDS1=(`$CHASSISCMD rsh -n ${dp1_ip} ps | grep "core_dump" |grep -v "grep" | awk {'print $1'}`)
		if [ ${#KILLPIDS1[@]} -gt 0 ]
		then
			echo "Killing pids ${KILLPIDS1[@]}"
			$CHASSISCMD rsh -n $dp1_ip kill -9 ${KILLPIDS1[@]}
		fi
	fi
	echo "kill_old_core_dump:end"
}
# *******************************************
# Workaround to collect Ftrace from DPs.
#
# *******Applicable only to Skybolt**********
#
# *******************************************
# FTR_START,/fabos/cliexec/ssave.sh --ftracecollect, , ,N,Y,N,N,Y,15,
# *******************************************
start_ftrace()
{
	dp0_ip=""
	dp1_ip=""
	slotNum=0
	validSlot=0
	dpSlotDir=""
	harpInChassis=0
	echo "start_ftrace:starting"
	if [ $standby = no ]
	then
		if [ $sw_platform = 148 -o $sw_platform = 171 ]; then
			# Cleanup any old ftrace and core files
			dp0_ip="dp0"
			dp1_ip="dp1"
			$CHASSISCMD /bin/df
			$CHASSISCMD /bin/ls -l /var/log/*
			$CHASSISCMD /bin/ls -l /mnt/var/log/*
			dpSlotDir="/var/log/dpSlot0"
			/bin/touch -c $dpSlotDir
			if [ ! -f $dpSlotDir ]; then
				$CHASSISCMD /bin/mkdir $dpSlotDir
			fi
			# For SkyBolt only, clean up old style support save and
			# FFDC generated files in /var/log and /mnt/var/log
			# clean up any old core.* files if any
			if [ `ls /var/log/core.* | wc -l` -gt 0 ]; then
				cd /var/log;
				$CHASSISCMD /bin/rm /var/log/core* &
			fi
			if [ `ls /mnt/var/log/core.* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/log/$pri_core_files &
			fi
			# clean up any old se-bt-core-* files if any
			if [ `ls /var/log/se-bt-core* | wc -l` -gt 0 ]; then
				cd /var/log;
				$CHASSISCMD /bin/rm /var/log/se-bt-core* &
			fi
			if [ `ls /mnt/var/log/se-bt-core* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/log/$pri_sebt_files &
			fi
			# clean up any old logd* files if any
			if [ `ls /var/log/logd* | wc -l` -gt 0 ]; then
				$CHASSISCMD /bin/rm /var/log/logd* &
			fi
			if [ `ls /mnt/var/log/logd* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/log/$pri_sebt_files &
			fi
			# clean up any old blz_* files if any
			if [ `ls /var/log/blz_* | wc -l` -gt 0 ]; then
				cd /var/log;
				$CHASSISCMD /bin/rm /var/log/blz_* &
			fi
			if [ `ls /mnt/var/log/blz_* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/$pri_blz_files &
			fi
			# clean up any old Dmesg* files
			if [ `ls /var/log/Dmesg* | wc -l` -gt 0 ]; then
				cd /var/log;
				$CHASSISCMD /bin/rm /var/log/Dmesg* &
			fi
			if [ `ls /mnt/var/log/Dmesg* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/log/$pri_dmesg_files &
			fi
			# clean up any old Ftrace* files
			if [ `ls /var/log/Ftrace* | wc -l` -gt 0 ]; then
				cd /var/log;
				$CHASSISCMD /bin/rm /var/log/Ftrace* &
			fi
			if [ `ls /mnt/var/log/Ftrace* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/log/Ftrace* &
			fi
			kill_old_core_dump
			# Collects Dmesg & Ftrace on DP and rcps the files to /var/log
			echo "start_ftrace:starting core dump on SkyBolt DP0"
			$CHASSISCMD rsh -n $dp0_ip /fabos/libexec/core_dump.sh &
			echo "start_ftrace:starting core dump on SkyBolt DP1"
			$CHASSISCMD rsh -n $dp1_ip /fabos/libexec/core_dump.sh &
		elif [ $sw_platform = 178 ]; then
			# Cleanup any old ftrace and core files
			dp0_ip="dp0"
			$CHASSISCMD /bin/df
			$CHASSISCMD /bin/ls -l /var/log/*
			$CHASSISCMD /bin/ls -l /mnt/var/log/*
			dpSlotDir="/var/log/dpSlot0"
			/bin/touch -c $dpSlotDir
			if [ ! -f $dpSlotDir ]; then
				$CHASSISCMD /bin/mkdir $dpSlotDir
			fi
			# For A-Wing only, clean up old style support save and
			# FFDC generated files in /var/log and /mnt/var/log
			# clean up any old core.* files if any
			if [ `ls /var/log/core.* | wc -l` -gt 0 ]; then
				cd /var/log;
				$CHASSISCMD /bin/rm /var/log/core* &
			fi
			if [ `ls /mnt/var/log/core.* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/log/$pri_core_files &
			fi
			# clean up any old se-bt-core-* files if any
			if [ `ls /var/log/se-bt-core* | wc -l` -gt 0 ]; then
				cd /var/log;
				$CHASSISCMD /bin/rm /var/log/se-bt-core* &
			fi
			if [ `ls /mnt/var/log/se-bt-core* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/log/$pri_sebt_files &
			fi
			# clean up any old logd* files if any
			if [ `ls /var/log/logd* | wc -l` -gt 0 ]; then
				$CHASSISCMD /bin/rm /var/log/logd* &
			fi
			if [ `ls /mnt/var/log/logd* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/log/$pri_sebt_files &
			fi
			# clean up any old blz_* files if any
			if [ `ls /var/log/blz_* | wc -l` -gt 0 ]; then
				cd /var/log;
				$CHASSISCMD /bin/rm /var/log/blz_* &
			fi
			if [ `ls /mnt/var/log/blz_* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/$pri_blz_files &
			fi
			# clean up any old Dmesg* files
			if [ `ls /var/log/Dmesg* | wc -l` -gt 0 ]; then
				cd /var/log;
				$CHASSISCMD /bin/rm /var/log/Dmesg* &
			fi
			if [ `ls /mnt/var/log/Dmesg* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/log/$pri_dmesg_files &
			fi
			# clean up any old Ftrace* files
			if [ `ls /var/log/Ftrace* | wc -l` -gt 0 ]; then
				cd /var/log;
				$CHASSISCMD /bin/rm /var/log/Ftrace* &
			fi
			if [ `ls /mnt/var/log/Ftrace* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/rm /mnt/var/log/Ftrace* &
			fi
			kill_old_core_dump
			# Collects Dmesg & Ftrace on DP and rcps the files to /var/log
			echo "start_ftrace:starting core dump on Skybolt DP0"
			$CHASSISCMD rsh -n $dp0_ip /fabos/libexec/core_dump.sh &
		elif [ $sw_platform = 165 -o $sw_platform = 166 ]; then
			# Cleanup any old ftrace and core files
			# Venator/165 has 8 slots
			# Allegiance/166 has 12 slots
			$CHASSISCMD /bin/df
			$CHASSISCMD /bin/ls -l /var/log
			$CHASSISCMD /bin/ls -l /mnt/var/log
			cd /proc/fabos/blade
			for slotNum in `ls -d [1-9]* | sort -n` ; do
				asic_db_blade_type_ $slotNum
				if [ "$?" -eq 0 ]; then
					if [ "$blade_type" = "harpoon" ]; then
						harpInChassis=1
					fi
				fi
			done
			if [ $harpInChassis -eq 1 ]; then
				kill_old_core_dump
			fi
			for slotNum in `ls -d [1-9]* | sort -n` ; do
				asic_db_blade_type_ $slotNum
				if [ "$?" -eq 0 ]; then
					if [ "$blade_type" = "harpoon" ]; then
						case "$slotNum" in
							"3" ) dp0_ip="sl3_dp0";
									dp1_ip="sl3_dp1";
									validSlot=1;
									dpSlotDir="/var/log/dpSlot3";;
							"4" ) dp0_ip="sl4_dp0";
									dp1_ip="sl4_dp1";
									validSlot=1;
									dpSlotDir="/var/log/dpSlot4";;
							"5" ) dp0_ip="sl5_dp0";
									dp1_ip="sl5_dp1";
									validSlot=1;
									dpSlotDir="/var/log/dpSlot5";;
							"6" ) dp0_ip="sl6_dp0";
									dp1_ip="sl6_dp1";
									validSlot=1;
									dpSlotDir="/var/log/dpSlot6";;
							"7" ) dp0_ip="sl7_dp0";
									dp1_ip="sl7_dp1";
									validSlot=1;
									dpSlotDir="/var/log/dpSlot7";;
							"8" ) dp0_ip="sl8_dp0";
									dp1_ip="sl8_dp1";
									validSlot=1;
									dpSlotDir="/var/log/dpSlot8";;
							"9" ) dp0_ip="sl9_dp0";
									dp1_ip="sl9_dp1";
									validSlot=1;
									dpSlotDir="/var/log/dpSlot9";;
							"10" ) dp0_ip="sl10_dp0";
									dp1_ip="sl10_dp1";
									validSlot=1;
									dpSlotDir="/var/log/dpSlot10";;
							"11" ) dp0_ip="sl11_dp0";
									dp1_ip="sl11_dp1";
									validSlot=1;
									dpSlotDir="/var/log/dpSlot11";;
							"12" ) dp0_ip="sl12_dp0";
									dp1_ip="sl12_dp1";
									validSlot=1;
									dpSlotDir="/var/log/dpSlot12";;
							* ) validSlot=0;;
						esac
						# Collects Core files, Dmesg & Ftrace on DP and rcps the files to $dpSlotDir
						if [ $validSlot -eq 1 ]; then
							/bin/touch -c $dpSlotDir
							if [ ! -f $dpSlotDir ]; then
								$CHASSISCMD /bin/mkdir $dpSlotDir
							fi
							echo "start_ftrace:starting core dump on $slotNum DP0"
							$CHASSISCMD rsh -n $dp0_ip /fabos/libexec/core_dump.sh 0 &
							echo "start_ftrace:starting core dump on $slotNum DP1"
							$CHASSISCMD rsh -n $dp1_ip /fabos/libexec/core_dump.sh 0 &
						fi
					fi
				fi
			done
		fi
	fi
	echo "start_ftrace:done"
}

# *******************************************
# Collect Dmesg and Ftrace occur during ffdc event
# *******************************************
#DM_FTR_FFDC,/fabos/cliexec/ssave.sh --dmesg,/bin/rm -f /var/log/*.tar,/var/log/Dmsg_Ftr_ffdc.tar,N,N,N,Y,Y,2,
# *******************************************
start_dmesg()
{
	all_dp_files="/var/log/DM_FTR_FFDC.tar"
	mnt_all_dp_files="/mnt/var/log/DM_FTR_FFDC.tar"
	dpSlotDir=0

	dp0_ip="dp0"
	dp1_ip="dp1"

	echo "start_dmesg:starting FCIP DP data collection"
	if [ `ls $all_dp_files* | wc -l` -gt 0 ]; then
		$CHASSISCMD /bin/rm $all_dp_files*
	fi
	if [ `ls $mnt_all_dp_files* | wc -l` -gt 0 ]; then
		$CHASSISCMD /bin/rm $mnt_all_dp_files*
	fi
	if [ $sw_platform = 148 -o $sw_platform = 165 -o $sw_platform = 166 -o $sw_platform = 171 -o $sw_platform = 178 ]; then
		# As Ftrace collection on each DP takes around 15Mins core_dump.sh
		# is launched in background on both DPs from ssave.sh --ftracecollect.
		# Here it is checked to make sure the background processes have exited
		# before files are collected.

		# Wait for DP0 to complete
		while [ `$CHASSISCMD rsh -n $dp0_ip ps | grep core_dump| grep -v "grep" |awk '{ print $1 }' | wc -w` -gt 0 ];
		do
			echo -n ">"
			sleep 10
		done
		echo  ""

		# Wait for DP1 to complete
		while [ `$CHASSISCMD rsh -n $dp1_ip ps | grep core_dump| grep -v "grep" |awk '{ print $1 }' | wc -w` -gt 0 ];
		do
			echo -n "<"
			sleep 10;
		done
		echo  ""
	fi
	# When we get to this spot, none of the DPs are still collecting
	# debug data. All core_dump processing has been completed.
	if [ $sw_platform = 148 -o $sw_platform = 165 -o $sw_platform = 166 -o $sw_platform = 171 -o $sw_platform = 178 ]; then
		# [SB/HARP rm all old support save generated files.
		dp_corefiles="/var/log/DPcorefiles.tar"
		mnt_dp_corefiles="/mnt/var/log/DPcorefiles.tar"
		sebtfiles="/var/log/DPsebtfiles.tar"
		mnt_sebtfiles="/mnt/var/log/DPsebtfiles.tar"
		blzr_reg_files="/var/log/DPblzrregfiles.tar"
		mnt_blzr_reg_files="/mnt/var/log/DPblzrregfiles.tar"
		dmesg_files="/var/log/Dmesg_ffdc.tar"
		mnt_dmesg_files="/mnt/var/log/Dmesg_ffdc.tar"
		ftrace_files="/var/log/Xftraces.tar"
		mnt_ftrace_files="/mnt/var/log/Xftraces.tar"
		# Clean up all old generated SSAVE DP files.
		if [ `ls $dp_corefiles | wc -l` -gt 0 ]; then
			$CHASSISCMD /bin/rm $dp_corefiles
		fi
		if [ `ls $mnt_dp_corefiles | wc -l` -gt 0 ]; then
			$CHASSISCMD /bin/rm $mnt_dp_corefiles
		fi
		if [ `ls $sebtfiles | wc -l` -gt 0 ]; then
			$CHASSISCMD /bin/rm $sebtfiles
		fi
		if [ `ls $mnt_sebtfiles | wc -l` -gt 0 ]; then
			$CHASSISCMD /bin/rm $mnt_sebtfiles
		fi
		if [ `ls $blzr_reg_files | wc -l` -gt 0 ]; then
			$CHASSISCMD /bin/rm $blzr_reg_files
		fi
		if [ `ls $mnt_blzr_reg_files | wc -l` -gt 0 ]; then
			$CHASSISCMD /bin/rm $mnt_blzr_reg_files
		fi
		if [ `ls $dmesg_files | wc -l` -gt 0 ]; then
			$CHASSISCMD /bin/rm $dmesg_files
		fi
		if [ `ls $mnt_dmesg_files | wc -l` -gt 0 ]; then
			$CHASSISCMD /bin/rm $mnt_dmesg_files
		fi
		if [ `ls $ftrace_files | wc -l` -gt 0 ]; then
			$CHASSISCMD /bin/rm $ftrace_files
		fi
		if [ `ls $mnt_ftrace_files | wc -l` -gt 0 ]; then
			$CHASSISCMD /bin/rm $mnt_ftrace_files
		fi
		# capture core.* files if any
		pri_core_files="dpSlot*/core.*"
		if [ `ls /var/log/dpSlot*/core.* | wc -l` -gt 0 ] &&
			[ `ls /mnt/var/log/dpSlot*/core.* | wc -l` -gt 0 ]; then
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $dp_corefiles $pri_core_files
			$CHASSISCMD /bin/rm /var/log/$pri_core_files &
			cd /mnt/var/log;
			$CHASSISCMD /bin/tar rvPf $dp_corefiles $pri_core_files
			$CHASSISCMD /bin/rm /mnt/var/log/$pri_core_files &
		elif [ `ls /var/log/dpSlot*/core.* | wc -l` -gt 0 ]; then
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $dp_corefiles $pri_core_files
			$CHASSISCMD /bin/rm /var/log/$pri_core_files &
		elif [ `ls /mnt/var/log/dpSlot*/core.* | wc -l` -gt 0 ]; then
			cd /mnt/var/log;
			$CHASSISCMD /bin/tar cvPf $dp_corefiles $pri_core_files
			$CHASSISCMD /bin/rm /mnt/var/log/$pri_core_files &
		else
			echo "No DP corefiles found." > /var/log/NoDPcoreFiles.txt
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $dp_corefiles NoDPcoreFiles.txt
			$CHASSISCMD /bin/rm /var/log/NoDPcoreFiles.txt
		fi
		# capture se-bt-core-* files if any
		pri_sebt_files="dpSlot*/se-bt-core* dpSlot*/logd*"
		if [ `ls /var/log/dpSlot*/se-bt-core* | wc -l` -gt 0 ] &&
			[ `ls /mnt/var/log/dpSlot*/se-bt-core* | wc -l` -gt 0 ]; then
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $sebtfiles $pri_sebt_files
			$CHASSISCMD /bin/rm /var/log/$pri_sebt_files &
			cd /mnt/var/log;
			$CHASSISCMD /bin/tar rvPf $sebtfiles $pri_sebt_files
			$CHASSISCMD /bin/rm /mnt/var/log/$pri_sebt_files &
		elif [ `ls /var/log/dpSlot*/se-bt-core* | wc -l` -gt 0 ]; then
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $sebtfiles $pri_sebt_files
			$CHASSISCMD /bin/rm /var/log/$pri_sebt_files &
		elif [ `ls /mnt/var/log/dpSlot*/se-bt-core* | wc -l` -gt 0 ]; then
			cd /mnt/var/log;
			$CHASSISCMD /bin/tar cvPf $sebtfiles $pri_sebt_files
			$CHASSISCMD /bin/rm /mnt/var/log/$pri_sebt_files &
		else
			echo "No DP SE backtrace files found." > /var/log/NoDPsebtFiles.txt
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $sebtfiles NoDPsebtFiles.txt
			$CHASSISCMD /bin/rm /var/log/NoDPsebtFiles.txt
			# if no se-bt-files, capture logd files
			pri_sebt_files="dpSlot*/logd*"
			if [ `ls /var/log/dpSlot*/logd* | wc -l` -gt 0 ]; then
				$CHASSISCMD /bin/tar rvPf $sebtfiles $pri_sebt_files
				$CHASSISCMD /bin/rm /var/log/$pri_sebt_files &
			fi
			if [ `ls /mnt/var/log/dpSlot*/logd* | wc -l` -gt 0 ]; then
				cd /mnt/var/log;
				$CHASSISCMD /bin/tar rvPf $sebtfiles $pri_sebt_files
				$CHASSISCMD /bin/rm /mnt/var/log/$pri_sebt_files &
			fi
		fi
		# capture blz_* files if any
		pri_blz_files="dpSlot*/blz_*"
		if [ `ls /var/log/dpSlot*/blz_* | wc -l` -gt 0 ] &&
			[ `ls /mnt/var/log/dpSlot*/blz_* | wc -l` -gt 0 ]; then
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $blzr_reg_files $pri_blz_files
			$CHASSISCMD /bin/rm /var/log/$pri_blz_files &
			cd /mnt/var/log;
			$CHASSISCMD /bin/tar rvPf $blzr_reg_files $pri_blz_files
			$CHASSISCMD /bin/rm /mnt/var/log/$pri_blz_files &
		elif [ `ls /var/log/dpSlot*/blz_* | wc -l` -gt 0 ]; then
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $blzr_reg_files $pri_blz_files
			$CHASSISCMD /bin/rm /var/log/$pri_blz_files &
		elif [ `ls /mnt/var/log/dpSlot*/blz_* | wc -l` -gt 0 ]; then
			cd /mnt/var/log;
			$CHASSISCMD /bin/tar cvPf $blzr_reg_files $pri_blz_files
			$CHASSISCMD /bin/rm /mnt/var/$pri_blz_files &
		else
			echo "No Blzr register dump files(taken during FFDC / credit loss) found." > /var/log/NoDPblzFiles.txt
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $blzr_reg_files NoDPblzFiles.txt
			$CHASSISCMD /bin/rm /var/log/NoDPblzFiles.txt
		fi
		# capture Dmesg* files
		pri_dmesg_files="dpSlot*/Dmesg*"
		if [ `ls /var/log/dpSlot*/Dmesg* | wc -l` -gt 0 ] &&
			[ `ls /mnt/var/log/dpSlot*/Dmesg* | wc -l` -gt 0 ]; then
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $dmesg_files $pri_dmesg_files
			$CHASSISCMD /bin/rm /var/log/$pri_dmesg_files &
			cd /mnt/var/log;
			$CHASSISCMD /bin/tar rvPf $dmesg_files $pri_dmesg_files
			$CHASSISCMD /bin/rm /mnt/var/log/$pri_dmesg_files &
		elif [ `ls /var/log/dpSlot*/Dmesg* | wc -l` -gt 0 ]; then
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $dmesg_files $pri_dmesg_files
			$CHASSISCMD /bin/rm /var/log/$pri_dmesg_files &
		elif [ `ls /mnt/var/log/dpSlot*/Dmesg* | wc -l` -gt 0 ]; then
			cd /mnt/var/log;
			$CHASSISCMD /bin/tar cvPf $dmesg_files $pri_dmesg_files
			$CHASSISCMD /bin/rm /mnt/var/log/$pri_dmesg_files &
		else
			echo "No Dmesg files found." > /var/log/NoDPdmesgFiles.txt
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $dmesg_files NoDPdmesgFiles.txt
			$CHASSISCMD /bin/rm /var/log/NoDPdmesgFiles.txt
		fi
		# capture Ftrace* files
		# DP has already compressed the files.
		pri_ftrace_files="dpSlot*/Ftrace*"
		if [ `ls /var/log/dpSlot*/Ftrace* | wc -l` -gt 0 ] &&
			[ `ls /mnt/var/log/dpSlot*/Ftrace* | wc -l` -gt 0 ]; then
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $ftrace_files $pri_ftrace_files
			$CHASSISCMD /bin/rm /var/log/$pri_ftrace_files &
			cd /mnt/var/log;
			$CHASSISCMD /bin/tar rvPf $ftrace_files $pri_ftrace_files
			$CHASSISCMD /bin/rm /mnt/var/log/$pri_ftrace_files &
		elif [ `ls /var/log/dpSlot*/Ftrace* | wc -l` -gt 0 ]; then
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $ftrace_files $pri_ftrace_files
			$CHASSISCMD /bin/rm /var/log/$pri_ftrace_files &
		elif [ `ls /mnt/var/log/dpSlot*/Ftrace* | wc -l` -gt 0 ]; then
			cd /mnt/var/log;
			$CHASSISCMD /bin/tar cvPf $ftrace_files $pri_ftrace_files
			$CHASSISCMD /bin/rm /mnt/var/log/$pri_ftrace_files &
		else
			echo "No Ftrace files found." > /var/log/NoDPftraceFiles.txt
			cd /var/log;
			$CHASSISCMD /bin/tar cvPf $ftrace_files NoDPftraceFiles.txt
			$CHASSISCMD /bin/rm /var/log/NoDPftraceFiles.txt
		fi
		# start creating the DM_FTR_FFDC.tar file
		# add the dp_corefiles
		$CHASSISCMD /bin/tar cvPf $all_dp_files $dp_corefiles
		# remove the temporary dp_corefiles
		$CHASSISCMD /bin/rm $dp_corefiles
		# add the sebtfiles to DM_FTR_FFDC.tar
		$CHASSISCMD /bin/tar rvPf $all_dp_files $sebtfiles
		# remove the temporary sebtfiles
		$CHASSISCMD /bin/rm $sebtfiles
		# add the blzr_reg_files to DM_FTR_FFDC.tar
		$CHASSISCMD /bin/tar rvPf $all_dp_files $blzr_reg_files
		# remove the temporary blzr_reg_files
		$CHASSISCMD /bin/rm $blzr_reg_files
		# add the dmesg_files to DM_FTR_FFDC.tar
		$CHASSISCMD /bin/tar rvPf $all_dp_files $dmesg_files
		# remove the temporary dmesg_files
		$CHASSISCMD /bin/rm $dmesg_files
		# add the ftrace_files to DM_FTR_FFDC.tar
		$CHASSISCMD /bin/tar rvPf $all_dp_files $ftrace_files
		# remove the temporary ftrace_files
		$CHASSISCMD /bin/rm $ftrace_files
		$CHASSISCMD /fabos/bin/esmcmd dbgcmd ft ci a
		echo "start_dmesg:completed FCIP DP data collection"
	else
		# ]STRIKER
		# All other platforms, create text file if there are no DP Dmesg files
		# and add to DM_FTR_FFDC file.
		dmesgfiles=`ls -l /var/log/ | grep Dmesg-* | wc -l`
		if [ "$dmesgfiles" -eq 0 ]; then
			$ECHO "No DP Dmesg* files found" > /var/log/Dmesg_Ftr_ffdc
		fi
		ftracefiles=`ls -l /var/log/ | grep Ftrace-* | wc -l`
		if [ "$ftracefiles" -eq 0 ]; then
			$ECHO "No Ftrace* files found" > /var/log/Ftrace_ffdc
		fi
		$CHASSISCMD /bin/tar cvf /var/log/Dmesg_ffdc.tar /var/log/Dmesg*
		if [ "$dmesgfiles" -ne 0 ]; then
			$CHASSISCMD /bin/rm /var/log/Dmesg-*
		fi
		$CHASSISCMD /bin/tar cvf /var/log/Ftrace_ffdc.tar /var/log/Ftrace*
		if [ "$ftracefiles" -eq 0 ]; then
			$CHASSISCMD /bin/rm /var/log/Ftrace-*
		fi
		cd /var/log;
		$CHASSISCMD /bin/tar cvPf $all_dp_files /var/log/Dmesg_ffdc.tar /var/log/Ftrace_ffdc.tar
		$CHASSISCMD /bin/rm /var/log/Dmesg_ffdc.tar /var/log/Ftrace_ffdc.tar
		echo "start_dmesg:completed $dmesgfiles DP messages captured"
		echo "start_dmesg:completed $ftracefiles Ftrace files captured"
	fi
	return 0
}


# *******************************************
# Collect CRYP /Mace
# *******************************************
#CVLMD_DBG,/fabos/link_bin/cryptodbg --show -v, , ,N,N,N,N,N,5,
#CVLMD_INFO,/bin/cat /tmp/cvlm_lun.txt /tmp/cvlm_wwn_map.txt /tmp/cd.txt, , ,Y,Y,N,N,Y,5,
#SPM_DBG,/fabos/libexec/spmCmds, , ,N,N,N,N,N,5,
# *******************************************

start_pub_cert_collection()
{
LS=/bin/ls
CAT=/bin/cat
LOCAL_CERTS_PATH=/etc/fabos/certs/sw0/l/
REMOTE_CERTS_PATH=/etc/fabos/certs/sw0/r/
if [ -e $LOCAL_CERTS_PATH ]; then
echo -e "\nFiles in /etc/fabos/certs/sw0/l"
echo -e "---------------\n"
$CHASSISCMD $LS -l $LOCAL_CERTS_PATH

echo -e "\nData in files in /etc/fabos/certs/sw0/l"
echo -e "---------------\n"
$CHASSISCMD $CAT $LOCAL_CERTS_PATH/*
fi

if [ -e $REMOTE_CERTS_PATH ]; then
echo -e "\nFiles in /etc/fabos/certs/sw0/r"
echo -e "---------------\n"
$CHASSISCMD $LS -l $REMOTE_CERTS_PATH

echo -e "\nData in files in /etc/fabos/certs/sw0/r"
echo -e "---------------\n"
$CHASSISCMD $CAT $REMOTE_CERTS_PATH/*
fi

if [ -e /root/.ssh ]; then
echo -e "\nFiles in /root/.ssh"
echo -e "---------------\n"
$CHASSISCMD $LS -l /root/.ssh

echo -e "\nData in files in /root/.ssh"
echo -e "---------------\n"
$CHASSISCMD $CAT /root/.ssh/*
fi
}

start_cryp()
{
	# check the CP platform type for Mace/DCX/DCX-4S
	crypto_plat=$( /sbin/sin 2>/dev/null | sed -n 's/^.*SWBD\([^,]*\),.*/\1/p' )
	if [ $crypto_plat -eq 62 -o $crypto_plat -eq 67 -o $crypto_plat -eq 77 ]
	then
	    if [ $standby = no ]
    	then
			$CHASSISCMD /fabos/bin/cryptodbg --show -v

			$CHASSISCMD  /bin/cat /tmp/cvlm_lun.txt
	    	if [ -f /tmp/cvlm_lun.txt ]
		    then
			    /bin/rm -f /tmp/cvlm_lun.txt
		    fi


			$CHASSISCMD  /bin/cat /tmp/cvlm_wwn_map.txt
		    if [ -f /tmp/cvlm_wwn_map.txt ]
		    then
			    /bin/rm -f /tmp/cvlm_wwn_map.txt
			fi

			$CHASSISCMD  /bin/cat /tmp/cd.txt
		    if [ -f /tmp/cd.txt ]
		    then
			    /bin/rm -f /tmp/cd.txt
		    fi

			$CHASSISCMD  /fabos/libexec/spmCmds

			$CHASSISCMD	start_pub_cert_collection

			$CHASSISCMD /fabos/libexec/cnmdbg --cs

			$CHASSISCMD /fabos/libexec/cnmdbg --ds

			$CHASSISCMD /fabos/libexec/cnmdbg --ns

			$CHASSISCMD /fabos/libexec/cnmdbg --hs

			$CHASSISCMD /fabos/libexec/cnmdbg --evth

			$CHASSISCMD /fabos/libexec/cnmdbg --cfgs

			$CHASSISCMD  /bin/cat /etc/fabos/mace/bp_cnsl_log

			$CHASSISCMD  /bin/cat /etc/fabos/mace/bp_cnsl_log.old

			$CHASSISCMD  /bin/cat /etc/fabos/mace/cnm_hbt.log

			$CHASSISCMD  /bin/cat /etc/fabos/mace/cnm_node.log

			cmd_title "cnm_node.log"
			$CHASSIS /bin/cat /etc/fabos/mace/cnm_node.log
			/bin/echo ""
		fi
	else
		$ECHO "Platform does not support crypto [Plat: "$crypto_plat "]"
	fi
}

# *******************************************
# Collect FCIP Spike/Striker
# *******************************************
start_fcip()
{
    if [ $sw_platform = 83 ]; then
        spike_internal_cmds
    elif [ $sw_platform = 62 -o $sw_platform = 77 ]; then
        cd /proc/fabos/blade
        for j in `ls -d [0-9]* | sort -n` ; do
            # check for return status stored in $?.
            asic_db_blade_type_ $j
            if [ "$?" -eq 0 ]; then
                if [ "$blade_type" = "striker" ]; then
                    striker_internal_cmds $j
                fi
            fi
        done
    fi
}

# *******************************************
# Applicable only to Skybolt
# Collect ESMd logs at DP, for AMP
# *******************************************
start_ampdplogs()
{
    corefile="";
    if [ $sw_platform = 171 ]; then
        amp_internal_cmds
    else
        echo "Applicable only for AMP." > placeholder.txt
        tar cvPf /var/log/esmdamp.tar placeholder.txt
        rm placeholder.txt
    fi

}

# *******************************************
# Applicable only to Skybolt
# Collect ESMd logs at DP, for Skybolt
# *******************************************
start_fcipdplogs()
{
    corefile="";
    if [ $sw_platform = 148 -o $sw_platform = 165 -o $sw_platform = 166 -o $sw_platform = 178 ]; then
        skybolt_internal_cmds
    else
        echo "Applicable only for Skybolt." > placeholder.txt
        tar cvPf /var/log/esmd.tar placeholder.txt
        rm placeholder.txt
    fi

}

spike_internal_cmds()
{
    $CHASSISCMD /bin/date

    # Test if DP is up
    spiker_test_dp_up 16
    DP_UP=$?

    # Check for IPSec enabled tunnels on DP's
    spike_ipsec_on_dp
    ipsec_on_dp=$?

    if [ "$DP_UP" -eq 0 ]; then
        $ECHO "Detected DP to be down!"
    else
        $ECHO "Detected DP to be up!"
    fi

    if [ "$DP_UP" -eq 1 ] && [ "$ipsec_on_dp" -eq 1 ]; then
        spiker_security_dbg ge0
    elif [ "$DP_UP" -eq 1 ] && [ "$ipsec_on_dp" -eq 0 ]; then
        $ECHO "No IPSec tunnels detected on Spike DP"
    else
        $ECHO "Skipping IPSec debug commands due to DP down."
    fi

    $CHASSISCMD /bin/date
}

striker_internal_cmds()
{
    $CHASSISCMD /bin/date

    # Forcing SWITCHCMD to execute in a non-VF mode.
    # Optimized iteration of logical switches will be
    # handled below.
    ORIGINAL_SWITCHCMD="$SWITCHCMD"
    SWITCHCMD='cmd_nonvf'

    # VF mode is enabled
    if [ -n "$HOME_VF" ]; then
        # Get Configured Logical Switches and Corresponding FIDs
        ls_fids=( `lscfg_test --all | sed 's/^[ \t]*[^ \t]*[ \t]*//;s/[ \t].*//;/[0-9]/!d'` )
		  ls_swno=( `lscfg_test --all | grep -E "Base|Logical|Default" | sed 's/^[ \t]*//;s/\([0-9]\).*/\1/;'` )
        # Test if DP's are up
        for (( i=0; i < ${#ls_fids[@]}; i++ )); do
            setcontext ${ls_fids[$i]} ${ls_swno[$i]}

            # Get VEs in current logical switch
            ve_ports=( `switchshow -slot $1 | sed '/VE/!d;s/^[ \t]*[^ \t]*[ \t]*//;s/^[^ \t]*[ \t]*//;s/[ \t].*//'` )
            for (( j=0; j < ${#ve_ports[@]}; j++ )); do
                if [ ${ve_ports[$j]} -eq 12 ]; then
                    spiker_test_dp_up $1/12
                    DP0_UP=$?
                fi
                if [ ${ve_ports[$j]} -eq 22 ]; then
                    spiker_test_dp_up $1/22
                    DP1_UP=$?
                fi
            done
        done

        if [ "$DP0_UP" -eq 0 ]; then
            $ECHO "Detected DP0 to be down!"
        else
            $ECHO "Detected DP0 to be up!"
        fi
        if [ "$DP1_UP" -eq 0 ]; then
            $ECHO "Detected DP1 to be down!"
        else
            $ECHO "Detected DP1 to be up!"
        fi

        # Display Security Information for ge0
        for (( i=0; i < ${#ls_fids[@]}; i++ )); do
            setcontext ${ls_fids[$i]} ${ls_swno[$i]}

            # Get GEs in current logical switch
            ge_ports=( `switchshow -slot $1 | sed '/FCIP/!d;s/^[ \t]*[^ \t]*[ \t]*//;s/[ \t].*//'` )

            # Check for IPSec enabled tunnels on DP's
            striker_ipsec_on_dps $1
            ipsec_dps=$?

            if [ "$ipsec_dps" -eq 3 ]; then
                ipsec_on_dp0=1
                ipsec_on_dp1=1
            elif [ "$ipsec_dps" -eq 2 ]; then
                ipsec_on_dp0=0
                ipsec_on_dp1=1
            elif [ "$ipsec_dps" -eq 1 ]; then
                ipsec_on_dp0=1
                ipsec_on_dp1=0
            else
                ipsec_on_dp0=0
                ipsec_on_dp1=0
            fi

            # Security Information
            for (( j=0; j < ${#ge_ports[@]}; j++ )); do
                if [ ${ge_ports[$j]} = 'ge0' ]; then
                    if [ "$DP0_UP" -eq 1 ] &&  [ "$ipsec_on_dp0" -eq 1 ]; then
                        spiker_security_dbg $1/ge0
                    elif [ "$DP0_UP" -eq 1 ] && [ "$ipsec_on_dp0" -eq 0 ]; then
                        $ECHO "No IPSec tunnels detected on Striker slot: $1 DP0"
                    else
                        $ECHO "Skipping IPSec debug commands due to Striker slot: $1 DP0 down"
                    fi
                elif [ ${ge_ports[$j]} = 'xge0' ]; then
                    if [ "$DP1_UP" -eq 1 ] && [ "$ipsec_on_dp1" -eq 1 ]; then
                        spiker_security_dbg $1/xge0
                    elif [ "$DP1_UP" -eq 1 ] && [ "$ipsec_on_dp1" -eq 0 ]; then
                        $ECHO "No IPSec tunnels detected on Striker slot: $1 DP1"
                    else
                        $ECHO "Skipping IPSec debug commands due to Striker slot: $1 DP1 down"
                    fi
                fi
            done
        done
    else # Non-VF mode
        # Test if DP's are up
        spiker_test_dp_up $1/12
        DP0_UP=$?
        spiker_test_dp_up $1/22
        DP1_UP=$?

        if [ "$DP0_UP" -eq 0 ]; then
            $ECHO "Detected DP0 to be down!"
        else
            $ECHO "Detected DP0 to be up!"
        fi
        if [ "$DP1_UP" -eq 0 ]; then
            $ECHO "Detected DP1 to be down!"
        else
            $ECHO "Detected DP1 to be up!"
        fi

        # Check for IPSec enabled tunnels on DP's
        striker_ipsec_on_dps $1
        ipsec_dps=$?

        if [ "$ipsec_dps" -eq 3 ]; then
            ipsec_on_dp0=1
            ipsec_on_dp1=1
        elif [ "$ipsec_dps" -eq 2 ]; then
            ipsec_on_dp0=0
            ipsec_on_dp1=1
        elif [ "$ipsec_dps" -eq 1 ]; then
            ipsec_on_dp0=1
            ipsec_on_dp1=0
        else
            ipsec_on_dp0=0
            ipsec_on_dp1=0
        fi

        # Display Security Information
        if [ "$DP0_UP" -eq 1 ] && [ "$ipsec_on_dp0" -eq 1 ]; then
            spiker_security_dbg $1/ge0
        elif [ "$DP0_UP" -eq 1 ] && [ "$ipsec_on_dp0" -eq 0 ]; then
            $ECHO "No IPSec tunnels detected on Striker slot: $1 DP0"
        else
            $ECHO "Skipping IPSec debug commands due to Striker slot: $1 DP0 down"
        fi

        if [ "$DP1_UP" -eq 1 ] && [ "$ipsec_on_dp1" -eq 1 ]; then
            spiker_security_dbg $1/xge0
        elif [ "$DP1_UP" -eq 1 ] && [ "$ipsec_on_dp1" -eq 0 ]; then
            $ECHO "No IPSec tunnels detected on Striker slot: $1 DP1"
        else
            $ECHO "Skipping IPSec debug commands due to Striker slot: $1 DP1 down"
        fi
    fi

    # Restore Original SWITCHCMD variable
    SWITCHCMD="$ORIGINAL_SWITCHCMD"

    $CHASSISCMD /bin/date
}

spike_ipsec_on_dp()
{
    local ipsec_on_dp=0

    local ipsec_ves=`configshow | sed "/xportCfg.VE.*XFCIPTUNNEL.*IPSec=1.*/!d;s/.*VE\([0-9]*\).*/\1/"`
    for ipsec_ve in $ipsec_ves; do
        case "$ipsec_ve" in
        16|17|18|19|20|21)
            ipsec_on_dp=1
            ;;
        esac
    done

    return "$ipsec_on_dp"
}

striker_ipsec_on_dps()
{
    local ipsec_on_dp0=0
    local ipsec_on_dp1=0

    local ipsec_ve_on_cur_slot=`configshow | sed "/xportCfg.S$1.VE.*XFCIPTUNNEL.*IPSec=1.*/!d;s/.*VE\([0-9]*\).*/\1/"`
    for ipsec_ve in $ipsec_ve_on_cur_slot; do
        case "$ipsec_ve" in
        12|13|14|15|16|17|18|19|20|21)
            ipsec_on_dp0=1
            ;;
        22|23|24|25|26|27|28|29|30|31)
            ipsec_on_dp1=1
            ;;
        esac
    done

    if [ "$ipsec_on_dp1" -eq 1 ] && [ "$ipsec_on_dp0" -eq 1 ]; then
        return 3
    elif [ "$ipsec_on_dp1" -eq 1 ] && [ "$ipsec_on_dp0" -eq 0 ]; then
        return 2
    elif [ "$ipsec_on_dp1" -eq 0 ] && [ "$ipsec_on_dp0" -eq 1 ]; then
        return 1
    else
        return 0
    fi
}

spiker_test_dp_up()
{
    local dp_up=1

    local rc_dp=`portshow xtun $1 -fcp -itl -info|sed -n 's/.*rc = \([a-fA-F0-9]*\)/\1/p'`

    if [ "$rc_dp" == 'fffffffc' ]; then
        dp_up=0
    fi

    return $dp_up
}

spiker_security_dbg()
{
    $ECHO  /*------------------------------------------------
    $ECHO  Dumping Individual SA Logs:
    $ECHO  ------------------------------------------------*/

    for tt in 0 1 2 3 4 5 6 7 8 9 a b c d e f; do
        $ECHO  "IKEv2_Dump_SA_Log_00_0$tt"
        $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec IKEv2_Dump_SA_Log_00_0$tt
    done

#    $ECHO  /*------------------------------------------------
#    $ECHO  SPD Summary:
#    $ECHO  ------------------------------------------------*/
#    $ECHO  "IKEv2_Dump_SPD_Table"
#    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec IKEv2_Dump_SPD_Table

#    $ECHO  /*------------------------------------------------
#    $ECHO  IKEv2 Session Summary
#    $ECHO  ------------------------------------------------*/
#    $ECHO  "IKEv2_Dump_IKEv2_Dump_IKEv2_Summary"
#    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec IKEv2_Dump_IKEv2_Summary

#    $ECHO  /*------------------------------------------------
#    $ECHO  SADB Summary:
#    $ECHO  ------------------------------------------------*/
#    $ECHO  "IKEv2_Dump_SA_Summary"
#    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec IKEv2_Dump_SA_Summary

    $ECHO  /*------------------------------------------------
    $ECHO   SA_DI_SPI_Loop Summary:
    $ECHO  ------------------------------------------------*/
    $ECHO  "Mstr_Dump_SA_DA_SPI_Ram_00"
    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec Mstr_Dump_SA_DA_SPI_Ram_00
    $ECHO  "Mstr_Dump_SA_DA_SPI_Ram_01"
    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec Mstr_Dump_SA_DA_SPI_Ram_01

    $ECHO  /*------------------------------------------------
    $ECHO  Cavium Key Memory:
    $ECHO  ------------------------------------------------*/
    $ECHO  "IKEv2_Dump_Cavium_Key_Memory_Control_Block_Array"
    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec IKEv2_Dump_Cavium_Key_Memory_Control_Block_Array

    $ECHO  /*------------------------------------------------
    $ECHO  Master Log for both IKE/IPSEC and Ethernet-Driver
    $ECHO  ------------------------------------------------*/
    $ECHO  "Mstr_log"
    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec Mstr_log

    $ECHO  /*------------------------------------------------
    $ECHO  Master IPsec log:
    $ECHO  ------------------------------------------------*/
    $ECHO  "Mstr_ipsec_log"
    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec Mstr_ipsec_log

    $ECHO  /*------------------------------------------------
    $ECHO  Master IKEv2 Log:
    $ECHO  ------------------------------------------------*/
    $ECHO  "Mstr_ikev2_log"
    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec Mstr_ikev2_log

    $ECHO  /*------------------------------------------------
    $ECHO  Blaster Registers:
    $ECHO  ------------------------------------------------*/
    $ECHO  "Mstr_Dump_Blaster_Registers_00"
    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec Mstr_Dump_Blaster_Registers_00
    $ECHO  "Mstr_Dump_SALT_Memory_00"
    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec Mstr_Dump_SALT_Memory_00
    $ECHO  "Mstr_Revision"
    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec Mstr_Revision

#    $ECHO  /*------------------------------------------------
#    $ECHO  IKEv2 Session Control Block Summary:
#    $ECHO  ------------------------------------------------*/
#    $ECHO  "IKEv2_Dump_IKEv2_Session_Control_Block_Array"
#    $ECHO  portshow fcipdebug 1/ge0 ipsec IKEv2_Dump_IKEv2_Session_Control_Block_Array

#    $ECHO  /*------------------------------------------------
#    $ECHO  Individual IKEv2 Session Control blocks:
#    $ECHO  ------------------------------------------------*/

#    for tt in 0 1 2 3 4 5 6 7 8 9 a b c d e f; do
#        $ECHO  "IKEv2_Dump_IKEv2_Session_Control_Block_Entry_0$tt"
#        $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec IKEv2_Dump_IKEv2_Session_Control_Block_Entry_0$tt
#    done

#    $ECHO  /*------------------------------------------------
#    $ECHO  Individual SADB Entries:
#    $ECHO  ------------------------------------------------*/

#    for tt in 0 1 2 3 4 5 6 7 8 9 a b c d e f; do
#        $ECHO  "IKEv2_Dump_SADB_Entry_00_0$tt"
#        $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec IKEv2_Dump_SADB_Entry_00_0$tt
#    done

    $ECHO  /*------------------------------------------------
    $ECHO  Dumping Individual IKE Session Logs:
    $ECHO  ------------------------------------------------*/

    for tt in 00 01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f 10 11 12 13 14 15 16 17 18 19 1a 1b 1c 1d 1e 1f; do
        $ECHO  "IKEv2_Dump_IKE_Session_Log_$tt"
        $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec IKEv2_Dump_IKE_Session_Log_$tt
    done

#    $ECHO  /*------------------------------------------------
#    $ECHO  Individual SPD Entries:
#    $ECHO  ------------------------------------------------*/

#    for tt in 0 1 2 3 4 5 6 7 8 9 a b c d e f; do
#        $ECHO  "IKEv2_Dump_SPD_Entry_000$tt"
#        $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec IKEv2_Dump_SPD_Entry_000$tt
#    done

    $ECHO  /*------------------------------------------------
    $ECHO  Individual Cavium Key Memory Entries:
    $ECHO  ------------------------------------------------*/
    $ECHO  "IKEv2_Dump_Cavium_Key_Memory_Control_Block_Entry_00"
    $SWITCHCMD /fabos/cliexec/portshow fcipdebug $1 ipsec IKEv2_Dump_Cavium_Key_Memory_Control_Block_Entry_00
}

bcm_commands_awing()
{
	sleep 2;
	echo -ne "console on\n";
    sleep 2;
    echo -ne "ps\n";
    sleep 2;
    echo -ne "\n\n";
    sleep 2;
echo  -ne "echo ##### PRINT COUNTERS STATS for FIRST SHOW#####\n"
    echo -ne "show counters\n";
    sleep 2;
    echo "\n\n";
    echo -ne "echo ##### PRINT COUNTERS STATS FOR SECOND SHOW#####\n"
    echo -ne "show counters\n";
    sleep 2;
    echo "\n\n";
    echo  -ne "echo ##### PRINT COUNTERS STATS FOR THIRD SHOW#####\n"
    echo -ne "show counters\n";
    sleep 2;
    echo "\n\n";
    sleep 2;
    echo -ne "soc\n";
    echo -ne "rxmon show\n";
    echo -ne "getreg chg XMAC_RX_LSS_STATUS\n";
    sleep 2;
    echo -ne "getreg chg XLPORT_LINKSTATUS_DOWN\n";
    sleep 2;
    echo -ne "getreg chg XLPORT_LINKSTATUS_DOWN_CLEAR\n";
    sleep 2;
    echo -ne "dump chg EPC_LINK_BMAP\n";
    sleep 2;
    echo -ne "dump chg LINK_STATUS\n";
    sleep 2;
    echo -ne "getreg chg ING_EVENT_DEBUG\n";
    echo -ne "getreg chg ING_EVENT_DEBUG_2\n";
    echo -ne "setreg ING_EVENT_DEBUG 0\n";
    sleep 1;
    echo -ne "getreg chg ING_EVENT_DEBUG\n";
    echo -ne "getreg chg ING_EVENT_DEBUG_2\n";
    echo -ne "getreg chg EGR_DROP_VECTOR\n";
    echo -ne "dump chg TRUNK_GROUP\n";
    echo -ne "dump chg TRUNK_MEMBER\n";
    echo -ne "dump chg SOURCE_TRUNK_MAP_MODBASE\n";
    echo -ne "dump chg TRUNK_BITMAP\n";
    echo -ne "dump chg SOURCE_TRUNK_MAP\n";
    echo -ne "dump chg NONUCAST_TRUNK_BLOCK_MASK\n";
    sleep 1
    echo -ne "dump chg vlan\n";
    echo -ne "dump chg vlan_profile_2\n";
    echo -ne "dump soc\n";
    sleep 10;
    echo "\n\n";
    sleep 2;
    echo -ne "fp show\n";
    sleep 40;
    echo "\n\n";
    sleep 2;
    echo -ne "vlan show\n";
    sleep 10;
    echo "\n\n";
    sleep 2;
    echo -ne "trunk show\n";
    sleep 10;
    echo "\n\n";
    sleep 2;
	echo -ne "console off\n";
	sleep 2;
    echo -ne "exit\n\n";
    sleep 1;
}

bcm_commands()
{
    sleep 2;
    echo -ne "ps\n";
    sleep 2;
    echo -ne "\n\n";
    sleep 2;
echo  -ne "echo ##### PRINT COUNTERS STATS for FIRST SHOW#####\n"
    echo -ne "show counters\n";
    sleep 2;
    echo "\n\n";
    echo -ne "echo ##### PRINT COUNTERS STATS FOR SECOND SHOW#####\n"
    echo -ne "show counters\n";
    sleep 2;
    echo "\n\n";
    echo  -ne "echo ##### PRINT COUNTERS STATS FOR THIRD SHOW#####\n"
    echo -ne "show counters\n";
    sleep 2;
    echo "\n\n";
    sleep 2;
    echo -ne "soc\n";
    echo -ne "rxmon show\n";
    echo -ne "getreg chg XMAC_RX_LSS_STATUS\n";
    sleep 2;
    echo -ne "getreg chg XLPORT_LINKSTATUS_DOWN\n";
    sleep 2;
    echo -ne "getreg chg XLPORT_LINKSTATUS_DOWN_CLEAR\n";
    sleep 2;
    echo -ne "dump chg EPC_LINK_BMAP\n";
    sleep 2;
    echo -ne "dump chg LINK_STATUS\n";
    sleep 2;
    echo -ne "getreg chg ING_EVENT_DEBUG\n";
    echo -ne "getreg chg ING_EVENT_DEBUG_2\n";
    echo -ne "setreg ING_EVENT_DEBUG 0\n";
    sleep 1;
    echo -ne "getreg chg ING_EVENT_DEBUG\n";
    echo -ne "getreg chg ING_EVENT_DEBUG_2\n";
    echo -ne "getreg chg EGR_DROP_VECTOR\n";
    echo -ne "dump chg TRUNK_GROUP\n";
    echo -ne "dump chg TRUNK_MEMBER\n";
    echo -ne "dump chg SOURCE_TRUNK_MAP_MODBASE\n";
    echo -ne "dump chg TRUNK_BITMAP\n";
    echo -ne "dump chg SOURCE_TRUNK_MAP\n";
    echo -ne "dump chg NONUCAST_TRUNK_BLOCK_MASK\n";
    sleep 1
    echo -ne "dump chg vlan\n";
    echo -ne "dump chg vlan_profile_2\n";
    echo -ne "dump soc\n";
    sleep 10;
    echo "\n\n";
    sleep 2;
    echo -ne "fp show\n";
    sleep 40;
    echo "\n\n";
    sleep 2;
    echo -ne "vlan show\n";
    sleep 10;
    echo "\n\n";
    sleep 2;
    echo -ne "trunk show\n";
    sleep 10;
    echo "\n\n";
    sleep 2;
    echo -ne "exit\n\n";
    sleep 1;
}

bcm_multi_slot_cmd_chp()
{
        unit=$1;

        echo -ne "\n\n";
    sleep 2;
        echo -ne "${unit}:\n\n";
    sleep 2;
    echo -ne "\n\n";
    sleep 2;
    echo -ne "ps\n";
    sleep 2;
    echo -ne "\n\n";
    sleep 2;
    echo -ne "show counters\n";
    sleep 2;
    echo -ne "\n\n";
    echo  -ne "echo ##### PRINT COUNTERS STATS for SECOND SHOW#####\n"
    echo -ne "show counters\n";
    sleep 2;
    echo -ne "\n\n";
    echo  -ne "echo ##### PRINT COUNTERS STATS for THIRD SHOW#####\n"
    echo -ne "show counters\n";
    sleep 2;
    echo -ne "\n\n";
    sleep 2;
    echo -ne "soc\n";
    echo -ne "rxmon show\n";
    echo -ne "getreg chg XMAC_RX_LSS_STATUS\n";
    echo -ne "\n\n";
    echo -ne "getreg chg XLPORT_LINKSTATUS_DOWN\n";
    echo -ne "\n\n";
    echo -ne "getreg chg XLPORT_LINKSTATUS_DOWN_CLEAR\n";
    echo -ne "\n\n";
    echo -ne "dump chg EPC_LINK_BMAP\n";
    echo -ne "\n\n";
    echo -ne "dump chg LINK_STATUS\n";
    echo -ne "\n\n";
    echo -ne "getreg chg ING_EVENT_DEBUG\n";
    echo -ne "\n\n";
    echo -ne "getreg chg ING_EVENT_DEBUG_2\n";
    echo -ne "\n\n";
    echo -ne "setreg ING_EVENT_DEBUG 0\n";
    sleep 1;
    echo -ne "\n\n";
    echo -ne "getreg chg ING_EVENT_DEBUG\n";
    echo -ne "\n\n";
    echo -ne "getreg chg ING_EVENT_DEBUG_2\n";
    echo -ne "\n\n";
    echo -ne "getreg chg EGR_DROP_VECTOR\n";
    echo -ne "\n\n";
    echo -ne "dump chg TRUNK_GROUP\n";
    echo -ne "\n\n";
    echo -ne "dump chg TRUNK_MEMBER\n";
    echo -ne "\n\n";
    echo -ne "dump chg SOURCE_TRUNK_MAP_MODBASE\n";
    echo -ne "\n\n";
    echo -ne "dump chg TRUNK_BITMAP\n";
    echo -ne "\n\n";
    echo -ne "dump chg SOURCE_TRUNK_MAP\n";
    echo -ne "\n\n";
    echo -ne "dump chg NONUCAST_TRUNK_BLOCK_MASK\n";
    sleep 1
    echo -ne "\n\n";
    echo -ne "dump chg vlan\n";
    echo -ne "\n\n";
    echo -ne "dump chg vlan_profile_2\n";

    echo -ne "\n\n";
    echo -ne "dump soc\n";
    sleep 10;
    echo -ne "\n\n";
    sleep 2;
    echo -ne "fp show\n";
    sleep 40;
    echo -ne "\n\n";
    sleep 2;
    echo -ne "vlan show\n";
    sleep 10;
    echo -ne "\n\n";
    sleep 2;
    echo -ne "trunk show\n";
    sleep 10;
    echo -ne "\n\n";
    sleep 2;
    echo -ne "exit\n\n";
    sleep 1;
}

is_bcm_unit_attached()
{
	slot=$1;
	unit=$2;
	bcm_attached="no";

	if [ "$unit" = "-1" ]; then
		bcm_attached="no"
	else
		chipstate=`/fabos/link_sbin/db $slot/0/1 bcm show stats chip_info 0 | grep BCM | cut -d' ' -f2`;
		$ECHO "=========== Chipstate $chipstate============";
#		Collect BCM shell stats only whn BCM chip is initialized with chip init_state=BCM_INIT_DONE_ALL
#		BCM_INIT_DONE_ALL == init_state is marked BCM_INIT_DONE + chip_init_done_all == 1,
#		bcmsdk_attach_check check passes.
		if [ "$chipstate" = "BCM_INIT_DONE_ALL" ] || [ "$chipstate" = "BCM_INIT_FAULT" ]; then
			bcm_attached="yes"
		fi
	fi
}

start_bcm_stats()
{
    if [ $sw_platform = 148 -o $sw_platform = 178 ]; then
		$ECHO -ne "******* Applicable only for Skybolt/A-Wing *******\n\n";
    	if test -d /proc/fabos/blade/0/0/1/ ; then
			$ECHO  "LAG stats dumping******";
			/fabos/link_sbin/db 0/0/1 bcm show stats lag
			if [ $sw_platform = 178 ]; then
				/fabos/link_sbin/db 0/0/1 bcm show stats tcam ip_config
			fi
			#$ECHO -ne "========== TCAM DUMP START  ==========\n";
			/fabos/link_sbin/db 0/0/1 bcm show stats tcam all
			$ECHO -ne "========== TCAM DUMP DIFF FIRST  ==========\n";
			/fabos/link_sbin/db 0/0/1 bcm show stats tcam diff
                        $ECHO -ne "========== TCAM DUMP DIFF SECOND  ==========\n";
                        /fabos/link_sbin/db 0/0/1 bcm show stats tcam diff
			sleep 1;
                        $ECHO -ne "========== TCAM DUMP DIFF THIRD  ==========\n";
                        /fabos/link_sbin/db 0/0/1 bcm show stats tcam diff
                        $ECHO -ne "========== TCAM DUMP DIFF FOURTH  ==========\n";
                        /fabos/link_sbin/db 0/0/1 bcm show stats tcam diff

			#$ECHO -ne "========== TCAM DUMP END  ==========\n";
		fi
        if [ "`cat /proc/system/lliRegShow | grep gbe_lli_global_intr_mask|awk '{ print $2 }'`" == "00"  ]
		then
			$ECHO -ne "========== BCM SHELL COMMANDS BEGIN ==========\n\n";
			bcm_commands | /fabos/libexec/bcm.user.proxy;
			#$ECHO -ne "========== BCM SHELL COMMANDS END   ==========\n";
    	fi

		if [  $sw_platform = 178 ]
		then
			$ECHO -ne "========== BCM SHELL COMMANDS BEGIN ==========\n\n";
			bcm_commands_awing | /fabos/libexec/bcm.user.proxy;
			#$ECHO -ne "========== BCM SHELL COMMANDS END   ==========\n";
		fi
    fi

    if [ $sw_platform -eq 165 ] || [ $sw_platform -eq 166 ]; then

		# Temp fix for Faulty 90 case. If any Harpoon Faulty 90,
		# return.
		slotshow | grep 186 | grep FAULTY | grep 90

		if [ $? -eq 0 ]; then
			return;
		fi

		echo -ne "========== BCM SHELL COMMANDS BEGIN ==========\n\n";

		for i in `seq 3 12`
		do
			$ECHO  "Trying Slot $i";
			if [ -d /proc/fabos/blade/$i/0/1/ ]; then
				$ECHO -ne "============DB dump start for slot ${i}======================\n"
				/fabos/link_sbin/db ${i}/0/1 bcm show stats ha_crc sdkwmem_crc
				/fabos/link_sbin/db ${i}/0/1 bcm show stats ha_crc acl_crc
				/fabos/link_sbin/db ${i}/0/1 bcm show stats tcam all
                        	$ECHO -ne "========== TCAM DUMP DIFF FIRST  ==========\n";
                        	/fabos/link_sbin/db ${i}/0/1 bcm show stats tcam diff
                        	$ECHO -ne "========== TCAM DUMP DIFF SECOND  ==========\n";
                        	/fabos/link_sbin/db ${i}/0/1 bcm show stats tcam diff
                        	sleep 1;
                        	$ECHO -ne "========== TCAM DUMP DIFF THIRD  ==========\n";
                        	/fabos/link_sbin/db ${i}/0/1 bcm show stats tcam diff
                        	$ECHO -ne "========== TCAM DUMP DIFF FOURTH  ==========\n";
                        	/fabos/link_sbin/db ${i}/0/1 bcm show stats tcam diff

				if [ $standby = yes ]; then
					continue;
				fi

				#$ECHO -ne "============ DB dump end =================\n\n"

				unit=`/fabos/link_sbin/db ${i}/0/1 bcm show stats chip_info 1 \
					| grep "slot\[${i}\]" | cut -d' ' -f3`

				$ECHO -ne "=========== Checking if BCM unit ${unit} is attached=========\n\n"

				is_bcm_unit_attached $i $unit

				if [ "$bcm_attached" = "yes" ]; then
					$ECHO -ne "========== BCM CHIP ${unit} ==========\n";
					bcm_multi_slot_cmd_chp ${unit} | /fabos/libexec/bcm.user.proxy;
				else
					$ECHO -ne "======BCM CHIP ${unit} NOT ATTATCHED =========\n";
				fi
			fi
		done

		echo -ne "========== BCM SHELL COMMANDS END   ==========\n";

		if [ $standby = no ]; then
			$ECHO  "LAG stats dumping";
			for i in `seq 3 12`
			do	$ECHO  "LAG stats dumping slot $i";
				if [ -d /proc/fabos/blade/$i/0/1/ ];then
					/fabos/link_sbin/db $i/0/1 bcm show stats lag
				fi
			done
		fi

		#Add LAG stats for all of the possible Harpoon blades/slot here
   	fi
}

# *******************************************
# Applicable only to Skybolt & Harpoon
# Collect BLZR stats
# *******************************************
start_blzr_stats()
{
	if [ $sw_platform = 148 -o $sw_platform = 165 -o $sw_platform = 166 -o $sw_platform = 171 -o $sw_platform = 178 ]; then
		$ECHO "Gathering BLZR stats ..."

		# Collect HA-Sync & OLV stats of Blzr driver from Active & Standby CPs
		cd /proc/fabos/blade
		for sl_n in `ls -d [0-9]* | sort -n` ; do
			$ECHO "Checking type of blade in slot#$sl_n ..."
			# Pizzabox
			if [ $sw_platform = 148 -o $sw_platform = 171 -o $sw_platform = 178]; then
				$ECHO "Collecting BLZR stats for slot#$sl_n"
				# Get OLV Stats
				$CHASSISCMD /fabos/link_sbin/db $sl_n/0/2 blz show \do 1 5
				if [ $sw_platform != 178 ]; then
					$CHASSISCMD /fabos/link_sbin/db $sl_n/0/3 blz show \do 1 5
				fi
				# Get CRC of IPP_SMEM
				$CHASSISCMD /fabos/link_sbin/db $sl_n/0/2 blz misc \do 1 16
				if [ $sw_platform != 178 ]; then
					$CHASSISCMD /fabos/link_sbin/db $sl_n/0/3 blz misc \do 1 16
				fi
				# Get ISC Stats
				$CHASSISCMD /fabos/link_sbin/db $sl_n/0/2 blz misc \do 1 27
				if [ $sw_platform != 178 ]; then
					$CHASSISCMD /fabos/link_sbin/db $sl_n/0/3 blz misc \do 1 27
				fi

			# Chassis
			else
				$CATFILE /proc/fabos/blade/$sl_n/property | grep 186 > /dev/null 2>&1
				if [ $? -eq 0 ]; then
					$ECHO "Collecting BLZR stats for slot#$sl_n"
					# Get OLV Stats
					$CHASSISCMD /fabos/link_sbin/db $sl_n/0/2 blz show \do 1 5
					$CHASSISCMD /fabos/link_sbin/db $sl_n/0/3 blz show \do 1 5
					# Get CRC of IPP_SMEM & HA-Sync Stats
					$CHASSISCMD /fabos/link_sbin/db $sl_n/0/2 blz misc \do 1 16
					$CHASSISCMD /fabos/link_sbin/db $sl_n/0/3 blz misc \do 1 16
					# Get ISC Stats
					$CHASSISCMD /fabos/link_sbin/db $sl_n/0/2 blz misc \do 1 27
					$CHASSISCMD /fabos/link_sbin/db $sl_n/0/3 blz misc \do 1 27
				fi
			fi
		done
	fi
}

amp_internal_cmds()
{
	$ECHO "Gathering AMP debug files."

	# Forcefully create an empty tar file. If the file is too large,
	# the filesystem can't do the 'rm' command. Tar can understand large files
	# so this will forcefully create something that is small enough that can
	# be deleted
	$CHASSISCMD /bin/tar -cf /var/log/esmdamp.tar /dev/null 1> /dev/null 2> /dev/null
	$CHASSISCMD /bin/rm -f /var/log/esmdamp.tar

	# Only grab DP logs from active CP
	if [ $standby = no ]; then
		cd /proc/fabos/blade
		for slotNum in `ls -d [0-9]* | sort -n` ; do
			asic_db_blade_type_ $slotNum
			if [ "$?" -eq 0 ]; then
				if [ "$blade_type" = "skybolt" ]; then
					$CHASSISCMD /bin/rcp dp0:/var/log/esmd* /var/log/
					$CHASSISCMD /bin/rcp dp1:/var/log/esmd* /var/log/
				elif [ "$blade_type" = "harpoon" ]; then
					$CHASSISCMD /bin/rcp sl${slotNum}_dp0:/var/log/esmd* /var/log/
					$CHASSISCMD /bin/rcp sl${slotNum}_dp1:/var/log/esmd* /var/log/
				fi
			fi
		done
	fi

	$CHASSISCMD /bin/tar -cvf /var/log/esmdamp.tar /var/log/esmd* /mnt/var/log/esmd*
	start_blzr_stats
}

skybolt_internal_cmds()
{
	$ECHO "Gathering extension debug files."

	# Forcefully create an empty tar file. If the file is too large,
	# the filesystem can't do the 'rm' command. Tar can understand large files
	# so this will forcefully create something that is small enough that can
	# be deleted
	$CHASSISCMD /bin/tar -cf /var/log/esmd.tar /dev/null 1> /dev/null 2> /dev/null
	$CHASSISCMD /bin/rm -f /var/log/esmd.tar

	# Only grab DP logs from active CP
	if [ $standby = no ]; then
		cd /proc/fabos/blade
		for slotNum in `ls -d [0-9]* | sort -n` ; do
			asic_db_blade_type_ $slotNum
			if [ "$?" -eq 0 ]; then
				if [ "$blade_type" = "skybolt" ]; then
					$CHASSISCMD /bin/rcp dp0:/var/log/esmd* /var/log/
					$CHASSISCMD /bin/rcp dp1:/var/log/esmd* /var/log/
				elif [ "$blade_type" = "harpoon" ]; then
					$CHASSISCMD /bin/rcp sl${slotNum}_dp0:/var/log/esmd* /var/log/
					$CHASSISCMD /bin/rcp sl${slotNum}_dp1:/var/log/esmd* /var/log/
				elif [ "$blade_type" = "a-wing" ]; then
					$CHASSISCMD /bin/rcp dp0:/var/log/esmd* /var/log/
				fi
			fi
		done
	fi

	$CHASSISCMD /bin/tar -cvf /var/log/esmd.tar /var/log/esmd* /mnt/var/log/esmd*
	start_blzr_stats
}

# Collect AN
# *******************************************
#FRMLOG_DUMP,/fabos/sbin/framelog --show -n 1200 * 10, , ,Y,Y,N,Y,Y,3,
#BD_DUMP,/fabos/sbin/bottleneckmon --status, , ,Y,Y,N,Y,Y,3,
# *******************************************
start_an()
{
    $SWITCHCMD /fabos/sbin/bottleneckmon --status

    $CHASSISCMD	/fabos/sbin/framelog --status

    $CHASSISCMD	/fabos/sbin/framelog --show -n 1200

    $SWITCHCMD /fabos/cliexec/bd_debug

	$ECHO ""
	for i in `seq 0 7`
	do
		if [ -f /etc/fabos/bneck.$i.cfg ]; then
			$ECHO "======== Bottleneck Configuration for Context $i ========"
			$CHASSISCMD /bin/cat /etc/fabos/bneck.$i.cfg
			$ECHO ""
		fi
		$ECHO "======== Bottleneck show for Context $i ========"
		$SWITCHCMD /fabos/sbin/bottleneckmon --show
		$ECHO ""
		$ECHO "======== Bottleneck show * for Context $i ========"
		$SWITCHCMD /fabos/sbin/bottleneckmon --show "'*'"
		$ECHO ""
	done
}
# *******************************************
# Collect Fabos-off acquirable info
# *******************************************
start_fabos_off()
{
   $CHASSISCMD /usr/bin/top -n 1

   $CHASSISCMD /sbin/ethtool eth0

   $CHASSISCMD /sbin/mii-tool -vvv

   $ECHO "du -xh / | /bin/sort:"
   /usr/bin/du -xh / | /bin/sort
   $ECHO ""

   $CHASSISCMD /bin/ps exfcl

   $CHASSISCMD /bin/rpm -qa

   $CHASSISCMD /bin/cat /var/log/dmesg

   $CHASSISCMD /bin/dmesg

   $CHASSISCMD /bin/cat /etc/fstab

   $CHASSISCMD /bin/cat /etc/mtab

   $ECHO "printing proc entries"
   if [ $standby = no ]
   then
	proc_entries="cmdline,cpuinfo,devices,filesystems,interrupts,meminfo,modules,mounts,mtd,partitions,pci,slabinfo,stat,tty/drivers,uptime,version"
   else
	proc_entries="cmdline,cpuinfo,devices,filesystems,interrupts,meminfo,modules,mounts,mtd,partitions,pci,slabinfo,stat,tty/drivers,uptime,version"
   fi
   for proc_entry in `$ECHO $proc_entries | /usr/bin/tr "," "\n"`
   do
      $CHASSISCMD /bin/cat /proc/$proc_entry
   done

   $CHASSISCMD /usr/bin/find /core_files /mnt/core_files -type f

   $CHASSISCMD /bin/rpm -Va

   $CHASSISCMD /usr/bin/tail -200 /var/log/user.log

   cmds="/sbin/bootenv,/sbin/sin,/bin/df,/sbin/ifconfig,/sbin/route,/bin/hostname"
   for cmd in `$ECHO $cmds | /usr/bin/tr "," "\n"`
   do
      $CHASSISCMD $cmd
   done

   $CHASSISCMD /sbin/arp -n

   $CHASSISCMD /sbin/ethtool eth0

   $CHASSISCMD /sbin/mii-tool -vv eth0

   $CHASSISCMD /sbin/ethtool --statistics eth0

   $CHASSISCMD /sbin/ip -s link

   $CHASSISCMD /sbin/ip -s addr

   $CHASSISCMD /bin/cat /proc/net/tcp

   $CHASSISCMD /bin/cat /proc/net/udp

   $CHASSISCMD /bin/cat /proc/net/netstat

   $CHASSISCMD /bin/cat /proc/net/sockstat

}

# *******************************************
# Collect VPWWN info
# *******************************************
#VPWWN_INFO,/fabos/cliexec/fapwwn --show all, , ,N,N,N,N,N,5,
#VPWWN_INFO,/fabos/cliexec/fapwwn --show -config, , ,N,N,N,N,N,5,
#VPWWN_INFO,/bin/cat /proc/sys/, , ,N,N,N,N,N,5,
# *******************************************
start_vpwwn()
{
	all_inst=`ls /proc/fabos/switch/`
	for sw_inst in $all_inst
	do
		$CHASSISCMD /bin/cat /proc/fabos/switch/$sw_inst/vpwwn_db
	done

	$SWITCHCMD /fabos/cliexec/fapwwn --show -config

	$SWITCHCMD /fabos/cliexec/fapwwn --show -totalcount

	$SWITCHCMD /fabos/cliexec/fapwwn --show -vsdumpall

	$CHASSISCMD /fabos/cliexec/configshow -all | /bin/grep -i "vpwwn"

}

# *******************************************
# Collect system info
# *******************************************
start_sys()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Standby CP: $standby"
     $ECHO "Date:"
     /bin/date
}

start_kvlog()
{
	$ECHO "Not supported" >/tmp/kvlog
	/bin/tar zcvf /tmp/ENC_LOGGER.tgz /tmp/kvlog
	/bin/rm /tmp/kvlog
	return 0

}

# *******************************************
# Collect Memory patroller logs
# *******************************************
start_mplog()
{
	nfile=`ls -l /var/log/ | grep mp_trace* | wc -l`
	if [ "$nfile" -eq 0 ]
	then
		$ECHO "No MP Trace logs found" > /var/log/mp_trace
	fi
	nfile=`ls -l /var/log/ | grep mp_snap* | wc -l`
	if [ "$nfile" -eq 0 ]
	then
		$ECHO "No MP Snap logs found" > /var/log/mp_snap
	fi
	tar -cvf /tmp/MP_LOG.tar /var/log/mp_trace* /var/log/mp_snap* /var/log/config_library.log* /mnt/var/log/config_library.log* 2> /dev/null
	/bin/rm /var/log/mp_trace* /var/log/mp_snap* /var/log/config_library.log* /mnt/var/log/config_library.log*
	return 0
}

# *******************************************
# Collect MAPS DATA logs
# *******************************************
start_mapsdc()
{
	$ECHO "Gathering maps debug files."

	$CHASSISCMD /bin/tar -cvf /var/log/maps.tar /var/log/mdd.log* /mnt/var/log/mdd.log*
}


# ***** Main ****************************************

  standby=no;
  # set standby flag
#  /fabos/cliexec/hashow | awk '/Local/ && /Standby/' > /dev/null 2>&1
  /fabos/cliexec/hashow | grep Local | grep Standby > /dev/null 2>&1
  if [ $? -eq 0 ]; then
	standby=yes;
  fi
  fabos_off=no;
  #/fabos/sbin/chkconfig | grep "fabos " | grep off > /dev/null 2>&1
  /bin/cat /etc/config/fabos | grep off > /dev/null 2>&1
  if [ $? -eq 0 ]; then
        fabos_off=yes;
  fi
  # set platform
#  sw_platform=`/sbin/sin 2>/dev/null | /bin/grep SWBD | /usr/bin/cut -d ' ' -f 2 | /usr/bin/cut -c 5-6`
   sw_platform=$( /sbin/sin 2>/dev/null | sed -n 's/^.*SWBD\([^,]*\),.*/\1/p' )
#  group_show start_sys
  isWM=no
  if [ -e /dev/wm_dumper ]; then
	isWM=yes;
  fi
if [ -e /fabos/link_sbin/lscfg_test ]
then
    /bin/rm /fabos/link_sbin/lscfg_test
fi

/bin/ln -s /fabos/cliexec/lscfg_util /fabos/link_sbin/lscfg_test 2> /dev/null
export PATH=/fabos/link_bin:/bin:/usr/bin:/sbin:/usr/sbin:/fabos/link_abin:/fabos/link_sbin:/fabos/link_rbin:/fabos/factory:/fabos/xtool
#NUM_SW_INSTANCE=`lscfg_test --all  | awk '/Total/ {print $5}'`
if [ "$(lscfg_test --vf_enabled 2> /dev/null)" = 'VF is enabled.' ]; then
    NUM_SW_INSTANCE=`lscfg_test --max`
    HOME_VF=128
    export HOME_VF
else
    HOME_VF=
    export HOME_VF
fi
  if [ "$HOME_VF" = "" ]
  then
     $ECHO "Non-VF"
     $ECHO "======================"
     SWITCHCMD="cmd_nonvf"
     CHASSISCMD="cmd_nonvf"
  else
     $ECHO "VF"
     $ECHO "======================"
     SWITCHCMD="cmd_iterate_all"
     CHASSISCMD="cmd_chassis"
  fi
  SSCMD="/fabos/cliexec/sscmd"
  $ECHO "WMEM switch=$isWM"

 for param in $@
  do
    # remove debug switch, if present, processed at top
    if [ "$param" = "--pre" ]
    then
      group_show start_pre
    fi

    if [ "$param" = "--post" ]
     then
     group_show start_post
    fi

    if [ "$param" = "--fs" ]
     then
     group_show start_fabric_service
    fi

    if [ "$param" = "--diag" ]
     then
     group_show start_diag
    fi

    if [ "$param" = "--cryp" ]
     then
     group_show start_cryp
    fi

    if [ "$param" = "--fcip" ]
     then
     group_show start_fcip
    fi

    if [ "$param" = "--fcipdplogs" ]
     then
     group_show start_fcipdplogs
    fi

    if [ "$param" = "--ampdplogs" ]
     then
     group_show start_ampdplogs
    fi

    if [ "$param" = "--vf" ]
     then
     group_show start_vf
    fi

    if [ "$param" = "--vs" ]
    then
	group_show start_vpwwn
	retval=`$ECHO $?`
    fi

    if [ "$param" == "--an" ]
     then
     group_show start_an
     fi

    if [ "$param" = "--asicdb" ]
     then
     start_asic_db_cmd
	 retval=`$ECHO $?`
    fi
    if [ "$param" = "--test" ]
     then
     /bin/date
     time cmd_iterate_all /bin/date
     /bin/date
    fi
    if [ "$param" = "--fabosoff" ]
     then
     group_show start_fabos_off
    fi

    if [ "$param" = "--avregdump" ]
     then
     start_regdump AVREGDUMP
	 retval=`$ECHO $?`
	fi

	if [ "$param" = "--c2regdump" ]
	 then
	 start_regdump C2REGDUMP
	 retval=`$ECHO $?`
	fi

    if [ "$param" = "--bcmstats" ]
     then
     start_bcm_stats
	retval=`$ECHO $?`
    fi

    if [ "$param" = "--ftracecollect" ]
     then
     start_ftrace
     retval=`$ECHO $?`
    fi

    if [ "$param" = "--dmesg" ]
     then
     start_dmesg
	retval=`$ECHO $?`
    fi

	if [ "$param" = "--cryp_kv" ]
	then
		start_kvlog
		retval=`$ECHO $?`
	fi

	if [ "$param" = "--mplog" ]
	then
		start_mplog
		retval=`$ECHO $?`
	fi

    if [ "$param" = "--mapsdc" ]
     then
     group_show start_mapsdc
    fi

    /bin/rm -rf /fabos/link_sbin/lscfg_test 2> /dev/null
	if [ $newline -eq 1 ]
	then
    	$ECHO  " " > $TTY
	fi
    exit $retval
  done

