#!/bin/bash
# Passed a file name containing the old mii-tool based script to set
# ethernet link modes, this script will make the equivalent exec of ethmode.

# populate $2,$3,$4 with auto/forced, desired link mode(s), interface
set -- `/bin/cat $1`
auto_forced=1
mode=0

# -F means force a single mode
match=`/usr/bin/expr match $2 ".*-F.*"`
if [ "$match" -ne 0 ]
then
	auto_forced=0
fi

# 10HD => bit 0x01
match=`/usr/bin/expr match $3 ".*10baseT-HD.*"`
if [ "$match" -ne 0 ]
then
	let "mode += 1"
fi

# 10FD => bit 0x02
match=`/usr/bin/expr match $3 ".*10baseT-FD.*"`
if [ "$match" -ne 0 ]
then
	let "mode += 2"
fi

# 100HD => bit 0x04
match=`/usr/bin/expr match $3 ".*100baseTx-HD.*"`
if [ "$match" -ne 0 ]
then
	let "mode += 4"
fi

# 100FD => bit 0x08
match=`/usr/bin/expr match $3 ".*100baseTx-FD.*"`
if [ "$match" -ne 0 ]
then
	let "mode += 8"
fi

# 1000HD => bit 0x10
match=`/usr/bin/expr match $3 ".*1000baseT-HD.*"`
if [ "$match" -ne 0 ]
then
	let "mode += 16"
fi

# 1000FD => bit 0x20
match=`/usr/bin/expr match $3 ".*1000baseT-FD.*"`
if [ "$match" -ne 0 ]
then
	let "mode += 32"
fi

/fabos/libexec/ethmode $4 $auto_forced $mode
