#!/bin/sh
# This Script is for configuring the ports as Frameshooter ports, adding the 
# frame and start the traffic. Curretly this script supports Thalassa and Galatea blades. 

NOT_STINGER_BLADE=0
STINGER_BLADE=1	
TH_OR_GA_BLADE=2
STINGER_BI_FP=24	#The Total FP is 48. This value is divided by 2 for Bidirectional Traffic
			# It needs to be modified based on the front end port of the Stinger Blade

# Frame Shooter Usage
function fshooter_usage {
	echo "Usage: Passing Command Line Arguments"
	echo "====================================="
	echo "fshooter.sh -mode [1 or 2 or 3] --config [-e or -t] -v [VC] -o [oxid] -s [size] -p [pattern]"
	echo "[mode 0: Cleanup 1: Port blade 2: Core blade to Port blade 3: Condor3 to Condor2 blade mode 4: All slots in a chassis]"
	echo "Example"
	echo "fshooter.sh --mode 1 --st 10 -v 3 -o 12345 -s 200 -p aa"
	echo "==========================================================================================="
	echo "Usage: Interactive User Input"
	echo "============================="
	echo "fshooter.sh"
	exit
}

function validate_args {
	argc=$#
	argv=("$@")
	for ((i=0;i<$argc;i++))
	do
		opt=${argv[$i]}
		if [ "$opt" == "--help" -o "$opt" == "-help" ] ; then
			fshooter_usage
		fi
		optarg=${argv[$i+1]}
		if [ "$opt" == "--mode" -o "$opt" == "-mode" ] ; then
			mode=$optarg
		fi
		if [ "$opt" == "-st" -o "$opt" == "--st" ] ; then
			slot=$optarg
		fi
		if [ "$opt" == "-c" -o "$opt" == "--c" ] ; then
			core_slot=$optarg
		fi
		if [ "$opt" == "-c3" -o "$opt" == "--c3" ] ; then
			c3_slot=$optarg
		fi
		if [ "$opt" == "-pt" -o "$opt" == "--pt" ] ; then
			port_slot=$optarg
		fi
		if [ "$opt" == "--c2" -o "$opt" == "-c2" ] ; then
			c2_slot=$optarg
		fi	
		if [ "$opt" == "--config" -o "$opt" == "-config" ] ; then
			config_opt=$optarg
		fi
		if [ "$opt" == "-v" -o "$opt" == "--v" ] ; then
			vc=$optarg	
		fi
		if [ "$opt" == "-o" -o "$opt" == "--o" ] ; then
			oxid=$optarg
		fi
		if [ "$opt" == "-s" -o "$opt" == "--s" ] ; then
			size=$optarg
		fi
		if [ "$opt" == "-p" -o "$opt" == "--p" ] ; then
			pattern=$optarg
		fi
		if [ "$opt" == "-f" -o "$opt" == "--f" ] ; then
			filename=$optarg
		fi
		if [ "$opt" == "-ip" -o "$opt" == "--ip" ] ; then
			ipaddr=$optarg
		fi
	done
	if [ "$mode" -gt 4 ] ; then
		echo "Invalid Mode $mode"
		fshooter_usage
	fi
	if [ "$mode" == 1 ] ; then
		if [ "$slot" == -1 -o "$core_slot" != -1 -o "$port_slot" != -1 -o "$c3_slot" != -1 -o "$c2_slot" != -1 ] ; then
			print_inputs
			echo "Invalid Option"
			fshooter_usage
		fi
	fi
}

# Getting inputs from the user
function get_input {
	echo -n "Enter Mode[1.Port Blades 2.Core-Port Blade 3.Condor3-Condor2 4.Exit]:"
	read mode
	if [ "$mode" == "" ] ; then
		mode=1
	fi
	echo "mode=$mode"
	if [ "$mode" == 1 ] ; then
		echo -n "Enter [Slot No]:"
		read slot
	elif [ "$mode" == 2 ] ; then
		echo -n "[Enter Core Slot Number]:"
		read core_slot
		echo -n "[Enter Port Blade Slot Number]:"
		read port_slot
	elif [ "$mode" == 3 ] ; then
		echo -n "[Enter Condor3 Slot Number]:"
		read c3_slot
		echo -n "[Enter Condor2 Slot Number]:"
		read c2_slot
	else
		fshooter_usage
	fi
	echo -n "Frame Shooter Options[N]:"
	read option
	if [ "$option" == "" ] ; then
		echo "No option given taking default options"
	else
		echo -n "Config Options[-e or -t][ ]:"
		read config_opt
		if [ "$config_opt" == "" ] ; then
			echo "No option Given"
		fi
		echo "Frame Options"
		echo -n "[VC No]:"
		read vc
		echo -n "[Orignator ID]:"
		read oxid
		echo -n "[File Name]:"
		read filename
		if [ "$filename" == "" ] ; then
			echo "No File Name"
			echo -n "Enter [Pattern]:"
			read pattern
		fi	
		echo -n "[Payload Size]:"
		read size
	fi
}

#print inputs
function print_inputs {
	echo "mode : $mode"
	echo "slot : $slot"
	echo "vc   : $vc"
	echo "size : $size"
	echo "patt : $pattern"
	echo "ipaddr : $ipaddr"
}

# Default Configuration
function default_configuration {
	mode=-1
	slot=-1
	core_slot=-1
	port_slot=-1
	c2_slot=-1
	c3_slot=-1	
	vc=2
	size=100
	pattern=aa
	oxid=1234
	ipaddr="0:0:0:0"
}

# Checking the blade is stinger or not
function is_stinger_blade {
	val=`slotshow | sed -n "/Not supported on this platform/p"`
	str="slotshow: Not supported on this platform"
	if [ "$val" == "$str" ] ; then
		return $STINGER_BLADE
	else
		return $NOT_STINGER_BLADE
	fi
}

function Fshooter_Config {
	bld=$1
	conf_opt=$2
	echo "bld=$bld"
	if [ "$conf_opt" == "-e" -o "$conf_opt" == "e" ] ; then
		conf_opt="-e"
	elif [ "$conf_opt" == "-t" -o "$conf_opt" == "t" ] ; then
		conf_opt="-t"
	fi
	echo "Fshooter Configuration"
	for i in $(switchshow | sed 's/^[ \t]*//' | tr -s " " " " | sed '/^[=aA-zZ]/d' | sed '/^$/d' |\
	awk '{ if($4 != "------" ) {print $2"_"$3;}}')
	do
		if [ "$bld" == $STINGER_BLADE ] ; then
			slot=0
			port=$(echo $i | cut -d "_" -f1)
		elif [ "$bld" == $NOT_STINGER_BLADE ] ; then
			slot=$(echo $i | cut -d "_" -f1)
			port=$(echo $i | cut -d "_" -f2)
		fi
		echo "fshooter --config" $slot/$port $conf_opt
		fshooter --config $slot/$port $conf_opt
	done
}

function Fshooter_Config_Check {
        bld=$1
        echo "Frame Shooter is not configured on the Following Port"
        echo "====================================================="
        if [ "$bld" == $STINGER_BLADE ] ; then
                switchshow | sed 's/^[ \t]*//' |  sed '/^[=aA-zZ]/d' | sed '/^$/d' |\
                awk '{ if($8 != "Frame" && $9 != "Shooter" && $10 != "Port") { print $0 } }'
                switchshow | sed 's/^[ \t]*//' |  sed '/^[=aA-zZ]/d' | sed '/^$/d' |\
                awk '{ if($8 == "Frame" && $9 == "Shooter" && $10 == "Port") { print $2,$3 } }' > slot_did_0.txt
        elif [ "$bld" == $NOT_STINGER_BLADE ] ; then
                switchshow | sed 's/^[ \t]*//' |  sed '/^[=aA-zZ]/d' | sed '/^$/d' |\
                awk '{ if($9 != "Frame" && $10 != "Shooter" && $11 != "Port") { print $0 } }'
                switchshow | sed 's/^[ \t]*//' |  sed '/^[=aA-zZ]/d' | sed '/^$/d' |\
                awk '{ if($9 == "Frame" && $10 == "Shooter" && $11 == "Port") { print $2,$3,$4 } }' > slot_did_0.txt
        fi
}

function Add_Frame_Start_Fshooter {
	bld=$1
        if [ "$bld" == $STINGER_BLADE ] ; then
		idx=0
		for i in $(cat slot_did_0.txt | awk '{ print $1"_"$2 }')
		do
			slot_port_did[$idx]=$i
			let idx=idx+1	
		done
        elif [ "$bld" == $NOT_STINGER_BLADE ] ; then
		idx=0
		for i in $(cat slot_did_0.txt | awk '{ print $1"_"$2"_"$3 }')
		do
			slot_port_did[$idx]=$i
			let idx=idx+1	
		done
	fi	
	end=$idx
	let end=end-1
	for ((start=0;start<$idx/2;start++))
	do
		echo "${slot_port_did[$start]}"
       		if [ "$bld" == $STINGER_BLADE ] ; then
			src_slot=0
			dst_slot=0
			src_port=$(echo "${slot_port_did[$start]}" | cut -d "_" -f1)
			src_did=$(echo "${slot_port_did[$start]}" | cut -d "_" -f2)
			dst_port=$(echo "${slot_port_did[$end]}" | cut -d "_" -f1)
			dst_did=$(echo "${slot_port_did[$end]}" | cut -d "_" -f2)
        	elif [ "$bld" == $NOT_STINGER_BLADE ] ; then
			src_slot=$(echo "${slot_port_did[$start]}" | cut -d "_" -f1)
			src_port=$(echo "${slot_port_did[$start]}" | cut -d "_" -f2)
			src_did=$(echo "${slot_port_did[$start]}" | cut -d "_" -f3)
			dst_slot=$(echo "${slot_port_did[$end]}" | cut -d "_" -f1)
			dst_port=$(echo "${slot_port_did[$end]}" | cut -d "_" -f2)
			dst_did=$(echo "${slot_port_did[$end]}" | cut -d "_" -f3)
		fi
		echo "fshooter --addf $src_slot/$src_port -d 0x$dst_did -o 0x$oxid -v $vc -p $pattern -s $size" 
		echo "fshooter --addf $dst_slot/$dst_port -d 0x$src_did	-o 0x$oxid -v $vc -p $pattern -s $size"
		fshooter --addf $src_slot/$src_port -d 0x$dst_did -o 0x$oxid -v $vc -p $pattern -s $size
		fshooter --addf $dst_slot/$dst_port -d 0x$src_did -o 0x$oxid -v $vc -p $pattern -s $size
		echo "fshooter --start $src_slot/$src_port"
		echo "fshooter --start $dst_slot/$dst_port"
		fshooter --start $src_slot/$src_port
		fshooter --start $dst_slot/$dst_port
		let end=end-1
	done
}

function Add_Frame_Start_Fshooter_mode4 {
	bld=$1
	idx=0
	idx_1=0
	idx_2=0
	for i in $(cat slot_did_0.txt | awk '{ print $1"_"$2"_"$3 }')
	do
		slot_port_did[$idx_1]=$i
		echo "slot_port_did[$idx_1]=${slot_port_did[$idx_1]}"
		let idx_1=idx_1+1	
	done
	for i in $(cat slot_did.txt | awk '{ print $3 }')
	do
		slot_port_did_1[$idx_2]=$i
		echo "slot_port_did_1[$idx_2]=${slot_port_did_1[$idx_2]}"
		let idx_2=idx_2+1	
	done
	if [ $idx_1 -ge $idx_2 ] ; then
		idx=$idx_2
		echo "1 : $idx"
	else
		idx=$idx_1
		echo "2 : $idx"
	fi
	echo "idx: $idx idx_1:$idx_1 idx_2:$idx_2" 
	for ((start=0;start<$idx;start++))
	do
		echo "${slot_port_did[$start]}"
		src_slot=$(echo "${slot_port_did[$start]}" | cut -d "_" -f1)
		src_port=$(echo "${slot_port_did[$start]}" | cut -d "_" -f2)
		echo "fshooter --addf $src_slot/$src_port -d 0x${slot_port_did_1[$start]} -o 0x$oxid -v $vc -p $pattern -s $size" 
		fshooter --addf $src_slot/$src_port -d 0x${slot_port_did_1[$start]} -o 0x$oxid -v $vc -p $pattern -s $size
		echo "fshooter --start $src_slot/$src_port"
		fshooter --start $src_slot/$src_port
	done
}

function Stop_Fshooter {
	bld=$1
	echo "Stop_Fshooter"
	for i in "${slot_port_did[@]}"
	do
		if [ "$bld" == $STINGER_BLADE ] ; then
			slot=0
			port=$(echo $i | cut -d "_" -f1)
		elif [ "$bld" == $NOT_STINGER_BLADE ] ; then
			slot=$(echo $i | cut -d "_" -f1)
			port=$(echo $i | cut -d "_" -f2)
		fi
		echo "fshooter --stop $slot/$port"
		fshooter --stop $slot/$port
	done
}

function Remove_Fshooter_Config {
	bld=$1
	echo "Remove_Fshooter"
	for i in "${slot_port_did[@]}"
	do
		if [ "$bld" == $STINGER_BLADE ] ; then
			slot=0
			port=$(echo $i | cut -d "_" -f1)
		elif [ "$bld" == $NOT_STINGER_BLADE ] ; then
			slot=$(echo $i | cut -d "_" -f1)
			port=$(echo $i | cut -d "_" -f2)
		fi
		echo "fshooter --remove $slot/$port"
		fshooter --remove $slot/$port
	done
}

# Configure all the Front End Ports to Frame Shooter Mode
function configure_fshooter_mode1 {
	echo "configure_fshooter_mode1"
	slot=$1
	if [ "$config_opt" == "-e" -o "$config_opt" == "e" ] ; then
		config_opt="-e"
	elif [ "$config_opt" == "-t" -o "$config_opt" == "t" ] ; then
		config_opt="-t"
	fi
	#a. Store the dids of the slotports in an array
	#switchshow | sed 's/^[ \t]*//' | tr -s " " " " | sed '/^[=aA-zZ]/d'| awk -v val=$slot -v bld=$blade '{ if(bld == 1 ) { print $2,$3 } else if( bld == 2 && $2 == val ) { print $3,$4 } }' > slot_did.txt
	for idx in $(switchshow | sed 's/^[ \t]*//' | tr -s " " " " | sed '/^[=aA-zZ]/d'| awk -v val=$slot -v bld=$blade '{ if(bld == 1 ) { print $2} else if( bld == 0 && $2 == val ) { print $3 } }') 
	do
		echo "fshooter --config $slot/$idx $config_opt"
		fshooter --config $slot/$idx $config_opt
	done
}





# Validate All the Front End Ports are configured as Frame Shooter Ports
function check_fshooter_configuration_mode1 {
	slot=$1
	echo "Frame Shooter is not configured on the Following Port"
	echo "====================================================="
	if [ "$blade" == $STINGER_BLADE ] ; then
		switchshow | sed 's/^[ \t]*//' |  sed '/^[=aA-zZ]/d' | awk -v val=$slot  \
		'{ if($8 != "Frame" && $9 != "Shooter" && $10 != "Port") { print $0 } }' 
		switchshow | sed 's/^[ \t]*//' |  sed '/^[=aA-zZ]/d' | awk -v val=$slot  \
		'{ if($8 == "Frame" && $9 == "Shooter" && $10 == "Port") { print $2,$3 } }' > slot_did_$slot.txt
	elif [ "$blade" == $NOT_STINGER_BLADE ] ; then
		switchshow | sed 's/^[ \t]*//' |  sed '/^[=aA-zZ]/d' | awk -v val=$slot  \
		'{ if($2 == val && $9 != "Frame" && $10 != "Shooter" && $11 != "Port") { print $0 } }' 
		switchshow | sed 's/^[ \t]*//' |  sed '/^[=aA-zZ]/d' | awk -v val=$slot  \
		'{ if($2 == val && $9 == "Frame" && $10 == "Shooter" && $11 == "Port") { print $3,$4 } }' > slot_did_$slot.txt
	fi
}

# For STINGER blade Storing half of the Front End ports into Chip 0 array and another half into Chip 1 array
function get_stinger_chip_array {
		slot=$1 
		idx=0
		idx_0=0
		idx_1=0
		for i in $(bladeportmap $slot | sed 's/^[ \t]*//' | tr -s " " " " | awk '$10 == 0 { print $4 }')
		do
			idx=$(cat slot_did_$slot.txt | awk -v val=$i '$1 == val { print $1 }')
			echo "i:$i idx:$idx"
			if [ "$idx" != "" -a "$idx_0" -lt $STINGER_BI_FP ] ; then
				chip_0[$idx_0]=$idx
				echo "chip_0[$idx_0]=${chip_0[$idx_0]}"
				let idx_0=$idx_0+1
			elif [ "$idx" != "" -a "$idx_0" -ge $STINGER_BI_FP ] ; then
				chip_1[$idx_1]=$idx
				echo "chip_1[$idx_1]=${chip_1[$idx_1]}"
				let idx_1=$idx_1+1
			fi
		done
		echo "idx_0:$idx_0 idx_1:$idx_1" 
		if [ $idx_0 > $idx_1 ] ; then
			idx=$idx_1
		else
			idx=$idx_0
		fi
		return $idx
}

# For Thalassa or Galatea blade
function get_th_ga_chip_array {
	# Store the Front End Slot Ports Corresponding to the Chip 0 in an array
	slot=$1
	idx=0
	idx_0=0
	for i in $(bladeportmap $slot | sed 's/^[ \t]*//' | tr -s " " " " | awk '$10 == 0 { print $4 }')
	do
		idx=$(cat slot_did_$slot.txt | awk -v val=$i '$1 == val { print $1 }')
		echo "i:$i idx:$idx"
		if [ "$idx" != "" ] ; then
			chip_0[$idx_0]=$idx
			echo "chip_0[$idx_0]=${chip_0[$idx_0]}"
			let idx_0=$idx_0+1
		fi
	done
	# Store the Front End Slot Ports Corresponding to the Chip 1 in an array
	idx_1=0
	for i in $(bladeportmap $slot | sed 's/^[ \t]*//' | tr -s " " " " | awk ' $10 == 1 { print $4 }')
	do
		idx=$(cat slot_did_$slot.txt | awk -v val=$i '$1 == val { print $1 }')
		echo "i:$i idx:$idx"
		if [ "$idx" != "" ] ; then
			chip_1[$idx_1]=$idx
			echo "chip_1[$idx_1]=${chip_1[$idx_1]}"
			let idx_1=$idx_1+1
		fi
	done
	echo "idx_0:$idx_0 idx_1:$idx_1" 
	if [ $idx_0 > $idx_1 ] ; then
		idx=$idx_1
	else
		idx=$idx_0
	fi
	return $idx
}

# Mode 1 - Port blades, 
# adding frames and starting the frame shooter
function add_frame_start_fshooter_mode1 {
	slot=$1
	idx=$2
	src_port=0
	dst_port=0
	if [ "$idx" == 0 ] ; then
		echo -n "Not able to generate Bidirectional traffic."
		echo "Since Frame shooter is not configured on even number of ports"
		fshooter_usage 
	fi
	for (( i=0;i<$idx;i++)) 
	do
		#i. Getting src and dst slot ports
		src_port=${chip_0[$i]}
		dst_port=${chip_1[$i]}
		#ii. Getting src_id and dst_id
		src_id=$(cat slot_did_$slot.txt | awk -v s_port=$src_port '$1 == s_port{print $2}')
		dst_id=$(cat slot_did_$slot.txt | awk -v d_port=$dst_port '$1 == d_port{print $2}')
		#iii. Adding Frames to the Frame shooter ports	
		echo "src_port:$src_port id:0x$src_id dst_port:$dst_port id:0x$dst_id"
		if [ "$src_port" != "" -a "$dst_port" != "" -a "$src_id" != "" -a "$dst_id" != "" ] ; then 
			if [ "$filename" == "" ] ; then
				echo "fshooter --addf $slot/$src_port -v $vc -d 0x$dst_id -o 0x$oxid -s $size -p $pattern "
				fshooter --addf $slot/$src_port -v $vc -d 0x$dst_id -o 0x$oxid -s $size -p $pattern
				echo "fshooter --addf $slot/$dst_port -v $vc -d 0x$src_id -o 0x$oxid -s $size -p $pattern"
				fshooter --addf $slot/$dst_port -v $vc -d 0x$src_id -o 0x$oxid -s $size -p $pattern
			else
				echo "fshooter --addf $slot/$src_port -v $vc -d 0x$dst_id -o 0x$oxid -s $size -f $filename "
				fshooter --addf $slot/$src_port -v $vc -d 0x$dst_id -o 0x$oxid -s $size -f $filename
				echo "fshooter --addf $slot/$dst_port -v $vc -d 0x$src_id -o $oxid -s $size -f $filename"
				fshooter --addf $slot/$dst_port -v $vc -d 0x$src_id -o 0x$oxid -s $size -f $filename
			fi
		else
			echo -n "Not able to generate Bidirectional traffic."
			echo "Since Frame shooter is not configured on even number of ports"
		fi	
		#iv. Starting the Frame shooter
		echo "fshooter --start $slot/$src_port"
		fshooter --start $slot/$src_port
		echo "fshooter --start $slot/$dst_port"
		fshooter --start $slot/$dst_port
	done
}

# Mode 1 - Stop the Frame Shooter
function stop_fshooter_mode1 {
	slot=$1
	idx=0
	for idx in $(cat slot_did_$slot.txt | awk '{ print $1 }')
	do
		echo "fshooter --stop $slot/$idx"
		fshooter --stop $slot/$idx
	done
}
# Mode 1 - Remove Frame Shooter Configuration
function remove_fshooter_mode1 {
	slot=$1
	idx=0
	for idx in $(cat slot_did_$slot.txt | awk '{ print $1 }')
	do
		echo "fshooter --remove $slot/$idx"
		fshooter --remove $slot/$idx
	done
}

# Mode 2 & Mode 3 
# ================

# Store the ICL slotportnumbers of the core blade or C3 port blade slot port numbers in an array
function get_ports {
	slot=$1
	idx=0
	for i in $(switchshow | sed 's/^[ \t]*//' | tr -s " " " " | sed '/^[=aA-zZ]/d'| awk -v val=$slot '{ if ($2 == val ) { print $3 } }')
	do
		slot_array[$idx]=$i
		let idx=idx+1	
	done
	return $idx
}

# Store dids of port blade or Condor2 port blade into did array
function get_dids {
	slot=$1
	idx=0
	for i in $(switchshow | sed 's/^[ \t]*//' | tr -s " " " " | sed '/^[=aA-zZ]/d'| awk -v val=$port_slot '{ if( $2 == val ) { print $4 } }' ) 
	do
		did[idx]=0x$i
		let idx=idx+1
	done
	return $idx
}

# The number of  Front End Ports in Port blade and the number of ICL ports in Core Blade may vary
# The core blade [CR8510(8)-16] has 64 ICL ports. In this case the number of ICL ports to be configured as Frame Shooter
# are equal to number of Front end ports in the Port blade
function configure_fshooter_mode2 {
	slot=$1
	slot_idx=$2
	did_idx=$3
	if [ "$config_opt" == "-e" -o "$config_opt" == "e" ] ; then
                config_opt="-e"
        elif [ "$config_opt" == "-t" -o "$config_opt" == "t" ] ; then
                config_opt="-t"
        fi
	# ICL ports > ports in Port blade => idx = no. of port blades 
	# ICL ports < ports in port blade => idx = no. of ICL ports
	if [ $slot_idx > $did_idx ] ; then 
		idx=$did_idx
	else
		idx=$slot_idx
	fi
	for ((i=0;i<$idx;i++))
	do
		echo "fshooter --config $slot/${slot_array[$i]} $config_opt"
		fshooter --config $slot/${slot_array[$i]} $config_opt
	done
	return $idx
}


# Mode 2 - Validate Frame Shooter Mode is confiured 
function check_fshooter_configuration_mode2 {
	slot=$1
	idx=$2
	echo "Frame Shooter is not configured on the Following Port"
	echo "====================================================="
	for ((i=0;i<$idx;i++))
	do
		port=${slot_array[$i]}
		switchshow | sed 's/^[ \t]*//' | tr -s " " " " | sed '/^[=aA-zZ]/d'| awk -v val=$slot -v pt=$port '{ if($2 == val && $3 == pt && $9 != "Frame" && $10 != "Shooter" && $11 != "Port") {  print $0 } }'
	done
	idx=0
	for i in $(switchshow | sed 's/^[ \t]*//' | tr -s " " " " | sed '/^[=aA-zZ]/d'| awk -v val=$slot '{ if($2 == val && $9 == "Frame" && $10 == "Shooter" && $11 == "Port") {  print $3 } }')
	do
		slot_did[$idx]=$i
		echo "slot_did[$idx]:${slot_did[$idx]}"
		let idx=$idx+1
	done	
	return $idx
}



# Mode 2 - Core Blade - Port Blade
# adding frames and starting the frame shooter
function add_frame_start_fshooter_mode2 {
		slot=$1
		fshooter_port_idx=$2
		did_idx=$3
		if [ $fshooter_port_idx == 0 ] ; then
			echo "Frame Shooter is not configured"
			fshooter_usage
		fi

		if [ $fshooter_port_idx > $did_idx ] ; then
			idx=$did_idx
		else
			idx=$fshooter_port_idx
		fi

		for ((i=0;i<$idx;i++))
		do
			if [ "$filename" == "" ] ; then
				echo "fshooter --addf $slot/${slot_array[$i]} -v $vc -d ${did[$i]} -o 0x$oxid -s $size -p $pattern "
				fshooter --addf $slot/${slot_array[$i]} -v $vc -d ${did[$i]} -o 0x$oxid -s $size -p $pattern
			else
				echo "fshooter --addf $slot/${slot_array[$i]} -v $vc -d ${did[$i]} -o 0x$oxid -s $size -f $filename "
				fshooter --addf $slot/${slot_array[$i]} -v $vc -d ${did[$i]} -o 0x$oxid -s $size -f $filename
			fi
			echo "fshooter --start $slot/${slot_array[$i]}"
			fshooter --start $slot/${slot_array[$i]}
		done
}



# Mode :2 Stop the Frame Shooter
function stop_fshooter_mode2 {
	slot=$1	
	idx=$2
	if [ $idx == 0 ] ; then
		echo "There is no Frame Shooter Configuration"
		fshooter_usage
	fi
	for ((i=0;i<$idx;i++))
	do
		echo "fshooter --stop $slot/${slot_array[$i]}"
		fshooter --stop $slot/${slot_array[$i]}
	done
}

# Mode :2 Remove the Frame Shooter
function remove_fshooter_mode2 {
	slot=$1	
	idx=$2
	if [ $idx == 0 ] ; then
		echo "There is no Frame Shooter Configuration"
		fshooter_usage
	fi
	for ((i=0;i<$idx;i++))
	do
		echo "fshooter --remove $slot/${slot_array[$i]}"
		fshooter --remove $slot/${slot_array[$i]}
	done
}

# Setting Delay
function delay {
	sleep $1
}

# SlotStatsClear	
function stats_clear {
	slotstatsclear
}

# Check for Errors
function check_for_errors {
	sloterrshow -c 1|grep -e er_ -e CONDOR
}

# Remove the file slot_did.txt
function clean_up {	
	if [ -f "slot_did_$slot.txt" ] ; then
		rm -rf slot_did_$slot.txt
	fi
	if [ -f "slot_did.txt" ] ; then
		rm -rf slot_did.txt
	fi
}

# Mode 5
# ================

# Store the ICL slotportnumbers of the core blade or C3 port blade slot port numbers in an array
function get_src_ports_mode_5 {
	src_idx=0
	slots=$(echo $1 | tr "," "\n")
	for slot in $slots
	do
		lines=`switchshow -slot $slot | \
				sed '/^$/d' | \
				sed 's/^[ \t]*//' | \
				tr -s " " " " | \
				sed '/^[-=aA-zZ]/d' | \
				sed '1d' | \
				grep -v "Disabled (Persistent)" | \
				awk -v val=$slot '{ if($8 == "FC") {printf("%s/%s#0x%s\n"), val, $3, $4}}'`
		for i in $lines
		do
			src_slot_port[$src_idx]=$(echo $i | cut -f 1 -d '#')
			src_did[$src_idx]=$(echo $i | cut -f 2 -d "#")
			let src_idx=$src_idx+1
		done
	done
	return $src_idx
}


# Store the ICL slotportnumbers of the core blade or C3 port blade slot port numbers in an array
function get_dst_ports_mode_5 {
	dst_idx=0
	slots=$(echo $1 | tr "," "\n")
	for slot in $slots
	do
		lines=`switchshow -slot $slot | \
				sed '/^$/d' | \
				sed 's/^[ \t]*//' | \
				tr -s " " " " | \
				sed '/^[-=aA-zZ]/d' | \
				sed '1d' | \
				grep -v "Disabled (Persistent)" | \
				awk -v val=$slot '{ if($8 == "FC") {printf("%s/%s#0x%s\n"), val, $3, $4}}'`
		for i in $lines
		do
			dst_slot_port[$dst_idx]=$(echo $i | cut -f 1 -d '#')
			dst_did[$dst_idx]=$(echo $i | cut -f 2 -d "#")
			let dst_idx=$dst_idx+1
		done
	done
	return $dst_idx
}

function configure_fshooter_mode5 {
	if [ "$config_opt" == "-e" -o "$config_opt" == "e" ] ; then
		config_opt="-e"
	elif [ "$config_opt" == "-t" -o "$config_opt" == "t" ] ; then
		config_opt="-t"
	fi

	for ((i=0;i<$src_idx;i++))
	do
		echo "fshooter --config ${src_slot_port[$i]} $config_opt"
		fshooter --config ${src_slot_port[$i]} $config_opt
	done

	for ((i=0;i<$dst_idx;i++))
	do
		portcfgspeed ${dst_slot_port[$i]} 8
		echo "fshooter --config ${dst_slot_port[$i]} $config_opt"
		fshooter --config ${dst_slot_port[$i]} $config_opt
	done
}
#
# Mode 5 - C3 to C2
# adding frames and starting the frame shooter
function add_frame_start_fshooter_mode5 {
	for ((i=0;i<$src_idx;i++))
	do
		if [ "$filename" == "" ] ; then
			echo "fshooter --addf ${src_slot_port[$i]} -v $vc -d ${dst_did[$i]} -o 0x$oxid -s $size -p $pattern "
			fshooter --addf ${src_slot_port[$i]} -v $vc -d ${dst_did[$i]} -o 0x$oxid -s $size -p $pattern
		else
			echo "fshooter --addf ${src_slot_port[$i]} -v $vc -d ${dst_did[$i]} -o 0x$oxid -s $size -f $filename "
				fshooter --addf ${src_slot_port[$i]} -v $vc -d ${dst_did[$i]} -o 0x$oxid -s $size -f $filename
		fi

		echo "fshooter --cfgf ${dst_slot_port[$i]} -d ${src_did[$i]} -z ${dst_did[$i]}"
		fshooter --cfgf ${dst_slot_port[$i]} -d ${src_did[$i]} -z ${dst_did[$i]}

		echo "fshooter --start ${src_slot_port[$i]}"
		fshooter --start ${src_slot_port[$i]}
	done
}

# Script Starting Point
# MAIN 
	# Assign default arguments
	default_configuration

	# Check for command line arguments
	arg_c=$#
	if [ "$arg_c" == 0 ] ; then
		get_input
	else
		validate_args $@	
	fi

	# Mode 0 : Clean up
	if [ "$mode" == 0 ] ; then
		echo "Clean up"
		slots=$(echo $slot | tr "," "\n")
		echo "slots:$slots"
		for slt in $slots
		do
			echo "Frame Shooter Stop for Slot $slt"
			stop_fshooter_mode1 $slt
			check_for_errors
			echo "Frame Shooter Remove for Slot $slt"
			remove_fshooter_mode1 $slt
			clean_up $slt
		done
	# Mode 1 : Traffic in a port blade
	elif [ "$mode" == 1 ] ; then
		is_stinger_blade
		blade=$?
		if [ "$blade" == $STINGER_BLADE ] ; then
			if [ "$slot" != 0 ] ; then
				echo "Invalid Slot Number $slot"
				slot=0
				echo "Changing slot number to $slot"
			fi
		fi	
		slots=$(echo $slot | tr "," "\n")
		echo "slots:$slots"
		for slt in $slots
		do
			echo "Frame Shooter Configuration for Slot $slt"
			configure_fshooter_mode1 $slt
			echo "Frame Shooter Check Configuration for Slot $slt"
			check_fshooter_configuration_mode1 $slt
			stats_clear
			if [ "$blade" == $STINGER_BLADE ] ; then
				echo "STINGER_BLADE"
				get_stinger_chip_array $slt
				idx=$?
				echo "idx=$idx"
			elif [ "$blade" == $NOT_STINGER_BLADE ] ; then
				get_th_ga_chip_array $slt
				idx=$?
			fi
			echo "Frame Shooter Add & Start for Slot $slt"
			add_frame_start_fshooter_mode1 $slt $idx
		done
	# Mode 2 : Traffic between two chassis
	elif [ "$mode" == 2 ] ; then
		Fshooter_Config $NOT_STINGER_BLADE $config_opt
		delay 5
		Fshooter_Config_Check $NOT_STINGER_BLADE
		echo "scp -r slot_did.txt root@$ipaddr:/root/slot_did_1.txt"
		scp -r slot_did.txt root@$ipaddr:/root/slot_did_1.txt
		echo "Generating port list ... Done"
		echo "The file slot_did.txt is transferred to the peer switch $ip_addr"
		echo "Press "Enter" when port list is generated on the peer switch $ip_addr"
		read key
		stats_clear
		Add_Frame_Start_Fshooter_mode4 $NOT_STINGER_BLADE
	# Mode 3 : Traffic  between condor 3 to condor 2 
	elif [ "$mode" == 3 ] ; then
		get_src_ports_mode_5 $c3_slot
		get_dst_ports_mode_5 $c2_slot

		echo "$src_idx source ports and $dst_idx destination ports"
		if [ $src_idx -gt $dst_idx ] ; then 
			echo "will not need all the source ports"
			src_idx=$dst_idx
		elif [ $src_idx -ne $dst_idx ] ; then 
			echo "Not enough source ports"
			dst_idx=$src_idx
		fi
		configure_fshooter_mode5
		stats_clear
		add_frame_start_fshooter_mode5
	# Mode 4 : All Slots in a Chassis
	elif [ "$mode" == 4 ] ; then
		print_inputs
		is_stinger_blade
		return_val=$?
		if [ "$return_val" -eq $STINGER_BLADE ] ; then
			echo "Stinger Blade"
			Fshooter_Config $STINGER_BLADE $config_opt
			delay 5
			Fshooter_Config_Check $STINGER_BLADE
			stats_clear
			Add_Frame_Start_Fshooter $STINGER_BLADE
		elif [ "$return_val" -eq $NOT_STINGER_BLADE ] ; then
			echo "Not Stinger Blade"
			Fshooter_Config $NOT_STINGER_BLADE $config_opt
			delay 5
			Fshooter_Config_Check $NOT_STINGER_BLADE
			stats_clear
			Add_Frame_Start_Fshooter $NOT_STINGER_BLADE
		else
			echo "Other Blade"
		fi
	fi
# SCRIPT END
