#!/bin/sh
#
#    Copyright (c) 1996-2003 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#    Initialization script to start the TraceDaemon
#

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/fabos/sbin:/fabos/bin

MODULE="tracer"
MAIN_DEVICE="tracer"
USER_DEVICE="tracerU"
GROUP="root"
MODE="664"

# tell the user about what we are doing
# echo "Deleting old tracer nodes: /dev/tracer and /dev/tracerU"

# remove stale nodes
rm -f /dev/${MAIN_DEVICE}
rm -f /dev/${USER_DEVICE}

MAJOR=`/bin/cat /proc/devices | grep ${MODULE} |sed 's? .*??g'`

# does the device exist?
if [ ! ${MAJOR} ]; then
#   echo "Did not find tracer device ... /dev entries not created ..."
    exit 1;
fi

# tell the user about what we are doing
# echo "Creating new tracer nodes: /dev/tracer and /dev/tracerU"

# create the character special file
/bin/mknod /dev/${MAIN_DEVICE} c ${MAJOR} 0
/bin/mknod /dev/${USER_DEVICE} c ${MAJOR} 1

# set permissions and ownership
/bin/chgrp ${GROUP} /dev/${MAIN_DEVICE}
/bin/chmod ${MODE}  /dev/${MAIN_DEVICE}
/bin/chgrp ${GROUP} /dev/${USER_DEVICE}
/bin/chmod ${MODE}  /dev/${USER_DEVICE}

# echo starting tracedaemon

/usr/bin/tracedaemon /dev/tracer /root/out.trace /root/out.proc

sleep 10

# modify the tracedaemon mask for disabling of all the trace events
# due to the local file system space constraints (since the output files
# generated by tracedaemon are stored on the compact flash)

/usr/bin/tracedaemon -m
