<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="html"/>
	<xsl:template match="/">
		<html>
			<head>
				<meta content="no-cache" http-equiv="Pragma"/>
				<title>Port Detail Report</title>
			</head>
			<body bgcolor="#ffffff">
				<xsl:apply-templates select="PortDetailReport"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="PortDetailReport">
		<xsl:choose>
			<xsl:when test="..=/">
				<table width="100%" border="0" cellspacing="0" cellpadding="5">
					<tbody>
						<tr bgcolor="#c0c0c0">
							<td>
								<xsl:value-of select="ReportName"/> Report</td>
							<td align="left">Report Time: <xsl:value-of select="ReportTime"/>
							</td>
						</tr>
					</tbody>
				</table>
				<p/>
				<table border="0">
					<tbody>
						<tr>
							<td width="120">Switch Name:</td>
							<td align="left">
								<xsl:value-of select="SwitchInfo/@SwitchName"/>
							</td>
						</tr>
						<tr>
							<td width="120">IP Address:</td>
							<td align="left">
								<xsl:value-of select="SwitchInfo/@IPAddress"/>
							</td>
						</tr>
					</tbody>
				</table>
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
		<table>
			<tbody>
				<tr>
					<td width="120">Search Criteria: </td>
					<td align="left">
						<xsl:value-of select="SearchCriteria"/>
					</td>
				</tr>
			</tbody>
		</table>
		<p/>
		<xsl:apply-templates select="PortDetailGroup"/>
		<p/>
		<hr/>
		<table width="100%" style="font-family:sans-serif,Arial, helvetica; font-size:8pt;">
			<tr>
				<td nowrap="yes">
					<a name="LFA">LFA(Link Loss) :</a>
				</td>
				<td align="left">Number of link loss occurrences exceeded range for time period.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: Troubleshoot transmitters, receivers, and fibers, and verify that all cables connect properly.
				</td>
			</tr>
			<tr>
				<td nowrap="yes">
					<a name="LSY">LSY(Sync Loss) :</a>
				</td>
				<td align="left">Number of sync loss occurrences exceeded range for time period.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: Check for problems with the appropriate SFP and cable. If you continue to experience sync loss errors, troubleshoot your HBA and contact your support representative.
				</td>
			</tr>
			<tr>
				<td nowrap="yes">
					<a name="LSI">LSI(Signal Loss) :</a>
				</td>
				<td align="left">
					Number of signal loss occurrences exceeded range for time period.
				</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: Troubleshoot transmitters, receivers, and fibers, and verify that all cables connect properly.
				</td>
			</tr>
			<tr>
				<td nowrap="yes">
					<a name="PER">PER(Protocol Error) :</a>
				</td>
				<td align="left">
					Number of protocol errors exceeded range for time period.
				</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: Check both ends of your connection, and verify that your cable and SFP are not faulty.
				</td>
			</tr>
			<tr>
				<td nowrap="yes">
					<a name="INW">INW(Invalid Word) :</a>
				</td>
				<td align="left">Number of invalid word exceeded range for time period.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: Verify that your cable is not faulty and check both ends of your connection. Troubleshoot your SFP to verify that it is not faulty.
				</td>
			</tr>
			<tr>
				<td nowrap="yes">
					<a name="CRC">CRC(Invalid CRC) :</a>
				</td>
				<td align="left">Number of invalid CRC errors exceeded range for time period.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: Check your SFPs, cables, and connections for faulty hardware. Clean all optical hardware.
				</td>
			</tr>			
			<tr>
				<td nowrap="yes">
					<a name="PSC"/>PSC(Port State) :</td>
				<td align="left">Port hardware state changed too often due to fabric reconfiguration.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: All State Changes messages are informational. Respond to this message as is appropriate to the particular policy of the end-user installation.
				</td>
			</tr>


<tr>
				<td nowrap="yes">
					<a name="LR"/>LR(Link Reset) :</td>
				<td align="left">The ports on which the number of link resets exceed the specified threshold value.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: All State Changes messages are informational. Respond to this message as is appropriate to the particular policy of the end-user installation.
				</td>
			</tr>

			<tr>
				<td nowrap="yes">
					<a name="BLP"/>BLP(Buffer Limited Port) :</td>
				<td align="left">Port buffer credit was not large enough.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: Reset the buffer credit.
				</td>
			</tr>
			
			<tr>
				<td nowrap="yes">
					<a name="STM">STM(SFP Temperature) :</a>
				</td>
				<td align="left">SFP temperature is out of specfications.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: Temperature-related messages usually indicate that you must replace the SFP.
				</td>
			</tr>
			<tr>
				<td nowrap="yes">
					<a name="SRX">SRX(SFP RX) :</a>
				</td>
				<td align="left">SFP receive power is out of specification.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: Replace the SFP.
				</td>
			</tr>
			<tr>
				<td nowrap="yes">
					<a name="STX">STX(SFP TX) :</a>
				</td>
				<td align="left">SFP transmit power is out of specifications.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: If the current rises above the high boundary, you must replace the SFP.
				</td>
			</tr>
			<tr>
				<td nowrap="yes">
					<a name="SCU">SCU(SFP Current) :</a>
				</td>
				<td align="left">SFP current is out of specifications.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: If the current rises above the high boundary, you must replace the SFP.
				</td>
			</tr>
			<tr>
				<td nowrap="yes">
					<a name="SVO">SVO(SFP Voltage) :</a>
				</td>
				<td align="left">SFP voltage is out of specifications.</td>
			</tr>
			<tr>	<td></td>
				<td align="left">
					Action: Frequent messages indicate that you must replace the SFP.
				</td>
			</tr>
			<tr>
				<td>
				- :
				</td>
				<td align="left">Monitoring value is within threshold.</td>
			</tr>
			<tr>
				<td>
				X :
				</td>
				<td align="left">Monitoring value is over threshold .</td>
			</tr>


			</table>
	</xsl:template>
	<xsl:template match="PortDetailGroup">
		<!--Use nested table to make thin border  //-->
		<table bgcolor="#999999" cellpadding="0" border="0" width="100%">
			<tr>
				<td bgcolor="#999999">
					<table width="100%" bgcolor="#999999" cellpadding="3" cellspacing="1" border="0">
						<tbody>
							<tr style="font-family:sans-serif,Arial, helvetica; font-size:8pt;">
								<th rowspan="2" nowrap="yes" bgcolor="#ffffff" align="center">Port #</th>
								<th rowspan="2" bgcolor="#ffffff" align="center">Type</th>
								<th rowspan="2" bgcolor="#ffffff" align="center">State</th>
								<th rowspan="2" bgcolor="#ffffff" align="center">Dur(H:M)</th>
								<th colspan="8" bgcolor="#ffffff" align="center">Port Errors</th>
								<th colspan="6" bgcolor="#ffffff" align="center">SFP Errors</th>
							</tr>
							<tr style="font-family:sans-serif,Arial, helvetica; font-size:8pt; background-color:white">
								<th bgcolor="#ffffff" align="center">
									<a href="#LFA">LFA</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#LSY">LSY</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#LSI">LSI</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#PER">PER</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#INW">INW</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#CRC">CRC</a>
								</th>								
								<th bgcolor="#ffffff" align="center">
									<a href="#PSC">PSC</a>
								</th>
                                                <th bgcolor="#ffffff" align="center">
									<a href="#LR">LR</a>
								</th>

								<th bgcolor="#ffffff" align="center">
									<a href="#BLP">BLP</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#STM">STM</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#SRX">SRX</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#STX">STX</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#SCU">SCU</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#SVO">SVO</a>
								</th>
							</tr>
							<xsl:apply-templates select="PortDetailItem"/>
						</tbody>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="PortDetailItem">
		<tr style="font-family:sans-serif,Arial, helvetica; font-size:8pt;">
			<td nowrap="yes" bgcolor="#ffffff">
				<xsl:choose>
					<xsl:when test="@PortNumber &lt; 10">00</xsl:when>
					<xsl:when test="@PortNumber &lt; 100">0</xsl:when>
				</xsl:choose>
				<xsl:value-of select="@PortNumber"/>
				<xsl:if test="string(@Location)">
				[<xsl:value-of select="@Location"/>]
				</xsl:if>
			</td>
			<td bgcolor="#ffffff">
				<xsl:value-of select="@PortType"/>
			</td>
			<xsl:choose>
				<xsl:when test="@PortState='HEALTHY'">
					<td bgcolor="#00ff00" align="center">
						<xsl:value-of select="@PortState"/>
					</td>
				</xsl:when>
				<xsl:when test="@PortState='MARGINAL'">
					<td bgcolor="#ffcc66" align="center">
						<xsl:value-of select="@PortState"/>
					</td>
				</xsl:when>
				<xsl:when test="@PortState='FAULTY' or @PortState='DOWN'">
					<td bgcolor="#ff6666" align="center">
						<xsl:value-of select="@PortState"/>
					</td>
				</xsl:when>
				<xsl:when test="@PortState='OFFLINE'">
					<td bgcolor="#ffffff" align="center">
						<xsl:value-of select="@PortState"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td bgcolor="#ffffff" align="center">>
						<xsl:value-of select="@PortState"/>
					</td>
				</xsl:otherwise>
			</xsl:choose>
			<td align="left" nowrap="yes" bgcolor="#ffffff">
				<xsl:value-of select="floor(@Duration div 3600)"/>:<xsl:value-of select="floor(@Duration mod 3600 div 60)"/>
			</td>
			<xsl:for-each select="PortField/@*">
				<xsl:call-template name="threshcell">
					<xsl:with-param name="value" select="."/>
				</xsl:call-template>
			</xsl:for-each>
			<xsl:for-each select="SFPField/@*">
				<xsl:call-template name="threshcell">
					<xsl:with-param name="value" select="."/>
				</xsl:call-template>
			</xsl:for-each>
		</tr>
	</xsl:template>
	<xsl:template name="threshcell">
		<xsl:param name="value"/>
		<td align="center" bgcolor="#ffffff">
			<xsl:choose>
				<xsl:when test="$value='IN_RANGE'">-</xsl:when>
				<xsl:when test="$value='OUT_RANGE'">X</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$value"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
</xsl:stylesheet>

