#!/bin/sh
#
#
#    Copyright (c) 1996-2001 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#    File name:   switchlabpost2.sh.in
#    Module name: diag/scripts
#
#    This file is replacement of POST2 script in case the 2nd bit of labmode
#    is set. This script will be called by diag daemon.
#
#    (Warning) This should not be used as an independent script.
#

#
# Load library 
#
home="/fabos/share"
util="diagcommon.sh"

utilfound=0
for f in "./$util" "$FABOSHOME/share/$util" "$home/$util" ; do
    if [ -r $f ] ; then
	. $f
	utilfound=1
	break;
    fi
done
if [ $utilfound -ne 1 ] ; then

    #
    # fatal error : it shouldn't happen.
    #
    echo "Error -- could not locate $util"
    exit 3
fi

#
# Variables for getConfig() call.
#
config_string="diag.mode.lab"
default_value=0
config_mode=$INTEGER

function refresh_labmode_value
{
    labmode=`getConfig $config_string $config_mode $config_default`
}

function checkLabmode
{
    #
    # check labmode to see if 2nd bit is unset, if it is the case
    # then it exits. if not, it does nothing.
    #
    refresh_labmode_value

    if [ $((labmode & 0x2)) -ne 0 ]
    then
	sleep 1
    else
	exit 0
    fi
}

#
# Main function.
#

refresh_labmode_value
if [ $((labmode & 0x2)) -ne 0 ]
then

#    echo "LabMode Alert ============================================"
#    echo "Run setlabmode with proper value to terminate dummy POST2."
#    echo "Refer to the man page of setlabmode for futher details.   "
#    echo "=========================================================="

    while [ 1 ] ; do
	checkLabmode
    done
fi

exit 0



