#!/bin/sh
#
#
#    Copyright (c) 1996-2013 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#
# NAME
#      kestrel3post2.sh - POST phase II support script for kestrel3
# 
# AVAILABILITY
#      internal
# 
# DESCRIPTION
#      This  is  not  a  command.  It  is a script that manages the
#      POST(power on self test) phase II operations, which involves
#      mainly  in functional tests. The script is designed to oper-
#      ate across power cycles.
# 
# SEE ALSO
#      kestrel3post2(1d)
# 

#  Init variables
#
nPost=0			# number of POST executed
exit_status=0		# this script's exit status value
slot=0			# target slot to run POST
slot_message=""         # message related to slot information

# Check for fwdl in progress
baddev=`bootenv BadRootDev 2>/dev/null`
softupgrade=`bootenv SoftUpgrade 2>/dev/null`

#  special temp file used for each test result
#
logFile=/tmp/post2Log

#
#  function to process trapped signal received. Upon entry, KILL the
#  child PID and output the abort message.
#
post_cleanup()
{
	if [ $?child ]
	then
		/bin/kill $child
	fi
	#
	#  display ALL performed test result
	#
	_current_time=`/bin/date \+\%s`
	_date=`/bin/date`
	_duration=`/usr/bin/expr $_current_time - $startTime`
	_minute=`/usr/bin/expr $_duration / 60`
	_hour=`/usr/bin/expr $_minute / 60`
	_sec=`/usr/bin/expr $_duration % 60`
	_minute=`/usr/bin/expr $_minute % 60`
	/bin/echo "" >> $logFile.$slot
	/bin/echo "POST2:$slot_message POST2 script has been ABORTED $_date took ($_hour:$_minute:$_sec)"
	/bin/echo "POST2:$slot_message POST2 script has been ABORTED $_date took ($_hour:$_minute:$_sec)" >> $logFile.$slot
	/bin/echo "POST2:$slot_message Completed $nPost Diagnostic tests."
	/bin/echo "POST2:$slot_message Completed $nPost Diagnostic tests." >> $logFile.$slot
	$smmi -reg DIAG_STATUS_ID -data POST2_FAILINIT
	exit 1
}


#
#  Function to wait for exec_diag return and process the return status.
#
checkStatus()
{
	#  wait for current child to finish and get return status
	#
	export child=$!
	wait $child
	rval=$?
	fail_code=$1
	shift
	
	
	#  construct PASSED or FAILED msg from return value
	#  .  return value = 0 for PASSED
	#  .  return value != 0 for FAILED
	#
	case $rval in
	139 | 237 )
		echo " SKIPPED $1 due to Known Issue ($rval). Please run following command manually."
		echo "$*"
		echo " SKIPPED $1 due to Known Issue ($rval). Please run following command manually." >>  $logFile.$slot
		echo "$*" >>  $logFile.$slot
		;;
	0 )
		status=PASSED;;
	* )
		status=FAILED
		exit_status=`/usr/bin/expr $exit_status + 1`
		$smmi -reg DIAG_STATUS_ID -data $fail_code
		_current_time=`/bin/date \+\%s`
		_date=`/bin/date`
		_duration=`/usr/bin/expr $_current_time - $startTime`
		_minute=`/usr/bin/expr $_duration / 60`
		_hour=`/usr/bin/expr $_minute / 60`
		_sec=`/usr/bin/expr $_duration % 60`
		_min=`/usr/bin/expr $_minute % 60`
		/bin/echo "POST2:$slot_message Script $status with exit status of $exit_status $_date took ($_hour:$_min:$_sec)"
		/bin/echo "POST2:$slot_message Script $status with exit status of $exit_status $_date took ($_hour:$_min:$_sec)" >> $logFile.$slot
		exit $exit_status
		;;

	esac

	#  compute return status (positive or negative value)
	#
	if [ $rval -gt 127 ]
	then
		rval=`/usr/bin/expr $rval - 256`
	fi

	/bin/echo "POST2:$slot_message Returned status = $rval ($status)" >> $logFile.$slot
}

if [ $?FABOS_SLOTNO ]
then
	slot=$FABOS_SLOTNO
fi

#
# source diagcommon
#
home="/fabos/share"
util="diagcommon.sh"
ok=0
for f in "./$util" "$FABOSHOME/share/$util" "$home/$util" ; do
	if [ -r $f ] ; then
		. $f
		ok=1
		break;
	fi
done
if [ $ok -ne 1 ] ; then
	err "Could not locate $util"
	exit 3
fi

smmi=`commandPath setmmi`
gmmi=`commandPath getmmi`
setdbg=`commandPath setdbg`
$setdbg DIAG 1

state=`$gmmi -reg "POST CONFIG" | cut -d" " -f2`
state1=`expr $state / 63`

case $state1 in
	0 )  $smmi -reg DIAG_STATUS_ID -data INIT_COMPLETE
		exit 0;;
	* ) ;;
esac

# if POST1 failed keep the value
state=`$gmmi -reg "DIAG_STATUS_ID" | cut -d" " -f2`
if [ $state = POST_FAIL2 ]
then
	state1 = 100;
fi

#
# get sys info for multi blade
#
multiBlade=`isMultiBlade`
if [ $multiBlade = TRUE ]
then
     slot_message="Slot $slot"
     export syntax="$0 -slot [slot] postScript"
else
     export syntax="$0 postScript"
fi

# cleanup the old log file
if [ -f $logFile.$slot ]
then
	/bin/rm $logFile.$slot
fi

# Prevent post from running when fwdl is in progress
if [ -n "$baddev" ]
then
    /bin/echo "POST2 skipped due to firmwaredownload in progress $_date" >> $logFile.$slot
    exit 0
fi

if [ -n "$softupgrade" ]
then
    /bin/echo "POST2 skipped due to firmwaredownload in progress $_date" >> $logFile.$slot
    exit 0
fi

#
#  display starting message
#
startTime=`/bin/date \+\%s`
_date=`/bin/date`
/bin/echo "POST2:$slot_message Started running $_date"
/bin/echo "POST2:$slot_message Started running $_date" >> $logFile.$slot


#  export environment variable
#
DIAG_POST=0 ; export DIAG_POST
$smmi -reg DIAG_STATUS_ID -data POST2_INIT

#
# Find exec_diag
#
cmd=`commandPath exec_diag`


#
# Get list of ports for those diags that need them
#
user_ports=`$cmd diagshow -use_bports 1 | /bin/grep "   OK" | /usr/bin/cut -d " " -f 2 | /bin/grep -v "\-\-" | /bin/sort -n | /usr/bin/xargs /bin/echo`

# Make sure there is a port to run
#
if [ -z "$user_ports" ] ;
then
     /bin/echo "POST2:$slot_message ABORT - Nothing to test (NO active ports)"
     /bin/echo "POST2:$slot_message ABORT - Nothing to test (NO active ports)" >> $logFile.$slot
     exit 3 ;
else
     /bin/echo "POST2:$slot_message Testing User ports: $user_ports" >> $logFile.$slot
fi


#  export environment variable
#
DIAG_POST=1 ; export DIAG_POST
DIAG_USR_FAILLIM=1 ; export DIAG_USR_FAILLIM

#  setup signal trap to call cleanup() if the followings:
#	control/d entered at the same window
#	kill <pid> is entered
#
trap "" 2
trap post_cleanup INT TERM KILL

#  reset Error on each port 
# 
/bin/echo "POST2:$slot_message Running diagclearerror" >> $logFile.$slot
$cmd diagclearerror $slot 2>&1 >> $logFile.$slot

# detect and handle bplb_mode
bplb_mode=`getConfig diag.mode.bplb 2 0`
if [ "$bplb_mode" != "0" ]
then
  echo "POST2:$slot_message BPLB mode is ON"
  echo "POST2:$slot_message BPLB mode is ON" >> $logFile.$slot
fi

#
# Start testing
#
#  perform PortLoopbackTest -- serdes test
#
nPost=`/usr/bin/expr $nPost + 1`
/bin/echo "" >> $logFile.$slot
/bin/echo "POST2:$slot_message Test #$nPost - Running portloopbacktest (SERDES)" >> $logFile.$slot
/bin/echo "POST2:$slot_message Test #$nPost - Running portloopbacktest (SERDES)"
#$cmd portloopbacktest -nframes 5 -lb_mode 2 2>&1 >> $logFile.$slot &
/fabos/cliexec/exec_diag2 portloopbacktest -nframes 5 -lb_mode 2 2>&1 >> $logFile.$slot &
checkStatus POST2_FAIL1 portloopbacktest -nframes 5 -lb_mode 2

#  perform Minicycle (internal) test
#
#nPost=`/usr/bin/expr $nPost + 1`
#/bin/echo "" >> $logFile.$slot
#/bin/echo "POST2:$slot_message Test #$nPost - Running minicycle (SERDES)" >> $logFile.$slot
#/bin/echo "POST2:$slot_message Test #$nPost - Running minicycle (SERDES)"
#$cmd minicycle -lb_mode 2 -nmegs 1 2>&1 >> $logFile.$slot &
#checkStatus POST2_FAIL2 minicycle -lb_mode 2 -nmegs 1

#  check test status of each port (must be RUN in fore ground)
# 
/bin/echo "POST2:$slot_message Running diagshow" >> $logFile.$slot
/bin/echo "POST2:$slot_message Running diagshow"
$smmi -reg DIAG_STATUS_ID -data POST2_TEST3
$cmd diagshow --slot $slot -use_bports 1 -silent 1 >> $logFile.$slot 
status=$?

if [ $status -ne 0 ]
then
    $smmi -reg DIAG_STATUS_ID -data POST2_FAIL3
    exit_status=`/usr/bin/expr $exit_status + 1`
fi

if [ $state1 = 100 ]
then
	$smmi -reg DIAG_STATUS_ID -data POST_FAIL2
	exit_status = 100
fi

#  display ALL performed test result
#
/bin/echo "" >> $logFile.$slot
/bin/echo "POST2:  ********** $slot_message POST Summary  **********" >> $logFile.$slot
/bin/echo "POST2:$slot_message Completed $nPost Diagnostic test:" >> $logFile.$slot

#  display exit msg and exit script
#
if [ $exit_status -ne 0 ]
then
    status=FAILED
else
    status=PASSED
    $smmi -reg DIAG_STATUS_ID -data INIT_COMPLETE
fi
_current_time=`/bin/date \+\%s`
_date=`/bin/date`
_duration=`/usr/bin/expr $_current_time - $startTime`
_minute=`/usr/bin/expr $_duration / 60`
_hour=`/usr/bin/expr $_minute / 60`
_sec=`/usr/bin/expr $_duration % 60`
_min=`/usr/bin/expr $_minute % 60`
/bin/echo "POST2:$slot_message Script $status with exit status of $exit_status $_date took ($_hour:$_min:$_sec)"
/bin/echo "POST2:$slot_message Script $status with exit status of $exit_status $_date took ($_hour:$_min:$_sec)" >> $logFile.$slot
exit $exit_status

