#!/bin/bash

## CHANGE domain "03" below to the actual domain of your switch:
##

f_pid() { x_pid=$(printf "%02x00" $1) ;}
f_online() { f_pid $1; switchshow | grep $x_pid | grep Online; }
f_nolight() { f_pid $1; switchshow | grep $x_pid | grep No_Light; }
f_sigdetect() { f_pid $1; switchshow | grep $x_pid | grep No_SigDet; }
f_nosync() { f_pid $1; switchshow | grep $x_pid | grep No_Sync; }

portOnline() { portshow $1 | grep Online; }

f_de() { portdisable $1; portenable $1; }

#### start #########
sleep 180

echo "#########################################################"
echo "#### Kicking off the script for SigDetect workaround ####"
echo "#########################################################"

while :
do
  for x in $(seq 14);
    do
      portst=`f_sigdetect $x`;
#     echo $portst
      length=${#portst};
#	echo "length=" $length;
#     echo $x: $portst
# Check if port is No Signal Detect State
      if [[ "$length" -gt 10 ]]
        then
          f_de $x
          echo "Port $x NoSigDet: toggled"
        fi
		
      portst=`f_nosync $x`;
#     echo $portst
      length=${#portst};
#	echo "length=" $length;
#     echo $x: $portst
# Check if port is No Sync State
      if [[ "$length" -gt 10 ]]
        then
          f_de $x
          echo "Port $x No_Sync: toggled"
        fi
    done
  sleep 2
done # Start over
