<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="switchhealth.xsl"/>
	<xsl:include href="portstatus.xsl"/>
	<xsl:include href="sam.xsl"/>
	<xsl:output method="html"/>
	<xsl:template match="/">
		<html>
			<head>
				<meta content="no-cache" http-equiv="Pragma"/>
				<title>
					Customized Report
				</title>
			</head>
			<body bgcolor="#ffffff">
				<xsl:apply-templates select="CustomizedReport"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="CustomizedReport ">
		<table width="100%" border="0" cellspacing="0" cellpadding="5">
			<tbody>
				<tr bgcolor="c0c0c0">
					<td>
						<xsl:value-of select="ReportName"/>
					</td>
					<td align="left">Report Time:  <xsl:value-of select="ReportTime"/>
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:apply-templates select="Content"/>
	</xsl:template>
	<xsl:template match="Content">
		<xsl:variable name="ReportCount" select="count(*)"/>
		<xsl:for-each select="*">
			<xsl:choose>
				<xsl:when test="position()=1">
					<table border="0">
						<tbody>
							<tr>
								<td width="120">Switch Name:</td>
								<td align="left">
									<xsl:value-of select="SwitchInfo/@SwitchName"/>
								</td>
							</tr>
							<tr>
								<td width="120">IP Address:</td>
								<td align="left">
									<xsl:value-of select="SwitchInfo/@IPAddress"/>
								</td>
							</tr>
						</tbody>
					</table>
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$ReportCount >1">
				<p>
					<b>
						<xsl:value-of select="ReportName"/>
					</b>
				</p>
			</xsl:if>
			<xsl:apply-templates select="."/>
		</xsl:for-each>
		<p/>
	</xsl:template>
</xsl:stylesheet>
