/*---------------------------------------------------------------
 * JavaScript Functions For Switch Report in Web Tools
 *---------------------------------------------------------------*/
var DEBUG = false;
function debug(msg)
{
  if (DEBUG)
	 window.alert("[debug]\n" + msg);
}

function dumpObj(obj)
{
  if (obj == null)
	 return "null";
  if (typeof obj != "object")
	 return typeof obj;
  var msg = "";
  for(var i in obj)
	 msg += i + "=" + obj[i] + "\n";
  return msg;
}

/*------------------------------------------------------------
 * Action Menu Support
 *------------------------------------------------------------*/
var isDOM = (document.getElementById ? true : false);
var isIE4 = ((document.all && !isDOM) ? true : false);
var isNS4 = (document.layers ? true : false);
var isIE6 = (document.all && navigator.userAgent.toLowerCase().indexOf('msie 6.') != -1);

function getRef(id)
{
  if (isDOM) return document.getElementById(id);
  if (isIE4) return document.all[id];
  if (isNS4) return document.layers[id];
}

function getSty(id)
{
  return (isNS4 ? getRef(id) : getRef(id).style);
}

// Hide timeout.
var popTimer = 0;

// Array showing highlighted menu items.
var litNow = new Array();

// mouse over
function popOver(menuNum, itemNum)
{
  clearTimeout(popTimer);
  hideAllBut(menuNum);
  litNow = getTree(menuNum, itemNum);
  changeCol(litNow, true);
  targetNum = menu[menuNum][itemNum].target;
  if (targetNum > 0) {
    thisX = parseInt(menu[menuNum][0].ref.left) + parseInt(menu[menuNum][itemNum].ref.left);
    thisY = parseInt(menu[menuNum][0].ref.top) + parseInt(menu[menuNum][itemNum].ref.top);
    with (menu[targetNum][0].ref) {
      left = parseInt(thisX + menu[targetNum][0].x);
      top = parseInt(thisY + menu[targetNum][0].y);
      visibility = 'visible';
    }
  }
}

// mouse out
function popOut(menuNum, itemNum)
{
  if ((menuNum == 0) && !menu[menuNum][itemNum].target)
    hideAllBut(0)
      else
	popTimer = setTimeout('hideAllBut(0)', 500);
}


function getTree(menuNum, itemNum)
{
  // Array index is the menu number. The contents are null (if that menu is not a parent)
  // or the item number in that menu that is an ancestor (to light it up).
  itemArray = new Array(menu.length);

  while(1) {
    itemArray[menuNum] = itemNum;
    // If we've reached the top of the hierarchy, return.
    if (menuNum == 0) return itemArray;
    itemNum = menu[menuNum][0].parentItem;
    menuNum = menu[menuNum][0].parentMenu;
  }
}

// Pass an array and a boolean to specify colour change, true = over colour.
function changeCol(changeArray, isOver)
{
  for (menuCount = 0; menuCount < changeArray.length; menuCount++) {
    if (changeArray[menuCount]) {
      newCol = isOver ? menu[menuCount][0].overCol : menu[menuCount][0].backCol;
      // Change the colours of the div/layer background.
      with (menu[menuCount][changeArray[menuCount]].ref) {
	if (isNS4) bgColor = newCol;
	else backgroundColor = newCol;
      }
    }
  }
}


function hideAllBut(menuNum)
{
  var keepMenus = getTree(menuNum, 1);
  for (count = 0; count < menu.length; count++)
    if (!keepMenus[count] && menu[count][0].ref != null)
      menu[count][0].ref.visibility = 'hidden';
  changeCol(litNow, false);
}

// Define Menu
function Menu(isVert, popInd, x, y, width, overCol, backCol, borderClass, textClass)
{
  // True or false - a vertical menu?
  this.isVert = isVert;
  // The popout indicator used (if any) for this menu.
  this.popInd = popInd;
  // Position and size settings.
  this.x = x;
  this.y = y;
  this.width = width;
  // Colours of menu and items.
  this.overCol = overCol;
  this.backCol = backCol;
  // The stylesheet class used for item borders and the text within items.
  this.borderClass = borderClass;
  this.textClass = textClass;
  // Parent menu and item numbers, indexed later.
  this.parentMenu = null;
 this.parentItem = null;
 // Reference to the object's style properties (set later).
 this.ref = null;
}

// Define Item
function Item(text, href, action, frame, length, spacing, target)
{
  this.text = text;
  this.href = href;
  this.action = action;
  this.frame = frame;
  this.length = length;
  this.spacing = spacing;
  this.target = target;
  // Reference to the object's style properties (set later).
  this.ref = null;
}

function writeMenus()
{
  if (!isDOM && !isIE4 && !isNS4) return;

  for (currMenu = 0; currMenu < menu.length; currMenu++) with (menu[currMenu][0]) {
    // Variable for holding HTML for items and positions of next item.
    var str = '', itemX = 0, itemY = 0;

    // Remember, items start from 1 in the array (0 is menu object itself, above).
    // Also use properties of each item nested in the other with() for construction.
    for (currItem = 1; currItem < menu[currMenu].length; currItem++) with (menu[currMenu][currItem]) {
      var itemID = 'menu' + currMenu + 'item' + currItem;

      // The width and height of the menu item - dependent on orientation!
      var w = (isVert ? width : length);
      var h = (isVert ? length : width);

      // Create a div or layer text string with appropriate styles/properties.
      // Thanks to Paul Maden (www.paulmaden.com) for helping debug this in IE4, apparently
      // the width must be a miniumum of 3 for it to work in that browser.
      if (isDOM || isIE4) {
	str += '<div id="' + itemID + '" style="position: absolute; left: ' + itemX + '; top: ' + itemY + '; width: ' + w + '; height: ' + h + '; visibility: inherit; ';
	if (backCol) str += 'background: ' + backCol + '; ';
	str += '" ';
      }

      if (isNS4) {
	str += '<layer id="' + itemID + '" left="' + itemX + '" top="' + itemY + '" width="' +  w + '" height="' + h + '" visibility="inherit" ';
	if (backCol) str += 'bgcolor="' + backCol + '" ';
      }
      if (borderClass) str += 'class="' + borderClass + '" ';

      // Add mouseover handlers and finish div/layer.
      str += 'onMouseOver="popOver(' + currMenu + ',' + currItem + ')" onMouseOut="popOut(' + currMenu + ',' + currItem + ')">';

      // Add contents of item (default: table with link inside).
      // In IE/NS6+, add padding if there's a border to emulate NS4's layer padding.
      // If a target frame is specified, also add that to the <a> tag.

      sAction='';
      if (action !=null && action.length >0) {
	sAction = ' onClick="' + action +'" ';
      }

      shref='';
      if (href != null && href.length >0 ) {
         shref = '<a class="' + textClass + '" href="' + href + '"' + (frame ? ' target="' + frame +'" ' : '') + sAction +'>' + text + '</a> ';
      }



      str += '<table width="' + (w - 8) + '" border="0" cellspacing="0" cellpadding="' + (!isNS4 && borderClass ? 3 : 0) + '"><tr><td class="' + textClass + '" align="left" height="' + (h - 7) + '" '+ sAction+ '>' + (shref.length > 0 ? shref:text)+'</td>';


      if (target > 0) {

	// Set target's parents to this menu item.
	menu[target][0].parentMenu = currMenu;
	menu[target][0].parentItem = currItem;

	// Add a popout indicator.
	if (popInd) str += '<td class="' + textClass + '" align="right">' + popInd + '</td>';
      }
      str += '</tr></table>' + (isNS4 ? '</layer>' : '</div>');
      if (isVert) itemY += length + spacing;
      else itemX += length + spacing;
    }

    if (isDOM) {
      var newDiv = document.createElement('div');
      document.getElementsByTagName('body').item(0).appendChild(newDiv);
      newDiv.innerHTML = str;
      ref = newDiv.style;
      ref.position = 'absolute';
      ref.visibility = 'hidden';
    }

    // Insert a div tag to the end of the BODY with menu HTML in place for IE4.
    if (isIE4) {
      document.body.insertAdjacentHTML('beforeEnd', '<div id="menu' + currMenu + 'div" ' + 'style="position: absolute; visibility: hidden">' + str + '</div>');
      ref = getSty('menu' + currMenu + 'div');
    }

    // In NS4, create a reference to a new layer and write the items to it.
    if (isNS4) {
      ref = new Layer(0);
      ref.document.write(str);
      ref.document.close();
    }

    for (currItem = 1; currItem < menu[currMenu].length; currItem++) {
      itemName = 'menu' + currMenu + 'item' + currItem;
      if (isDOM || isIE4) menu[currMenu][currItem].ref = getSty(itemName);
      if (isNS4) menu[currMenu][currItem].ref = ref.document[itemName];
    }
  }
  with(menu[0][0]) {
    ref.left = x;
    ref.top = y;
    ref.visibility = 'visible';
  }
}

//-------------------------
// Define Menu Content
//-------------------------
var menu = new Array();

// Default menu color
var defOver = '#a0a0a0', defBack = '#D6D3C6';

// Default 'length' of menu items - item height if menu is vertical, width if horizontal.
var defLength = 25;

// Menu 0 is the special, 'root' menu from which everything else arises.
menu[0] = new Array();
menu[0][0] = new Menu(true, '', 0, 0, 150, defOver, defBack, 'menuBorder', 'menuText');
// Notice how the targets are all set to nonzero values...
menu[0][1] = new Item('  Action', '', '', '', defLength, 5, 1);

// Action menu items
menu[1] = new Array();
menu[1][0] = new Menu(true, '>', 0, 24, 120, defOver, defBack, 'itemBorder', 'itemText');
menu[1][1] = new Item('Refresh Report',   '', 'actionProxy(AID_REFRESH);', '', defLength, 0, 0);
menu[1][2] = new Item('Customize Report', '', 'actionProxy(AID_CUSTOMIZE);', '', defLength, 0, 0);
menu[1][3] = new Item('View Raw Data',    '', 'actionProxy(AID_VIEWDATA);', '', defLength, 0, 0);
menu[1][4] = new Item('View Style Sheet', '', 'actionProxy(AID_VIEWSTYLE);', '', defLength, 0, 0);
menu[1][5] = new Item('View Schema',      '', 'actionProxy(AID_VIEWSCHEMA);', '', defLength, 0, 0);

// These two lines handle the window resize bug in NS4. See <body onResize="...">.
// I recommend you leave this here as otherwise when you resize NS4's width menus are hidden.

var popOldWidth = window.innerWidth;
nsResizeHandler = new Function('if (popOldWidth != window.innerWidth) location.reload()');


// This is a quick snippet that captures all clicks on the document and hides the menus
// every time you click. Use if you want.

if (isNS4) document.captureEvents(Event.CLICK);
document.onclick = clickHandle;

function clickHandle(evt)
{
 if (isNS4) document.routeEvent(evt);
 hideAllBut(0);
}

// This is just the moving command for the example.

function moveRoot()
{
 with(menu[0][0].ref) left = ((parseInt(left) < 100) ? 100 : 5);
}


/*----------------------------------------------------------
 * Report Action Support
 *----------------------------------------------------------*/
  // report source id
  var SID_REPORT  = 0
  var SID_RAWDATA = 1;
  var SID_STYLE   = 2;
  var SID_SCHEMA  = 3;

  // report id
  var RID_SWHEALTH      = 0;
  var RID_PORTHEALTHY   = 1;
  var RID_PORTMARGINAL  = 2;
  var RID_PORTFAULTY    = 3;
  var RID_PORTALL       = 4;
  var RID_SAM           = 5;
  var RID_CUSTOMIZED    = 6;

  // action id
  var AID_REFRESH       = 0;
  var AID_CUSTOMIZE     = 1;
  var AID_VIEWDATA      = 2;
  var AID_VIEWSTYLE     = 3;
  var AID_VIEWSCHEMA    = 4;

  // Acitons: row order follows action id
  var actions = ["Refresh Report",
		  "Customize Report",
		  "View Raw Data",
		  "View Style Sheet",
                  "View Schema"
                 ];

  // record current select report ID
  var currRID = 0;

  // record Fabric Watch License
  var hasFWLic = true;

  // record authentication info
  var authInfo = "";

  // URLs: row order follows report id; coloumn order follows report source id.
  var reportUrls =
                  [["switchhealthreport.xml", "switchhealth.xml", "switchhealth.xsl", "switchhealth.xsd"],
						 ["portstatusreport.xml?ports=healthy", "portstatus.xml?ports=healthy", "portstatus.xsl", "portstatus.xsd"],
						 ["portstatusreport.xml?ports=marginal", "portstatus.xml?ports=marginal", "portstatus.xsl", "portstatus.xsd"],
						 ["portstatusreport.xml?ports=faulty", "portstatus.xml?ports=faulty", "portstatus.xsl", "portstatus.xsd"],
						 ["portstatusreport.xml?ports=all", "portstatus.xml?ports=all", "portstatus.xsl", "portstatus.xsd"],
                   ["samreport.xml", "sam.xml", "sam.xsl", "sam.xsd"],
                   ["customizedreport.xml", "customized.xml", "customized.xsl", "customized.xsd"],
                  ];

  var initUrl = reportUrls[0][0];
  var queryUrl = "reportQuery.html";

  var WIN_PROP = "height=450,width=720,location=yes,menubar=yes,resizable=yes,"+
             "status=yes,titlebar=yes,toolbar=no,scrollbars=yes";
  var DIALOG_PROP = "height=340,width=480,location=no,menubar=no,resizable=no,"+
             "status=no,titlebar=no,toolbar=no,scrollbars=no";

  var wtrf = new WTReportForm();
  window.wtrf = wtrf;

  function selectReport(reportId)
  {
	 if (reportId < 0 || reportId >= reportUrls.length) {
		alert("Invalid Report Selection: " + reportId +
				".\n Please check with your selection.");
		return;
	 }

	 debug("report=" + reportUrls[reportId][0]);

	 currRID = reportId;
  }

  function actionProxy(aid)
  {
	 switch(aid) {
	 case AID_REFRESH:
		refreshReport("rpmain_frame");
		break;
	 case AID_CUSTOMIZE:
		queryReport("query_win");
		break;
	 case AID_VIEWDATA:
		viewSource(SID_RAWDATA, "_blank");
		break;
	 case AID_VIEWSTYLE:
		viewSource(SID_STYLE, "_blank");
		break;
	 case AID_VIEWSCHEMA:
		viewSource(SID_SCHEMA, "_blank");
		break;
	 }
  }

  function refreshReport(target)
  {
	var url;
	if (currRID != RID_CUSTOMIZED) {
	   url =  reportUrls[currRID][0];
	} else {
           var cat = "?";
           if (reportUrls[currRID][0].indexOf("?") >=0)
	     cat = "&";
           url = reportUrls[currRID][0]+
	         cat + document.querydataform.reportname.name + "=" +document.querydataform.reportname.value +
                 "&" + document.querydataform.switchhealth.name +"=" +document.querydataform.switchhealth.value;
	   if (hasFWLic) {
                 url = url +
                       "&" + document.querydataform.sam.name +"=" +document.querydataform.sam.value +
                       "&" + document.querydataform.portstatus.name +"=" +document.querydataform.portstatus.value +
                       "&" + document.querydataform.ports.name +"=" +document.querydataform.ports.value +
                       "&" + document.querydataform.portlist.name +"=" +document.querydataform.portlist.value;
                }
	}

	var tauth = "";
	if (authInfo.length>0) {
		if (url.indexOf("?") >=0)
			tauth = "&"+authInfo;
		else
			tauth = "?"+authInfo;
	}

	pageLoad(url+tauth, target);
  }

  function queryReport(target)
  {
	 var win = window.open("", "_blank", DIALOG_PROP);
	 if (win == null || typeof win == "undefined") {
		alert("Browser cannot open new window");
	   return;
	 }
	 wtrf.showForm(win);
  }

  function viewSource(sid, target)
  {
	var url;
	if (currRID != RID_CUSTOMIZED || sid != SID_RAWDATA) {
	   url = reportUrls[currRID][sid];
	} else {
	   var cat = "?";
           if (reportUrls[currRID][sid].indexOf("?") >=0)
	     cat = "&";
           url = reportUrls[currRID][sid]+
	         cat + document.querydataform.reportname.name + "=" +document.querydataform.reportname.value +
                 "&" + document.querydataform.switchhealth.name +"=" +document.querydataform.switchhealth.value;
	   if (hasFWLic) {
                 url = url +
                       "&" + document.querydataform.sam.name +"=" +document.querydataform.sam.value +
                       "&" + document.querydataform.portstatus.name +"=" +document.querydataform.portstatus.value +
                       "&" + document.querydataform.ports.name +"=" +document.querydataform.ports.value +
                       "&" + document.querydataform.portlist.name +"=" +document.querydataform.portlist.value;
                }
	}

	var tauth = "";
	if (authInfo.length>0) {
		if (url.indexOf("?") >=0)
			tauth = "&"+authInfo;
		else
			tauth = "?"+authInfo;
	}

	pageLoad(url+tauth, target, WIN_PROP);
  }



function pageLoad(url, target, prop)
{
  debug("URL==>" + url +
		  "\ntarget==>" + target);
  window.open(url, target, prop);

  // add the page not found handle.
}

/*--------------------------------------------------------------
 * Customize Report -- Query Form Support
 *--------------------------------------------------------------*/

function WTReportForm()
{
   var HTML_BEG =
	 "<html>\n<head>\n"+
	 "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n"+
	 "<title>Customize Report</title>\n"+
	 "</head>\n"+
	 "<body bgcolor=\"#D4D0C8\" text=\"#000000\">\n"+
	 "<script language=\"javascript\">\n<!--\n"+
	 "var wtrf = window.opener.wtrf;\n"+
	 "// -->\n</script>\n"+
	 "<center>\n";

  var mauth = "";
  if (authInfo.length >0) {
    var t1 = authInfo.split("=");
    if (t1.length == 2) {
      mauth = "<input type=\"hidden\" name=\"" + t1[0] +"\" value=\"" + t1[1] +"\" />\n";
    }
  }
  var FORM1 =
	 "<form name=\"sf\" action=\"customizedreport.xml\" method=\"GET\" target=\"window.opener.rpmain_frame\">\n" + mauth +
	  "<input type=\"hidden\" name=\"reportname\" />\n" +
	  "<input type=\"hidden\" name=\"switchhealth\" />\n" +
          "<input type=\"hidden\" name=\"sam\" />\n" +
          "<input type=\"hidden\" name=\"portstatus\" />\n" +
          "<input type=\"hidden\" name=\"ports\" />\n" +
          "<input type=\"hidden\" name=\"portlist\" />\n" +
	 "</form>\n";

  var FORM2_BEG =
	 "<form name=\"qf\">\n"+
	 "<table border=\"0\" width=\"100%\" align=\"center\">\n"+
	 "<tr>\n<td colspan=2 bgcolor=#c0c0c0>\n"+
	 "&nbsp;Enter your settings to generate customized report\n" +
	 "</td>\n</tr>\n"+
	 "<tr><td>&nbsp;</td></tr>\n<tr>\n"+
	 "<td width=\"30\">Name:</td>\n"+
	 "<td width=\"300\"><input type=\"text\" name=\"reportName\" value=\"\" onKeyPress=\"return wtrf.disableEnterKey(event);\" size=\"50\"/></td>\n"+
	 "</tr>\n<tr>\n"+
	 "<td>Options</td>\n"+
	 "<td>\n<input type=\"checkbox\" name=\"switchHealth\" value=\"\" />Switch Health\n";
  var FORM2_NOLIC_END =
	 "<tr>\n"+
	 "<tr><td>&nbsp</td></tr><tr><td>&nbsp</td></tr><tr><td>&nbsp</td></tr><tr><td>&nbsp</td></tr>\n"+
	 "<td colspan=\"2\" align=\"center\">\n"+
	 "<input type=\"button\" name=\"bt_ok\" value=\"   OK   \" onclick=\"wtrf.clickOK();\" />\n"+
	 "<input type=\"button\" name=\"bt_cancel\" value=\"Cancel\" onclick=\"wtrf.clickCancel();\" />\n"+
	 "</td></tr>\n</table>\n</form>\n";
  var FORM2_LIC_END =
	 "<input type=\"checkbox\" name=\"sam\" value=\"\" />SAM&nbsp;&nbsp;\n"+
	 "<input type=\"checkbox\" name=\"portStatus\" value=\"\" onClick=\"wtrf.selectPortStatus(this.checked);\"/>Port Detail\n"+
    "</td>\n</tr>\n<tr>\n"+
	 "<td>Port Range</td>\n"+
	 "<td><input type=\"radio\" name=\"ports\" value=\"\" onClick=\"wtrf.selectChoosePorts(this.checked);\"/>\n"+
	 "<select name=\"portSelect\" size=1 disabled=true/>\n" +
	 "<option value=\"\"></option>\n" +
	 "<option value=\"all\">All</option>\n" +
	 "<option value=\"healthy\">Healthy</option>\n" +
	 "<option value=\"marginal\">Marginal</option>\n" +
	 "<option value=\"faulty\">Faulty</option>\n" +
	 "</select>\n" +
	 "</td></tr>\n<tr>\n"+
	 "<td>&nbsp;</td>\n<td>\n"+
	 "<input type=\"radio\" name=\"ports\" value=\"\" onClick=\"wtrf.selectInputPorts(this.checked);\" />Ports:&nbsp;\n"+
	 "<input type=\"text\"  name=\"portField\" value=\"\" size=\"40\" onFocus=\"wtrf.setPortsInputFieldFocus();\" onChange=\"wtrf.setPortsInputFieldChange();\"/>\n"+
	 "</td>\n</tr>\n<tr>\n"+
	 "<td>&nbsp;</td>\n"+
	 "<td>(Enter port numbers and/or port ranges</td>\n"+
	 "</tr>\n<tr>\n"+
	 "<td>&nbsp;</td>\n"+
	 "<td>separated by commas. For example, 1,3,5-15)</td>\n</tr> \n"+
	 "<tr><td>&nbsp;</td></tr>\n<tr>\n"+
	 "<td colspan=\"2\" align=\"center\">\n"+
	 "<input type=\"button\" name=\"bt_ok\" value=\"    OK    \" onclick=\"wtrf.clickOK();\" />\n"+
	 "<input type=\"button\" name=\"bt_cancel\" value=\"Cancel\" onclick=\"wtrf.clickCancel();\" />\n"+
	 "</td>\n</tr>\n</table>\n</form>\n";
  var HTML_END =
	 "</center>\n"+
	 "<script language=\"javascript\">\n<!--\n"+
	 "wtrf.setForm(document.qf, document.sf);\n"+
	 "// -->\n</script>\n"+
	 "</body>\n</html>";

  var win;
  var qf;
  var sf;


  var YES = "yes";
  var NO = "no";


  this.selectPortStatus = selectPortStatus;
  this.selectChoosePorts = selectChoosePorts;
  this.selectInputPorts = selectInputPorts;
  this.setPortsInputFieldFocus = setPortsInputFieldFocus;
  this.setPortsInputFieldChange = setPortsInputFieldChange;
  this.clickOK = clickOK;
  this.clickCancel = clickCancel;
  this.setForm = setForm;
  this.saveFormData = saveFormData;
  this.showForm = showForm;
  this.disableEnterKey = disableEnterKey;


  function showForm(in_win)
  {
     var ss = HTML_BEG + FORM1 + FORM2_BEG;

     if (hasFWLic) {
		 ss += FORM2_LIC_END;
	  }
     else
		 ss += FORM2_NOLIC_END;
     ss += HTML_END;

     win = in_win;
	  win.document.open();
     win.document.write(ss);
	  win.document.close();
  }

  function saveFormData(submitForm)
  {
	 if (document.querydataform == null || typeof document.querydataform == "undefined") {
		win.alert("querydataform does not existed in page: cannot save query data.");
		return;
	 }
	 document.querydataform.reportname.value=submitForm.reportname.value
	 document.querydataform.switchhealth.value=submitForm.switchhealth.value;
	 if (hasFWLic) {
		document.querydataform.sam.value=submitForm.sam.value;
		document.querydataform.portstatus.value=submitForm.portstatus.value;
		document.querydataform.ports.value=submitForm.ports.value;
		document.querydataform.portlist.value =submitForm.portlist.value;
	 }

	debug("reportName=" + document.querydataform.reportname.value +
				"\nswitchHealth=" + document.querydataform.switchhealth.value +
				"\nsam=" + document.querydataform.sam.value +
				"\nportStatus=" + document.querydataform.portstatus.value +
				"\nports=" + document.querydataform.ports.value +
				"\nportlist=" + document.querydataform.portlist.value);
  }


  function setForm(queryForm, submitForm)
  {
	 if (queryForm == null || typeof queryForm == "undefined" ||
		  submitForm == null || typeof submitForm == "undefined") {
		win.alert("Invalid Forms");
		return;
	 }

	 qf = queryForm;
	 sf = submitForm;
  }

  // Parse and process Port Input
  var pattern = /^[(\d{1,2,3}|\d{1,2,3}\-\d{1,2,3}),]*$/;

  function formatInputPorts(str, old_delim, new_delim)
  {
	 debug("Input:" +str);
	 var newstr = str;
	 var t = newstr.split(old_delim);
	 var numArray = new Array();
	 var count = 0;
	 for(var i=0; i < t.length; i++) {
        debug("t[i]=" + t[i]);
		if (t[i].indexOf("-") == -1) {
			var digital = parseInt(stringTrim(t[i]));
			if (insertDigital(numArray, count, digital)) {
				count++;
			}
		} else {
		  var t1 = t[i].split("-");
		  var begin = parseInt(stringTrim(t1[0]));
		  var end = parseInt(stringTrim(t1[1]));
		  if (begin >= end) {
			 if (insertDigital(numArray, count, begin))
				count++;
		  } else {
			 for(var k=begin; k<=end; k++) {
				if ( insertDigital(numArray, count, k))
				  count++;
			 }
		  }
		}
	 }

	 if (count == 0)
		return "";
	 else {
		var str = "";
		for(var i=0; i<count-1; i++)
		  str += numArray[i] + new_delim;
		str += numArray[count-1];
		return str;
	 }
  }
 function disableEnterKey(event)
  {
    var key = event.keyCode ? event.keyCode : event.which ? event.which : event.charCode;

     if(key == 13)
          return false;
     else
          return true;
   }

  // Insert digial to sorted array.
  function insertDigital(arr, count, digital)
  {
	 // find insert position
	 var pos = -1;
	 for(var i=0; i<count; i++) {
		if (arr[i] > digital) {
		  pos = i;
		  break;
		} else if (arr[i] == digital) {
		  // redundant digital, abort insertion
		  return false;
		}
	 }

	 // shift rest digitals
	 if (pos == -1) {
		arr[count] = digital;
	 } else {
		for(var i=count; i>pos; i--) {
		  arr[i] = arr[i-1];
		}
		arr[pos] = digital;
	 }

	 return true;
  }

  // trim leading and tailing whitespace from string
  function stringTrim(str)
  {
         if (document.all && !isIE6) {
            return str;
         }

	 var t = str;
	 t = t.replace(/^\s*(.*)/, "$1");
	 t = t.replace(/(.*?)\s*$/, "$1");

	 return t;
  }

  // OK Button Action
  function clickOK()
  {
	 if (qf == null || typeof qf == "undefined" ||
             sf == null || typeof sf == "undefined") {
		win.alert("Invalid Forms");
		return;
	 }

	 qf.reportName.value = stringTrim(qf.reportName.value);
	 // Fix for the defect: TR000231175
	 if (qf.reportName.value.length <1 || qf.reportName.value.length >30) {
	    win.alert("Invalid Report Name: Length of name should be >=1 and <=30.\nPlease re-enter.");
            return;
         }
         if (!isSwitchHealthSelected()&&!hasFWLic) {
		win.alert("Invalid Report Options: empty\nPlease re-enter.");
		return;
         }

	 if (qf.reportName.value.indexOf("<") >-1 ||
             qf.reportName.value.indexOf(">") >-1 || qf.reportName.value.indexOf("&") >-1) {
            win.alert("Invalid Report Name: cannot contain '<', '>' or '&'.\nPlease re-enter.");
            return;
         }

	 if (!isSwitchHealthSelected() && !isSAMSelected() && !isPortStatusSelected()) {
	    win.alert("Invalid Report Options: empty\nPlease re-enter.");
            return;
         }
         sf.reportname.value = escape(qf.reportName.value);

	 sf.switchhealth.value = isSwitchHealthSelected()? YES:NO;

	 if (hasFWLic) {
		sf.sam.value = isSAMSelected()? YES:NO;
		sf.portstatus.value= isPortStatusSelected()? YES:NO;
		sf.ports.value = getPorts();
		if (sf.ports.value == "list") {
			var input = qf.portField.value;
			if (! isValidPortsInput(input)) {
				win.alert("Invalid Ports:\"" + input +
				  "\"\nPlease re-enter.");
				setPortsInputFieldFocus();
			        sf.reset();
				return;
			}
			sf.portlist.value = getInputPorts();
		} else {
			sf.portlist.value = "";
		}
		debug("reportName=" + sf.reportname.value +
				"\nswitchHealth=" + sf.switchhealth.value +
				"\nsam=" + sf.sam.value +
				"\nportStatus=" + sf.portstatus.value +
				"\nports=" + sf.ports.value +
				"\nportlist=" + sf.portlist.value);
	 }
	 saveFormData(sf);
	 currRID = RID_CUSTOMIZED;

	 refreshReport("rpmain_frame");
	 qf.reset();
	 sf.reset();
	 if (win != null) {
		win.close();
		win = null;
	 }
  }

  // Cancel Button Action
  function clickCancel()
  {
	 if (qf != null)
		qf.reset();

	 if (sf != null)
		sf.reset();
	 if (win != null) {
		win.close();
		win = null;
	 }
  }

  // select Option -- Port Status
  function selectPortStatus(isSelected)
  {
	 if (isSelected) {
		selectChoosePorts(true);
	 } else {
		selectChoosePorts(false);
		selectInputPorts(false);
	 }
  }

  // select Port Range-- Choose Ports
  function selectChoosePorts(isSelected)
  {
	 if (! isPortStatusSelected()) {
		  qf.ports[0].checked = false;
		  qf.portSelect.selectedIndex= 0;
		  qf.portSelect.disabled = true;
		  return;
	 }

	 if (isSelected) {
		qf.ports[0].checked = true;
		qf.ports[1].checked = false;
		qf.portField.value = "";
		qf.portField.readonly = true;
		qf.portSelect.selectedIndex= 1;
		qf.portSelect.disabled = false;
	 } else {
		qf.ports[0].checked = false;
		qf.ports[1].checked = true;
		qf.portField.readonly = false;
		qf.portField.focus();
	        qf.portSelect.selectedIndex= 0;
		qf.portSelect.disabled = true;
	 }
  }

  // select Port Range--Input Ports
  function selectInputPorts(isSelected)
  {
	 if (! isPortStatusSelected()) {
		qf.ports[1].checked = false;
		qf.portField.value = "";
		qf.portField.readonly = true;
		return;
	 }

	 if (isSelected) {
		qf.ports[0].checked = false;
		qf.ports[1].checked = true;
		qf.portField.readonly = false;
		qf.portField.focus();
	        qf.portSelect.selectedIndex= 0;
		qf.portSelect.disabled = true;
	 } else {
		qf.ports[0].checked = true;
		qf.ports[1].checked = false;
		qf.portField.value = "";
		qf.portField.readonly = true;
		qf.portSelect.selectedIndex= 1;
		qf.portSelect.disabled = false;
	 }
  }

  function isSwitchHealthSelected()
  {
	 return qf.switchHealth.checked;
  }

  function isSAMSelected()
  {
	 return qf.sam.checked;
  }

  function isPortStatusSelected()
  {
	 return qf.portStatus.checked;
  }

  function getPorts()
  {
	 if (! isPortStatusSelected())
		return "";

	 if (isChoosePortsSelected())
		return qf.portSelect.options[qf.portSelect.selectedIndex].value;

	 if (isInputPortsSelected())
		return "list";
  }

  function isChoosePortsSelected()
  {
         debug("choose port==>" + qf.ports[0].checked);
	 return qf.ports[0].checked;
  }

  function isInputPortsSelected()
  {
         debug("input port==>" + qf.ports[1].checked);
         return qf.ports[1].checked;
  }

  function getInputPorts()
  {
	 if (! isInputPortsSelected())
		return "";

	 var input = qf.portField.value;
	 if (isValidPortsInput(input)) {
		return formatInputPorts(input, ",", ",");
	 } else {
		return "";
	 }
  }

  function isValidPortsInput(input)
  {
	 debug("input object==>" + dumpObj(input));
	 if (isPortStatusSelected() &&
		  isInputPortsSelected() &&
		  typeof input != "string") {
		debug("Invalid input object:" + input);
		return false;
	 } else if (typeof input == "string") {
		input = stringTrim(input);
		if (input.length <1) {
		  debug("Invalid input object: blank");
                  return false;
                }
		var matched = (input.match(pattern));
		debug("matched object==>" + dumpObj(matched));
		if (matched != null &&
			 typeof matched != "undefined")
		  return true;
		else
		  return false;
	 }

	 return true;
  }

  function setPortsInputFieldChange()
  {
	 if (! isPortStatusSelected()||
		  ! isInputPortsSelected()) {
		qf.portField.value="";
	 }
  }

  function setPortsInputFieldFocus()
  {
	 if (! isPortStatusSelected() ||
		  ! isInputPortsSelected()) {
		qf.portField.blur();
	 } else {
		qf.portField.focus();
	 }
  }

  function getAuthenToken()
  {
      var qstr =  window.location.search;
      var aid = qstr.indexOf("Authorization");
      if (aid >-1) {
        var bid = qstr.indexOf("&", aid);
        if (bid >-1)
          qstr = qstr.substring(aid, bid);
        else
          qstr = qstr.substring(aid);
      } else {
          qstr = "";
      }
  }
}
