#!/bin/sh
#
#
#    Copyright (c) 1996-2000 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#
#    This script file will convert the burnin configuration variables
#    into environment variables for a specific shell.  This
#    script must be source'd in the current shell rather than
#    executed so that it is able to modify the calling routines
#    environment.
#
# NAME
#      burninenv.sh  -  copy burnin configuration variables to user
#      environment
# 
# SYNOPSIS
#      burninenv.sh [ switch [ slotno ]]
# 
# AVAILABILITY
#      internal
# 
# DESCRIPTION
#      This script file will convert the burnin configuration vari-
#      ables into environment variables for a specific shell.  This
#      script must be source'd in the  current  shell  rather  than
#      executed  so  that it is able to modify the calling routines
#      environment.  Each burnin script  should  source  this  file
#      before each call to exec_diag.
# 
# 
# OPTIONS
#      switch    If  provided, the value will be used as the switch
#                number to set  up.   Otherwise,  ${FABOS_SWITCHNO}
#                will be used.
# 
#      slotno    If  provided,  the  value  will  be used to select
#                which  slot  should   be   processed.   Otherwise,
#                ${FABOS_SLOTNO} will be used.
# 
# ENVIRONMENT VARIABLES
#      FABOSHOME The  ${FABOSHOME}  environment variable is used to
#                locate     an     internal     library      script
#                ${FABOSHOME}/share/diagcommon.sh used by this com-
#                mand.
# 
#      FABOS_SLOTNO
#                The ${FABOS_SLOTNO} environment variable  is  used
#                as  the  default slot number if the slot parameter
#                is not specified.
# 
#      FABOS_SWITCHNO
#                The ${FABOS_SWITCHNO} environment variable is used
#                as the default switch number if the switch parame-
#                ter is not specified.
# 
# FILES
#      ${FABOSHOME}/share/diagcommon.sh
# 
# SEE ALSO
#      burninlevel(1d), burninname(1d), burninscript(1d), burninse-
#      rial(1d),
# 
# 
# NOTE
#      burninenv.sh  is  only  compatible  with  Borne (sh or bash)
#      style shells.  If your burnin script is  using  a  different
#      shell, then it must set up the environment variables in some
#      other manner.
# 

def_slot=0

#
#
# Load library -- must be first.
#
home="/fabos/share"
util="diagcommon.sh"
ok=0
for f in "./$util" "$FABOSHOME/share/$util" "$home/$util" ; do
	if [ -r $f ] ; then
		. $f
		ok=1
		break;
	fi
done
if [ $ok -ne 1 ] ; then
	echo "Error -- could not locate $util"
	exit 3
fi

#
# Get switch number
#
_x=`/usr/bin/expr "$1" : "\([0-9]\+\)"`
if { [ -z $_x ] || [ $_x -lt 0 ] || [ $_x -gt 10 ] ; }
then
     _x=`/usr/bin/expr "$FABOS_SWITCHNO" : "\([0-9]\+\)"`
     if { [ -z $_x ] || [ $_x -lt 0 ] || [ $_x -gt 10 ] ; }
     then
	  _switch=0
     else
	  _switch=$_x
     fi
else
     _switch=$_x
fi

#
# Get slot number
#
_x=`/usr/bin/expr "$2" : "\([0-9]\+\)"`
if [ -z $_x ] ; then
    ans="`isValidSlot $FABOS_SLOTNO -chassis`"
    if [ "$ans" = TRUE ] ; then
        slot=$FABOS_SLOTNO
    else
        slot=$def_slot
    fi
else
      ans="`isValidSlot $_x -chassis`"
      if [ "$ans" = TRUE ] ; then
         slot=$_x
      else 
	  err "$_x is an invalid slot number"
	  exit 4
      fi
fi
if [ `isMultiBlade` = TRUE ]
then
    slot_message="slot: $slot,  switch: $_switch"
else
    slot_message="switch"
fi
echo "Setting up burnin variables for $slot_message." >&2

# Burnin start
_string="diag.mode.burnin.$slot.firstPowerUp"
_default="0:0"
_mode=$STRING
_val=`getConfig $_string $_mode $_default`
DIAG_PKG_BEG=$_val ; export DIAG_PKG_BEG
echo "DIAG_PKG_BEG=$DIAG_PKG_BEG" >&2

# Burnin passnum
_string="diag.mode.burnin.$slot.passnum"
_default=1
_mode=$INTEGER
_val=`getConfig $_string $_mode $_default`
DIAG_PKG_PASS=$_val ; export DIAG_PKG_PASS
echo "DIAG_PKG_PASS=$DIAG_PKG_PASS" >&2

# Burnin nexec
_string="diag.mode.burnin.$slot.nexec"
_default=0
_mode=$INTEGER
_val=`getConfig $_string $_mode $_default`
DIAG_PKG_NEXEC=$_val ; export DIAG_PKG_NEXEC
echo "DIAG_PKG_NEXEC=$DIAG_PKG_NEXEC" >&2

# Burnin level
_string="diag.mode.burnin.level"
_default=0
_mode=$INTEGER
_val=`getConfig $_string $_mode $_default`
DIAG_PKG_ENV=$_val ; export DIAG_PKG_ENV
echo "DIAG_PKG_ENV=$DIAG_PKG_ENV" >&2

# Burnin name
_string="diag.mode.burnin.$slot.name"
_default=""
_mode=$STRING
_val=`getConfig $_string $_mode $_default`
DIAG_PKG_NAME="$_val" ; export DIAG_PKG_NAME
echo "DIAG_PKG_NAME=$DIAG_PKG_NAME" >&2






