#!/bin/sh
#
#
#    Copyright (c) 1996-2000 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#
# NAME
#      diag_holdoff.sh - Grabs diag semaphore and waits indefenitly.
# 
# AVAILABILITY
#      internal
# 
# DESCRIPTION
#      This  is  not  a  command.  It  is a script that calls a diag
#      command which grabs the diag semaphore for the slot, and sends an SCN
#      with the current state, and SCN_DIAG_ACTIVE reason code.
#      This is used to hold off diag activity during state transitions.
# 
# SEE ALSO
# 

#  Init variables
#
exit_status=0		# this script's exit status value
slot=0			# target slot to run POST
slot_message=""         # message related to slot information

#  special temp file used for each test result
#
logFile=/var/log/diag_holdoffLog
#
#  function to process trapped signal received. Upon entry, KILL the
#  child PID and output the abort message.
#
holdoff_cleanup()
{
	if [ $?child ]
	then
		/bin/echo "DIAG_HOLDOFF_CLEANUP: $slot_message Sending kill message (PID $child)." >> $logFile.$slot.$post
		/bin/kill $child
	fi
	#
	#  display ALL performed test result
	#
	_current_time=`/bin/date \+\%s`
	_date=`/bin/date`
	_duration=`/usr/bin/expr $_current_time - $startTime`
	_minute=`/usr/bin/expr $_duration / 60`
	_hour=`/usr/bin/expr $_minute / 60`
	_sec=`/usr/bin/expr $_duration % 60`
	_minute=`/usr/bin/expr $_minute % 60`
    /bin/echo "DIAG_HOLDOFF_TIME: $_date $_duration." >> $logFile.$slot.$post
	/bin/echo "" >> $logFile.$slot.$post
#	/bin/echo "DIAG_HOLDOFF:$slot_message Completed State Transition."
	/bin/echo "DIAG_HOLDOFF_CLEANUP:$slot_message Completed State Transition." >> $logFile.$slot.$post
	exit 0
}


#
#  Function to wait for exec_diag return and process the return status.
#
checkStatus()
{
	#  wait for current child to finish and get return status
	#
	export child=$!
        echo "child pid : $child" >> $logFile.$slot.$post
	wait $child
	rval=$?
	
	#  construct PASSED or FAILED msg from return value
	#  .  return value = 0 for PASSED
	#  .  return value != 0 for FAILED
	#
	case $rval in
	139 | 237 )
#		echo " SKIPPED $1 due to Known Issue ($rval). Please run following command manually."
		echo "$*"
		echo " SKIPPED $1 due to Known Issue ($rval). Please run following command manually." >>  $logFile.$slot.$post
		echo "$*" >>  $logFile.$slot.$post
		;;
	0 )
		status=PASSED
        echo "$status: $slot $post (pid :- $child)." >> $logFile.$slot.$post 
        ;;
	* )
		status=FAILED
		exit_status=`/usr/bin/expr $exit_status + 1`
        echo "$status: $slot $post (pid :- $child) $exit_status." >> $logFile.$slot.$post
        ;;
	esac

	#  compute return status (positive or negative value)
	#
	if [ $rval -gt 127 ]
	then
		rval=`/usr/bin/expr $rval - 256`
	fi

	/bin/echo "DIAG_HOLDOFF_CHECKSTATUS:$slot_message Returned status = $rval ($status)" >> $logFile.$slot.$post
}

if [ "$FABOS_SLOTNO" != "" ]
then
	slot=$FABOS_SLOTNO
fi

#
# source diagcommon
#
home="/fabos/share"
util="diagcommon.sh"
ok=0
for f in "./$util" "$FABOSHOME/share/$util" "$home/$util" ; do
	if [ -r $f ] ; then
		. $f
		ok=1
		break;
	fi
done
if [ $ok -ne 1 ] ; then
	err "Could not locate $util"
	exit 3
fi

#
# get sys info for multi blade
#
multiBlade=`isMultiBlade`
if [ $multiBlade = TRUE ]
then
     slot_message=" Slot $slot"
     export syntax="$0 -slot [slot]"
else
     export syntax="$0"
fi

post=`/fabos/link_bin/slotshow -d575 | /bin/grep BLADE | /usr/bin/tr -s " 	" " " | /usr/bin/cut -d" " -f2,6 | /bin/grep -w "^$slot" |  /usr/bin/cut -d" " -f2`
# cleanup the old log file
if [ -f $logFile.$slot.$post ]
then
	/bin/rm $logFile.$slot.$post
fi

#
#  display starting message
#
startTime=`/bin/date \+\%s`
_date=`/bin/date`
/bin/echo "DIAG_HOLDOFF_START:$slot_message Started running $_date" >> $logFile.$slot.$post


#  export environment variable
#
DIAG_POST=0 ; export DIAG_POST

#
# Find exec_diag
#
cmd=`commandPath exec_diag`
setdbg=`commandPath setdbg`
$setdbg DIAG 1

#  export environment variable
#
DIAG_POST=1 ; export DIAG_POST
DIAG_USR_FAILLIM=1 ; export DIAG_USR_FAILLIM

#  setup signal trap to call cleanup() if the followings:
#	control/d entered at the same window
#	kill <pid> is entered
#
trap "" 2
trap holdoff_cleanup INT TERM KILL

#
# Start testing
#
#  perform diagholdoff
#
/bin/echo "" >> $logFile.$slot.$post
/bin/echo "DIAG_HOLDOFF_NEW:$slot_message Test - Running diagholdoff" >> $logFile.$slot.$post
#/bin/echo "DIAG_HOLDOFF:$slot_message Test - Running diagholdoff"
$cmd diagholdoff -timeout 60 2>&1 >> $logFile.$slot.$post &
#$cmd diagholdoff -timeout 60 &
checkStatus diagholdoff -timeout 60

#  display ALL performed test result
#
/bin/echo "" >> $logFile.$slot.$post
/bin/echo "DIAG_HOLDOFF_WHERE:  ********** $slot_message DIAG_HOLDOFF Summary  **********" >> $logFile.$slot.$post
/bin/echo "DIAG_HOLDOFF_LAST:$slot_message Completed State Transition:" >> $logFile.$slot.$post

#  display exit msg and exit script
#
if [ $exit_status -ne 0 ]
then
    status=FAILED
else
    status=PASSED
fi
_current_time=`/bin/date \+\%s`
_date=`/bin/date`
_duration=`/usr/bin/expr $_current_time - $startTime`
_minute=`/usr/bin/expr $_duration / 60`
_hour=`/usr/bin/expr $_minute / 60`
_sec=`/usr/bin/expr $_duration % 60`
_minute=`/usr/bin/expr $_minute % 60`
#/bin/echo "DIAG_HOLDOFF:$slot_message Script $status with exit status of $exit_status $_date took ($_hour:$_minute:$_sec)"
/bin/echo "DIAG_HOLDOFF:$slot_message Script $status with exit status of $exit_status $_date took ($_hour:$_minute:$_sec)" >> $logFile.$slot.$post
# We are not really testing anything, so always exit with good status
exit 0
