#! /bin/sh
DEFAULTFREQ=10   # Default frequency is 60 minutes ( once per hour)

/bin/cat /proc/cmdline | /bin/grep -q slub_debug
if [ $? -neq 0 ]; then
    exit
fi

#Mount sysfs if it is not mounted
/bin/mount | grep -q sysfs
if [ $? -ne 0 ]; then
	/bin/mount -t sysfs none /sys
fi
runno=1

/bin/cat /proc/cmdline | /bin/grep -q SLABINFOFREQ
if [ $? -eq 0 ]; then
    SLABINFOFREQ=`/bin/cat /proc/cmdline | /bin/sed 's:^.*SLABINFOFREQ=\([0-9]\+\).*:\1:'`
    if [ -z "${SLABINFOFREQ}" ] || [ -z "${SLABINFOFREQ+xxx}" ]; then
	    SLABINFOFREQ=$DEFAULTFREQ;
    fi
    echo "Using command line value of $SLABINFOFREQ minutes to run slab verification" >> /var/log/slabinfov
else
    SLABINFOFREQ=$DEFAULTFREQ;
    echo "Using Default value of $SLABINFOFREQ minutes to run slab verification" >> /var/log/slabinfov
fi

#if the frequency of data collection is more than once every 10 minutes, we rotate the logs every hour
if [ "${SLABINFOFREQ}" -lt 10 ]; then
    if [ -f /etc/cron.daily/logrotate ]; then 
	/bin/mv /etc/cron.daily/logrotate /etc/cron.hourly/logrotate
    fi
    /bin/sync;
    echo "Rotating the logs every hour due to user setting" >> /var/log/slabinfov
else 
    if [ -f /etc/cron.hourly/logrotate ]; then
	/bin/mv /etc/cron.hourly/logrotate /etc/cron.daily/logrotate
    fi
    /bin/sync;
fi
while [ 1 ] ;
do
	echo "Running slab verification daemon count = $runno";
	echo "Output of slabinfo -v: `date +%F--%T`" >> /var/log/slabinfov
	echo "===============================================" >> /var/log/slabinfov
	/bin/slabinfo -v >> /var/log/slabinfov
	echo "===============================================" >> /var/log/slabinfov
	sleep $((SLABINFOFREQ * 60));
	runno=$((runno + 1));
done;
