#!/bin/sh
# cgroup_throttle_count.sh -- "how much time can be attributed to CPU throttling?"
if [ ! -d "/cgroups" ]; then
  exit;
fi
cgroup_log="/var/log/fos_cgroup.log"
tted=0

num_cpus=`grep -c processor /proc/cpuinfo`
#assumption is script is being run in 60 secs
freq=60

max_root_usage=$((num_cpus * freq))


fos_usage_nsec=`cat "/cgroups/cpuacct/fos/cpuacct.usage"`
mgmnt_usage_nsec=`cat "/cgroups/cpuacct/mgmnt/cpuacct.usage"`
others_usage_nsec=`cat "/cgroups/cpuacct/others/cpuacct.usage"`
root_usage_nsec=`cat "/cgroups/cpuacct/cpuacct.usage"`

fos_usage_sec=`expr $fos_usage_nsec / 1000000000` 
mgmnt_usage_sec=`expr $mgmnt_usage_nsec /  1000000000`
others_usage_sec=`expr $others_usage_nsec / 1000000000`
root_usage_sec=`expr $root_usage_nsec / 1000000000`

root_usage_percent1=$(( root_usage_sec * 100 ))
root_usage_percent=`expr $root_usage_percent1 / $max_root_usage`


#echo "###### usage for cgroups root=$root_usage_sec  fos=$fos_usage_sec mgmnt=$mgmnt_usage_sec others=$others_usage_sec ########"
#echo "###### usage for cgroups root=$root_usage_nsec  fos=$fos_usage_nsec mgmnt=$mgmnt_usage_nsec others=$others_usage_nsec ########"
echo " " >> $cgroup_log
echo "`date`" >> $cgroup_log
echo "*************************" >> $cgroup_log
echo "Total cpu usage: $root_usage_percent" >> $cgroup_log

if [ $root_usage_sec -ge $max_root_usage ]; then #cpu is hitting 100%
	max_fos_usage_sec=$(((`cat "/cgroups/cpu/fos/cpu.shares"`) * (freq * num_cpus) ))
	max_mgmnt_usage_sec=$(((`cat "/cgroups/cpu/mgmnt/cpu.shares"`) * (freq * num_cpus) ))
	max_others_usage_sec=$(((`cat "/cgroups/cpu/others/cpu.shares"`) * (freq * num_cpus) ))

	max_fos_usage_sec=`expr $max_fos_usage_sec / 100`
	max_mgmnt_usage_sec=`expr $max_mgmnt_usage_sec / 100`
	max_others_usage_sec=`expr $max_others_usage_sec / 100`

	#echo "###### max usage for cgroups $max_fos_usage_sec $max_mgmnt_usage_sec $max_others_usage_sec ########"

	#if the usage is more than the maximum allowed usage, raslog
	if [ $fos_usage_sec -gt  $max_fos_usage_sec ];
	then
		fos_usage_percent1=$(( fos_usage_sec * 100 ))
		fos_usage_percent=`expr $fos_usage_percent1 / $max_root_usage`
		max_fos_usage_percent=`cat "/cgroups/cpu/fos/cpu.shares"`
		group="fos-group" 
		echo "cgroup $group may be getting throttled. Allowed usage $max_fos_usage_percent%  actual usage $fos_usage_percent%" >> $cgroup_log
		/fabos/cliexec/errlogtest -i SRM-5007 -r -a $group $fos_usage_percent $max_fos_usage_percent 
		top  -n 1 >> $cgroup_log
		echo " " >> $cgroup_log
		tted=1
	fi
	if [ $mgmnt_usage_sec -gt $max_mgmnt_usage_sec ]; then
		#mgmnt_usage_percent=`expr $mgmnt_usage_sec * 100`
		mgmnt_usage_percent1=$(( mgmnt_usage_sec * 100 ))
		mgmnt_usage_percent=`expr $mgmnt_usage_percent1 / $max_root_usage`
		max_mgmnt_usage_percent=`cat "/cgroups/cpu/mgmnt/cpu.shares"`
		group="management-telemetry-group" 
		echo "cgroup $group may be getting throttled max_uage $max_mgmnt_usage_percent% actual usage $mgmnt_usage_percent%" >> %cgroup_log
		/fabos/cliexec/errlogtest -i SRM-5007 -r -a $group $mgmnt_usage_percent $max_mgmnt_usage_percent 
		tted=1
	fi
	if [ $others_usage_sec -gt $max_others_usage_sec ]; then
		#others_usage_percent=`expr $others_usage_sec * 100`
		others_usage_percent1=$(( others_usage_sec * 100 ))
		others_usage_percent=`expr $others_usage_percent1 / $max_root_usage`
		max_others_usage_percent=`cat "/cgroups/cpu/others/cpu.shares"`
		group="others" 
		echo "cgroup $group may be getting throttled max_usage $max_others_usage_percent actual usage $others_usage_percent" >> $cgroup_log
		/fabos/cliexec/errlogtest -i SRM-5007 -r -a $group $others_usage_percent $max_others_usage_percent 
		tted=1
	fi

fi

if [ $tted -eq 1 ]; then
	echo "cgroup accounting data:"
	echo "/cgroups/cpu/fos/cpu.shares `cat "/cgroups/cpu/fos/cpu.shares"`" >> $cgroup_log
	echo "/cgroups/cpu/mgmnt/cpu.shares `cat "/cgroups/cpu/mgmnt/cpu.shares"`" >> $cgroup_log
	echo "/cgroups/cpu/others/cpu.shares `cat "/cgroups/cpu/others/cpu.shares"`" >> $cgroup_log

	echo "/cgroups/cpuacct/cpuacct.usage `cat "/cgroups/cpuacct/cpuacct.usage"`" >> $cgroup_log
	echo "/cgroups/cpuacct/fos/cpuacct.usage `cat "/cgroups/cpuacct/fos/cpuacct.usage"`" >> $cgroup_log
	echo "/cgroups/cpuacct/mgmnt/cpuacct.usage `cat "/cgroups/cpuacct/mgmnt/cpuacct.usage"`" >> $cgroup_log
	echo "/cgroups/cpuacct/others/cpuacct.usage `cat "/cgroups/cpuacct/mgmnt/cpuacct.usage"`" >> $cgroup_log
	echo " " >> $cgroup_log
fi	
	echo "cpu usage for the interval" >> $cgroup_log
	#echo "$root_usage_nsec $root_usage_sec $max_root_usage" >> $cgroup_log
	#echo "$root_usage_percent1 $root_usage_percent" >> $cgroup_log
	fos_usage_percent1=$(( fos_usage_sec * 100 ))
	fos_usage_percent=`expr $fos_usage_percent1 / $max_root_usage`
	max_fos_usage_percent=`cat "/cgroups/cpu/fos/cpu.shares"`
	group="fos-group" 
	echo "$group actual usage $fos_usage_percent max usage $max_fos_usage_percent" >> $cgroup_log
	mgmnt_usage_percent1=$(( mgmnt_usage_sec * 100 ))
	mgmnt_usage_percent=`expr $mgmnt_usage_percent1 / $max_root_usage`
	max_mgmnt_usage_percent=`cat "/cgroups/cpu/mgmnt/cpu.shares"`
	group="management-telemetry-group" 
	echo "$group actual usage $mgmnt_usage_percent max usage $max_mgmnt_usage_percent" >> $cgroup_log
	others_usage_percent1=$(( others_usage_sec * 100 ))
	others_usage_percent=`expr $others_usage_percent1 / $max_root_usage`
	max_others_usage_percent=`cat "/cgroups/cpu/others/cpu.shares"`
	group="others-group" 
	echo "$group actual usage $others_usage_percent max usage $max_others_usage_percent" >> $cgroup_log
	

# reset all the usages
echo 0 >/cgroups/cpuacct/fos/cpuacct.usage
echo 0 >/cgroups/cpuacct/mgmnt/cpuacct.usage
echo 0 >/cgroups/cpuacct/others/cpuacct.usage
echo 0 >/cgroups/cpuacct/cpuacct.usage




