#!/bin/sh
#
#    Copyright (c) 2002-2007 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#    File name:   logout
#
#    This script will logout all sessions of specified particular users.
#    It's called by the in a number of situtaions in secure mode
#    by the FABOS code such as when passwords change or FCS role
#    change.
#
PATH=/fabos/sbin:/fabos/bin:/bin:/usr/bin:/sbin

export ROLE_ID=root

CLP_LOG=/var/log/clp.log

#if [ ! -f /var/log/clp.log ]; then
    echo "$(date -u) CLP clp.log created" > $CLP_LOG
    chmod 666 $CLP_LOG
#fi

# A common function to logout all the sessions in case of AAA config change
# or ssh session termination on zeroization
logout_all_sessions()
{
#	echo "Logging out all the sessions"
    echo "$(date -u) CLP detected, logout all user begin" >> $CLP_LOG
    mytty=`tty|sed  -e 's/\/dev\///g'`

    for tty in `who | sed -e 's/   / /g' | sed -e 's/  / /g' | sed -e 's/  / /g' \
        | cut -d' ' -f2`
    do
     # kill all other shells first
    	if [ "$tty" != "$mytty" ]; then
            pid=`fuser /dev/$tty 2>/dev/null | sed -e "s,^/dev/[[:alnum:]/]*:[[:space:]]*,,g"`

            # echo Killing PID $pid
            if [ "$pid" != "" ]; then
		echo "$(date -u) kill PID =$pid" >> $CLP_LOG
            	kill -9 $pid 2> /dev/null
            fi
    	fi
    done

    # kill my own shell
    #echo "$(date --utc +%FT%T.%3NZ) kill self shell" >> $CLP_LOG
    #pid=`fuser /dev/$mytty 2>/dev/null | sed -e "s,^/dev/[[:alnum:]/]*:[[:space:]]*,,g"`

    # echo Killing PID $pid
    # if [ "$pid" != "" ]; then
    #    kill -9 $pid 2> /dev/null
    #fi

    echo "$(date -u) CLP detected, logout all user end" >> $CLP_LOG
}

terminate_sftp_sessions()
{

	for sftp_sess_pid in `ps -aef | grep "sftp " | sed -e 's/     / /g' | cut -d' ' -f2 2>>/dev/null`
	do
    	if [ "$sftp_sess_pid" != "" ]; then
        	kill -9 $sftp_sess_pid 2> /dev/null
    	fi
	done
}

terminate_ssh_sessions()
{
	for ssh_sess_pid in `ps -aef | grep "sshd: " | sed -e 's/  */ /g'|cut -d' ' -f2 2>>/dev/null`
	do
    	if [ "$ssh_sess_pid" != $PPID ]; then
        	kill -9 $ssh_sess_pid 2> /dev/null
    	else
			$mysess_pid = $PPID
		fi
	done

	if [ "$mysess_pid" = $PPID ]; then
		kill -9 $mysess_pid 2> /dev/null
   	fi
}

terminate_user_sessions()
{
	killown=0
	echo "Logging out all the sessions of user $2"

	mytty=`tty|sed  -e 's/\/dev\///g'`

	for tty in `who | grep -w "$1"|  sed -e 's/   / /g' | sed -e 's/  / /g' | sed -e 's/  / /g' \
            | cut -d' ' -f2`
	do
    	echo "*aaa tty - $tty*" >> $CLP_LOG
#kill all other shells first
    	if [ "$tty" != "$mytty" ]; then
        	pid=`fuser /dev/$tty 2>/dev/null | sed -e "s,^/dev/[[:alnum:]/]*:[[:space:]]*,,g"`

#   echo Killing PID $pid
        	if [ "$pid" != "" ]; then
            	kill -9 $pid 2> /dev/null
        	fi
	else
	killown=1
    	fi
	
	done
#kill my own shell
if [ $killown == 1 ]; then
    pid=`fuser /dev/$mytty 2>/dev/null | sed -e "s,^/dev/[[:alnum:]/]*:[[:space:]]*,,g"`

#   echo Killing PID $pid
    if [ "$pid" != "" ]; then
        kill -9 $pid 2> /dev/null
    fi
fi

}

msg="License Violation Detected: all accounts will be logged out!"
wall "$msg"
#logout_all_sessions
/fabos/cliexec/licadmin -l


