#!/bin/sh
CORE_ROOT=/
CORE_FILES_DIR=core_files
TRACEOD_FILES_DIR=var/trace
SMRTDC_FILES_DIR=var/log/smrtdc
MNT_DIR=mnt
CORE_TAR=*.tar
PATH=/bin:/usr/bin:/fabos/link_sbin
export ROLE_ID="root"

if [ ! -e /fabos/link_sbin/lscfg_test ]
then
  /bin/ln -s /fabos/cliexec/lscfg_util /fabos/link_sbin/lscfg_test 2> /dev/null
  RM_LSCFG_TEST=TRUE
else
  RM_LSCFG_TEST=FALSE
fi

if [ "$(lscfg_test --vf_enabled 2> /dev/null)" = 'VF is enabled.' ]; then
	VF_ENABLED=1
else
	VF_ENABLED=
fi

if [ "$RM_LSCFG_TEST" = "TRUE" ]; then
    /bin/rm -rf /fabos/link_sbin/lscfg_test
fi

# Function to get a list of core files
getCoreFileList() {
	core_files_list=`/usr/bin/find ${CORE_ROOT}${CORE_FILES_DIR} ${CORE_ROOT}${MNT_DIR}/${CORE_FILES_DIR} ${CORE_ROOT}${TRACEOD_FILES_DIR} \( -name "*ffdc*" -o -name "*core*"  -o -name "*.od" \) -type f -print 2> /dev/null`
	
	if [ -z "${core_files_list}" ]
	then
		printf "No core or FFDC data files found!\n"
		exit 0
	fi
	tmpList=""
	for coreFile in ${core_files_list}
	do
		tmpList="${tmpList}  `/usr/bin/dirname ${coreFile}`"
	done
	core_files_list=`/bin/ls -d $tmpList | /bin/sort | /usr/bin/uniq`
	idx=0
	for coreFile in ${core_files_list}
	do
		coreFileArry[${idx}]="${coreFile}"
		coreSelArry[${idx}]=" "
		idx=`/fabos/bin/expr ${idx} + 1`
	done
	coreFilesCount=$idx
}

# function to tar both core and smrt data files
tarAllFiles() {
	core_files_list=`/usr/bin/find ${CORE_ROOT}${CORE_FILES_DIR} ${CORE_ROOT}${MNT_DIR}/${CORE_FILES_DIR} \( -name "*ffdc*" -o -name "*core*" \) -type f -print 2> /dev/null`
	
	smrtdc_files_list=`/usr/bin/find ${CORE_ROOT}${SMRTDC_FILES_DIR} ${CORE_ROOT}${MNT_DIR}/${SMRTDC_FILES_DIRR} \( -name "*smrtdc*" \) -type f -print 2> /dev/null`

	if [ -z "${core_files_list}" ] && [ -z "${smrtdc_files_list}" ]
	then
		printf "No core or FFDC data files found!\n"
		exit 0
	fi

	if [  $argLog -eq 1 ]
	then
	    printf "core=${core_files_list} smrt=${smrtdc_files_list}\n"
	fi

	if [ "${core_files_list}" != "" ]
	then
	    chmod 666 ${core_files_list}
	    tmpList=""
	    for coreFile in ${core_files_list}
	    do
		tmpList="${tmpList}  `/usr/bin/dirname ${coreFile}`"
	    done
	    core_files_list=`/bin/ls -d $tmpList | /bin/sort | /usr/bin/uniq`
	fi
	idx=0

	if [  $argLog -eq 1 ]
	then
	    printf "tar file:${core_files_list} ${smrtdc_files_list}\n"
	fi

	tar -czPf ${cmdFileName} ${core_files_list}  ${smrtdc_files_list} 2> /dev/null
}


# Function to remove ALL core files
rmCoreFilesListAll() {
	idx=0
	printf "Removing all core and FFDC files!\n" 
	while [ $idx -lt $coreFilesCount ]
	do
        	#/bin/rm -f ${coreFileArry[$idx]}/*
		file_list=`/usr/bin/find  ${coreFileArry[$idx]} ! -name "*.dat"`
		for file in ${file_list}
		do
			if [ "$file" != "${coreFileArry[$idx]}" ]; then
				/bin/rm -f $file
			fi
		done

		# for fdet and ptlog in /core_files/
		name=${coreFileArry[$idx]:12:5}
		# for fdet and ptlog in /mnt/core_files/
		name1=${coreFileArry[$idx]:16:5}
		if [ "$name" = "fdet." -o "$name" = "ptlog" ] ||
		   [ "$name1" = "fdet." -o "$name1" = "ptlog" ]
		then
			/bin/rmdir ${coreFileArry[$idx]}
		fi
		idx=`/fabos/bin/expr ${idx} + 1`
	done
	#printf "reset fddc control count"
	rm -f /core_files/*.tar
	#defect 437464:  we need to run supportuffdc command in chassis context if vf enabled (i.e CURRENT_VF = 255)
	if [ "$VF_ENABLED" = "1" ]
	then
		export CURRENT_VF=255
		/fabos/rbin/supportuffdc -p
	else 
		/fabos/rbin/supportuffdc -p
	fi

}

# main starts here
	argRemoveAll=0	    	# Remove ALL core files	    (-R)
	argFtpAnon=""    	# FTP   user is anonimous   (-a)
	argRemoveTar=0	    	# FTP   user is anonimous   (-t)
	argLog=0                # FTP   user is anonimous   (-l)

# get the command options, if any
	while getopts Rla:t: c
	do
		case $c in
		R) argRemoveAll=1
		   ;;
		a) argFtpAnon=$OPTARG
		   ;;
		t) argRemoveTar= $OPTARG
		   ;;
		l) argLog=1
		   ;;
		*)
		   exit -1
		   ;;
		esac
	done

	# Remove all Files
	if [  $argRemoveAll -eq 1 ]
	then
		getCoreFileList
		rmCoreFilesListAll
		
		exit 0
	fi
	# create tar file 
	if [ -n "${argFtpAnon}" ]
	then
		cmdFileName="${argFtpAnon}"
	 	tarAllFiles
		exit 0
	fi

	# remove created tarfile 
	if [ -n "${argRemoveTar}" ]
	then
		cmdFileName="${argRemoveTar}"
		/bin/rm -f ${CORE_ROOT}${CORE_FILES_DIR}${CORE_ROOT}${cmdFileName}
		exit 0
	fi
