#!/bin/sh
sw_platform=$( /sbin/sin 2>/dev/null | sed -n 's/^.*SWBD\([^,]*\),.*/\1/p' )
blade=$2
DIR="/proc/fabos/blade/${blade}/"
rsh_helper()
{
	ping -q -W 2 -c 1 ${1} > /dev/null
	retval=$?
	if [ $retval -eq 0 ]; then
		echo -e "\n\n"
		echo "/******* rsh ${1} dmesg *******/"
		rsh ${1} dmesg -s 131072
	fi
}


if [ $sw_platform -eq 178 ] || [ $sw_platform -eq 148 ]; then
	echo -e "\n\n"
	echo "/******* /proc/dp0_consolelog *******/"
	cat /proc/dp0_consolelog
	
	rsh_helper dp0

	if [ $sw_platform -eq 148 ]; then
		echo -e "\n\n"
		echo "/******* /proc/dp1_consolelog *******/"
		cat /proc/dp1_consolelog

		rsh_helper dp1
	fi
elif [ $sw_platform -eq 165 ] || [ $sw_platform -eq 166 ]; then
	if [ "$1" == "Slot" ] && [ -d "$DIR" ]; then
		bladeid=`cat /proc/fabos/blade/${blade}/info | /bin/grep --binary-files=text bladeId | sed 's/[^0-9]//g'`
		if [ $bladeid = 186 ]; then
			rsh_helper sl${blade}_dp0

			rsh_helper sl${blade}_dp1
		fi
	fi
fi
