#!/bin/sh
#
# This script, usually run once during system startup from /etc/inittab,
# Checks for an existance of a panicdump in devices such as MTD.
# If found, and if newer than the one found under /core_files/panic/
# then it copies the panicdump from MTD to destination directory.
#

BIN=/fabos/cliexec/
PD_SUCCESS=0

# core files and now pd location. This is a directory name
CORE_FILES_DIR=/core_files/	# The place where we store panicdump
				# which is same for core files
				# see savecore also, where this is used

PD_DIR=$CORE_FILES_DIR/panic/

# pd Control file. Will contain all the control date related to pd.
# It contains the time-stamp of pd.
# Note: this time-stamp is the time retrieved from MTD and NOT the
# current time, when we saved this
PD_CTRL_FILE=/etc/.pd_data	# We will NOT store this in $CORE_FILES
				# This is because the existance is NOT
				# guaranteed and an user may choose to
				# delete $CORE_FILES_DIR. But we need
				# this time stamp
PD_TEMP_ERRLOG_FILE=/tmp/pd_temp_errlog


Debug=printf
#
#	Function used to check for a presence of a dumpfile
#	if new pd found, record the date in $mtd_ts and return 1
#	returns 0 otherwise
#
if [ ! -f $PD_TEMP_ERRLOG_FILE ]
then
	exit 0
fi
cat $PD_TEMP_ERRLOG_FILE | sed -e "/^[ 	]*$/d" | \
while [ 1 ]
do
	read oneLine
	if [ -z "${oneLine}" ]
	then
		rm -f $PD_TEMP_ERRLOG_FILE
		exit 0
	fi
	$BIN/errloginfo "${oneLine}"
done

#    Invoke auto ftp
/fabos/rbin/supportautoftp -f /core_files -d60 & >/dev/null 2>&1

