#!/bin/sh
#
#  Panic Dump, UP Load Post-Fabos parameters.
#  some of the parameters can be obtained only ater the fabos is up and
#  running, such as WWN.
#  This script is used to obtain such information and upload them to
#  PD_MISC client of panicdump, so we get them when the system panics
#  in future.
#
MISC_FILE=/core_files/panic/system_sym  # if you change this, also change
                                # corresponding entry in pdul_misc_pre.sh and
                                # pdul_misc_post.sh and pdcheck.sh
#
# we will take a copy of /proc/kallsyms, so the panic analyzers can take a
# look at it if they ever want to
#
PATH=/bin:/usr/bin

# Discard error output. There are several sources of error
# The MISC_FILE could be missing, md5sum will complain
exec 2>/dev/null

consolelog(){
	# copy a line at a time to /proc/consolelog
	# We need to do this because of the "interesting" way consolelog is
	# implemented. If we have a later version of GNU sed that
	# implements the "-u" switch we could use that instead.
	while read -r line
	do
		printf "%s\n" "$line" > /proc/consolelog
	done
}

# Copy kallsyms to $MISC_FILE only if it has changed (to avoid flash wear)
# md5sum outputs hash, filename pairs, so $2 & $4 are the filenames and $1 & $3
# are the hashes. $3 is unset if the second file is missing
set -- $(/usr/bin/md5sum /proc/kallsyms $MISC_FILE )
if [ "$1" != "$3" ]
then
	umask 022
	# create any missing directories
	mkdir -p ${MISC_FILE%/*}
	cp /proc/kallsyms $MISC_FILE
	sync
fi


sleep 60  # we wait so that we get all the info below

if [ -f /fabos/cliexec/hashow ]
then
	# Let us store the HAM information
	printf "Section=HA Show Output\n" > /proc/pdmisc
	/fabos/cliexec/hashow | /bin/sed -e 's/^/haShow=/' | consolelog
fi


printf "Section=sin Output\n" > /proc/pdmisc
/sbin/sin | /bin/sed -e 's/^/sin=/' | consolelog

#setting the ROLE_ID to avoid RBAC failure.
wwnnumber=$(ROLE_ID=root /fabos/bin/wwn)
printf "WWN=$wwnnumber\n" > /proc/consolelog
