#!/bin/bash

fpgafilename=${1:-lune_top.rbf.gz}
fpgapath='/ciena/fpga'
debug_fpgapath='/mnt/sysfs'

bindir='/ciena/bin'
loader=$bindir/fpgadownload
cpldreg=$bindir/le450cpldreg
lunereg=$bindir/lunereg
sirionreg=$bindir/sirionreg
zcat=/usr/bin/zcat

get_board_id ()
{
    local var="$1"
    local board_id=$(ls -d /sys/bus/platform/devices/board_id.*)
    local regex='\.(.+)$'
    if [[ $board_id =~ $regex ]]
    then
        eval $var=${BASH_REMATCH[1]}
    else
        eval $var=0
    fi
}

test_cpld_reg ()
{
    local regname="$1"
    local value="$2"
    local regex=$regname'\s+(0[xX][[:xdigit:]]+)'
    local x=$($cpldreg $regname)
    if [[ $x =~ $regex ]]
    then
        (( ${BASH_REMATCH[1]} == $value ))
        return $?
    fi
    return 1
}

show_fpga_reg ()
{
    local decoder="$1"
    local regname="$2"
    local regex=$regname'\s+(0[xX].*)'
    local x=$($decoder $regname)
    if [[ $x =~ $regex ]]
    then
        echo ${BASH_REMATCH[0]}
    fi
}

load_fpga ()
{
    local board_id="$1"
    local filename="$2"

    if [ "$filename" = "${filename##*/}" ]  # filename without path
    then
        if [ -r "$debug_fpgapath/$filename" ]
        then
            filename="$debug_fpgapath/$filename"
        elif [ -r "$debug_fpgapath/${filename%.gz}" ]
        then
            filename="$debug_fpgapath/${filename%.gz}"
        else
            filename="$fpgapath/$filename"
        fi
    fi

    if [ -r "$filename" ]
    then
        echo loading FPGA with $filename
        if [ "${filename##*.}" = 'gz' ]
        then
            $zcat $filename | $loader "$board_id" -
        else
            $loader "$board_id" $filename
        fi

        if [ $? -eq 0 ]
        then
            case "$board_id" in
                1) show_fpga_reg $lunereg LUNE_VER
                   ;;
                2) show_fpga_reg ${sirionreg}0 SRN_VER
                   show_fpga_reg ${sirionreg}1 SRN_VER
                   ;;
            esac
        else
            echo $0: $filename: loading FPGA failed
        fi
    else
        echo $0: $filename: No such file
    fi
}

get_board_id bid
case "$bid" in
1)
    if test_cpld_reg LE450CPLD_VER 0x11
    then
        load_fpga "$bid" "lune_top_revAB14.rbf.gz"  # CN3940 rev 1
    else
        load_fpga "$bid" "$fpgafilename"            # CN3940 rev 2
    fi
    ;;
2)
    load_fpga "$bid" "siri_top.rbf.gz"  # CN3960
    ;;
esac
