# This file contains platform specific functions some of which require utils.sh
# to be sourced before this file. To avoid a circular reference, users should
# source utils.sh instead of this file to be sure that all references will be
# resolved.

# -----------------------------------------------------------------------------
get_board_name()
{
    board3940=/sys/bus/platform/devices/board_id.1
    board3960=/sys/bus/platform/devices/board_id.2

    if [ -e "$board3940" ]; then
        echo '3940'
    elif [ -e "$board3960" ]; then
        echo '3960'
    else
        echo 'unknown'
    fi
}

# -----------------------------------------------------------------------------
get_local_if()
{
    echo 'eth0'
}

# -----------------------------------------------------------------------------
board_has_rtc()
{
    [ "$(get_board_name)" = "3960" ]
}

# -----------------------------------------------------------------------------
mount_log_partition()
{
    mount_log_partition_on_jffs2 10
}

# -----------------------------------------------------------------------------
EXIT_BANKA=1
EXIT_BANKB=2
EXIT_NFS=3
EXIT_UNKNOWN=-1
get_running_bank()
{
    case "$(kernel_arg root)" in
        /dev/nfs)        return $EXIT_NFS     ;;
        /dev/mtdblock9)  return $EXIT_BANKA   ;;
        /dev/mtdblock12) return $EXIT_BANKB   ;;
        *)               return $EXIT_UNKNOWN ;;
    esac
}

# -----------------------------------------------------------------------------
get_eeprom_file()
{
    echo /sys/bus/i2c/devices/1-0054/eeprom
}
