#!/bin/sh
##########################################################
#                                                        #
# Name		: initNTP.sh                             #
# Purpose	: Initialize NTPD required files         #
# Usage		:                                        #
#            initNTP.sh                                  # 
#                                                        #
##########################################################

# Local declarations

# Stop the NTP daemon
/ciena/scripts/stopNTP.sh

# make the NTP sub-directory 
   if [ -d /tmp/etc/ntp ]; then
      rm -rf /tmp/etc/ntp
   fi 
   mkdir -p /tmp/etc/ntp

   touch /tmp/etc/ntp/drift
   touch /tmp/etc/ntp/keys
 
# Create Random seed - required for NTP-Keygen & Authentication
   if [ ! -f /tmp/.rnd ]; then
      dd if=/dev/urandom of=/tmp/.rnd bs=512 count=1
   fi

# Exit with status
exit 0

# End of initNTP.sh
