
# -----------------------------------------------------------------------------
# This function accepts a single argument, and will search the kernel command
# line for the corresponding parameter.  If a match is found, the function
# returns zero, and the value of the parameter is put in kernel_arg_val.
#
# Note that this function uses bash regex matching
#
kernel_arg() {

    local kernel_arg_val

    kernel_cmdline=$(cat /proc/cmdline)

    match=$1

    if [ -z "$match" ]; then
        kernel_arg_val=
        return 1
    fi

    kernel_args=($kernel_cmdline)

    for arg in ${kernel_args[*]} ; do
        parm="${arg%%=*}"
        kernel_arg_val="${arg##*=}"
        if [ "$match" == "$parm" ] ; then
            echo $kernel_arg_val
            return 0
        fi
    done

    return 2
}

