#!/bin/sh
#########################################################################
#									#
# Name		: startNTP.sh						#
# Purpose	: Start NTP daemon					#
#									#
# Usage		:							#
#									#
# startNTP.sh { <delay> }						#
#									#
# where,								#
#									#
# <delay>	: * Number of seconds to start the NTP daemon *		#
#									#
#########################################################################

# Ignore SIGINT
# trap "" SIGINT

# Local declarations
ntp_status=0
ntp_delay=2
ntp_mode=polling

if [ "$#" -gt "0" ]; then
   ntp_mode=$1
fi

if [ "$#" -gt "1" ]; then
   ntp_delay=$2
fi

# Make sure NTPD is not running
   /ciena/scripts/stopNTP.sh

# Start the NTP daemon
   if [ $ntp_mode = "polling" ]; then
      # /usr/sbin/ntpd -g -d -l "/tmp/log/ntp.log" >/tmp/log/ntp.detail.log &
      /usr/bin/ntpd -g -l "/tmp/log/ntp.log" >/tmp/log/ntp.detail.log &
   else
      # /usr/sbin/ntpd -g -b -d -l "/tmp/log/ntp.log" >/tmp/log/ntp.detail.log &
      /usr/bin/ntpd -g -b -l "/tmp/log/ntp.log" >/tmp/log/ntp.detail.log &
   fi

# Check the NTP daemon status
[ "$?" -ne "0" ] && ntp_status=2

# Wait for that number of seconds specified
   sleep $ntp_delay

# Restore SIGINT
# trap - SIGINT

# Exit with status
exit $ntp_status

# End of startNTP.sh
