#!/bin/sh
#########################################################################
#									#
# Name		: startSSH.sh						#
# Purpose	: Start SSH daemon					#
#									#
# Usage		:							#
#									#
# startSSH.sh { <delay> }						#
#									#
# where,								#
#									#
# <delay>	: * Number of seconds to start the SSH daemon *		#
#									#
#########################################################################

# Ignore SIGINT

# Local declarations
local status=0

# Make sure SSHD is not running
   /ciena/scripts/stopSSH.sh

# SSH is picky about the permission on this
   if [ -d /var/run/sshd ]; then
       chmod 0640 /var/run/sshd
   fi

# SSH is picky about the permission on this
   if [ -f /etc/ssh/ssh_host_rsa_key ]; then
       chmod 0600 /etc/ssh/ssh_host_rsa_key
   fi

   sleep 1

# Start the SSH daemon, not as a real-time process (our parent LEOS is RT).
   chrt -o 0 /usr/sbin/sshd -q -f /etc/sshd_config > /dev/null 2>&1

# Check the SSH daemon status
   if [ "$?" -ne "0" ]; then
      echo "$?:  Can't start SSH daemon"
      status=2
   fi

# Exit with status

exit $status

# End of startSSH.sh
