#!/bin/sh
#########################################################################
#									#
# Name		: stopDhcpc.sh						#
# Purpose	: Stop DHCP-Client daemon				#
#									#
# Usage		:							#
#									#
# 		stopDhcpc.sh { <delay> }				#
#									#
#########################################################################


#### delay
if [ "$#" -gt "0" ]; then
   delay=$1
else
   delay=3
fi

# Proceeding to stop DHCP-C

sleep $delay
#### Kill previous instance of DHCP if running
UDHCPC_PID=`pidof udhcpc`
if [ ! -z "$UDHCPC_PID" ]; then
      # DHCPC is running
    killall -KILL udhcpc > /dev/null 2>&1

      # Wait for that number of seconds specified
    exec sleep $delay
fi

#### Unconfigure the interface
#   /sbin/route del default > /dev/null 2>&1
#   /sbin/route del default $interface > /dev/null 2>&1
#   /sbin/ifconfig $interface 0.0.0.0 > /dev/null 2>&1

# Exit with status
exit 0

# End of stopDhcpc.sh
