#!/bin/sh

#unreset all PHYS
le450cpldreg LE450CPLD_RST 0x0

# lps - set up the FPGA registers to enable NNI ports

PCS_UNI3=0x3b
PCS_NNI0_M2P=0x30

luneWaitComplete()
{
    for (( j=0 ; j<5; j++ ))
    do
        lunereg LUNE_INDX_SEL >> /dev/null
    done
}

# set GbE speed via PCS IF_MODE register 0x28
lunereg LUNE_DAT0 0x9
lunereg LUNE_INDX1 0x0
lunereg LUNE_INDX0 0x28		# IF_MODE reg

for (( i = $PCS_UNI3 ; i >= $PCS_NNI0_M2P ; i-- ))
do
    luneWaitComplete
    lunereg LUNE_INDX_SEL $i
done

echo "IF_MODE set to SGMII"

sleep 1

# setup the autoneg link timer in case we need it
lunereg LUNE_DAT0 0x0d40
lunereg LUNE_INDX1 0x0
lunereg LUNE_INDX0 0x24		# link_timer_low reg
for (( i = $PCS_UNI3 ; i >= $PCS_NNI0_M2P ; i-- ))
do
    luneWaitComplete
    lunereg LUNE_INDX_SEL $i
done
sleep 1
lunereg LUNE_DAT0 0x3
lunereg LUNE_INDX1 0x0
lunereg LUNE_INDX0 0x26		# link_timer_high reg
for (( i = $PCS_UNI3 ; i >= $PCS_NNI0_M2P ; i-- ))
do
    luneWaitComplete
    lunereg LUNE_INDX_SEL $i
done
echo "AutoNeg timer set"
sleep 1

# set aneg off, restart_an on
lunereg LUNE_DAT0 0x200		# ( 1 << 9 ) restart_an
lunereg LUNE_INDX1 0x0
lunereg LUNE_INDX0 0x0		# CTRL reg
for (( i = $PCS_UNI3 ; i >= $PCS_NNI0_M2P ; i-- ))
do
    luneWaitComplete
    lunereg LUNE_INDX_SEL $i
done
echo "AutoNeg turned off"
sleep 1

#enable NNI ports
lunereg LUNE_IGREN 0xff00
lunereg LUNE_EGREN 0xff00

# RESET the PHY - it self clears and comes out of reset
lunereg LUNE_DAT0 0x8200	# (1<<9) | (1<<15) restart_an, Reset PHY
lunereg LUNE_INDX1 0x0
lunereg LUNE_INDX0 0x0		# CTRL reg
for (( i = $PCS_UNI3 ; i >= $PCS_NNI0_M2P ; i-- ))
do
    luneWaitComplete
    lunereg LUNE_INDX_SEL $i
done
echo "Reset the FPGA PHYs"
sleep 1


# setup NNI control register to 1Gbps
lunereg LUNE_U0_CNFG 0x0

#enable NNI ports
lunereg LUNE_IGREN 0xff00
lunereg LUNE_EGREN 0xff00


