#!/bin/bash

fpgafilename_gx15=${1:-grey_top_gx15.rbf}
fpgafilename_gx30=${1:-grey_top_gx30.rbf}
fpgapath='/ciena/fpga'
debug_fpgapath='/mnt/sysfs'

bindir='/ciena/bin'
loader=$bindir/fpgadownload
greylinreg=$bindir/greylinreg
zcat=/usr/bin/zcat

board_info='/sys/bus/platform/devices/board_info'

show_fpga_reg ()
{
    local decoder="$1"
    local regname="$2"
    local regex=$regname'\s+(0[xX].*)'
    local x=$($decoder $regname)
    if [[ $x =~ $regex ]]
    then
        echo ${BASH_REMATCH[0]}
    fi
}

load_fpga ()
{
    local board_id="$1"
    local filename="$2"

    if [ "$filename" = "${filename##*/}" ]  # filename without path
    then
        if [ -r "$debug_fpgapath/$filename" ]
        then
            filename="$debug_fpgapath/$filename"
        elif [ -r "$debug_fpgapath/${filename%.gz}" ]
        then
            filename="$debug_fpgapath/${filename%.gz}"
        else
            filename="$fpgapath/$filename"
        fi
    fi

    if [ -r "$filename" ]
    then
        echo loading FPGA with $filename
        if [ "${filename##*.}" = 'gz' ]
        then
            $zcat "$filename" | $loader "$board_id" -
        else
            $loader "$board_id" "$filename"
        fi

        if [ $? -eq 0 ]
        then
            show_fpga_reg $greylinreg GREYLIN_REG_REVISION
            show_fpga_reg $greylinreg GREYLIN_REG_BUILD_REVISION
        else
            echo $0: $filename: loading FPGA failed
        fi
    else
        echo $0: $filename: No such file
    fi
}

if [ -r "${board_info}/gx30" ]
then
    id=$(< "${board_info}/id" )
    gx30=$(< "${board_info}/gx30" )

    case "${gx30}" in
        0 ) load_fpga "$id" "$fpgafilename_gx15" ;;
        1 ) load_fpga "$id" "$fpgafilename_gx30" ;;
        * ) echo "Error loading FPGA: unexpected value '${gx30}' in ${board_info}/gx30" ;;
    esac
fi

